/*
 * Decompiled with CFR 0.152.
 */
import data_structures.Atom;
import data_structures.Residue;
import data_structures.SC_Structure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class PymolColoring {
    public static void main(String[] main) {
        HashMap<Integer, Residue> str = PDB_parser.parse("/Users/bielasek/Desktop/EpitopePrediction_P/HomologyPrediction/EpiPred/out_1ahw/0-green.pdb", 'A');
        ArrayList<String> lines = FileSystemTools.readFile("/Users/bielasek/Desktop/EpitopePrediction_P/HomologyPrediction/EpiPred/solution/1ahw/epitope.txt");
        ArrayList<Integer> contacts = new ArrayList<Integer>();
        for (String line : lines) {
            int id = Integer.parseInt(FileSystemTools.getColumn(line, 1));
            contacts.add(id);
        }
        lines = FileSystemTools.readFile("/Users/bielasek/Desktop/EpitopePrediction_P/HomologyPrediction/EpiPred/out_1ahw/0.txt");
        ArrayList<Integer> predictions = new ArrayList<Integer>();
        for (String line : lines) {
            int id = Integer.parseInt(line);
            predictions.add(id);
        }
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i : str.keySet()) {
            sorted.add(i);
        }
        ArrayList<String> out_file = new ArrayList<String>();
        for (Integer i : sorted) {
            Residue r = str.get(i);
            String color = "100.0";
            for (Atom a : r.atoms) {
                String pdb_line = a.pdb_line;
                if (contacts.contains(i) && !predictions.contains(i)) {
                    pdb_line = SC_Structure.colorBFactor(pdb_line, "50.0");
                }
                if (contacts.contains(i) && predictions.contains(i)) {
                    pdb_line = SC_Structure.colorBFactor(pdb_line, "100.0");
                }
                if (!contacts.contains(i) && predictions.contains(i)) {
                    pdb_line = SC_Structure.colorBFactor(pdb_line, "0.0");
                }
                if (!contacts.contains(i) && !predictions.contains(i)) {
                    pdb_line = SC_Structure.colorBFactor(pdb_line, "25.0");
                }
                out_file.add(pdb_line);
            }
        }
        FileSystemTools.writeFile("/Users/bielasek/Desktop/EpitopePrediction_P/HomologyPrediction/EpiPred/out_1ahw/full.pdb", out_file);
    }
}

