/*
 * Decompiled with CFR 0.152.
 */
package score_calculators;

import data_structures.Residue;
import data_structures.Residue_type;
import data_structures.SC_Structure;
import java.util.ArrayList;
import java.util.HashMap;

public class APro_calculator {
    public static void calculate_APro(SC_Structure struc, double[][] w_intra, HashMap<Integer, ArrayList<Residue_type[]>> g) {
        HashMap<Integer, Double> Sis = APro_calculator.calculateSi(g);
        for (Integer i : struc.residues.keySet()) {
            Residue res_central = struc.residues.get(i);
            double sum = 0.0;
            for (Residue res_inpatch : res_central.getPatch().patch_residues) {
                sum += w_intra[res_central.getRefSite()][res_inpatch.getRefSite()] * Sis.get(res_inpatch.getRefSite());
            }
            if (res_central.getPatch().patch_residues.size() == 0) continue;
            res_central.setAPro(sum / (double)res_central.getPatch().patch_residues.size());
        }
    }

    public static HashMap<Integer, Double> calculateSi(HashMap<Integer, ArrayList<Residue_type[]>> g) {
        HashMap<Integer, Double> Sis = new HashMap<Integer, Double>();
        for (Integer i : g.keySet()) {
            double sum = 0.0;
            for (Residue_type[] res : g.get(i)) {
                sum += res[i.intValue()].propensity;
            }
            Sis.put(i, sum /= (double)g.get(i).size());
        }
        return Sis;
    }
}

