/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import java.util.Vector;
import weka.core.Instances;
import weka.gui.beans.AbstractTestSetProducer;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.StructureProducer;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;

public class TestSetMaker
extends AbstractTestSetProducer
implements DataSourceListener,
EventConstraints,
Serializable,
StructureProducer {
    private static final long serialVersionUID = -8473882857628061841L;
    protected boolean m_receivedStopNotification = false;

    @Override
    public Instances getStructure(String eventName) {
        if (!eventName.equals("dataSet")) {
            return null;
        }
        if (this.m_listenee == null) {
            return null;
        }
        if (this.m_listenee != null && this.m_listenee instanceof StructureProducer) {
            return ((StructureProducer)this.m_listenee).getStructure("dataSet");
        }
        return null;
    }

    public TestSetMaker() {
        this.m_visual.loadIcons("weka/gui/beans/icons/TestSetMaker.gif", "weka/gui/beans/icons/TestSetMaker_animated.gif");
        this.m_visual.setText("TestSetMaker");
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String globalInfo() {
        return "Designate an incoming data set as a test set.";
    }

    @Override
    public void acceptDataSet(DataSetEvent e) {
        this.m_receivedStopNotification = false;
        TestSetEvent tse = new TestSetEvent(this, e.getDataSet());
        tse.m_setNumber = 1;
        tse.m_maxSetNumber = 1;
        this.notifyTestSetProduced(tse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTestSetProduced(TestSetEvent tse) {
        Vector l;
        TestSetMaker testSetMaker = this;
        synchronized (testSetMaker) {
            l = (Vector)this.m_listeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                if (this.m_receivedStopNotification) {
                    if (this.m_logger != null) {
                        this.m_logger.logMessage("[TestSetMaker] " + this.statusMessagePrefix() + " stopping.");
                        this.m_logger.statusMessage(this.statusMessagePrefix() + "INTERRUPTED");
                    }
                    this.m_receivedStopNotification = false;
                    break;
                }
                ((TestSetListener)l.elementAt(i)).acceptTestSet(tse);
            }
        }
    }

    @Override
    public void stop() {
        this.m_receivedStopNotification = true;
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (this.m_listenee == null) {
            return false;
        }
        return !(this.m_listenee instanceof EventConstraints) || ((EventConstraints)this.m_listenee).eventGeneratable("dataSet");
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }
}

