/*
 * Decompiled with CFR 0.152.
 */
package EpitopePredictor;

import data_structures.Residue;
import docking_global.DockingDistances;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import parsing.PSA;
import utils.FileSystemTools;
import utils.MathFunctions;

public class PerformanceAnalyzer {
    public static void main(String[] args) {
        PerformanceAnalyzer.createInputFolder(2);
    }

    public static void createInputFolder(int ordinal) {
        String folder = "/Users/bielasek/Desktop/EpitopePrediction_P/Results/Run_0.0_0.5_1.0/EpiPred";
        String out_folder = "/Users/bielasek/Desktop/EpitopePrediction_P/input";
        for (String pdb : PerformanceAnalyzer.NR()) {
            System.out.println(pdb);
            File d = new File(String.valueOf(out_folder) + "/" + pdb);
            if (!d.exists()) {
                d.mkdir();
            }
            FileSystemTools.CopyFile(String.valueOf(folder) + "/out_" + pdb + "/AB.pdb", String.valueOf(out_folder) + "/" + pdb + "/AB.pdb");
            FileSystemTools.CopyFile(String.valueOf(folder) + "/out_" + pdb + "/AG.pdb", String.valueOf(out_folder) + "/" + pdb + "/AG.pdb");
            FileSystemTools.CopyFile(String.valueOf(folder) + "/out_" + pdb + "/" + ordinal + ".txt", String.valueOf(out_folder) + "/" + pdb + "/epitope.txt");
            FileSystemTools.CopyFile(String.valueOf(folder) + "/out_" + pdb + "/paratope.txt", String.valueOf(out_folder) + "/" + pdb + "/paratope.txt");
        }
    }

    public static void createSolFolder() {
        String folder = "/Users/bielasek/Desktop/EpitopePrediction_P/Results/Run_0.0_0.2_0.2/EpiPred";
        String out_folder = "/Users/bielasek/Desktop/EpitopePrediction_P/solution";
        for (String pdb : PerformanceAnalyzer.NR()) {
            System.out.println(pdb);
            File d = new File(String.valueOf(out_folder) + "/" + pdb);
            if (!d.exists()) {
                d.mkdir();
            }
            FileSystemTools.CopyFile(String.valueOf(folder) + "/out_" + pdb + "/AB.pdb", String.valueOf(out_folder) + "/" + pdb + "/AB.pdb");
            FileSystemTools.CopyFile(String.valueOf(folder) + "/out_" + pdb + "/AG.pdb", String.valueOf(out_folder) + "/" + pdb + "/AG.pdb");
        }
    }

    public static void createIRMSDSolFolder() {
        String folder = "/Users/bielasek/Desktop/EpitopePrediction_P/Results/Run_0.0_0.2_0.2/EpiPred";
        String out_folder = "/Users/bielasek/Desktop/EpitopePrediction_P/IRMSD";
        for (String pdb : PerformanceAnalyzer.NR()) {
            System.out.println(pdb);
            HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(folder) + "/out_" + pdb + "/AB.pdb", 'A');
            HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(folder) + "/out_" + pdb + "/AG.pdb", 'A');
            DockingDistances.extractCons(ab, ag);
            ArrayList<Integer> ab_aug = DockingDistances.augmentBinding(ab, 10.0);
            ArrayList<Integer> ag_aug = DockingDistances.augmentBinding(ag, 10.0);
            FileSystemTools.writeFileInts(String.valueOf(out_folder) + "/" + pdb + "_AB.txt", ab_aug);
            FileSystemTools.writeFileInts(String.valueOf(out_folder) + "/" + pdb + "_AG.txt", ag_aug);
        }
    }

    public static void PredictionTest(boolean test, int order) {
        HashMap<String, String> results = new HashMap<String, String>();
        String folder = "/Users/bielasek/Desktop/EpitopePrediction_P/Results";
        ArrayList<String> folders = FileSystemTools.getFolders(folder);
        boolean prog = false;
        for (String f : folders) {
            if (!f.contains("Run_0.0") && !f.contains("Run_1.0")) continue;
            Res r = PerformanceAnalyzer.PredictionTestSingle(String.valueOf(folder) + "/" + f, test, order);
            String value = String.valueOf(r.p) + " " + r.r + " " + r.good + " " + r.v_good + " " + r.p_s + " " + r.r_s + " " + r.total;
            results.put(f, value);
        }
        String out = "";
        for (String a : results.keySet()) {
            out = String.valueOf(out) + a + " " + (String)results.get(a) + "\n";
        }
        String filename = String.valueOf(test ? "Te" : "Tr") + "_" + order + ".txt";
        filename = "/Users/bielasek/Desktop/EpitopePrediction_P/Stats/" + filename;
        FileSystemTools.writeFile(filename, out);
    }

    public static Res PredictionTestSingle(String folder, boolean test, int order) {
        ArrayList<String> nr = PerformanceAnalyzer.NR();
        double prec = 0.0;
        double rec = 0.0;
        double total = 0.0;
        double progress = 0.0;
        int good = 0;
        int v_good = 0;
        folder = String.valueOf(folder) + "/EpiPred";
        ArrayList<String> folders = FileSystemTools.getFolders(folder);
        ArrayList<Double> precs = new ArrayList<Double>();
        ArrayList<Double> recs = new ArrayList<Double>();
        for (String res_folder : folders) {
            Res r;
            String in_folder = folder;
            if (!res_folder.contains("out_") || res_folder.contains("4hcr")) continue;
            HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(in_folder) + "/" + res_folder + "/AG.pdb", 'A');
            String pdb = res_folder.substring(res_folder.lastIndexOf("_") + 1);
            if ((!test ? nr.contains(pdb) : !nr.contains(pdb)) || (r = PerformanceAnalyzer.GetPR(in_folder = String.valueOf(in_folder) + "/" + res_folder, order)) == null) continue;
            prec += r.p;
            rec += r.r;
            if (r.p > 0.25 && r.r > 0.6) {
                ++good;
            }
            System.out.println(String.valueOf(pdb) + " : " + r.p + " " + r.r);
            if (r.p > 0.3 && r.r > 0.7) {
                ++v_good;
            }
            precs.add(r.p);
            recs.add(r.r);
            total += 1.0;
        }
        double p_std = MathFunctions.getStdDevDouble(precs);
        double r_std = MathFunctions.getStdDevDouble(recs);
        System.out.println("Good ones: " + good);
        return new Res(prec / total, rec / total, good, v_good, total, p_std, r_std);
    }

    public static void randomTest(boolean test) {
        ArrayList<String> nr = PerformanceAnalyzer.NR();
        double prec = 0.0;
        double rec = 0.0;
        double total = 0.0;
        double progress = 0.0;
        double todo = 745.0;
        int i = 0;
        while (i <= 4) {
            String folder = "/Users/bielasek/Desktop/EpitopePrediction_R/EpitopePrediction_R_5/EpiPred_R";
            folder = folder.replaceAll("5", "" + i);
            ArrayList<String> folders = FileSystemTools.getFolders(folder);
            for (String res_folder : folders) {
                System.out.println(String.valueOf(progress += 1.0) + "/" + todo);
                String in_folder = folder;
                if (!res_folder.contains("out_") || res_folder.contains("4hcr")) continue;
                String pdb = res_folder.substring(res_folder.lastIndexOf("_") + 1);
                System.out.println(pdb);
                if (test ? !nr.contains(pdb) : nr.contains(pdb)) continue;
                System.out.println("Currently doing: " + pdb);
                in_folder = String.valueOf(in_folder) + "/" + res_folder;
                int how_many = PerformanceAnalyzer.countTXT(in_folder);
                int j = 0;
                while (j < how_many) {
                    Res r = PerformanceAnalyzer.GetPR(in_folder, j);
                    System.out.println("Precision: " + (prec += r.p) / (total += 1.0));
                    System.out.println("Recall: " + (rec += r.r) / total);
                    ++j;
                }
            }
            ++i;
        }
        System.out.println("Precision: " + prec / total);
        System.out.println("Recall: " + rec / total);
    }

    public static int countTXT(String folder) {
        ArrayList<String> files = FileSystemTools.getFiles(folder);
        int count = 0;
        for (String file : files) {
            if (!file.contains(".txt") || file.contains("AB") || file.contains("AG") || file.contains("paratope")) continue;
            ++count;
        }
        return count;
    }

    public static Res GetPR(String folder, int whichone) {
        String ab_file = String.valueOf(folder) + "/AB.pdb";
        String ag_file = String.valueOf(folder) + "/AG.pdb";
        String ab_psa_file = String.valueOf(folder) + "/tempAB.txt";
        String ag_psa_file = String.valueOf(folder) + "/tempAG.txt";
        HashMap<Integer, Residue> ab = PDB_parser.parse(ab_file, 'A');
        HashMap<Integer, Residue> ag = PDB_parser.parse(ag_file, 'A');
        HashMap<Integer, Boolean> ab_surface_exp = PSA.readPSAFile(ab_psa_file, 7.5);
        HashMap<Integer, Boolean> ag_surface_exp = PSA.readPSAFile(ag_psa_file, 7.5);
        DockingDistances.extractCons(ab, ag);
        ArrayList<Integer> ag_cons_real = new ArrayList<Integer>();
        for (Integer id : ag.keySet()) {
            if (!ag_surface_exp.get(id).booleanValue() || !ag.get((Object)id).isContact) continue;
            ag_cons_real.add(id);
        }
        File f = new File(String.valueOf(folder) + "/" + whichone + ".txt");
        if (!f.exists()) {
            return null;
        }
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(folder) + "/" + whichone + ".txt");
        ArrayList<Integer> ag_cons_nons = new ArrayList<Integer>();
        for (String line : lines) {
            int id = Integer.parseInt(line);
            ag_cons_nons.add(id);
        }
        ArrayList<Integer> ag_cons_pred = new ArrayList<Integer>();
        for (Integer id : ag.keySet()) {
            if (!ag_surface_exp.get(id).booleanValue() || ag_cons_nons.contains(id)) continue;
            ag_cons_pred.add(id);
        }
        double count = 0.0;
        for (Integer id : ag_cons_pred) {
            if (!ag_cons_real.contains(id)) continue;
            count += 1.0;
        }
        double precision = count / (double)ag_cons_pred.size();
        double recall = count / (double)ag_cons_real.size();
        return new Res(precision, recall);
    }

    public static ArrayList<String> NR() {
        ArrayList<String> test = new ArrayList<String>();
        ArrayList<String> lines = FileSystemTools.readFile("/Users/bielasek/Desktop/EpitopePrediction_P/NR");
        for (String line : lines) {
            String pdb = line.substring(0, 4);
            test.add(pdb);
        }
        System.out.println(lines.size());
        return test;
    }

    public static class Res {
        public final double r;
        public final double p;
        public double r_s;
        public double p_s;
        public double good;
        public double v_good;
        public double total;

        public Res(double prec, double rec) {
            this.r = rec;
            this.p = prec;
        }

        public Res(double prec, double rec, double g, double v_g, double t, double p_std, double r_std) {
            this.r = rec;
            this.p = prec;
            this.good = g;
            this.total = t;
            this.r_s = r_std;
            this.p_s = p_std;
        }
    }
}

