/*
 * Decompiled with CFR 0.152.
 */
package data_structures;

import data_structures.Atom_class;

public class Atom {
    public final double x_cord;
    public final double y_cord;
    public final double z_cord;
    public final String pdb_line;
    public final Atom_class atom_name;

    public Atom(double x, double y, double z, String _pdb_line) {
        this.x_cord = x;
        this.y_cord = y;
        this.z_cord = z;
        this.pdb_line = _pdb_line;
        String res_type = this.pdb_line.substring(17, 20);
        String atom_type = this.pdb_line.substring(13, 16);
        this.atom_name = Atom_class.map(String.valueOf(res_type) + "_" + atom_type);
    }

    public double distanceFrom(Atom atom) {
        double dx = Math.pow(this.x_cord - atom.x_cord, 2.0);
        double dy = Math.pow(this.y_cord - atom.y_cord, 2.0);
        double dz = Math.pow(this.z_cord - atom.z_cord, 2.0);
        return Math.sqrt(dx + dy + dz);
    }

    public void Output() {
        System.out.println("X: " + this.x_cord);
        System.out.println("Y: " + this.y_cord);
        System.out.println("Z: " + this.z_cord);
    }
}

