/*
 * Decompiled with CFR 0.152.
 */
package dockingfurther;

import data_structures.Residue;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class DockingSubset {
    private static final String userdir = System.getProperty("user.dir");
    public static final String res_dir = String.valueOf(userdir) + "/result_dump/DP_recalculation";

    public static void main(String[] args) {
        ArrayList<String> NR_initial = FileSystemTools.readFile(String.valueOf(res_dir) + "/PDBs_all/AG_protein.txt");
        ArrayList<String> NR = new ArrayList<String>();
        for (String pdb : NR_initial) {
            pdb = pdb.substring(0, 4);
            NR.add(pdb);
        }
        ArrayList<String> nrsubset = FileSystemTools.readFile(String.valueOf(res_dir) + "/dataset_test");
        for (String pdb : nrsubset) {
            DockingSubset.copyPDB(pdb);
            pdb = pdb.substring(0, 4);
            System.out.println(pdb);
            NR.remove(pdb);
        }
        System.out.println(NR.size());
    }

    public static void copyPDB(String pdb) {
        String dataset = "nr_subset";
        boolean iter = false;
        File f = new File(String.valueOf(res_dir) + "/NRSUBSET/" + pdb);
        if (!f.exists()) {
            f.mkdir();
        }
        String ab_file = String.valueOf(userdir) + "/resources/nr_training/dataset/" + pdb + "/AB.pdb";
        String ag_file = String.valueOf(userdir) + "/resources/" + dataset + "/dataset/" + pdb + "/AG.pdb";
        HashMap<Integer, Residue> ab = PDB_parser.parse(ab_file, 'A');
        HashMap<Integer, Residue> ag = PDB_parser.parse(ag_file, 'A');
    }
}

