/*
 * Decompiled with CFR 0.152.
 */
package main;

import ABiPatch_NewData.copy.ABiPatch_ND;
import abModels.CDRipatch;
import data_structures.MSA;
import data_structures.Residue;
import data_structures.Residue_type;
import data_structures.SC_Structure;
import dockingfurther.PropensityCalculation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import main.Main_inter;
import parsing.FASTA_parser;
import parsing.PDB_parser;
import parsing.PSA;
import parsing.ROI_parser;
import utils.FileSystemTools;

public class Main_outer {
    public static void executeIPatch(String interest_1, String interest_2, String pdb_file1, String pdb_file2, String alignment_file, String id) {
        String directory = "/../../cache/" + id;
        ArrayList<Integer> roi_1 = ROI_parser.parse(interest_1);
        ArrayList<Integer> roi_2 = ROI_parser.parse(interest_2);
        int spacing = ROI_parser.getSpacing(interest_1);
        MSA msa = FASTA_parser.splitToPairs(spacing, alignment_file);
        int reference = FASTA_parser.getReference();
        SC_Structure strA = Main_outer.structureAndMSA(pdb_file1, msa, reference, true, roi_1, ROI_parser.getChain(interest_1), directory, true, false);
        SC_Structure strB = Main_outer.structureAndMSA(pdb_file2, msa, reference, false, roi_2, ROI_parser.getChain(interest_2), directory, true, false);
        Main_inter mi = new Main_inter(msa, strA, strB);
        String outname_1 = String.valueOf(System.getProperty("user.dir")) + directory + "/const_1";
        String outname_2 = String.valueOf(System.getProperty("user.dir")) + directory + "/const_2";
        double cutoff = 2.0;
        PDB_parser.writePDB(strA, outname_1, String.valueOf(System.getProperty("user.dir")) + directory + "/out_1", true, cutoff);
        PDB_parser.writePDB(strB, outname_2, String.valueOf(System.getProperty("user.dir")) + directory + "/out_2", false, cutoff);
        PDB_parser.OutputHTML(strA, strB, String.valueOf(System.getProperty("user.dir")) + directory, "out_1", "out_2");
        PDB_parser.writePDB(strA, outname_1, String.valueOf(System.getProperty("user.dir")) + "/auxiliarysoftware/pymol/StrA.pdb", true, cutoff);
        PDB_parser.writePDB(strB, outname_2, String.valueOf(System.getProperty("user.dir")) + "/auxiliarysoftware/pymol/StrB.pdb", false, cutoff);
    }

    public static void main2(String[] args) {
        Main_outer.executeIPatch(null, null, null, null, null, null);
    }

    public static void main(String[] args) {
    }

    private static void AnnotatePatch(ArrayList<Integer> to_remove, Residue residue, double cutoff, HashMap<Integer, Double> olds) {
        if (residue.checked) {
            return;
        }
        residue.checked = true;
        for (Residue r : residue.getPatch().patch_residues) {
            if (to_remove.contains(r.site) || !(r.getTPro() > cutoff)) continue;
            Main_outer.AnnotatePatch(to_remove, r, cutoff, olds);
        }
    }

    public static SC_Structure calculateNeighborsA(SC_Structure s1, SC_Structure s2) {
        HashMap<Integer, Residue> residues_s1 = s1.residues;
        HashMap<Integer, Residue> residues_s2 = s2.residues;
        for (Integer i : residues_s1.keySet()) {
            s1.residues.get((Object)i).isContact = false;
            for (Integer j : residues_s2.keySet()) {
                if (!(residues_s2.get(j).distanceFrom(residues_s1.get(i)) < 4.5)) continue;
                System.out.println("A: " + s1.residues.get((Object)i).site + " " + i + " " + (Object)((Object)s1.residues.get((Object)i).type));
                s1.residues.get((Object)i).isContact = true;
                if (i == s1.residues.get((Object)i).site) continue;
                System.err.println("unequal");
                System.exit(0);
            }
        }
        return s1;
    }

    public static SC_Structure calculateNeighborsB(SC_Structure s1, SC_Structure s2) {
        HashMap<Integer, Residue> residues_s1 = s1.residues;
        HashMap<Integer, Residue> residues_s2 = s2.residues;
        for (Integer i : residues_s2.keySet()) {
            s2.residues.get((Object)i).isContact = false;
            for (Integer j : residues_s1.keySet()) {
                if (!(residues_s1.get(j).distanceFrom(residues_s2.get(i)) < 4.5)) continue;
                System.out.println("B: " + s2.residues.get((Object)i).site + " " + i + " " + (Object)((Object)s2.residues.get((Object)i).type));
                s2.residues.get((Object)i).isContact = true;
                if (i == s2.residues.get((Object)i).site) continue;
                System.err.println("unequal");
                System.exit(0);
            }
        }
        return s2;
    }

    public static SC_Structure structureAndMSA(String pdb_file1, MSA msa, int reference, boolean isA, ArrayList<Integer> roi, char chain, String directory, boolean use_full_msa, boolean cdr_only) {
        Residue_type[] ref_seq;
        String outname = String.valueOf(directory) + (isA ? "/const_1" : "/const_2");
        PDB_parser.writeConstrainingPDB(pdb_file1, outname, roi, chain);
        String psa_name = outname.replace("Models", "Control");
        psa_name = psa_name.replace("H3", "");
        psa_name = psa_name.replace("CDR", "");
        psa_name = psa_name.replace("FULL", "");
        psa_name = psa_name.replace("NS", "");
        System.out.println("Running psa");
        HashMap<Integer, Boolean> map = PSA.runPSA(7.0, psa_name);
        System.out.println("Done with psa");
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i : map.keySet()) {
            sorted.add(i);
        }
        HashMap<Integer, Residue> pdb_residues = PDB_parser.parse(outname, roi, chain);
        System.out.println(String.valueOf(pdb_file1) + " " + pdb_file1.lastIndexOf(47));
        if (isA && cdr_only) {
            CDRipatch.annotateStructure(pdb_file1.substring(pdb_file1.lastIndexOf(47) - 4, pdb_file1.lastIndexOf(47)), pdb_residues);
        }
        if (isA) {
            if (!use_full_msa) {
                ref_seq = msa.sequences.get((int)0).sequenceA;
            } else {
                ref_seq = msa.sequences.get((int)reference).sequenceA;
                System.out.println("Reference sequence is " + ref_seq.length);
            }
        } else if (!use_full_msa) {
            ref_seq = msa.sequences.get((int)0).sequenceB;
        } else {
            ref_seq = msa.sequences.get((int)reference).sequenceB;
            System.out.println("Reference sequence is " + ref_seq.length);
        }
        String first_seven = "";
        int k = 1;
        for (Integer i : sorted) {
            first_seven = String.valueOf(first_seven) + (Object)((Object)pdb_residues.get((Object)i).type);
            if (++k > 7) break;
        }
        String sequence = "";
        int l = 0;
        while (l < ref_seq.length) {
            if (ref_seq[l] != Residue_type.gap) {
                sequence = String.valueOf(sequence) + (Object)((Object)ref_seq[l]);
            }
            ++l;
        }
        System.out.println(String.valueOf(isA) + " ,first occurence " + sequence.indexOf(first_seven) + " of " + first_seven);
        System.out.println("In the sequence \n" + sequence);
        String the_ref = "";
        String the_res = "";
        int j = 0;
        int res_count = 0;
        int l2 = 0;
        while (l2 < ref_seq.length && res_count < sequence.indexOf(first_seven)) {
            if (ref_seq[l2] != Residue_type.gap) {
                ++res_count;
                the_ref = String.valueOf(the_ref) + (Object)((Object)ref_seq[j]);
                the_res = String.valueOf(the_res) + "-";
            }
            ++j;
            ++l2;
        }
        for (Integer i : sorted) {
            if (!pdb_residues.containsKey(i)) continue;
            while (j < ref_seq.length && ref_seq[j] != pdb_residues.get((Object)i).type) {
                if (ref_seq[j] != Residue_type.gap) {
                    the_ref = String.valueOf(the_ref) + (Object)((Object)ref_seq[j]);
                    the_res = String.valueOf(the_res) + "-";
                    System.out.println("Skipping over " + (Object)((Object)ref_seq[j]));
                    int temp_count = 0;
                    String prop_seq = "";
                    for (Integer i_new : sorted) {
                        if (i_new < i || temp_count >= 7) continue;
                        prop_seq = String.valueOf(prop_seq) + (Object)((Object)pdb_residues.get((Object)i_new).type);
                        ++temp_count;
                    }
                    System.out.println(prop_seq);
                    Object sequence_here = "";
                    int k_other = j + 1;
                    while (k_other < ref_seq.length) {
                        if (ref_seq[k_other] != Residue_type.gap) {
                            sequence_here = String.valueOf(sequence_here) + (Object)((Object)ref_seq[k_other]);
                        }
                        ++k_other;
                    }
                    int first_ = ((String)sequence_here).indexOf(prop_seq);
                    int k_other2 = j + 1;
                    k_other2 = j + 1;
                    while (k_other2 < ref_seq.length && first_ > 0) {
                        if (ref_seq[k_other2] != Residue_type.gap) {
                            --first_;
                        }
                        ++k_other2;
                    }
                    j = k_other2 - 1;
                    System.out.println("skipped over " + first_);
                }
                ++j;
            }
            if (j < ref_seq.length) {
                the_ref = String.valueOf(the_ref) + (Object)((Object)ref_seq[j]);
                the_res = String.valueOf(the_res) + (Object)((Object)pdb_residues.get((Object)i).type);
                pdb_residues.get(i).setRefSite(j);
                ++j;
                continue;
            }
            System.err.println("Main_outer:StructureandMSA: It was impossible to annotate sequence at residue " + i);
            pdb_residues.get(i).setRefSite(-1);
            System.exit(0);
        }
        System.out.println("Original from the MSA: " + the_ref);
        System.out.println("Aligned from the PDB : " + the_res);
        HashMap<Integer, Residue> final_residues = new HashMap<Integer, Residue>();
        ArrayList<Integer> nogapA = msa.gapColumnsA(0.5);
        ArrayList<Integer> nogapB = msa.gapColumnsB(0.5);
        for (Integer i : pdb_residues.keySet()) {
            String isa;
            String string = isa = isA ? "A: " : " B: ";
            if (!map.get(i).booleanValue() || (!isA || !nogapA.contains(pdb_residues.get(i).getRefSite())) && (isA || !nogapB.contains(pdb_residues.get(i).getRefSite()))) continue;
            Residue res = pdb_residues.get(i);
            final_residues.put(i, res);
        }
        SC_Structure to_return = new SC_Structure(final_residues, sorted, isA, chain);
        to_return.surface_exposed = map;
        String output = "";
        for (Integer i : final_residues.keySet()) {
            output = String.valueOf(output) + i + " " + final_residues.get(i).getRefSite() + " " + (Object)((Object)final_residues.get((Object)i).type) + "\n";
        }
        FileSystemTools.writeFile(String.valueOf(directory) + (isA ? "/mapping_1" : "/mapping_2"), output);
        return new SC_Structure(final_residues, sorted, isA, chain);
    }

    public static SC_Structure structureAndMSACore(String name, String dataset, String pdb_file1, MSA msa, int reference, boolean isA, ArrayList<Integer> roi, char chain, String directory, boolean use_full_msa, boolean cdr_only) {
        Residue_type[] ref_seq;
        String outname = String.valueOf(directory) + (isA ? "/const_1" : "/const_2");
        PDB_parser.writeConstrainingPDB(pdb_file1, outname, roi, chain);
        String psa_name = outname.replace("Models", "Control");
        psa_name = psa_name.replace("H3", "");
        psa_name = psa_name.replace("CDR", "");
        psa_name = psa_name.replace("FULL", "");
        psa_name = psa_name.replace("NS", "");
        System.out.println("Running psa");
        HashMap<Integer, Boolean> map = PropensityCalculation.getSurfExp(name, "AG_" + dataset, isA ? "Ab" : "Ag");
        System.out.println("Done with psa");
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i : map.keySet()) {
            sorted.add(i);
        }
        HashMap<Integer, Residue> pdb_residues = PDB_parser.parse(outname, roi, chain);
        System.out.println(String.valueOf(pdb_file1) + " " + pdb_file1.lastIndexOf(47));
        if (isA) {
            ABiPatch_ND.annotateCDR(pdb_residues, name, dataset, "ch");
        }
        if (isA) {
            if (!use_full_msa) {
                ref_seq = msa.sequences.get((int)0).sequenceA;
            } else {
                ref_seq = msa.sequences.get((int)reference).sequenceA;
                System.out.println("Reference sequence is " + ref_seq.length);
            }
        } else if (!use_full_msa) {
            ref_seq = msa.sequences.get((int)0).sequenceB;
        } else {
            ref_seq = msa.sequences.get((int)reference).sequenceB;
            System.out.println("Reference sequence is " + ref_seq.length);
        }
        String first_seven = "";
        int k = 1;
        for (Integer i : sorted) {
            first_seven = String.valueOf(first_seven) + (Object)((Object)pdb_residues.get((Object)i).type);
            if (++k > 7) break;
        }
        String sequence = "";
        int l = 0;
        while (l < ref_seq.length) {
            if (ref_seq[l] != Residue_type.gap) {
                sequence = String.valueOf(sequence) + (Object)((Object)ref_seq[l]);
            }
            ++l;
        }
        System.out.println(String.valueOf(isA) + " ,first occurence " + sequence.indexOf(first_seven) + " of " + first_seven);
        System.out.println("In the sequence \n" + sequence);
        String the_ref = "";
        String the_res = "";
        int j = 0;
        int res_count = 0;
        int l2 = 0;
        while (l2 < ref_seq.length && res_count < sequence.indexOf(first_seven)) {
            if (ref_seq[l2] != Residue_type.gap) {
                ++res_count;
                the_ref = String.valueOf(the_ref) + (Object)((Object)ref_seq[j]);
                the_res = String.valueOf(the_res) + "-";
            }
            ++j;
            ++l2;
        }
        for (Integer i : sorted) {
            if (!pdb_residues.containsKey(i)) continue;
            while (j < ref_seq.length && ref_seq[j] != pdb_residues.get((Object)i).type) {
                if (ref_seq[j] != Residue_type.gap) {
                    the_ref = String.valueOf(the_ref) + (Object)((Object)ref_seq[j]);
                    the_res = String.valueOf(the_res) + "-";
                    System.out.println("Skipping over " + (Object)((Object)ref_seq[j]));
                    int temp_count = 0;
                    String prop_seq = "";
                    for (Integer i_new : sorted) {
                        if (i_new < i || temp_count >= 7) continue;
                        prop_seq = String.valueOf(prop_seq) + (Object)((Object)pdb_residues.get((Object)i_new).type);
                        ++temp_count;
                    }
                    System.out.println(prop_seq);
                    Object sequence_here = "";
                    int k_other = j + 1;
                    while (k_other < ref_seq.length) {
                        if (ref_seq[k_other] != Residue_type.gap) {
                            sequence_here = String.valueOf(sequence_here) + (Object)((Object)ref_seq[k_other]);
                        }
                        ++k_other;
                    }
                    int first_ = ((String)sequence_here).indexOf(prop_seq);
                    int k_other2 = j + 1;
                    k_other2 = j + 1;
                    while (k_other2 < ref_seq.length && first_ > 0) {
                        if (ref_seq[k_other2] != Residue_type.gap) {
                            --first_;
                        }
                        ++k_other2;
                    }
                    j = k_other2 - 1;
                    System.out.println("skipped over " + first_);
                }
                ++j;
            }
            if (j < ref_seq.length) {
                the_ref = String.valueOf(the_ref) + (Object)((Object)ref_seq[j]);
                the_res = String.valueOf(the_res) + (Object)((Object)pdb_residues.get((Object)i).type);
                pdb_residues.get(i).setRefSite(j);
                ++j;
                continue;
            }
            System.err.println("Main_outer:StructureandMSA: It was impossible to annotate sequence at residue " + i);
            pdb_residues.get(i).setRefSite(-1);
            System.exit(0);
        }
        HashMap<Integer, Residue> final_residues = new HashMap<Integer, Residue>();
        ArrayList<Integer> nogapA = msa.gapColumnsA(0.5);
        ArrayList<Integer> nogapB = msa.gapColumnsB(0.5);
        for (Integer i : pdb_residues.keySet()) {
            String isa;
            String string = isa = isA ? "A: " : " B: ";
            if (!map.get(i).booleanValue() || (!isA || !nogapA.contains(pdb_residues.get(i).getRefSite())) && (isA || !nogapB.contains(pdb_residues.get(i).getRefSite()))) continue;
            Residue res = pdb_residues.get(i);
            final_residues.put(i, res);
        }
        SC_Structure to_return = new SC_Structure(final_residues, sorted, isA, chain);
        to_return.surface_exposed = map;
        String output = "";
        for (Integer i : final_residues.keySet()) {
            output = String.valueOf(output) + i + " " + final_residues.get(i).getRefSite() + " " + (Object)((Object)final_residues.get((Object)i).type) + "\n";
        }
        FileSystemTools.writeFile(String.valueOf(directory) + (isA ? "/mapping_1" : "/mapping_2"), output);
        return new SC_Structure(final_residues, sorted, isA, chain);
    }
}

