/*
 * Decompiled with CFR 0.152.
 */
package ABiPatch_NewData.copy;

import abModels.CDRipatch;
import abModels.ModelAnalyzer;
import data_structures.Residue;
import docking_global.DockingDistances;
import dockingfurther.PropensityCalculation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import utils.FileSystemTools;

public class ABiPatch_ND {
    private static final String userdir = System.getProperty("user.dir");
    public static final String data_dir = "/Volumes/NOAH/Wissenschaft/DP_recalculation";
    private static final double max_cut = 300.0;
    private static final double delta = 1.0;
    private static final double cdr_cut = 0.0;
    private static final int iterations = 10;
    public static final String res_dir = String.valueOf(userdir) + "/result_dump/DP_recalculation";

    public static void main(String[] args) {
        String dataset = "protein";
        ArrayList<statsRes> ab_results = new ArrayList<statsRes>();
        ArrayList<statsRes> ag_results = new ArrayList<statsRes>();
        ArrayList<Integer> st = new ArrayList<Integer>();
        st.add(0);
        st.add(0);
        st.add(0);
        st.add(0);
        int iter = 0;
        while (iter < 10) {
            statsRes ab_main = new statsRes();
            statsRes ag_main = new statsRes();
            ArrayList<String> to_test = PropensityCalculation.recalculateProps(dataset, 30);
            int prog = 0;
            System.out.println("Re-calculated props, test size = " + to_test.size());
            for (String folder : to_test) {
                System.out.println(String.valueOf(++prog) + "/" + to_test.size() + "[" + folder + "]");
                String f1 = "/Volumes/NOAH/Wissenschaft/DP_recalculation/AG_" + dataset + "/" + folder + "/Ab_std.pdb";
                String f2 = "/Volumes/NOAH/Wissenschaft/DP_recalculation/AG_" + dataset + "/" + folder + "/Ag_std.pdb";
                ModelAnalyzer.resStr res = ModelAnalyzer.abPonomND(folder, "TPRO", f1, f2, dataset);
                HashMap<Integer, Residue> ab = res.ab;
                HashMap<Integer, Residue> ag = res.ag;
                for (Integer i : ab.keySet()) {
                    Residue ab_r = ab.get(i);
                    for (Integer j : ag.keySet()) {
                        Residue ag_r = ag.get(j);
                        if (!(ab_r.distanceFrom(ag_r) < 4.5)) continue;
                        ab_r.isContact = true;
                        ag_r.isContact = true;
                    }
                }
                ArrayList<Integer> st_new = ABiPatch_ND.calcStatsCDR(ab);
                st = ABiPatch_ND.addLists(st, st_new);
                statsRes ab_res = ABiPatch_ND.calcStats(ab);
                statsRes ag_res = ABiPatch_ND.calcStats(ag);
                ab_main = statsRes.sumUp(ab_main, ab_res);
                ag_main = statsRes.sumUp(ag_main, ag_res);
            }
            ab_results.add(ab_main);
            ag_results.add(ag_main);
            ++iter;
        }
        statsRes ab_final = statsRes.mean(ab_results);
        statsRes ag_final = statsRes.mean(ag_results);
        ArrayList<String> out_static = new ArrayList<String>();
        out_static.add("" + st.get(0));
        out_static.add("" + st.get(1));
        out_static.add("" + st.get(2));
        out_static.add("" + st.get(3));
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/DP_recalculation/Test_res/" + dataset + "/static.txt", out_static);
        ab_final.writeToFile(String.valueOf(userdir) + "/result_dump/DP_recalculation/Test_res/" + dataset + "/Ab");
        ag_final.writeToFile(String.valueOf(userdir) + "/result_dump/DP_recalculation/Test_res/" + dataset + "/Ag");
    }

    public static ArrayList<Integer> addLists(ArrayList<Integer> l1, ArrayList<Integer> l2) {
        ArrayList<Integer> lnew = new ArrayList<Integer>();
        lnew.add(l1.get(0) + l2.get(0));
        lnew.add(l1.get(1) + l2.get(1));
        lnew.add(l1.get(2) + l2.get(2));
        lnew.add(l1.get(3) + l2.get(3));
        return lnew;
    }

    public static ArrayList<Integer> calcStatsCDR(HashMap<Integer, Residue> ab) {
        int tp = 0;
        int fp = 0;
        int fn = 0;
        int tn = 0;
        for (Integer i : ab.keySet()) {
            Residue r = ab.get(i);
            if (r.isContact && r.isCDR) {
                ++tp;
                continue;
            }
            if (r.isContact && !r.isCDR) {
                ++fn;
                continue;
            }
            if (!r.isContact && r.isCDR) {
                ++fp;
                continue;
            }
            if (!r.isContact && !r.isCDR) {
                ++tn;
                continue;
            }
            System.err.println("Something went wrong");
            System.err.println("R: " + r.isContact);
            System.exit(0);
        }
        ArrayList<Integer> res_list = new ArrayList<Integer>();
        res_list.add(tp);
        res_list.add(fp);
        res_list.add(tn);
        res_list.add(fn);
        return res_list;
    }

    public static statsRes calcStats(HashMap<Integer, Residue> ab) {
        HashMap<Double, Integer> tp = new HashMap<Double, Integer>();
        HashMap<Double, Integer> fp = new HashMap<Double, Integer>();
        HashMap<Double, Integer> tn = new HashMap<Double, Integer>();
        HashMap<Double, Integer> fn = new HashMap<Double, Integer>();
        double cut = 0.1;
        while (cut < 300.0) {
            cut = (double)Math.round(100.0 * cut) / 100.0;
            tp.put(cut, 0);
            fp.put(cut, 0);
            tn.put(cut, 0);
            fn.put(cut, 0);
            cut += 1.0;
        }
        int tot_cons = 0;
        ArrayList<Integer> ab_interface = DockingDistances.augmentCDR(ab, 0.0);
        for (Integer i : ab.keySet()) {
            Residue r = ab.get(i);
            double score = r.getTPro();
            System.out.println(score);
            if (r.isContact) {
                ++tot_cons;
            }
            if (Double.isNaN(score) || !ab_interface.contains(i) || !r.isCDR) continue;
            double cut2 = 0.1;
            while (cut2 < 300.0) {
                cut2 = (double)Math.round(100.0 * cut2) / 100.0;
                if (r.isContact && score > cut2) {
                    tp.put(cut2, tp.get(cut2) + 1);
                } else if (r.isContact && score < cut2) {
                    fn.put(cut2, fn.get(cut2) + 1);
                } else if (!r.isContact && score > cut2) {
                    fp.put(cut2, fp.get(cut2) + 1);
                } else if (!r.isContact && score < cut2) {
                    tn.put(cut2, tn.get(cut2) + 1);
                } else {
                    System.err.println("Something went wrong");
                    System.err.println("R: " + r.isContact);
                    System.err.println("R: " + score);
                    System.exit(0);
                }
                cut2 += 1.0;
            }
        }
        System.out.println("Tot cons " + tot_cons);
        return new statsRes(tp, fp, tn, fn);
    }

    public static HashMap<String, String> readInOptions(String[] args) {
        System.out.println("Listing the arguments:");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("-agf", "");
        options.put("-abf", "");
        int i = 0;
        while (i < args.length) {
            String opt;
            if (i == args.length) {
                System.err.println("Not enough arguments supplied");
                ABiPatch_ND.printUsage();
            }
            if (!options.containsKey(opt = args[i])) {
                System.err.println("Unknown option : " + opt);
                ABiPatch_ND.printUsage();
            }
            if (i == args.length - 1) {
                System.err.println("Not enough arguments supplied");
                ABiPatch_ND.printUsage();
            }
            String input = args[i + 1];
            ++i;
            options.put(opt, input);
            ++i;
        }
        System.out.println("Executing with options:");
        for (String opt : options.keySet()) {
            if (options.get(opt).length() == 0 && !opt.contains("-cons")) {
                System.err.println(String.valueOf(opt) + " uninitialized");
                ABiPatch_ND.printUsage();
                continue;
            }
            System.out.println(String.valueOf(opt) + " : " + options.get(opt));
            File f = new File(String.valueOf(userdir) + "/" + options.get(opt));
            if (f.exists()) continue;
            System.out.println("The file " + options.get(opt) + " doesn't exist - Stopping");
            ABiPatch_ND.printUsage();
        }
        return options;
    }

    public static void annotateCDR(HashMap<Integer, Residue> str, String pdb, String d_name, String tech) {
        ArrayList<String> cdrs = new ArrayList<String>();
        String seq = ABiPatch_ND.getSeq(str);
        System.out.println(seq);
        cdrs.add("H_CDR1");
        cdrs.add("H_CDR2");
        cdrs.add("H_CDR3");
        cdrs.add("L_CDR1");
        cdrs.add("L_CDR2");
        cdrs.add("L_CDR3");
        for (String cdr : cdrs) {
            ArrayList<String> cdr_seqs = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/DP_recalculation/CDR_rep/" + pdb.substring(0, 4) + "_" + tech + "_" + cdr + ".txt");
            String cdr_seq = cdr_seqs.get(0);
            if (cdr_seq == null || cdr_seq.equals("")) {
                System.err.println("CDR issue with " + pdb);
                System.exit(0);
            }
            if (seq.indexOf(cdr_seq) == -1) continue;
            CDRipatch.annotateAccordingly(seq.indexOf(cdr_seq), cdr_seq.length(), str, cdr_seq, "");
        }
    }

    public static String getSeq(HashMap<Integer, Residue> str) {
        TreeSet<Integer> sort = new TreeSet<Integer>();
        for (Integer i : str.keySet()) {
            sort.add(i);
        }
        String seq = "";
        for (Integer i : sort) {
            seq = String.valueOf(seq) + (Object)((Object)str.get((Object)i).type);
        }
        return seq;
    }

    public static void printUsage() {
        System.out.println("Usage:");
        System.out.println("java -jar ABiPatch.jar -abf [antibody file] -agf [antigen file] ");
        System.out.println("All the chains should be merged into one and called 'A', with residue ids beginning with 1.");
        System.out.println("The files are output in the same directory as the original files, called antibody.pdb and anrigen.pdb with the B-Factor fields overwritten with the i-Patch score.");
        System.exit(0);
    }

    public static class statsRes {
        public final HashMap<Double, Integer> ab_tp;
        public final HashMap<Double, Integer> ab_fp;
        public final HashMap<Double, Integer> ab_tn;
        public final HashMap<Double, Integer> ab_fn;

        public static statsRes sumUp(statsRes sr1, statsRes sr2) {
            HashMap<Double, Integer> tp = new HashMap<Double, Integer>();
            HashMap<Double, Integer> fp = new HashMap<Double, Integer>();
            HashMap<Double, Integer> tn = new HashMap<Double, Integer>();
            HashMap<Double, Integer> fn = new HashMap<Double, Integer>();
            for (double d : sr1.ab_tp.keySet()) {
                tp.put(d, sr1.ab_tp.get(d) + sr2.ab_tp.get(d));
                fp.put(d, sr1.ab_fp.get(d) + sr2.ab_fp.get(d));
                tn.put(d, sr1.ab_tn.get(d) + sr2.ab_tn.get(d));
                fn.put(d, sr1.ab_fn.get(d) + sr2.ab_fn.get(d));
            }
            return new statsRes(tp, fp, tn, fn);
        }

        public static statsRes mean(ArrayList<statsRes> list) {
            statsRes sr = new statsRes();
            for (statsRes sr_entry : list) {
                sr = statsRes.sumUp(sr, sr_entry);
            }
            HashMap<Double, Integer> tp = new HashMap<Double, Integer>();
            HashMap<Double, Integer> fp = new HashMap<Double, Integer>();
            HashMap<Double, Integer> tn = new HashMap<Double, Integer>();
            HashMap<Double, Integer> fn = new HashMap<Double, Integer>();
            for (double d : sr.ab_tp.keySet()) {
                tp.put(d, sr.ab_tp.get(d) / list.size());
                fp.put(d, sr.ab_fp.get(d) / list.size());
                tn.put(d, sr.ab_tn.get(d) / list.size());
                fn.put(d, sr.ab_fn.get(d) / list.size());
            }
            return new statsRes(tp, fp, tn, fn);
        }

        public statsRes() {
            HashMap<Double, Integer> tp = new HashMap<Double, Integer>();
            HashMap<Double, Integer> fp = new HashMap<Double, Integer>();
            HashMap<Double, Integer> tn = new HashMap<Double, Integer>();
            HashMap<Double, Integer> fn = new HashMap<Double, Integer>();
            double cut = 0.1;
            while (cut < 300.0) {
                cut = (double)Math.round(100.0 * cut) / 100.0;
                tp.put(cut, 0);
                fp.put(cut, 0);
                tn.put(cut, 0);
                fn.put(cut, 0);
                cut += 1.0;
            }
            this.ab_tp = tp;
            this.ab_fp = fp;
            this.ab_tn = tn;
            this.ab_fn = fn;
        }

        public void writeToFile(String filename) {
            this.printSingle(String.valueOf(filename) + "_TP.txt", this.ab_tp);
            this.printSingle(String.valueOf(filename) + "_FP.txt", this.ab_fp);
            this.printSingle(String.valueOf(filename) + "_TN.txt", this.ab_tn);
            this.printSingle(String.valueOf(filename) + "_FN.txt", this.ab_fn);
        }

        public void printSingle(String filename, HashMap<Double, Integer> map) {
            ArrayList<String> out = new ArrayList<String>();
            for (double d : map.keySet()) {
                out.add(String.valueOf(d) + " " + map.get(d));
            }
            FileSystemTools.writeFile(filename, out);
        }

        public statsRes(HashMap<Double, Integer> tp, HashMap<Double, Integer> fp, HashMap<Double, Integer> tn, HashMap<Double, Integer> fn) {
            this.ab_tp = tp;
            this.ab_fp = fp;
            this.ab_tn = tn;
            this.ab_fn = fn;
        }
    }
}

