/*
 * Decompiled with CFR 0.152.
 */
package docking;

import abModels.CDRipatch;
import data_structures.Residue;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import parsing.PDB_parser;
import utils.FileSystemTools;
import utils.MathFunctions;

public class PrepareCases {
    private static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        PrepareCases.preparePatchDockCases();
    }

    public static void preparePatchDockCases() {
        String folder = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/patchdock_cases";
        ArrayList<String> cases = FileSystemTools.getFolders(folder);
        for (String _case : cases) {
            System.out.println("Doing " + _case);
            ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(folder) + "/" + _case);
            for (String pdb : pdbs) {
                System.out.println("Doing " + pdb);
                ArrayList<String> ze_lines = FileSystemTools.readFile(String.valueOf(folder) + "/" + _case + "/" + pdb + "/epitope_z.txt");
                ArrayList<String> zp_lines = FileSystemTools.readFile(String.valueOf(folder) + "/" + _case + "/" + pdb + "/paratope_z.txt");
                ArrayList<Integer> z_epitope = new ArrayList<Integer>();
                ArrayList<Integer> z_paratope = new ArrayList<Integer>();
                for (String line : ze_lines) {
                    z_epitope.add(Integer.parseInt(line));
                }
                for (String line : zp_lines) {
                    z_paratope.add(Integer.parseInt(line));
                }
                HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(folder) + "/" + _case + "/" + pdb + "/AB.pdb");
                HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(folder) + "/" + _case + "/" + pdb + "/AG.pdb");
                String epi_con = "";
                String para_con = "";
                for (Integer i : ab.keySet()) {
                    if (z_paratope.contains(i)) continue;
                    para_con = String.valueOf(para_con) + i + " A\n";
                }
                for (Integer i : ag.keySet()) {
                    if (z_epitope.contains(i)) continue;
                    epi_con = String.valueOf(epi_con) + i + " A\n";
                }
                FileSystemTools.writeFile(String.valueOf(folder) + "/" + _case + "/" + pdb + "/p_epitope.txt", epi_con);
                FileSystemTools.writeFile(String.valueOf(folder) + "/" + _case + "/" + pdb + "/p_paratope.txt", para_con);
            }
        }
    }

    public static void prepareIRMSD() {
        String solution_fold = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution";
        ArrayList<String> pdbs = FileSystemTools.getFolders(solution_fold);
        for (String pdb : pdbs) {
            System.out.println("Processing: " + pdb);
            HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(solution_fold) + "/" + pdb + "/AB.pdb", 'A');
            HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(solution_fold) + "/" + pdb + "/AG.pdb", 'A');
            ArrayList<Integer> ab_ifc = new ArrayList<Integer>();
            ArrayList<Integer> ag_ifc = new ArrayList<Integer>();
            for (Integer ab_i : ab.keySet()) {
                Residue ab_r = ab.get(ab_i);
                for (Integer ag_i : ag.keySet()) {
                    Residue ag_r = ag.get(ag_i);
                    if (!(ab_r.distanceFrom(ag_r) < 10.0)) continue;
                    if (!ab_ifc.contains(ab_i)) {
                        ab_ifc.add(ab_i);
                    }
                    if (ag_ifc.contains(ag_i)) continue;
                    ag_ifc.add(ag_i);
                }
            }
            String ab_out = "";
            for (Integer i : ab_ifc) {
                ab_out = String.valueOf(ab_out) + i + "\n";
            }
            String ag_out = "";
            for (Integer i : ag_ifc) {
                ag_out = String.valueOf(ag_out) + i + "\n";
            }
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/IRMSD/" + pdb + "_AB.txt", ab_out);
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/IRMSD/" + pdb + "_AG.txt", ag_out);
        }
    }

    public static void ipatchCasesSCORE(String case_num, String cutoff, boolean copy_epitope) {
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("H");
        cases.add("R");
        for (String _case : cases) {
            String case_file = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_ipatch/case_" + case_num + _case;
            File f = new File(case_file);
            if (!f.exists()) {
                f.mkdir();
            }
            String source_file = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_5BASE/case_5" + _case;
            for (String pdb : FileSystemTools.getFolders(source_file)) {
                f = new File(String.valueOf(case_file) + "/" + pdb);
                if (!f.exists()) {
                    f.mkdir();
                }
                FileSystemTools.CopyFile(String.valueOf(source_file) + "/" + pdb + "/AB.pdb", String.valueOf(case_file) + "/" + pdb + "/AB.pdb");
                FileSystemTools.CopyFile(String.valueOf(source_file) + "/" + pdb + "/AG.pdb", String.valueOf(case_file) + "/" + pdb + "/AG.pdb");
                if (copy_epitope) {
                    FileSystemTools.CopyFile(String.valueOf(source_file) + "/" + pdb + "/epitope_z.txt", String.valueOf(case_file) + "/" + pdb + "/epitope_z.txt");
                }
                ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(source_file) + "/" + pdb + "/ipatch_" + cutoff + ".txt");
                ArrayList<Integer> contact = new ArrayList<Integer>();
                for (String line : lines) {
                    if (line.length() <= 0) continue;
                    contact.add(Integer.parseInt(line));
                }
                HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(source_file) + "/" + pdb + "/AB.pdb");
                String paratope_out = "";
                for (Integer i : ab.keySet()) {
                    if (contact.contains(i)) continue;
                    paratope_out = String.valueOf(paratope_out) + i + "\n";
                }
                FileSystemTools.writeFile(String.valueOf(case_file) + "/" + pdb + "/paratope_z.txt", paratope_out);
            }
        }
    }

    public static void ipatchCasesSCOREPARTIAL(String case_num, String cutoff, boolean copy_epitope) {
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("H");
        cases.add("R");
        for (String _case : cases) {
            String case_file = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_ipatch/case_" + case_num + _case;
            File f = new File(case_file);
            if (!f.exists()) {
                f.mkdir();
            }
            String source_file = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_5BASE/case_5" + _case;
            for (String pdb : FileSystemTools.getFolders(source_file)) {
                f = new File(String.valueOf(case_file) + "/" + pdb);
                if (!f.exists()) {
                    f.mkdir();
                }
                FileSystemTools.CopyFile(String.valueOf(source_file) + "/" + pdb + "/AB.pdb", String.valueOf(case_file) + "/" + pdb + "/AB.pdb");
                FileSystemTools.CopyFile(String.valueOf(source_file) + "/" + pdb + "/AG.pdb", String.valueOf(case_file) + "/" + pdb + "/AG.pdb");
                if (copy_epitope) {
                    FileSystemTools.CopyFile("/Users/bielasek/Sites/Dropbox/workspace/I-Patch/result_dump/Docking/docking_dataset/real/" + pdb + "/epitope_4.txt", String.valueOf(case_file) + "/" + pdb + "/epitope_z.txt");
                }
                ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(source_file) + "/" + pdb + "/ipatch_" + cutoff + ".txt");
                ArrayList<Integer> contact = new ArrayList<Integer>();
                for (String line : lines) {
                    if (line.length() <= 0) continue;
                    contact.add(Integer.parseInt(line));
                }
                HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(source_file) + "/" + pdb + "/AB.pdb");
                String paratope_out = "";
                for (Integer i : ab.keySet()) {
                    if (contact.contains(i)) continue;
                    paratope_out = String.valueOf(paratope_out) + i + "\n";
                }
                FileSystemTools.writeFile(String.valueOf(case_file) + "/" + pdb + "/paratope_z.txt", paratope_out);
            }
        }
    }

    public static void ipatchCasesTOPN(String case_num, String cutoff, boolean copy_epitope) {
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("H");
        cases.add("S");
        cases.add("R");
        for (String _case : cases) {
            String case_file = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_ipatch/case_" + case_num + _case;
            File f = new File(case_file);
            if (!f.exists()) {
                f.mkdir();
            }
            String source_file = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_5BASE/case_5" + _case;
            for (String pdb : FileSystemTools.getFolders(source_file)) {
                f = new File(String.valueOf(case_file) + "/" + pdb);
                if (!f.exists()) {
                    f.mkdir();
                }
                FileSystemTools.CopyFile(String.valueOf(source_file) + "/" + pdb + "/AB.pdb", String.valueOf(case_file) + "/" + pdb + "/AB.pdb");
                FileSystemTools.CopyFile(String.valueOf(source_file) + "/" + pdb + "/AG.pdb", String.valueOf(case_file) + "/" + pdb + "/AG.pdb");
                if (copy_epitope) {
                    FileSystemTools.CopyFile(String.valueOf(source_file) + "/" + pdb + "/epitope_z.txt", String.valueOf(case_file) + "/" + pdb + "/epitope_z.txt");
                }
                ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(source_file) + "/" + pdb + "/top" + cutoff + ".txt");
                ArrayList<Integer> contact = new ArrayList<Integer>();
                for (String line : lines) {
                    if (line.length() <= 0) continue;
                    contact.add(Integer.parseInt(line));
                }
                HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(source_file) + "/" + pdb + "/AB.pdb");
                String paratope_out = "";
                for (Integer i : ab.keySet()) {
                    if (contact.contains(i)) continue;
                    paratope_out = String.valueOf(paratope_out) + i + "\n";
                }
                FileSystemTools.writeFile(String.valueOf(case_file) + "/" + pdb + "/paratope_z.txt", paratope_out);
            }
        }
    }

    public static void case_3() {
        String sol_dir = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution";
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("case_3R");
        cases.add("case_3S");
        cases.add("case_3H");
        for (String _case : cases) {
            ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_3/" + _case);
            for (String pdb : pdbs) {
                String curr_fold = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_3/" + _case + "/" + pdb;
                System.out.println(String.valueOf(_case) + " " + pdb);
                String epitope = String.valueOf(sol_dir) + "/" + pdb + "/epitope_z.txt";
                FileSystemTools.CopyFile(epitope, String.valueOf(curr_fold) + "/epitope_z.txt");
                HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(curr_fold) + "/AB.pdb", 'A');
                System.out.println("=================");
                System.out.println("Size = " + ab.size());
                CDRipatch.annotateStructure(pdb, ab);
                String par_z = "";
                TreeSet<Integer> ids = new TreeSet<Integer>();
                for (Integer i : ab.keySet()) {
                    ids.add(i);
                }
                for (Integer i : ids) {
                    System.out.println(i + " " + ab.get((Object)i).isCDR);
                    if (ab.get((Object)i).isCDR) continue;
                    par_z = String.valueOf(par_z) + i + "\n";
                }
                FileSystemTools.writeFile(String.valueOf(curr_fold) + "/paratope_z.txt", par_z);
                System.out.println("=================");
            }
        }
    }

    public static void case_partial() {
        String sol_dir = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution";
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("case_3R");
        cases.add("case_3H");
        cases.add("case_3S");
        for (String _case : cases) {
            String src = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_3/" + _case;
            ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_3/" + _case);
            String case_fold = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_partial/" + _case;
            File f = new File(case_fold);
            if (!f.exists()) {
                f.mkdir();
            }
            for (String pdb : pdbs) {
                String curr_fold = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_partial/" + _case + "/" + pdb;
                f = new File(curr_fold);
                if (!f.exists()) {
                    f.mkdir();
                }
                System.out.println(String.valueOf(_case) + " " + pdb);
                String epitope = String.valueOf(sol_dir) + "/" + pdb + "/epitope_4.txt";
                FileSystemTools.CopyFile(epitope, String.valueOf(curr_fold) + "/epitope_z.txt");
                HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(src) + "/" + pdb + "/AB.pdb", 'A');
                System.out.println("=================");
                System.out.println("Size = " + ab.size());
                CDRipatch.annotateStructure(pdb, ab);
                String par_z = "";
                TreeSet<Integer> ids = new TreeSet<Integer>();
                for (Integer i : ab.keySet()) {
                    ids.add(i);
                }
                for (Integer i : ids) {
                    System.out.println(i + " " + ab.get((Object)i).isCDR);
                    if (ab.get((Object)i).isCDR) continue;
                    par_z = String.valueOf(par_z) + i + "\n";
                }
                FileSystemTools.writeFile(String.valueOf(curr_fold) + "/paratope_z.txt", par_z);
                FileSystemTools.CopyFile(String.valueOf(src) + "/" + pdb + "/AB.pdb", String.valueOf(curr_fold) + "/AB.pdb");
                FileSystemTools.CopyFile(String.valueOf(src) + "/" + pdb + "/AG.pdb", String.valueOf(curr_fold) + "/AG.pdb");
                System.out.println("=================");
            }
        }
    }

    public static void case_4() {
        String sol_dir = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution";
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("case_4R");
        cases.add("case_4S");
        cases.add("case_4H");
        for (String _case : cases) {
            ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_4/" + _case);
            for (String pdb : pdbs) {
                String curr_fold = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_4/" + _case + "/" + pdb;
                System.out.println(String.valueOf(_case) + " " + pdb);
                HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(curr_fold) + "/AB.pdb", 'A');
                System.out.println("=================");
                System.out.println("Size = " + ab.size());
                CDRipatch.annotateStructure(pdb, ab);
                String par_z = "";
                TreeSet<Integer> ids = new TreeSet<Integer>();
                for (Integer i : ab.keySet()) {
                    ids.add(i);
                }
                for (Integer i : ids) {
                    System.out.println(i + " " + ab.get((Object)i).isCDR);
                    if (ab.get((Object)i).isCDR) continue;
                    par_z = String.valueOf(par_z) + i + "\n";
                }
                FileSystemTools.writeFile(String.valueOf(curr_fold) + "/paratope_z.txt", par_z);
                System.out.println("=================");
            }
        }
    }

    public static void prepareEParatopes() {
        String target_dir = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution";
        ArrayList<String> targets = FileSystemTools.getFolders(target_dir);
        int progress = 0;
        int total_cons = 0;
        int total_cdrs = 0;
        for (String pdb_code : targets) {
            System.out.println("Reading [" + pdb_code + "] " + ++progress + "/" + targets.size());
            String ab_fname = String.valueOf(target_dir) + "/" + pdb_code + "/AB.pdb";
            String ag_fname = String.valueOf(target_dir) + "/" + pdb_code + "/AG.pdb";
            String real_folder = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/real/" + pdb_code;
            String with_H3_folder = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/with_H3/" + pdb_code;
            String solution_dir = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution/" + pdb_code;
            HashMap<Integer, Residue> antibody = PDB_parser.parse(ab_fname, 'A');
            HashMap<Integer, Residue> antigen = PDB_parser.parse(ag_fname, 'A');
            CDRipatch.annotateStructure(pdb_code, antibody);
            int[][] spec = new int[antibody.size() + 1][antigen.size() + 1];
            ArrayList<Integer> ab_cons = new ArrayList<Integer>();
            ArrayList<Integer> ag_cons = new ArrayList<Integer>();
            for (Integer ab_i : antibody.keySet()) {
                Residue ab_r = antibody.get(ab_i);
                for (Integer ag_i : antigen.keySet()) {
                    Residue ag_r = antigen.get(ag_i);
                    if (!(ab_r.distanceFrom(ag_r) < 4.5)) continue;
                    if (!ab_cons.contains(ab_i)) {
                        ab_cons.add(ab_i);
                        ++total_cons;
                    }
                    if (!ag_cons.contains(ag_i)) {
                        ag_cons.add(ag_i);
                    }
                    spec[ab_i.intValue()][ag_i.intValue()] = 1;
                }
            }
            ArrayList<Integer> aug_antigen_4 = new ArrayList<Integer>();
            ArrayList<Integer> aug_antigen_5 = new ArrayList<Integer>();
            ArrayList<Integer> aug_antigen_6 = new ArrayList<Integer>();
            for (Integer ag_con : ag_cons) {
                if (!aug_antigen_4.contains(ag_con)) {
                    aug_antigen_4.add(ag_con);
                }
                if (!aug_antigen_5.contains(ag_con)) {
                    aug_antigen_5.add(ag_con);
                }
                if (!aug_antigen_6.contains(ag_con)) {
                    aug_antigen_6.add(ag_con);
                }
                Residue central = antigen.get(ag_con);
                for (Integer ag_patch : antigen.keySet()) {
                    if (ag_patch == ag_con) continue;
                    Residue neigh = antigen.get(ag_patch);
                    if (central.distanceFrom(neigh) < 4.0 && !aug_antigen_4.contains(ag_patch)) {
                        aug_antigen_4.add(ag_patch);
                    }
                    if (central.distanceFrom(neigh) < 5.0 && !aug_antigen_5.contains(ag_patch)) {
                        aug_antigen_5.add(ag_patch);
                    }
                    if (!(central.distanceFrom(neigh) < 6.0) || aug_antigen_6.contains(ag_patch)) continue;
                    aug_antigen_6.add(ag_patch);
                }
            }
            for (Integer i : antibody.keySet()) {
                if (!antibody.get((Object)i).isCDR) continue;
                ++total_cdrs;
            }
            if (antibody.size() < 1) {
                System.out.println("Fuckup");
                System.exit(0);
            }
            if (antigen.size() < 1) {
                System.out.println("Fuckup");
                System.exit(0);
            }
            String ep = "";
            String ep_z = "";
            String map_con = "";
            for (Integer i : ag_cons) {
                ep = String.valueOf(ep) + i + " A\n";
                map_con = String.valueOf(map_con) + i + "_AG\n";
            }
            for (Integer i : antigen.keySet()) {
                if (ag_cons.contains(i)) continue;
                ep_z = String.valueOf(ep_z) + i + "\n";
            }
            String ep_4 = "";
            String ep_5 = "";
            String ep_6 = "";
            for (Integer i : antigen.keySet()) {
                if (!aug_antigen_4.contains(i)) {
                    ep_4 = String.valueOf(ep_4) + i + "\n";
                }
                if (!aug_antigen_5.contains(i)) {
                    ep_5 = String.valueOf(ep_5) + i + "\n";
                }
                if (aug_antigen_6.contains(i)) continue;
                ep_6 = String.valueOf(ep_6) + i + "\n";
            }
            String ep_4_bild = "";
            String ep_5_bild = "";
            String ep_6_bild = "";
            for (Integer i : aug_antigen_4) {
                ep_4_bild = String.valueOf(ep_4_bild) + i + "\n";
            }
            for (Integer i : aug_antigen_5) {
                ep_5_bild = String.valueOf(ep_5_bild) + i + "\n";
            }
            for (Integer i : aug_antigen_6) {
                ep_6_bild = String.valueOf(ep_6_bild) + i + "\n";
            }
            FileSystemTools.writeFile(String.valueOf(real_folder) + "/epitope_4_raw.txt", ep_4_bild);
            FileSystemTools.writeFile(String.valueOf(real_folder) + "/epitope_5_raw.txt", ep_5_bild);
            FileSystemTools.writeFile(String.valueOf(real_folder) + "/epitope_6_raw.txt", ep_6_bild);
            FileSystemTools.writeFile(String.valueOf(real_folder) + "/epitope_4.txt", ep_4);
            FileSystemTools.writeFile(String.valueOf(real_folder) + "/epitope_5.txt", ep_5);
            FileSystemTools.writeFile(String.valueOf(real_folder) + "/epitope_6.txt", ep_6);
            FileSystemTools.writeFile(String.valueOf(real_folder) + "/epitope.txt", ep);
            FileSystemTools.writeFile(String.valueOf(real_folder) + "/epitope_z.txt", ep_z);
            FileSystemTools.writeFile(String.valueOf(with_H3_folder) + "/epitope.txt", ep);
            FileSystemTools.writeFile(String.valueOf(with_H3_folder) + "/epitope_z.txt", ep_z);
            FileSystemTools.writeFile(String.valueOf(with_H3_folder) + "/epitope_4.txt", ep_4);
            FileSystemTools.writeFile(String.valueOf(with_H3_folder) + "/epitope_5.txt", ep_5);
            FileSystemTools.writeFile(String.valueOf(with_H3_folder) + "/epitope_6.txt", ep_6);
            FileSystemTools.writeFile(String.valueOf(solution_dir) + "/epitope.txt", ep);
            FileSystemTools.writeFile(String.valueOf(solution_dir) + "/epitope_z.txt", ep_z);
            FileSystemTools.writeFile(String.valueOf(solution_dir) + "/epitope_4.txt", ep_4);
            FileSystemTools.writeFile(String.valueOf(solution_dir) + "/epitope_5.txt", ep_5);
            FileSystemTools.writeFile(String.valueOf(solution_dir) + "/epitope_6.txt", ep_6);
            ep = "";
            ep_z = "";
            String pd_ep = "";
            for (Integer i : ab_cons) {
                ep = String.valueOf(ep) + i + " A\n";
                map_con = String.valueOf(map_con) + i + "_AB\n";
                if (i >= 100) continue;
                pd_ep = String.valueOf(pd_ep) + i + " A\n";
            }
            for (Integer i : antibody.keySet()) {
                if (ab_cons.contains(i)) continue;
                ep_z = String.valueOf(ep_z) + i + "\n";
            }
            FileSystemTools.writeFile(String.valueOf(real_folder) + "/paratope.txt", pd_ep);
            FileSystemTools.writeFile(String.valueOf(real_folder) + "/paratope_z.txt", ep_z);
            FileSystemTools.writeFile(String.valueOf(real_folder) + "/map_con.txt", map_con);
            FileSystemTools.writeFile(String.valueOf(with_H3_folder) + "/paratope.txt", pd_ep);
            FileSystemTools.writeFile(String.valueOf(with_H3_folder) + "/paratope_z.txt", ep_z);
            FileSystemTools.writeFile(String.valueOf(with_H3_folder) + "/map_con.txt", map_con);
            FileSystemTools.writeFile(String.valueOf(solution_dir) + "/paratope.txt", pd_ep);
            FileSystemTools.writeFile(String.valueOf(solution_dir) + "/paratope_z.txt", ep_z);
            FileSystemTools.writeFile(String.valueOf(solution_dir) + "/map_con.txt", map_con);
            FileSystemTools.CopyFile(String.valueOf(real_folder) + "/AB.pdb", String.valueOf(real_folder) + "/strA.pdb");
            FileSystemTools.CopyFile(String.valueOf(real_folder) + "/AG.pdb", String.valueOf(real_folder) + "/strB.pdb");
            FileSystemTools.CopyFile(String.valueOf(with_H3_folder) + "/AB.pdb", String.valueOf(with_H3_folder) + "/strA.pdb");
            FileSystemTools.CopyFile(String.valueOf(with_H3_folder) + "/AG.pdb", String.valueOf(with_H3_folder) + "/strB.pdb");
            FileSystemTools.CopyFile(String.valueOf(solution_dir) + "/AB.pdb", String.valueOf(solution_dir) + "/strA.pdb");
            FileSystemTools.CopyFile(String.valueOf(solution_dir) + "/AG.pdb", String.valueOf(solution_dir) + "/strB.pdb");
            MathFunctions.printParsable2D(spec, String.valueOf(solution_dir) + "/specific.txt");
        }
        System.out.println("Contacts: " + total_cons);
        System.out.println("CDRS: " + total_cdrs);
    }

    public static void fixed_1() {
    }
}

