/*
 * Decompiled with CFR 0.152.
 */
package othermethods;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import utils.FileSystemTools;

public class MSAmethods {
    private static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        String alignment = String.valueOf(userdir) + "/pnase.txt";
        String output = "out_align";
        MSAmethods.MI(alignment, output);
        MSAmethods.ELSC(alignment, output);
        MSAmethods.OmesCovariance(alignment, output);
        MSAmethods.SCA(alignment, output);
        MSAmethods.ConservationSum(alignment, output);
        MSAmethods.RandomScore(alignment, output);
    }

    public static void MI(String alignment, String output) {
        System.out.println("Running MI");
        String command = "java covariance.algorithms.MICovariance " + alignment + " " + output;
        try {
            String s;
            Process p_psa = Runtime.getRuntime().exec(command);
            BufferedReader stdInput_psa = new BufferedReader(new InputStreamReader(p_psa.getInputStream()));
            BufferedReader stdError_psa = new BufferedReader(new InputStreamReader(p_psa.getErrorStream()));
            while ((s = stdError_psa.readLine()) != null) {
                System.err.println(s);
            }
            while ((s = stdInput_psa.readLine()) != null) {
                System.out.println(s);
            }
            FileSystemTools.RemoveLine(output, 0);
            FileSystemTools.RemoveLine(output, 0);
            p_psa.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void SCA(String alignment, String output) {
        System.out.println("Running SCA");
        String command = "java covariance.algorithms.JavaSCA " + alignment + " " + output;
        try {
            String s;
            Process p_psa = Runtime.getRuntime().exec(command);
            BufferedReader stdInput_psa = new BufferedReader(new InputStreamReader(p_psa.getInputStream()));
            BufferedReader stdError_psa = new BufferedReader(new InputStreamReader(p_psa.getErrorStream()));
            while ((s = stdError_psa.readLine()) != null) {
                System.err.println(s);
            }
            while ((s = stdInput_psa.readLine()) != null) {
                System.out.println(s);
            }
            FileSystemTools.RemoveLine(output, 0);
            p_psa.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void ELSC(String alignment, String output) {
        System.out.println("Running ELSC");
        String command = "java covariance.algorithms.ELSCCovariance " + alignment + " " + output;
        try {
            String s;
            Process p_psa = Runtime.getRuntime().exec(command);
            BufferedReader stdInput_psa = new BufferedReader(new InputStreamReader(p_psa.getInputStream()));
            BufferedReader stdError_psa = new BufferedReader(new InputStreamReader(p_psa.getErrorStream()));
            while ((s = stdError_psa.readLine()) != null) {
                System.err.println(s);
            }
            while ((s = stdInput_psa.readLine()) != null) {
                System.out.println(s);
            }
            FileSystemTools.RemoveLine(output, 0);
            p_psa.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void OmesCovariance(String alignment, String output) {
        System.out.println("Running OmesCovariance");
        String command = "java covariance.algorithms.OmesCovariance " + alignment + " " + output;
        try {
            String s;
            Process p_psa = Runtime.getRuntime().exec(command);
            BufferedReader stdInput_psa = new BufferedReader(new InputStreamReader(p_psa.getInputStream()));
            BufferedReader stdError_psa = new BufferedReader(new InputStreamReader(p_psa.getErrorStream()));
            while ((s = stdError_psa.readLine()) != null) {
                System.err.println(s);
            }
            while ((s = stdInput_psa.readLine()) != null) {
                System.out.println(s);
            }
            FileSystemTools.RemoveLine(output, 0);
            p_psa.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void ConservationSum(String alignment, String output) {
        System.out.println("Running ConservationSum");
        String command = "java covariance.algorithms.ConservationSum " + alignment + " " + output;
        try {
            String s;
            Process p_psa = Runtime.getRuntime().exec(command);
            BufferedReader stdInput_psa = new BufferedReader(new InputStreamReader(p_psa.getInputStream()));
            BufferedReader stdError_psa = new BufferedReader(new InputStreamReader(p_psa.getErrorStream()));
            while ((s = stdError_psa.readLine()) != null) {
                System.err.println(s);
            }
            while ((s = stdInput_psa.readLine()) != null) {
                System.out.println(s);
            }
            FileSystemTools.RemoveLine(output, 0);
            p_psa.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void RandomScore(String alignment, String output) {
        System.out.println("Running RandomScore");
        String command = "java covariance.algorithms.RandomScore " + alignment + " " + output;
        try {
            String s;
            Process p_psa = Runtime.getRuntime().exec(command);
            BufferedReader stdInput_psa = new BufferedReader(new InputStreamReader(p_psa.getInputStream()));
            BufferedReader stdError_psa = new BufferedReader(new InputStreamReader(p_psa.getErrorStream()));
            while ((s = stdError_psa.readLine()) != null) {
                System.err.println(s);
            }
            while ((s = stdInput_psa.readLine()) != null) {
                System.out.println(s);
            }
            FileSystemTools.RemoveLine(output, 0);
            p_psa.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

