/*
 * Decompiled with CFR 0.152.
 */
package propensity;

import data_structures.AB_Residue_combinations;
import data_structures.AG_Residue_combinations;
import data_structures.Residue_classification;
import data_structures.Residue_combinations;
import data_structures.Residue_type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import utils.AAKMeans;
import utils.MathFunctions;

public class FrequencyCalculator {
    private static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        String dataset = "training_pdbs";
        double[] a1 = new double[7];
        double[] a2 = new double[7];
        a1[0] = 0.0;
        a1[1] = 1.0;
        a1[2] = 2.0;
        a1[3] = 3.0;
        a1[4] = 4.0;
        a1[5] = 5.0;
        a1[6] = 6.0;
        int i = 0;
        while (i < a1.length) {
            a2[i] = a1[i] * a1[i];
            ++i;
        }
        System.out.println(FrequencyCalculator.SpearmanCorrelation(a1, a2));
    }

    public static void initializeResiduesTriangle(String abag) {
        String dataset = "training_pdbs";
        double[][][] triangle = FrequencyCalculator.getPropensitiesTriangle(abag, dataset);
        HashMap clustering = new HashMap();
        ArrayList<Integer> arr = null;
        if (abag.equals("ab")) {
            arr = new ArrayList<Integer>();
            arr.add(0);
            clustering.put(0, arr);
            arr = new ArrayList();
            arr.add(19);
            arr.add(18);
            arr.add(3);
            arr.add(4);
            arr.add(6);
            arr.add(8);
            arr.add(9);
            arr.add(10);
            arr.add(11);
            arr.add(13);
            arr.add(14);
            arr.add(15);
            arr.add(5);
            clustering.put(1, arr);
            arr = new ArrayList();
            arr.add(16);
            clustering.put(2, arr);
            arr = new ArrayList();
            arr.add(7);
            clustering.put(3, arr);
            arr = new ArrayList();
            arr.add(12);
            clustering.put(4, arr);
            arr = new ArrayList();
            arr.add(1);
            arr.add(2);
            clustering.put(5, arr);
            arr = new ArrayList();
            arr.add(17);
            clustering.put(6, arr);
        }
        if (abag.equals("ag")) {
            arr = new ArrayList();
            arr.add(10);
            arr.add(0);
            arr.add(4);
            clustering.put(0, arr);
            arr = new ArrayList();
            arr.add(16);
            clustering.put(1, arr);
            arr = new ArrayList();
            arr.add(2);
            clustering.put(2, arr);
            arr = new ArrayList();
            arr.add(17);
            clustering.put(3, arr);
            arr = new ArrayList();
            arr.add(7);
            clustering.put(4, arr);
            arr = new ArrayList();
            arr.add(11);
            clustering.put(5, arr);
            arr = new ArrayList();
            arr.add(18);
            arr.add(1);
            arr.add(3);
            arr.add(5);
            arr.add(6);
            arr.add(8);
            arr.add(9);
            arr.add(12);
            arr.add(13);
            arr.add(14);
            arr.add(15);
            arr.add(19);
            clustering.put(6, arr);
        }
        String out = "";
        for (Integer class_i : clustering.keySet()) {
            out = String.valueOf(out) + class_i + " & ";
            ArrayList cluster = (ArrayList)clustering.get(class_i);
            for (Integer res_i : cluster) {
                if (abag.equals("ab")) {
                    Residue_type.values()[res_i.intValue()].ab_classification = Residue_classification.values()[class_i];
                    out = String.valueOf(out) + (Object)((Object)Residue_type.values()[res_i]) + " ";
                    continue;
                }
                Residue_type.values()[res_i.intValue()].ag_classification = Residue_classification.values()[class_i];
            }
            out = String.valueOf(out) + "\\\\\\ \\hline\n";
        }
        if (abag.equals("ab")) {
            AB_Residue_combinations.intra_pair_lookup = FrequencyCalculator.w_pairCalculator(abag, dataset);
            AB_Residue_combinations.triangle_lookup = FrequencyCalculator.getPropensitiesTriangleClassified(abag, dataset);
            AB_Residue_combinations.intra_weight_lookup = FrequencyCalculator.w_intraCalculator(abag, dataset);
        } else {
            AG_Residue_combinations.intra_pair_lookup = FrequencyCalculator.w_pairCalculator(abag, dataset);
            AG_Residue_combinations.triangle_lookup = FrequencyCalculator.getPropensitiesTriangleClassified(abag, dataset);
            AG_Residue_combinations.intra_weight_lookup = FrequencyCalculator.w_intraCalculator(abag, dataset);
        }
    }

    public static void initializeResiduesTriangleCustom(String abag, String dataset) {
        System.out.println("Creating the reduced alphabet");
        double[][][] triangle = FrequencyCalculator.getPropensitiesTriangle(abag, dataset);
        HashMap clustering = new HashMap();
        ArrayList<Integer> arr = null;
        if (abag.equals("ab")) {
            arr = new ArrayList<Integer>();
            arr.add(0);
            clustering.put(0, arr);
            arr = new ArrayList();
            arr.add(19);
            arr.add(18);
            arr.add(3);
            arr.add(4);
            arr.add(6);
            arr.add(8);
            arr.add(9);
            arr.add(10);
            arr.add(11);
            arr.add(13);
            arr.add(14);
            arr.add(15);
            arr.add(5);
            clustering.put(1, arr);
            arr = new ArrayList();
            arr.add(16);
            clustering.put(2, arr);
            arr = new ArrayList();
            arr.add(7);
            clustering.put(3, arr);
            arr = new ArrayList();
            arr.add(12);
            clustering.put(4, arr);
            arr = new ArrayList();
            arr.add(1);
            arr.add(2);
            clustering.put(5, arr);
            arr = new ArrayList();
            arr.add(17);
            clustering.put(6, arr);
        }
        if (abag.equals("ag")) {
            arr = new ArrayList();
            arr.add(10);
            arr.add(0);
            arr.add(4);
            clustering.put(0, arr);
            arr = new ArrayList();
            arr.add(16);
            clustering.put(1, arr);
            arr = new ArrayList();
            arr.add(2);
            clustering.put(2, arr);
            arr = new ArrayList();
            arr.add(17);
            clustering.put(3, arr);
            arr = new ArrayList();
            arr.add(7);
            clustering.put(4, arr);
            arr = new ArrayList();
            arr.add(11);
            clustering.put(5, arr);
            arr = new ArrayList();
            arr.add(18);
            arr.add(1);
            arr.add(3);
            arr.add(5);
            arr.add(6);
            arr.add(8);
            arr.add(9);
            arr.add(12);
            arr.add(13);
            arr.add(14);
            arr.add(15);
            arr.add(19);
            clustering.put(6, arr);
        }
        String out = "";
        for (Integer class_i : clustering.keySet()) {
            out = String.valueOf(out) + class_i + " & ";
            ArrayList cluster = (ArrayList)clustering.get(class_i);
            for (Integer res_i : cluster) {
                if (abag.equals("ab")) {
                    Residue_type.values()[res_i.intValue()].ab_classification = Residue_classification.values()[class_i];
                    out = String.valueOf(out) + (Object)((Object)Residue_type.values()[res_i]) + " ";
                    continue;
                }
                Residue_type.values()[res_i.intValue()].ag_classification = Residue_classification.values()[class_i];
            }
            out = String.valueOf(out) + "\\\\\\ \\hline\n";
        }
        if (abag.equals("ab")) {
            AB_Residue_combinations.intra_pair_lookup = FrequencyCalculator.w_pairCalculator(abag, dataset);
            AB_Residue_combinations.triangle_lookup = FrequencyCalculator.getPropensitiesTriangleClassified(abag, dataset);
            AB_Residue_combinations.intra_weight_lookup = FrequencyCalculator.w_intraCalculator(abag, dataset);
        } else {
            AG_Residue_combinations.intra_pair_lookup = FrequencyCalculator.w_pairCalculator(abag, dataset);
            AG_Residue_combinations.triangle_lookup = FrequencyCalculator.getPropensitiesTriangleClassified(abag, dataset);
            AG_Residue_combinations.intra_weight_lookup = FrequencyCalculator.w_intraCalculator(abag, dataset);
        }
    }

    public static double[][] SpearmanCorrelation(double[][] props) {
        double[][] correlations = new double[props.length][props.length];
        int i = 0;
        while (i < props.length) {
            int j = 0;
            while (j < props.length) {
                if (i != j) {
                    double[] x = new double[props[0].length];
                    int k = 0;
                    while (k < props[0].length) {
                        x[k] = props[i][k];
                        ++k;
                    }
                    double[] y = new double[props[0].length];
                    int k2 = 0;
                    while (k2 < props[0].length) {
                        y[k2] = props[j][k2];
                        ++k2;
                    }
                    double correlation = FrequencyCalculator.SpearmanCorrelation(x, y);
                    correlations[i][j] = 1.0 - correlation;
                }
                ++j;
            }
            ++i;
        }
        return correlations;
    }

    public static double[][] SpearmanCorrelation(double[][][] props) {
        double[][] correlations = new double[props.length][props.length];
        int i = 0;
        while (i < props.length) {
            int j = 0;
            while (j < props.length) {
                if (i != j) {
                    double[] x = new double[props[0].length * props[0].length];
                    int k = 0;
                    while (k < props[0].length) {
                        int l = 0;
                        while (l < props[0].length) {
                            x[k * props[0].length + l] = props[i][k][l];
                            ++l;
                        }
                        ++k;
                    }
                    double[] y = new double[props[0].length * props[0].length];
                    int k2 = 0;
                    while (k2 < props[0].length) {
                        int l = 0;
                        while (l < props[0].length) {
                            y[k2 * props[0].length + l] = props[j][k2][l];
                            ++l;
                        }
                        ++k2;
                    }
                    double correlation = FrequencyCalculator.SpearmanCorrelation(x, y);
                    correlations[i][j] = 1.0 - correlation;
                }
                ++j;
            }
            ++i;
        }
        return correlations;
    }

    public static double SpearmanCorrelation(double[] a1, double[] a2) {
        if (a1.length != a2.length) {
            System.out.println("SpearmanCorrelation: Lengths of provided arrays do not match");
        }
        HashMap<Integer, Double> rank1 = FrequencyCalculator.getRanks(a1);
        HashMap<Integer, Double> rank2 = FrequencyCalculator.getRanks(a2);
        double sum_d = 0.0;
        int i = 0;
        while (i < a1.length) {
            sum_d += Math.pow(rank1.get(i) - rank2.get(i), 2.0);
            ++i;
        }
        int n = a1.length;
        int denom = n * (n * n - 1);
        return 1.0 - (sum_d *= 6.0) / (double)denom;
    }

    public static HashMap<Integer, Double> getRanks(double[] a1) {
        double[] my_copy = Arrays.copyOf(a1, a1.length);
        Arrays.sort(my_copy);
        HashMap<Double, Double> ranking = new HashMap<Double, Double>();
        int i = 0;
        while (i < my_copy.length) {
            if (i < my_copy.length - 1 && my_copy[i] == my_copy[i + 1]) {
                double start = 2 * i + 1;
                double n = 2.0;
                ++i;
                while (i < my_copy.length - 1 && my_copy[i + 1] == my_copy[i]) {
                    start += (double)(i + 1);
                    n += 1.0;
                    ++i;
                }
                ranking.put(my_copy[i - 1], start / n);
            } else {
                ranking.put(my_copy[i], Double.valueOf(i));
            }
            ++i;
        }
        HashMap<Integer, Double> ranking_map = new HashMap<Integer, Double>();
        int i2 = 0;
        while (i2 < a1.length) {
            ranking_map.put(i2, (Double)ranking.get(a1[i2]));
            ++i2;
        }
        return ranking_map;
    }

    public static double[][] w_pairCalculator(String abag, String dataset) {
        int k;
        int j;
        String filename_nons = String.valueOf(userdir) + "/result_dump/ab_propensity/data/" + dataset + "/p_pair_" + abag + "_nons.txt";
        int[][] pair_nons = MathFunctions.readParsable2D(filename_nons);
        String filename_cons = String.valueOf(userdir) + "/result_dump/ab_propensity/data/" + dataset + "/p_pair_" + abag + "_cons.txt";
        int[][] pair_cons = MathFunctions.readParsable2D(filename_cons);
        filename_nons = String.valueOf(userdir) + "/result_dump/ab_propensity/data/" + dataset + "/p_triangle_" + abag + "_nons.txt";
        int[][][] triangle_nons = MathFunctions.readParsable3D(filename_nons);
        filename_cons = String.valueOf(userdir) + "/result_dump/ab_propensity/data/" + dataset + "/p_triangle_" + abag + "_cons.txt";
        int[][][] triangle_cons = MathFunctions.readParsable3D(filename_cons);
        long[][] f_cons_triangle = new long[28][7];
        long[][] f_nons_triangle = new long[28][7];
        long[] f_cons_pair = new long[28];
        long[] f_nons_pair = new long[28];
        int i = 0;
        while (i < 20) {
            j = 0;
            while (j < 20) {
                int j_class;
                int i_class;
                if (abag.equals("ab")) {
                    i_class = Residue_type.values()[i].ab_classification.ordinal();
                    j_class = Residue_type.values()[j].ab_classification.ordinal();
                } else {
                    i_class = Residue_type.values()[i].ag_classification.ordinal();
                    j_class = Residue_type.values()[j].ag_classification.ordinal();
                }
                Residue_combinations pair = Residue_combinations.pair_lookup[i_class][j_class];
                int n = pair.ordinal();
                f_cons_pair[n] = f_cons_pair[n] + (long)pair_cons[i][j];
                int n2 = pair.ordinal();
                f_nons_pair[n2] = f_nons_pair[n2] + (long)pair_nons[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 20) {
            j = 0;
            while (j < 20) {
                k = 0;
                while (k < 20) {
                    int class_k;
                    int class_j;
                    int class_i;
                    if (abag.equals("ab")) {
                        class_i = Residue_type.values()[i].ab_classification.ordinal();
                        class_j = Residue_type.values()[j].ab_classification.ordinal();
                        class_k = Residue_type.values()[k].ab_classification.ordinal();
                    } else {
                        class_i = Residue_type.values()[i].ag_classification.ordinal();
                        class_j = Residue_type.values()[j].ag_classification.ordinal();
                        class_k = Residue_type.values()[k].ag_classification.ordinal();
                    }
                    Residue_combinations the_pair = Residue_combinations.pair_lookup[class_i][class_j];
                    long[] lArray = f_cons_triangle[the_pair.ordinal()];
                    int n = class_k;
                    lArray[n] = lArray[n] + (long)triangle_cons[i][k][j];
                    long[] lArray2 = f_nons_triangle[the_pair.ordinal()];
                    int n3 = class_k;
                    lArray2[n3] = lArray2[n3] + (long)triangle_nons[i][k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        double[][] propensities = new double[28][7];
        int i2 = 0;
        while (i2 < 28) {
            k = 0;
            while (k < 7) {
                propensities[i2][k] = (double)f_cons_triangle[i2][k] / (double)f_nons_triangle[i2][k];
                propensities[i2][k] = propensities[i2][k] / ((double)f_cons_pair[i2] / (double)f_nons_pair[i2]);
                ++k;
            }
            ++i2;
        }
        return propensities;
    }

    public static double[][] w_intraCalculator(String abag, String dataset) {
        String filename_nons = String.valueOf(userdir) + "/result_dump/ab_propensity/data/" + dataset + "/p_single_" + abag + "_nons.txt";
        int[] single_nons = MathFunctions.readParsable1D(filename_nons);
        String filename_cons = String.valueOf(userdir) + "/result_dump/ab_propensity/data/" + dataset + "/p_single_" + abag + "_cons.txt";
        int[] single_cons = MathFunctions.readParsable1D(filename_cons);
        filename_nons = String.valueOf(userdir) + "/result_dump/ab_propensity/data/" + dataset + "/p_pair_" + abag + "_nons.txt";
        int[][] pair_nons = MathFunctions.readParsable2D(filename_nons);
        filename_cons = String.valueOf(userdir) + "/result_dump/ab_propensity/data/" + dataset + "/p_pair_" + abag + "_cons.txt";
        int[][] pair_cons = MathFunctions.readParsable2D(filename_cons);
        long[][] f_cons = new long[7][7];
        long[][] f_nons = new long[7][7];
        long[] f_cons_single = new long[7];
        long[] f_nons_single = new long[7];
        int i = 0;
        while (i < 20) {
            int i_class = abag.equals("ab") ? Residue_type.values()[i].ab_classification.ordinal() : Residue_type.values()[i].ag_classification.ordinal();
            int n = i_class;
            f_cons_single[n] = f_cons_single[n] + (long)single_cons[i];
            int n2 = i_class;
            f_nons_single[n2] = f_nons_single[n2] + (long)single_nons[i];
            ++i;
        }
        i = 0;
        while (i < 20) {
            int j = 0;
            while (j < 20) {
                int j_class;
                int i_class;
                if (abag.equals("ab")) {
                    i_class = Residue_type.values()[i].ab_classification.ordinal();
                    j_class = Residue_type.values()[j].ab_classification.ordinal();
                } else {
                    i_class = Residue_type.values()[i].ag_classification.ordinal();
                    j_class = Residue_type.values()[j].ag_classification.ordinal();
                }
                long[] lArray = f_cons[i_class];
                int n = j_class;
                lArray[n] = lArray[n] + (long)pair_cons[i][j];
                long[] lArray2 = f_nons[i_class];
                int n3 = j_class;
                lArray2[n3] = lArray2[n3] + (long)pair_nons[i][j];
                ++j;
            }
            ++i;
        }
        double[][] propensities = new double[7][7];
        int i2 = 0;
        while (i2 < 7) {
            int j = 0;
            while (j < 7) {
                propensities[i2][j] = (double)f_cons[i2][j] / (double)f_nons[i2][j];
                propensities[i2][j] = propensities[i2][j] / ((double)f_cons_single[i2] / (double)f_nons_single[i2]);
                ++j;
            }
            ++i2;
        }
        return propensities;
    }

    public static void produceDataForAnalysis() {
        String output_folder = String.valueOf(userdir) + "/result_dump/ab_propensity/bowmethod";
        double[] ab_single = FrequencyCalculator.getPropensitiesSingle("ab", "training_pdbs");
        double[] ag_single = FrequencyCalculator.getPropensitiesSingle("ag", "training_pdbs");
        double[][] ab_pair = FrequencyCalculator.getPropensitiesPair("ab", "training_pdbs");
        double[][] ag_pair = FrequencyCalculator.getPropensitiesPair("ag", "training_pdbs");
        double[][][] ab_triangle = FrequencyCalculator.getPropensitiesTriangle("ab", "training_pdbs");
        double[][][] ag_triangle = FrequencyCalculator.getPropensitiesTriangle("ag", "training_pdbs");
        AAKMeans.BowMethod(FrequencyCalculator.calculateDistances(ab_single), 100000, String.valueOf(output_folder) + "/ab_single.txt");
        AAKMeans.BowMethod(FrequencyCalculator.calculateDistances(ag_single), 100000, String.valueOf(output_folder) + "/ag_single.txt");
        AAKMeans.BowMethod(FrequencyCalculator.calculateDistances(ab_pair), 100000, String.valueOf(output_folder) + "/ab_pair.txt");
        AAKMeans.BowMethod(FrequencyCalculator.calculateDistances(ag_pair), 100000, String.valueOf(output_folder) + "/ag_pair.txt");
        AAKMeans.BowMethod(FrequencyCalculator.calculateDistances(ab_triangle), 100000, String.valueOf(output_folder) + "/ab_triangle.txt");
        AAKMeans.BowMethod(FrequencyCalculator.calculateDistances(ag_triangle), 100000, String.valueOf(output_folder) + "/ag_triangle.txt");
        MathFunctions.write2Drray(FrequencyCalculator.calculateDistances(ab_single), String.valueOf(output_folder) + "/ab_single_arr.txt");
        MathFunctions.write2Drray(FrequencyCalculator.calculateDistances(ag_single), String.valueOf(output_folder) + "/ag_single_arr.txt");
        MathFunctions.write2Drray(FrequencyCalculator.calculateDistances(ab_pair), String.valueOf(output_folder) + "/ab_pair_arr.txt");
        MathFunctions.write2Drray(FrequencyCalculator.calculateDistances(ag_pair), String.valueOf(output_folder) + "/ag_pair_arr.txt");
        MathFunctions.write2Drray(FrequencyCalculator.calculateDistances(ab_triangle), String.valueOf(output_folder) + "/ab_triangle_arr.txt");
        MathFunctions.write2Drray(FrequencyCalculator.calculateDistances(ag_triangle), String.valueOf(output_folder) + "/ag_triangle_arr.txt");
    }

    public static double[][] calculateDistances(double[][][] props) {
        double[][] dist = new double[props.length][props.length];
        int i = 0;
        while (i < props.length) {
            int j = 0;
            while (j < props.length) {
                if (i != j) {
                    double sum = 0.0;
                    int k = 0;
                    while (k < props.length) {
                        int l = 0;
                        while (l < props.length) {
                            sum += Math.pow(props[i][k][l] - props[j][k][l], 2.0);
                            ++l;
                        }
                        ++k;
                    }
                    dist[i][j] = Math.pow(sum, 0.5);
                }
                ++j;
            }
            ++i;
        }
        return dist;
    }

    public static double[][] calculateDistances(double[][] props) {
        double[][] dist = new double[props.length][props.length];
        int i = 0;
        while (i < props.length) {
            int j = 0;
            while (j < props.length) {
                if (i != j) {
                    double sum = 0.0;
                    int k = 0;
                    while (k < props.length) {
                        sum += Math.pow(props[i][k] - props[j][k], 2.0);
                        ++k;
                    }
                    dist[i][j] = Math.pow(sum, 0.5);
                }
                ++j;
            }
            ++i;
        }
        return dist;
    }

    public static double[][] calculateDistances(double[] props) {
        double[][] dist = new double[props.length][props.length];
        int i = 0;
        while (i < props.length) {
            int j = 0;
            while (j < props.length) {
                dist[i][j] = Math.abs(props[i] - props[j]);
                ++j;
            }
            ++i;
        }
        return dist;
    }

    public static double[][][] getPropensitiesTriangleClassified(String abag, String dataset) {
        String filename_nons = String.valueOf(userdir) + "/result_dump/ab_propensity/data/" + dataset + "/p_triangle_" + abag + "_nons.txt";
        int[][][] nons = MathFunctions.readParsable3D(filename_nons);
        String filename_cons = String.valueOf(userdir) + "/result_dump/ab_propensity/data/" + dataset + "/p_triangle_" + abag + "_cons.txt";
        int[][][] cons = MathFunctions.readParsable3D(filename_cons);
        long[][][] f_cons = new long[7][7][7];
        long[][][] f_nons = new long[7][7][7];
        long sum_nons = 0L;
        long sum_cons = 0L;
        int i = 0;
        while (i < 20) {
            int j = 0;
            while (j < 20) {
                int k = 0;
                while (k < 20) {
                    int class_k;
                    int class_j;
                    int class_i;
                    if (abag.equals("ab")) {
                        class_i = Residue_type.values()[i].ab_classification.ordinal();
                        class_j = Residue_type.values()[j].ab_classification.ordinal();
                        class_k = Residue_type.values()[k].ab_classification.ordinal();
                    } else {
                        class_i = Residue_type.values()[i].ag_classification.ordinal();
                        class_j = Residue_type.values()[j].ag_classification.ordinal();
                        class_k = Residue_type.values()[k].ag_classification.ordinal();
                    }
                    long[] lArray = f_cons[class_i][class_j];
                    int n = class_k;
                    lArray[n] = lArray[n] + (long)cons[i][j][k];
                    long[] lArray2 = f_nons[class_i][class_j];
                    int n2 = class_k;
                    lArray2[n2] = lArray2[n2] + (long)nons[i][j][k];
                    if (nons[i][j][k] == 0) {
                        nons[i][j][k] = 1;
                    }
                    if (sum_nons > sum_nons + (long)nons[i][j][k]) {
                        System.err.println("variable overflow");
                        System.exit(0);
                    }
                    sum_nons += (long)nons[i][j][k];
                    if (sum_cons > sum_cons + (long)cons[i][j][k]) {
                        System.err.println("variable overflow");
                        System.exit(0);
                    }
                    sum_cons += (long)cons[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        double denominator_sum = (double)sum_cons / (double)sum_nons;
        double[][][] propensities = new double[7][7][7];
        int i2 = 0;
        while (i2 < 7) {
            int j = 0;
            while (j < 7) {
                int k = 0;
                while (k < 7) {
                    propensities[i2][k][j] = (double)f_cons[i2][j][k] / (double)f_nons[i2][j][k];
                    propensities[i2][k][j] = propensities[i2][k][j] / denominator_sum;
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        return propensities;
    }

    public static double[][][] getPropensitiesTriangle(String abag, String dataset) {
        String filename_nons = String.valueOf(userdir) + "/result_dump/ab_propensity/data/" + dataset + "/p_triangle_" + abag + "_nons.txt";
        int[][][] nons = MathFunctions.readParsable3D(filename_nons);
        String filename_cons = String.valueOf(userdir) + "/result_dump/ab_propensity/data/" + dataset + "/p_triangle_" + abag + "_cons.txt";
        int[][][] cons = MathFunctions.readParsable3D(filename_cons);
        long sum_nons = 0L;
        long sum_cons = 0L;
        int i = 0;
        while (i < 20) {
            int j = 0;
            while (j < 20) {
                int k = 0;
                while (k < 20) {
                    if (nons[i][j][k] == 0) {
                        nons[i][j][k] = 1;
                    }
                    if (sum_nons > sum_nons + (long)nons[i][j][k]) {
                        System.err.println("variable overflow");
                        System.exit(0);
                    }
                    sum_nons += (long)nons[i][j][k];
                    if (sum_cons > sum_cons + (long)cons[i][j][k]) {
                        System.err.println("variable overflow");
                        System.exit(0);
                    }
                    sum_cons += (long)cons[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        double denominator_sum = (double)sum_cons / (double)sum_nons;
        double[][][] propensities = new double[20][20][20];
        int i2 = 0;
        while (i2 < 20) {
            int j = 0;
            while (j < 20) {
                int k = 0;
                while (k < 20) {
                    propensities[i2][j][k] = (double)cons[i2][j][k] / (double)nons[i2][j][k];
                    propensities[i2][j][k] = propensities[i2][j][k] / denominator_sum;
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        return propensities;
    }

    public static double[][] getPropensitiesPair(String abag, String dataset) {
        String filename_nons = String.valueOf(userdir) + "/result_dump/ab_propensity/data/" + dataset + "/p_pair_" + abag + "_nons.txt";
        int[][] nons = MathFunctions.readParsable2D(filename_nons);
        String filename_cons = String.valueOf(userdir) + "/result_dump/ab_propensity/data/" + dataset + "/p_pair_" + abag + "_cons.txt";
        int[][] cons = MathFunctions.readParsable2D(filename_cons);
        long sum_nons = 0L;
        long sum_cons = 0L;
        int i = 0;
        while (i < 20) {
            int j = 0;
            while (j < 20) {
                if (nons[i][j] == 0) {
                    System.err.println("Pairs: Not enough data on nons");
                    System.exit(0);
                }
                sum_nons += (long)nons[i][j];
                sum_cons += (long)cons[i][j];
                ++j;
            }
            ++i;
        }
        double denominator_sum = (double)sum_cons / (double)sum_nons;
        double[][] propensities = new double[20][20];
        int i2 = 0;
        while (i2 < 20) {
            int j = 0;
            while (j < 20) {
                propensities[i2][j] = (double)cons[i2][j] / (double)nons[i2][j];
                propensities[i2][j] = propensities[i2][j] / denominator_sum;
                ++j;
            }
            ++i2;
        }
        return propensities;
    }

    public static double[] getPropensitiesSingle(String abag, String dataset) {
        String filename_nons = String.valueOf(userdir) + "/result_dump/ab_propensity/data/" + dataset + "/p_single_" + abag + "_nons.txt";
        int[] nons = MathFunctions.readParsable1D(filename_nons);
        String filename_cons = String.valueOf(userdir) + "/result_dump/ab_propensity/data/" + dataset + "/p_single_" + abag + "_cons.txt";
        int[] cons = MathFunctions.readParsable1D(filename_cons);
        long sum_nons = 0L;
        long sum_cons = 0L;
        int i = 0;
        while (i < 20) {
            if (nons[i] == 0) {
                System.err.println("Single: Not enough data on nons");
                System.exit(0);
            }
            sum_nons += (long)nons[i];
            sum_cons += (long)cons[i];
            ++i;
        }
        double denominator_sum = (double)sum_cons / (double)sum_nons;
        double[] propensities = new double[20];
        int i2 = 0;
        while (i2 < 20) {
            propensities[i2] = (double)cons[i2] / (double)nons[i2];
            propensities[i2] = propensities[i2] / denominator_sum;
            ++i2;
        }
        return propensities;
    }

    public static void printPL(double[][] arr) {
        System.out.println("{");
        int j = 0;
        while (j < 28) {
            System.out.print("{ ");
            int k = 0;
            while (k < 7) {
                System.out.print(String.valueOf(arr[j][k]) + " ");
                if (k != 6) {
                    System.out.print(", ");
                }
                ++k;
            }
            System.out.println("},");
            ++j;
        }
        System.out.println("};");
    }

    public static void printIW(double[][] arr) {
        System.out.println("{");
        int j = 0;
        while (j < 7) {
            System.out.print("{ ");
            int k = 0;
            while (k < 7) {
                System.out.print(String.valueOf(arr[j][k]) + " ");
                if (k != 6) {
                    System.out.print(", ");
                }
                ++k;
            }
            System.out.println("},");
            ++j;
        }
        System.out.println("};");
    }

    public static void printTL(double[][][] arr) {
        System.out.println("{");
        int i = 0;
        while (i < 7) {
            System.out.println("{");
            int j = 0;
            while (j < 7) {
                System.out.print("{ ");
                int k = 0;
                while (k < 7) {
                    System.out.print(String.valueOf(arr[i][j][k]) + " ");
                    if (k != 6) {
                        System.out.print(", ");
                    }
                    ++k;
                }
                System.out.println("},");
                ++j;
            }
            System.out.println("},");
            ++i;
        }
        System.out.println("};");
    }
}

