/*
 * Decompiled with CFR 0.152.
 */
import data_structures.Atom;
import data_structures.Residue;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class DockingTools {
    private static final String userdir = System.getProperty("user.dir");
    private static final String res_dir = String.valueOf(userdir) + "/result_dump/DockingTools";
    private static final String piper_dir = String.valueOf(userdir) + "/result_dump/GlobalDocking/PIPER";

    public static void main(String[] args) {
        DockingTools.HowRweDoin();
    }

    public static double getIRMSD(String pdb, int rank) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/GlobalDocking/res/" + pdb + "_res.txt");
        for (String line : lines) {
            line = line.replace(" RMS: ", " ");
            int r = Integer.parseInt(FileSystemTools.getColumn(line, 1));
            double d = Double.parseDouble(FileSystemTools.getColumn(line, 2));
            if (r != rank) continue;
            return d;
        }
        return -1.0;
    }

    public static void HowRweDoin() {
        ArrayList<String> folders = FileSystemTools.getFolders(piper_dir);
        int wins = 0;
        int loss = 0;
        int draw = 0;
        for (String folder : folders) {
            System.out.println("Doing: " + folder);
            int res = (int)DockingTools.scoreMeIrmsd(folder);
            switch (res) {
                case -1: {
                    ++draw;
                    break;
                }
                case 0: {
                    ++wins;
                    break;
                }
                case 1: {
                    ++loss;
                    break;
                }
            }
        }
        System.out.println("Wins: " + wins);
        System.out.println("Loss: " + loss);
        System.out.println("Wins: " + draw);
    }

    public static HashMap<Double, Integer> rankScores(ArrayList<Double> scores) {
        TreeSet<Double> sorted = new TreeSet<Double>();
        for (Double d : scores) {
            sorted.add(d);
        }
        int rank = 0;
        HashMap<Double, Integer> ranked = new HashMap<Double, Integer>();
        for (Double d : sorted.descendingSet()) {
            if (ranked.containsKey(d)) {
                System.out.println("Houston...");
                System.exit(0);
            }
            ranked.put(d, rank);
            ++rank;
        }
        return ranked;
    }

    public static double scoreMe(String pdb) {
        String f1 = String.valueOf(piper_dir) + "/" + pdb.toUpperCase() + "/" + pdb.toUpperCase() + "-Antibody.pdb";
        String f2 = String.valueOf(piper_dir) + "/" + pdb.toUpperCase() + "/" + pdb.toUpperCase() + "_ligand.pdb";
        Str rec_strucs = new Str(f1);
        Str lig_strucs = new Str(f2);
        double f_nat_max = 0.0;
        double adars_rank = 0.0;
        double us_score = 0.0;
        ArrayList<Double> scores = new ArrayList<Double>();
        int i = 0;
        while (i < 30) {
            String id = i < 10 ? "0" + i : String.valueOf(i);
            String f3 = String.valueOf(piper_dir) + "/" + pdb.toUpperCase() + "/Antigen_1_000_" + id + ".pdb";
            Str lig_dock = new Str(f3);
            double fnat = DockingTools.annotateCons(rec_strucs, lig_strucs, lig_dock);
            double score = DockingTools.scoreCons(rec_strucs, lig_dock);
            System.out.println("Score: " + score);
            scores.add(score);
            if (fnat > f_nat_max) {
                f_nat_max = fnat;
                us_score = score;
                adars_rank = i;
            }
            ++i;
        }
        HashMap<Double, Integer> rank = DockingTools.rankScores(scores);
        System.out.println(String.valueOf(pdb) + " : " + rank.get(us_score) + " : " + adars_rank + " " + ((double)rank.get(us_score).intValue() < adars_rank) + " : " + f_nat_max + " " + DockingTools.getIRMSD(pdb, (int)adars_rank));
        return (double)rank.get(us_score).intValue() - adars_rank;
    }

    public static double scoreMeIrmsd(String pdb) {
        String folder_out = String.valueOf(userdir) + "/resources/1/" + pdb.toLowerCase();
        File f = new File(folder_out);
        if (!f.exists()) {
            f.mkdir();
        }
        String fnat_out = "";
        String rmsd_out = "";
        String score_out = "";
        String f1 = String.valueOf(piper_dir) + "/" + pdb.toUpperCase() + "/" + pdb.toUpperCase() + "-Antibody.pdb";
        String f2 = String.valueOf(piper_dir) + "/" + pdb.toUpperCase() + "/" + pdb.toUpperCase() + "_ligand.pdb";
        Str rec_strucs = new Str(f1);
        Str lig_strucs = new Str(f2);
        double irmsd_min = 100.0;
        double f_nat_max = 0.0;
        double adars_rank = 0.0;
        double us_score = 0.0;
        ArrayList<Double> scores = new ArrayList<Double>();
        HashMap<Double, Integer> vsadars = new HashMap<Double, Integer>();
        int i = 0;
        while (i < 30) {
            String id = i < 10 ? "0" + i : String.valueOf(i);
            String f3 = String.valueOf(piper_dir) + "/" + pdb.toUpperCase() + "/Antigen_1_000_" + id + ".pdb";
            Str lig_dock = new Str(f3);
            double irmsd = DockingTools.getIRMSD(pdb, i);
            double score = DockingTools.scoreCons(rec_strucs, lig_dock);
            double fnat = DockingTools.annotateCons(rec_strucs, lig_strucs, lig_dock);
            rmsd_out = String.valueOf(rmsd_out) + (i + 1) + " " + irmsd + "\n";
            fnat_out = String.valueOf(fnat_out) + (i + 1) + " Fnat = " + fnat + "\n";
            score_out = String.valueOf(score_out) + (i + 1) + " " + score + "\n";
            vsadars.put(score, i);
            scores.add(score);
            ++i;
        }
        i = 30;
        while (i < 201) {
            rmsd_out = String.valueOf(rmsd_out) + (i + 1) + " 0\n";
            fnat_out = String.valueOf(fnat_out) + (i + 1) + " Fnat = 0\n";
            score_out = String.valueOf(score_out) + (i + 1) + " 0\n";
            ++i;
        }
        FileSystemTools.writeFile(String.valueOf(folder_out) + "/fnat.txt", fnat_out);
        FileSystemTools.writeFile(String.valueOf(folder_out) + "/irmsds.txt", rmsd_out);
        FileSystemTools.writeFile(String.valueOf(folder_out) + "/rescored_local.txt", score_out);
        TreeSet<Double> sorted = new TreeSet<Double>();
        for (Double key : scores) {
            sorted.add(key);
        }
        double adars_irmsd = 100.0;
        adars_rank = 100.0;
        int i2 = 0;
        while (i2 < 10) {
            String id = i2 < 10 ? "0" + i2 : String.valueOf(i2);
            String f3 = String.valueOf(piper_dir) + "/" + pdb.toUpperCase() + "/Antigen_1_000_" + id + ".pdb";
            Str lig_dock = new Str(f3);
            double irmsd = DockingTools.getIRMSD(pdb, i2);
            double fnat = DockingTools.annotateCons(rec_strucs, lig_strucs, lig_dock);
            if (irmsd < adars_irmsd) {
                adars_irmsd = irmsd;
                adars_rank = i2;
            }
            ++i2;
        }
        int prog = -1;
        double us_irmsd = 100.0;
        int us_rank = 100;
        Iterator iterator = sorted.descendingSet().iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            int i3 = (Integer)vsadars.get(d);
            if (++prog > 10) break;
            String id = i3 < 10 ? "0" + i3 : String.valueOf(i3);
            String f3 = String.valueOf(piper_dir) + "/" + pdb.toUpperCase() + "/Antigen_1_000_" + id + ".pdb";
            Str lig_dock = new Str(f3);
            double irmsd = DockingTools.getIRMSD(pdb, i3);
            double fnat = 0.0;
            double score = DockingTools.scoreCons(rec_strucs, lig_dock);
            if (irmsd < adars_irmsd && prog < i3) {
                us_rank = prog;
                us_irmsd = irmsd;
                break;
            }
            if (!(irmsd < us_irmsd)) continue;
            us_rank = prog;
            us_irmsd = irmsd;
        }
        System.out.println(String.valueOf(pdb) + " " + us_rank + " " + us_irmsd + " " + adars_rank + " " + adars_irmsd);
        int result = -1;
        if ((double)us_rank <= adars_rank && us_irmsd <= adars_irmsd) {
            result = 0;
        } else if ((double)us_rank >= adars_rank && us_irmsd >= adars_irmsd) {
            result = 1;
        }
        System.out.println(result);
        return result;
    }

    public static double annotateCons(Str s1, Str s2, Str s3) {
        double corr = 0.0;
        double tot = 0.0;
        for (Character c1 : s1.str.keySet()) {
            HashMap<Integer, Residue> ch1 = s1.str.get(c1);
            for (Character c2 : s2.str.keySet()) {
                HashMap<Integer, Residue> ch2 = s2.str.get(c2);
                if (!s3.str.containsKey(c2)) {
                    System.out.println("Supplied ligand decoys does not have chain " + c2);
                    System.exit(0);
                }
                HashMap<Integer, Residue> ch3 = s3.str.get(c2);
                for (Integer i_r : ch1.keySet()) {
                    Residue res_r = ch1.get(i_r);
                    for (Integer i_l : ch2.keySet()) {
                        Residue res_l1 = ch2.get(i_l);
                        Residue res_l2 = ch3.get(i_l);
                        if (res_r.distanceFrom(res_l1) < 4.5) {
                            tot += 1.0;
                            res_r.isContact = true;
                            res_l1.isContact = true;
                        }
                        if (!(res_r.distanceFrom(res_l1) < 4.5) || !(res_r.distanceFrom(res_l2) < 4.5)) continue;
                        corr += 1.0;
                    }
                }
            }
        }
        double perc = (double)Math.round(100.0 * (corr / tot)) / 100.0;
        return perc;
    }

    public static void compareCorrect(HashMap<Integer, Residue> sol, String lig_file) {
        String chains_ag = PDB_parser.getChains(lig_file);
        HashMap<Integer, Residue> s2 = PDB_parser.parse(lig_file, chains_ag.charAt(0));
    }

    public static ArrayList<HashMap<Integer, Residue>> readStrIn(String f1) {
        ArrayList<HashMap<Integer, Residue>> rec_strucs = new ArrayList<HashMap<Integer, Residue>>();
        String chains_ab = PDB_parser.getChains(f1);
        int i = 0;
        while (i < chains_ab.length()) {
            HashMap<Integer, Residue> s1 = PDB_parser.parse(f1, chains_ab.charAt(i));
            rec_strucs.add(s1);
            ++i;
        }
        return rec_strucs;
    }

    public static double scoreCons(Str s1, Str s2) {
        double[][] prop_mat = DockSorterCMD.prop_mat;
        double tot = 0.0;
        double score = 0.0;
        for (Character c1 : s1.str.keySet()) {
            HashMap<Integer, Residue> ch1 = s1.str.get(c1);
            for (Character c2 : s2.str.keySet()) {
                HashMap<Integer, Residue> ch2 = s2.str.get(c2);
                for (Integer i_r : ch1.keySet()) {
                    Residue res_r = ch1.get(i_r);
                    for (Integer i_l : ch2.keySet()) {
                        Residue res_l1 = ch2.get(i_l);
                        if (!(res_r.distanceFrom(res_l1) < 4.5)) continue;
                        tot += 1.0;
                        score += prop_mat[res_r.type.ordinal()][res_l1.type.ordinal()];
                    }
                }
            }
        }
        return score;
    }

    public static void augmentBinding(Str s) {
        for (Character chain : s.str.keySet()) {
            HashMap<Integer, Residue> str1 = s.str.get(chain);
            for (Integer i : str1.keySet()) {
                Residue r1 = str1.get(i);
                for (Character chain2 : s.str.keySet()) {
                    HashMap<Integer, Residue> str2 = s.str.get(chain2);
                    for (Integer i2 : str1.keySet()) {
                        Residue r2 = str1.get(i2);
                        if (r1.isContact) {
                            r1.isCDR = true;
                            if (r2.distanceFrom(r1) < 10.0) {
                                r2.isCDR = true;
                            }
                        }
                        if (!r2.isContact) continue;
                        r2.isCDR = true;
                        if (!(r1.distanceFrom(r2) < 10.0)) continue;
                        r1.isCDR = true;
                    }
                }
            }
        }
    }

    public static int writeIntfStr(Str s, String filename, Character ch) {
        ArrayList<String> out = new ArrayList<String>();
        int tot = 0;
        for (Character chain : s.str.keySet()) {
            HashMap<Integer, Residue> str = s.str.get(chain);
            TreeSet<Integer> sorted = new TreeSet<Integer>();
            for (Integer i : str.keySet()) {
                sorted.add(i);
            }
            for (Integer i : sorted) {
                Residue r = str.get(i);
                if (!r.isCDR) continue;
                ++tot;
                for (Atom a : r.atoms) {
                    out.add(a.pdb_line);
                }
            }
        }
        FileSystemTools.writeFile("_tmp", out);
        System.out.println("Writing to " + filename);
        PDB_parser.standardizePDB("_tmp", filename, ch.charValue());
        return tot;
    }

    public static void writeIntfStr(Str s, Str s2, String filename, Character ch) {
        ArrayList<String> out = new ArrayList<String>();
        for (Character chain : s.str.keySet()) {
            HashMap<Integer, Residue> str = s.str.get(chain);
            HashMap<Integer, Residue> str2 = s2.str.get(chain);
            TreeSet<Integer> sorted = new TreeSet<Integer>();
            for (Integer i : str.keySet()) {
                sorted.add(i);
            }
            for (Integer i : sorted) {
                Residue r = str.get(i);
                Residue r2 = str2.get(i);
                if (!r.isCDR) continue;
                for (Atom a : r2.atoms) {
                    out.add(a.pdb_line);
                }
            }
        }
        FileSystemTools.writeFile("_tmp", out);
        System.out.println("Writing to " + filename);
        PDB_parser.standardizePDB("_tmp", filename, ch.charValue());
    }

    public static void contrainPDBs() {
        ArrayList<String> folders = FileSystemTools.getFolders(piper_dir);
        for (String pdb : folders) {
            String f1 = String.valueOf(piper_dir) + "/" + pdb.toUpperCase() + "/" + pdb.toUpperCase() + "-Antibody.pdb";
            String f2 = String.valueOf(piper_dir) + "/" + pdb.toUpperCase() + "/" + pdb.toUpperCase() + "_ligand.pdb";
            File folder = new File(String.valueOf(piper_dir) + "_IRMSD/" + pdb.toUpperCase());
            File folder2 = new File(String.valueOf(piper_dir) + "_data/" + pdb.toLowerCase());
            if (!folder2.exists()) {
                folder2.mkdir();
            }
            Str ab = new Str(f1);
            Str ag = new Str(f2);
            DockingTools.constrainInterface(ab, ag);
            int ab_len = DockingTools.writeIntfStr(ab, String.valueOf(piper_dir) + "_IRMSD/" + pdb.toUpperCase() + "/Ab_ref.pdb", Character.valueOf('A'));
            int ag_len = DockingTools.writeIntfStr(ag, String.valueOf(piper_dir) + "_IRMSD/" + pdb.toUpperCase() + "/Ag_ref.pdb", Character.valueOf('B'));
            DockingTools.writeIntfStr(ab, String.valueOf(piper_dir) + "_data/" + pdb.toLowerCase() + "/AB.pdb", Character.valueOf('A'));
            DockingTools.writeIntfStr(ag, String.valueOf(piper_dir) + "_data/" + pdb.toLowerCase() + "/AG.pdb", Character.valueOf('A'));
            DockingTools.writeScript(ab_len, ag_len, String.valueOf(piper_dir) + "_IRMSD/" + pdb.toUpperCase() + "/prof_script.txt");
            ArrayList<String> file1 = FileSystemTools.readFile(String.valueOf(piper_dir) + "_IRMSD/" + pdb.toUpperCase() + "/Ab_ref.pdb");
            ArrayList<String> file2 = FileSystemTools.readFile(String.valueOf(piper_dir) + "_IRMSD/" + pdb.toUpperCase() + "/Ag_ref.pdb");
            file1.addAll(file2);
            FileSystemTools.writeFile(String.valueOf(piper_dir) + "_IRMSD/" + pdb.toUpperCase() + "/ref.pdb", file1);
            if (!folder.exists()) {
                folder.mkdir();
            }
            int i = 0;
            while (i < 30) {
                String id = i < 10 ? "0" + i : String.valueOf(i);
                String f3 = String.valueOf(piper_dir) + "/" + pdb.toUpperCase() + "/Antigen_1_000_" + id + ".pdb";
                Str lig_dock = new Str(f3);
                DockingTools.writeIntfStr(ag, lig_dock, String.valueOf(piper_dir) + "_IRMSD/" + pdb.toUpperCase() + "/Antigen_1_000_" + id + ".pdb", Character.valueOf('B'));
                file1 = FileSystemTools.readFile(String.valueOf(piper_dir) + "_IRMSD/" + pdb.toUpperCase() + "/Ab_ref.pdb");
                file2 = FileSystemTools.readFile(String.valueOf(piper_dir) + "_IRMSD/" + pdb.toUpperCase() + "/Antigen_1_000_" + id + ".pdb");
                file1.addAll(file2);
                FileSystemTools.writeFile(String.valueOf(piper_dir) + "_IRMSD/" + pdb.toUpperCase() + "/Antigen_1_000_" + id + "_mob.pdb", file1);
                ++i;
            }
        }
    }

    public static void writeScript(int ablen, int aglen, String filename) {
        String out = "";
        out = String.valueOf(out) + "ATOMS N, CA, C, O,\n";
        out = String.valueOf(out) + "IGNOREMISSING\n";
        out = String.valueOf(out) + "ZONE A.1-A." + ablen + ":A.1-A." + ablen + "\n";
        out = String.valueOf(out) + "FIT\n";
        out = String.valueOf(out) + "RZONE B.1-B." + aglen + ":B.1-B." + aglen + "\n";
        out = String.valueOf(out) + "QUIT\n";
        FileSystemTools.writeFile(filename, out);
    }

    public static void constrainInterface(Str s1, Str s2) {
        DockingTools.annotateCons(s1, s2, s2);
        DockingTools.augmentBinding(s1);
        DockingTools.augmentBinding(s2);
    }

    public static class Str {
        public final HashMap<Character, HashMap<Integer, Residue>> str;

        public Str(String filename) {
            HashMap<Character, HashMap<Integer, Residue>> rec_strucs = new HashMap<Character, HashMap<Integer, Residue>>();
            String chains_ab = PDB_parser.getChains(filename);
            int i = 0;
            while (i < chains_ab.length()) {
                char chain = chains_ab.charAt(i);
                HashMap<Integer, Residue> s1 = PDB_parser.parse(filename, chain);
                rec_strucs.put(Character.valueOf(chain), s1);
                ++i;
            }
            this.str = rec_strucs;
        }

        public Str(HashMap<Character, HashMap<Integer, Residue>> _str) {
            this.str = _str;
        }
    }
}

