/*
 * Decompiled with CFR 0.152.
 */
package parsing;

import data_structures.Atom;
import data_structures.Residue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class PDBStandardizer {
    public static void standardize(String pdb_in, String pdb_out, String chains) {
        ArrayList<String> lines = new ArrayList<String>();
        int c_i = 0;
        while (c_i < chains.length()) {
            char chain = chains.charAt(c_i);
            HashMap<Integer, Residue> residues = PDB_parser.parse(pdb_in, chain);
            TreeSet<Integer> sorted = new TreeSet<Integer>();
            for (Integer i : residues.keySet()) {
                sorted.add(i);
            }
            for (Integer i : sorted) {
                Residue r = residues.get(i);
                for (Atom a : r.atoms) {
                    lines.add(a.pdb_line);
                }
            }
            ++c_i;
        }
        String seq_id = "-1";
        int ordinal = 0;
        String ord_str = "";
        ArrayList<String> output = new ArrayList<String>();
        for (String line : lines) {
            if (!line.contains("ATOM")) continue;
            String n_seq_id = line.substring(22, 27).replace(" ", "");
            if (!n_seq_id.equals(seq_id)) {
                seq_id = n_seq_id;
                ord_str = String.valueOf(++ordinal);
                while (ord_str.length() < 4) {
                    ord_str = " " + ord_str;
                }
            }
            line = String.valueOf(line.substring(0, 21)) + "A" + line.substring(22);
            line = String.valueOf(line.substring(0, 22)) + ord_str + " " + line.substring(27);
            output.add(line);
        }
        FileSystemTools.writeFile(pdb_out, output);
    }
}

