/*
 * Decompiled with CFR 0.152.
 */
package EpitopePredictor;

import data_structures.Atom;
import data_structures.Residue;
import data_structures.SC_Structure;
import docking_global.GraphCreator;
import docking_global.PrepareData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import parsing.PDB_parser;
import parsing.PSA;
import utils.FileSystemTools;

public class EpiPred {
    public static void main(String[] args) {
        String folder = args[0];
        String local_folder = args[6];
        int depth = Integer.parseInt(args[7]);
        double nwidth = Double.parseDouble(args[8]);
        System.out.println("Running EpiPred with:");
        System.out.println("Depth: " + depth);
        System.out.println("Neighbor width: " + nwidth);
        double cutoff_graph = Double.parseDouble(args[1]);
        double perc_cutoff = Double.parseDouble(args[2]);
        double ext_cutoff = 0.0;
        String ab_file = String.valueOf(folder) + "/AB.pdb";
        String ag_file = String.valueOf(folder) + "/AG.pdb";
        String ab_psa = String.valueOf(folder) + "/tempAB.txt";
        String ag_psa = String.valueOf(folder) + "/tempAG.txt";
        EpiPred.FullPredictEpi(Integer.parseInt(args[4]), String.valueOf(folder) + "/temp_out", ext_cutoff, args[3], ab_psa, ag_psa, ab_file, ag_file, 1, cutoff_graph, perc_cutoff, local_folder, depth, nwidth);
    }

    /*
     * WARNING - void declaration
     */
    public static ArrayList<PrepareData.Struct_maximization> FullPredictEpi(int num_predictions, String out_folder, double ext_cutoff, String paratope, String ab_psa_file, String ag_psa_file, String ab_file, String ag_file, int num_iteations, double cutoff_graph, double perc_cutoff, String local_folder, int depth, double nwidth) {
        void var28_30;
        ArrayList<PrepareData.Struct_maximization> results = new ArrayList<PrepareData.Struct_maximization>();
        HashMap<Integer, Residue> ab = PDB_parser.parse(ab_file, 'A');
        HashMap<Integer, Residue> ag = PDB_parser.parse(ag_file, 'B');
        HashMap<Integer, Boolean> ab_surface_exp = PSA.readPSAFile(ab_psa_file, 7.5);
        HashMap<Integer, Boolean> ag_surface_exp = PSA.readPSAFile(ag_psa_file, 7.5);
        ArrayList<Integer> ab_cons = EpiPred.readParatopeExtension(paratope, ab, ab_surface_exp, ext_cutoff);
        System.out.println("Paratope size: " + ab_cons.size());
        double[][] ab_dists = new double[ab.size() + 1][ab.size() + 1];
        double[][] ag_dists = new double[ag.size() + 1][ag.size() + 1];
        for (Integer ab_i_1 : ab_cons) {
            for (Integer n : ab_cons) {
                if (ab_i_1 == n) continue;
                ab_dists[ab_i_1.intValue()][n.intValue()] = ab.get(ab_i_1).distanceFrom(ab.get(n));
            }
        }
        for (Integer ag_i_1 : ag.keySet()) {
            for (Integer n : ag.keySet()) {
                if (ag_i_1 == n) continue;
                ag_dists[ag_i_1.intValue()][n.intValue()] = ag.get(ag_i_1).distanceFrom(ag.get(n));
            }
        }
        int prog = 1;
        for (Integer i : ag_surface_exp.keySet()) {
            System.out.println(String.valueOf(prog++) + "/" + ag_surface_exp.size());
            if (!ag_surface_exp.get(i).booleanValue()) continue;
            int d = depth;
            PrepareData.Struct_maximization struc = PrepareData.randomEpitopeSeeded(i, null, ag_surface_exp, ag, d, ab_cons, nwidth);
            ArrayList<Integer> ag_cons = struc.epitope;
            GraphCreator.Graph_struc gs = GraphCreator.createGraph(ag_surface_exp, cutoff_graph, ab, ag, null, ab_cons, ag_cons, ab_dists, ag_dists, local_folder);
            struc.score = gs.score_sum_deg;
            System.out.println("Score: " + struc.score);
            results.add(struc);
        }
        HashMap<Integer, PrepareData.Struct_maximization> all_strucs = new HashMap<Integer, PrepareData.Struct_maximization>();
        boolean bl = false;
        while (var28_30 < results.size()) {
            all_strucs.put((int)var28_30, (PrepareData.Struct_maximization)results.get((int)var28_30));
            ++var28_30;
        }
        double[][] dArray = new double[all_strucs.size()][all_strucs.size()];
        boolean progress = false;
        for (Integer i02 : all_strucs.keySet()) {
            PrepareData.Struct_maximization sm0 = (PrepareData.Struct_maximization)all_strucs.get(i02);
            for (Integer i1 : all_strucs.keySet()) {
                double d;
                PrepareData.Struct_maximization sm1 = (PrepareData.Struct_maximization)all_strucs.get(i1);
                dArray[i02.intValue()][i1.intValue()] = d = EpiPred.overlapPerc(sm0.epitope, sm1.epitope);
            }
        }
        ArrayList<SuperEpi> epis = new ArrayList<SuperEpi>();
        int iter = 0;
        while (iter < num_predictions) {
            SuperEpi se = EpiPred.PickBiggestRemove(results, 1, 1);
            if (epis.size() != 0 && EpiPred.checkDuplicates(epis, se, perc_cutoff)) {
                --iter;
            } else {
                epis.add(se);
                ArrayList<String> epitope = new ArrayList<String>();
                for (Integer i_ag : ag.keySet()) {
                    if (se.epitope.contains(i_ag)) continue;
                    epitope.add("" + i_ag);
                }
                HashMap<Integer, String> colors = new HashMap<Integer, String>();
                for (Integer i_ag : ag.keySet()) {
                    if (se.epitope.contains(i_ag)) {
                        colors.put(i_ag, "100");
                        continue;
                    }
                    colors.put(i_ag, "0");
                }
                ArrayList<String> out_pdb = EpiPred.saveColored(ag, colors);
                FileSystemTools.writeFile(String.valueOf(out_folder) + "/" + iter + ".pdb", out_pdb);
                FileSystemTools.writeFile(String.valueOf(out_folder) + "/" + iter + ".txt", epitope);
            }
            ++iter;
        }
        return results;
    }

    public static boolean checkDuplicates(ArrayList<SuperEpi> ses, SuperEpi se, double cutoff) {
        for (SuperEpi se_temp : ses) {
            if (!(EpiPred.overlapPerc(se_temp.epitope, se.epitope) > cutoff)) continue;
            return true;
        }
        return false;
    }

    public static double overlapPerc(ArrayList<Integer> a1, ArrayList<Integer> a2) {
        double tot = 0.0;
        for (Integer i : a1) {
            if (!a2.contains(i)) continue;
            tot += 1.0;
        }
        return tot / (double)a2.size();
    }

    public static SuperEpi PickBiggestRemove(ArrayList<PrepareData.Struct_maximization> epis, int N, int pdb_id) {
        int orig_n = N;
        int temp_n = N;
        TreeSet sorted = new TreeSet();
        double delta = 1.0E-4;
        double curr_max = -1.0;
        PrepareData.Struct_maximization best = null;
        for (PrepareData.Struct_maximization struc : epis) {
            if (!(struc.score > curr_max)) continue;
            curr_max = struc.score;
            best = struc;
        }
        epis.remove(best);
        if (best == null) {
            System.out.println("It appears that your percentage cutoff is too high given the number of epitopes you would like to get out of this program - please increase the percentage cutoff or decrease the number of returned epitopes");
            System.exit(0);
        }
        return new SuperEpi("", best.epitope);
    }

    public static ArrayList<Integer> readParatopeExtension(String paratope, HashMap<Integer, Residue> str, HashMap<Integer, Boolean> surf, double cutoff) {
        ArrayList<Integer> n_cons = new ArrayList<Integer>();
        ArrayList<Integer> cons = new ArrayList<Integer>();
        ArrayList<String> not_in = FileSystemTools.readFile(paratope);
        for (String line : not_in) {
            int id = Integer.parseInt(line);
            n_cons.add(id);
        }
        for (Integer i : str.keySet()) {
            if (n_cons.contains(i) || !surf.get(i).booleanValue()) continue;
            cons.add(i);
        }
        ArrayList<Integer> augmented = new ArrayList<Integer>();
        for (Integer i : str.keySet()) {
            for (Integer con : cons) {
                if (!(str.get(i).distanceFrom(str.get(con)) < cutoff) || augmented.contains(i) || cons.contains(i) || !surf.get(i).booleanValue()) continue;
                augmented.add(i);
            }
        }
        cons.addAll(augmented);
        return cons;
    }

    public static ArrayList<String> saveColored(HashMap<Integer, Residue> str, HashMap<Integer, String> colors) {
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i : str.keySet()) {
            sorted.add(i);
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (Integer i : sorted) {
            Residue r = str.get(i);
            for (Atom a : r.atoms) {
                lines.add(SC_Structure.colorBFactor(a.pdb_line, colors.get(i)));
            }
        }
        return lines;
    }

    public static class SuperEpi {
        final String data;
        public double score;
        final ArrayList<Integer> epitope;

        public SuperEpi(String stats, ArrayList<Integer> epi) {
            this.data = stats;
            this.epitope = epi;
        }
    }
}

