/*
 * Decompiled with CFR 0.152.
 */
package analysis;

import analysis.FakeProtein;
import data_structures.MSA;
import data_structures.Patch;
import data_structures.Residue;
import data_structures.Residue_type;
import data_structures.SC_Structure;
import data_structures.SequencePair;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import main.Main_inter;
import parsing.PDB_parser;
import utils.FileSystemTools;
import utils.MathFunctions;

public class SurfaceAnalyzer {
    private static final String cwd = System.getProperty("user.dir");

    public static void main(String[] args) {
        String to_vec = "1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 0 1 0 0 1 0 ";
        PatchVector pv = PatchVector.vectorize(to_vec);
        PatchVector.print(pv);
    }

    public static void parseNonRedundantList() {
        String filename = String.valueOf(cwd) + "/SurfaceData/DataFiles/non_redundant_pdbs_SURFACE";
        String out_filename = String.valueOf(cwd) + "/SurfaceData/non_redundant_pdbs";
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        String out_lines = "";
        for (String line : lines) {
            String pdb_all = line.substring(214, 219);
            String pdb_code = pdb_all.substring(0, 4);
            char chain = pdb_all.charAt(4);
            System.out.println(String.valueOf(pdb_all) + " " + pdb_code + " " + chain);
            out_lines = String.valueOf(out_lines) + pdb_code + "\t" + chain + "\n";
        }
        FileSystemTools.writeFile(out_filename, out_lines);
    }

    public static void parseComplexList() {
        String filename = String.valueOf(cwd) + "/SurfaceData/qiang_complex";
        String pdb_src_folder = String.valueOf(cwd) + "/SurfaceData/DataFiles/complex_pdbs";
        String pdb_out_folder = String.valueOf(cwd) + "/SurfaceData/DataFiles/processed_complex";
        ArrayList<String> pdbs = FileSystemTools.readFile(filename);
        for (String pdb_name : pdbs) {
            pdb_name = pdb_name.toUpperCase();
            String pdb_file_source = String.valueOf(pdb_src_folder) + "/" + pdb_name + ".pdb";
            String chains = PDB_parser.getChains(pdb_file_source);
            System.out.println(String.valueOf(pdb_name) + " " + chains);
            int i = 0;
            while (i < chains.length()) {
                char chain = chains.charAt(i);
                String pdb_file_out = String.valueOf(pdb_out_folder) + "/" + pdb_name + chain + ".pdb";
                PDB_parser.writeConstrainingPDBINDEX(pdb_file_source, pdb_file_out, chain);
                ++i;
            }
        }
    }

    public static void parseDomainList() {
        String filename = String.valueOf(cwd) + "/SurfaceData/qiang_domain";
        String pdb_src_folder = String.valueOf(cwd) + "/SurfaceData/DataFiles/domain_pdbs";
        String pdb_out_folder = String.valueOf(cwd) + "/SurfaceData/DataFiles/processed_domain";
        ArrayList<String> pdbs = FileSystemTools.readFile(filename);
        String domain = "_2";
        int duplic = 3;
        ArrayList<String> duplicates = new ArrayList<String>();
        String out_names = "";
        int progress = 0;
        for (String line : pdbs) {
            System.out.println("[" + ++progress + "/" + pdbs.size() + "]");
            line = line.toUpperCase();
            domain = domain.equals("_1") ? "_2" : "_1";
            System.out.println(line);
            String pdb_code = line.substring(0, 4);
            line = line.substring(6);
            char chain = line.charAt(0);
            line = line.substring(line.indexOf("_") + 1);
            int start = Integer.parseInt(line.substring(0, line.indexOf("_")));
            line = line.substring(line.indexOf("_") + 1);
            int end = Integer.parseInt(line);
            ArrayList<Integer> roi = new ArrayList<Integer>();
            int i = start;
            while (i <= end) {
                roi.add(i);
                ++i;
            }
            System.out.println(pdbs.size());
            if (!duplicates.contains(String.valueOf(pdb_code) + domain)) {
                duplicates.add(String.valueOf(pdb_code) + domain);
                out_names = String.valueOf(out_names) + pdb_code + domain + "\n";
            } else {
                domain = "_" + duplic++;
                if (duplicates.contains(String.valueOf(pdb_code) + domain)) {
                    System.err.println("PANIKA");
                    System.exit(0);
                }
                duplicates.add(String.valueOf(pdb_code) + domain);
                out_names = String.valueOf(out_names) + pdb_code + domain + "\n";
            }
            System.out.println("chain:" + chain);
            System.out.println("start:" + start);
            System.out.println("end:" + end);
            System.out.println("pdb_name: " + pdb_code + domain);
            String pdb_file_source = String.valueOf(pdb_src_folder) + "/" + pdb_code + ".pdb";
            String pdb_file_out = String.valueOf(pdb_out_folder) + "/" + pdb_code + domain + ".pdb";
            PDB_parser.writeConstrainingPDBINDEX(pdb_file_source, pdb_file_out, roi, chain);
        }
        FileSystemTools.writeFile(String.valueOf(cwd) + "/SurfaceData/out.txt", out_names);
        System.out.println(duplicates.size());
    }

    public static ArrayList<String> getInputFiles(String input_folder) {
        System.out.println("Extracting file list from " + input_folder);
        File folder = new File(input_folder);
        File[] listOfFiles = folder.listFiles();
        ArrayList<String> out_files = new ArrayList<String>();
        ArrayList<String> test = FileSystemTools.readFile(String.valueOf(cwd) + "/SurfaceData/test_pdbs");
        int i = 0;
        while (i < listOfFiles.length) {
            if (listOfFiles[i].isFile()) {
                String files = listOfFiles[i].getName();
                if (files.contains(".pdb")) {
                    out_files.add(files);
                }
                if (test.contains(files = files.substring(0, 4))) {
                    System.err.println(String.valueOf(files) + " is in the test dataset");
                }
            }
            ++i;
        }
        System.out.println(String.valueOf(out_files.size()) + " elements extracted from " + input_folder);
        return out_files;
    }

    public static void calculateSurfaceResidues(String input_folder, String output_folder) {
        ArrayList<String> pdb_files = SurfaceAnalyzer.getInputFiles(input_folder);
        int progress = 0;
        for (String pdb_file : pdb_files) {
            System.out.println("Calculating surface of " + pdb_file);
            System.out.println("===========================================");
            System.out.println(String.valueOf(input_folder) + ": [" + ++progress + "/" + pdb_files.size() + "]" + " " + pdb_file);
            SC_Structure str = SurfaceAnalyzer.calculateIndividualPDB(String.valueOf(input_folder) + "/" + pdb_file);
            SurfaceAnalyzer.writeSingleFile(String.valueOf(output_folder) + "/" + pdb_file.substring(0, pdb_file.indexOf(46)), str);
            System.out.println("===========================================");
        }
    }

    public static void calculateSurfaceResiduesDC() {
        String input_folder = String.valueOf(cwd) + "/SurfaceData/DataFiles/processed_domain";
        String output_folder = String.valueOf(cwd) + "/SurfaceData/DataFiles/contact_patches_domain";
        ArrayList<String> pdb_files = SurfaceAnalyzer.getInputFiles(input_folder);
        int progress = 0;
        for (String pdb_file : pdb_files) {
            String pdb_id = pdb_file.substring(0, pdb_file.indexOf(".pdb"));
            int index = Integer.parseInt(pdb_id.substring(pdb_id.indexOf(95) + 1));
            if (index % 2 == 0) continue;
            String other = String.valueOf(pdb_id.substring(0, pdb_id.indexOf(95))) + "_" + ++index;
            String f1 = String.valueOf(input_folder) + "/" + pdb_id + ".pdb";
            String f2 = String.valueOf(input_folder) + "/" + other + ".pdb";
            System.out.println("===========================================");
            System.out.println("Contact DC: [" + ++progress + "/" + pdb_files.size() + "]" + " " + pdb_id + " " + other);
            SC_Structure str1 = SurfaceAnalyzer.calculateIndividualPDB(f1);
            SC_Structure str2 = SurfaceAnalyzer.calculateIndividualPDB(f2);
            SurfaceAnalyzer.writeSingleFileContact(String.valueOf(output_folder) + "/" + pdb_id, str1, str2);
            SurfaceAnalyzer.writeSingleFileContact(String.valueOf(output_folder) + "/" + other, str2, str1);
            System.out.println("===========================================");
        }
    }

    public static void calculateSurfaceResiduesCC() {
        String filename = String.valueOf(cwd) + "/SurfaceData/qiang_complex";
        String pdb_src_folder = String.valueOf(cwd) + "/SurfaceData/DataFiles/complex_pdbs";
        String pdb_out_folder = String.valueOf(cwd) + "/SurfaceData/DataFiles/processed_complex";
        String patches_folder = String.valueOf(cwd) + "/SurfaceData/DataFiles/contact_patches_complex";
        ArrayList<String> pdbs = FileSystemTools.readFile(filename);
        int progress = 0;
        for (String pdb_name : pdbs) {
            pdb_name = pdb_name.toUpperCase();
            String pdb_file_source = String.valueOf(pdb_src_folder) + "/" + pdb_name + ".pdb";
            String chains = PDB_parser.getChains(pdb_file_source);
            System.out.println(String.valueOf(pdb_name) + " " + chains);
            char chain1 = chains.charAt(0);
            String pdb_file_out1 = String.valueOf(pdb_out_folder) + "/" + pdb_name + chain1 + ".pdb";
            char chain2 = chains.charAt(1);
            String pdb_file_out2 = String.valueOf(pdb_out_folder) + "/" + pdb_name + chain2 + ".pdb";
            System.out.println("===========================================");
            System.out.println("Contact CC: [" + ++progress + "/" + pdbs.size() + "]" + " " + pdb_name + chain1 + " " + pdb_name + chain2);
            SC_Structure str1 = SurfaceAnalyzer.calculateIndividualPDB(pdb_file_out1);
            SC_Structure str2 = SurfaceAnalyzer.calculateIndividualPDB(pdb_file_out2);
            SurfaceAnalyzer.writeSingleFileContact(String.valueOf(patches_folder) + "/" + pdb_name + chain1, str1, str2);
            SurfaceAnalyzer.writeSingleFileContact(String.valueOf(patches_folder) + "/" + pdb_name + chain2, str2, str1);
            System.out.println("===========================================");
        }
    }

    public static SC_Structure calculateIndividualPDB(String pdb_file) {
        Residue_type[] first = FakeProtein.getNewSequence(pdb_file, cwd, true);
        SequencePair sp = new SequencePair(first, first, 0);
        ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
        sp_arr.add(sp);
        MSA msa = new MSA(sp_arr);
        System.out.println("Creating structure from file: " + pdb_file);
        SC_Structure str = FakeProtein.structureAndMSA(pdb_file, msa, true, cwd);
        System.out.println("Calculating patches for file: " + pdb_file);
        Main_inter.calculatePatches(str);
        return str;
    }

    public static int[] SurfaceStats(SC_Structure str) {
        int[] res_arr = new int[20];
        for (Integer r_i : str.residues.keySet()) {
            Residue res = str.residues.get(r_i);
            int n = res.type.ordinal();
            res_arr[n] = res_arr[n] + 1;
        }
        return res_arr;
    }

    public static void createPatchDB(String input_folder, String output_folder) {
    }

    public static HashMap<Residue_type, ArrayList<PatchVector>> singleProtein(SC_Structure str) {
        HashMap<Residue_type, ArrayList<PatchVector>> map = new HashMap<Residue_type, ArrayList<PatchVector>>();
        for (Integer i_res : str.residues.keySet()) {
            ArrayList<Object> vec_list;
            Residue res = str.residues.get(i_res);
            Patch patch = res.getPatch();
            int[] arr = SurfaceAnalyzer.vectorize(patch);
            if (!map.containsKey((Object)res.type)) {
                vec_list = new ArrayList();
                map.put(res.type, vec_list);
            } else {
                vec_list = map.get((Object)res.type);
            }
            boolean found = false;
            for (PatchVector patchVector : vec_list) {
                if (!patchVector.equal(arr)) continue;
                ++patchVector.count;
                found = true;
                break;
            }
            if (!found) {
                PatchVector patchVector = new PatchVector(arr);
                vec_list.add(patchVector);
            }
            map.put(res.type, vec_list);
        }
        return map;
    }

    public static HashMap<Residue_type, ArrayList<PatchVector>> singleProteinContact(SC_Structure str, SC_Structure str2) {
        HashMap<Residue_type, ArrayList<PatchVector>> map = new HashMap<Residue_type, ArrayList<PatchVector>>();
        for (Integer i_res : str.residues.keySet()) {
            ArrayList<Object> vec_list;
            Residue res = str.residues.get(i_res);
            boolean found_contact = false;
            for (Integer j_res : str2.residues.keySet()) {
                Residue res2 = str2.residues.get(j_res);
                if (!(res2.distanceFrom(res) < 4.5)) continue;
                found_contact = true;
            }
            if (!found_contact) continue;
            Patch patch = res.getPatch();
            int[] arr = SurfaceAnalyzer.vectorize(patch);
            if (!map.containsKey((Object)res.type)) {
                vec_list = new ArrayList();
                map.put(res.type, vec_list);
            } else {
                vec_list = map.get((Object)res.type);
            }
            boolean found = false;
            for (PatchVector patchVector : vec_list) {
                if (!patchVector.equal(arr)) continue;
                ++patchVector.count;
                found = true;
                break;
            }
            if (!found) {
                PatchVector patchVector = new PatchVector(arr);
                vec_list.add(patchVector);
            }
            map.put(res.type, vec_list);
        }
        return map;
    }

    public static void writeSingleFile(String pdb_name, SC_Structure str) {
        HashMap<Residue_type, ArrayList<PatchVector>> mapping = SurfaceAnalyzer.singleProtein(str);
        File f = new File(pdb_name);
        f.mkdir();
        for (Residue_type type : mapping.keySet()) {
            ArrayList<PatchVector> vps = mapping.get((Object)type);
            String filename = String.valueOf(pdb_name) + "/" + (Object)((Object)type);
            String data_out = "";
            for (PatchVector vp : vps) {
                data_out = String.valueOf(data_out) + vp.count + " ";
                int i = 0;
                while (i < 20) {
                    data_out = String.valueOf(data_out) + vp.AAs[i] + " ";
                    ++i;
                }
                data_out = String.valueOf(data_out) + "\n";
            }
            FileSystemTools.writeFile(filename, data_out);
        }
    }

    public static void writeSingleFileContact(String pdb_name, SC_Structure str, SC_Structure str2) {
        HashMap<Residue_type, ArrayList<PatchVector>> mapping = SurfaceAnalyzer.singleProteinContact(str, str2);
        File f = new File(pdb_name);
        f.mkdir();
        for (Residue_type type : mapping.keySet()) {
            ArrayList<PatchVector> vps = mapping.get((Object)type);
            String filename = String.valueOf(pdb_name) + "/" + (Object)((Object)type);
            String data_out = "";
            for (PatchVector vp : vps) {
                data_out = String.valueOf(data_out) + vp.count + " ";
                int i = 0;
                while (i < 20) {
                    data_out = String.valueOf(data_out) + vp.AAs[i] + " ";
                    ++i;
                }
                data_out = String.valueOf(data_out) + "\n";
            }
            FileSystemTools.writeFile(filename, data_out);
        }
    }

    public static int[] vectorize(Patch p) {
        int[] arr = new int[20];
        for (Residue res : p.patch_residues) {
            int n = res.type.ordinal();
            arr[n] = arr[n] + 1;
        }
        return arr;
    }

    public static class PatchVector {
        public int count;
        public final int[] AAs;

        public PatchVector(int[] amino_acids) {
            if (amino_acids == null || amino_acids.length != 20) {
                System.err.println("Attempting to create an invalid PatchVector");
                System.exit(0);
            }
            this.count = 1;
            this.AAs = amino_acids;
        }

        public static void parseVPFile(String filename) {
            ArrayList<String> parsed = FileSystemTools.readFile(filename);
            for (String string : parsed) {
            }
        }

        public static PatchVector vectorize(String line) {
            int _count = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            line = line.substring(line.indexOf(" ") + 1);
            int[] arr = new int[20];
            int i = 0;
            while (i < 19) {
                arr[i] = Integer.parseInt(line.substring(0, line.indexOf(" ")));
                line = line.substring(line.indexOf(" ") + 1);
                ++i;
            }
            arr[19] = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            PatchVector pv = new PatchVector(arr);
            pv.count = _count;
            return pv;
        }

        public boolean equal(int[] other) {
            if (other == null || other.length != 20) {
                System.err.println("Wrong array supplied to PatchVector.equal()");
                System.exit(0);
            }
            int i = 0;
            while (i < 20) {
                if (this.AAs[i] != other[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public static void print(PatchVector pv) {
            System.out.println("==================");
            System.out.println("count= " + pv.count);
            MathFunctions.printAAArray(pv.AAs);
            System.out.println("==================");
        }
    }
}

