/*
 * Decompiled with CFR 0.152.
 */
package docking_global;

import data_structures.Residue;
import docking.BatchAnalyzer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.BronKerboschCliqueFinder;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;
import utils.MathFunctions;

public class GraphCreator {
    private static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        SimpleGraph<String, DefaultEdge> g = new SimpleGraph<String, DefaultEdge>(DefaultEdge.class);
        g.addVertex("1");
        g.addVertex("2");
        g.addVertex("3");
        g.addVertex("4");
        g.addVertex("5");
        g.addVertex("6");
        g.addEdge("1", "2");
        g.addEdge("1", "3");
        g.addEdge("3", "2");
        g.addEdge("1", "4");
        g.addEdge("1", "5");
        g.addEdge("4", "5");
        System.out.println(((Object)g).toString());
        BronKerboschCliqueFinder bk = new BronKerboschCliqueFinder(g);
        System.out.println("Getting all cliques");
        Collection cliques = bk.getAllMaximalCliques();
        System.out.println("There are " + cliques.size() + " cliques");
        int clique_i = 1;
        for (Set clique : cliques) {
            System.out.println("Clique no. " + clique_i);
            for (String i : clique) {
                System.out.print(String.valueOf(i) + " ");
            }
            ++clique_i;
            System.out.println();
        }
    }

    public static double[][] CompileStandardizationResults() {
        double[][] props = new double[20][20];
        double[][] pos = MathFunctions.readParsable2DDouble(String.valueOf(userdir) + "/result_dump/trainingstats_deg_pos.txt");
        double[][] neg = MathFunctions.readParsable2DDouble(String.valueOf(userdir) + "/result_dump/trainingstats_deg_neg.txt");
        int i = 0;
        while (i < 20) {
            int j = 0;
            while (j < 20) {
                if (pos[i][j] + neg[i][j] != 0.0) {
                    props[i][j] = pos[i][j] / (pos[i][j] + neg[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return props;
    }

    public static Graph_struc createGraphProtein(double cutoff, HashMap<Integer, Residue> ab_str, HashMap<Integer, Residue> ag_str, ArrayList<Integer> ab, ArrayList<Integer> ag, double[][] ab_d, double[][] ag_d) {
        double score_sum_degree = 0.0;
        double score_sum_rd = 0.0;
        double[][] prop_mat = BatchAnalyzer.getLikelihoodProteins();
        HashMap<String, Integer> degrees = new HashMap<String, Integer>();
        for (Integer i : ab) {
            for (Integer j : ag) {
                for (Integer i_other : ab) {
                    for (Integer j_other : ag) {
                        if (j == j_other || i == i_other || !(Math.abs(ab_d[i][i_other] - ag_d[j][j_other]) < cutoff)) continue;
                        if (!degrees.containsKey(i + "_" + j)) {
                            degrees.put(i + "_" + j, 1);
                        } else {
                            degrees.put(i + "_" + j, (Integer)degrees.get(i + "_" + j) + 1);
                        }
                        if (!degrees.containsKey(i_other + "_" + j_other)) {
                            degrees.put(i_other + "_" + j_other, 1);
                            continue;
                        }
                        degrees.put(i_other + "_" + j_other, (Integer)degrees.get(i_other + "_" + j_other) + 1);
                    }
                }
            }
        }
        for (String vertex : degrees.keySet()) {
            int ab_i = Integer.parseInt(vertex.substring(0, vertex.indexOf("_")));
            int ag_i = Integer.parseInt(vertex.substring(vertex.indexOf("_") + 1));
            int num_edges = (Integer)degrees.get(vertex);
            score_sum_degree += prop_mat[ab_str.get((Object)Integer.valueOf((int)ab_i)).type.ordinal()][ag_str.get((Object)Integer.valueOf((int)ag_i)).type.ordinal()] * (double)num_edges;
        }
        Graph_struc gs = new Graph_struc(score_sum_degree, score_sum_rd, degrees.size());
        return gs;
    }

    public static Graph_struc createGraph(HashMap<Integer, Boolean> surf, double cutoff, HashMap<Integer, Residue> ab_str, HashMap<Integer, Residue> ag_str, double[][] cons, ArrayList<Integer> ab, ArrayList<Integer> ag, double[][] ab_d, double[][] ag_d, String train_data) {
        double score_sum_degree = 0.0;
        double score_sum_rd = 0.0;
        double[][] prop_mat = BatchAnalyzer.getLikelihoodFrom(train_data);
        int[][] degrees = new int[MathFunctions.getMax(ab) + 1][MathFunctions.getMax(ag) + 1];
        for (int i : ab) {
            for (int j : ag) {
                if (!surf.get(j).booleanValue()) continue;
                for (int i_other : ab) {
                    for (int j_other : ag) {
                        if (!surf.get(j_other).booleanValue() || j == j_other || i == i_other || !(Math.abs(ab_d[i][i_other] - ag_d[j][j_other]) < cutoff)) continue;
                        int[] nArray = degrees[i];
                        int n = j;
                        nArray[n] = nArray[n] + 1;
                        int[] nArray2 = degrees[i_other];
                        int n2 = j_other;
                        nArray2[n2] = nArray2[n2] + 1;
                    }
                }
            }
        }
        for (int i : ab) {
            for (int j : ag) {
                int num_edges = degrees[i][j];
                score_sum_degree += prop_mat[ab_str.get((Object)Integer.valueOf((int)i)).type.ordinal()][ag_str.get((Object)Integer.valueOf((int)j)).type.ordinal()] * (double)num_edges;
            }
        }
        Graph_struc gs = new Graph_struc(score_sum_degree, score_sum_rd, degrees.length);
        return gs;
    }

    public static boolean isCorrect(String vertex, double[][] corrs) {
        int ag;
        int ab = Integer.parseInt(vertex.substring(0, vertex.indexOf("_")));
        return corrs[ab][ag = Integer.parseInt(vertex.substring(vertex.indexOf("_") + 1))] == 1.0;
    }

    public static void ClusteringCoefficientScore(UndirectedGraph<String, DefaultEdge> g) {
    }

    public static class Graph_struc {
        public final double score_sum_deg;
        public final double score_sum_rd;
        public final double num_vertices;

        Graph_struc(double ss, double rd, double nv) {
            this.score_sum_deg = ss;
            this.score_sum_rd = rd;
            this.num_vertices = nv;
        }
    }
}

