/*
 * Decompiled with CFR 0.152.
 */
package ipatch_lite;

import data_structures.Atom;
import data_structures.MSA;
import data_structures.Residue;
import data_structures.Residue_type;
import data_structures.SC_Structure;
import data_structures.SequencePair;
import docking.BatchAnalyzer;
import docking_global.GraphCreator;
import docking_global.PrepareData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import main.Main_inter;
import main.Main_outer;
import main.ResultWriter;
import parsing.PDB_parser;
import parsing.PSA;
import utils.FileSystemTools;
import utils.MathFunctions;

public class iPatchLite {
    private static final String userdir = System.getProperty("user.dir");
    private static final String db_folder = String.valueOf(userdir) + "/protein_database/standardized";
    private static final String dgf = "/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50/";

    public static void main(String[] args) {
        iPatchLite.ab_lite_ds56("TPRO");
    }

    public void runDockGroundReal() {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        String scramble_run = "/Tests/form";
        String results = "TestResults/2013TPRO";
        HashMap<String, DockGroundStruc> strucs = this.getPairs();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1E96");
        pdbs.add("1GPW");
        pdbs.add("1HE8");
        pdbs.add("1MA9");
        pdbs.add("1S6V");
        pdbs.add("1XD3");
        pdbs.add("2A5T");
        pdbs.add("2CKH");
        pdbs.add("3FAP");
        pdbs.add("1AVW");
        pdbs.add("1KU6");
        pdbs.add("1OPH");
        pdbs.add("1TMQ");
        pdbs.add("2BKR");
        pdbs.add("1U7F");
        HashMap onebatch = new HashMap();
        HashMap<Double, Double> howmany = new HashMap<Double, Double>();
        for (String pdb : strucs.keySet()) {
            System.out.println(pdb);
            if (!pdbs.contains(pdb)) continue;
            ArrayList<String> complex = strucs.get(pdb).getComplex(1, 1);
            String pdb1 = String.valueOf(complex.get(0).substring(0, 6)) + ".pdb";
            String pdb2 = String.valueOf(complex.get(1).substring(0, 6)) + ".pdb";
            String rep1 = complex.get(0);
            String rep2 = complex.get(1);
            System.out.println(String.valueOf(pdb1) + " : " + pdb2);
            String psa1 = "/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//psa_out/" + pdb1;
            String psa2 = "/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//psa_out/" + pdb2;
            HashMap<Double, ArrayList<Double>> temp = iPatchLite.DockGroundAnalysisReal(rep1, rep2, pdb1, pdb2, scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, "TPRO", constrain_msa, psa1, psa2);
            for (double cutoff : temp.keySet()) {
                if (!onebatch.containsKey(cutoff)) {
                    ArrayList<Double> nar = new ArrayList<Double>();
                    nar.add(0.0);
                    nar.add(0.0);
                    onebatch.put(cutoff, nar);
                    howmany.put(cutoff, 0.0);
                }
                ArrayList<Double> narr = new ArrayList<Double>();
                narr.add((Double)((ArrayList)onebatch.get(cutoff)).get(0) + temp.get(cutoff).get(0));
                narr.add((Double)((ArrayList)onebatch.get(cutoff)).get(1) + temp.get(cutoff).get(1));
                onebatch.put(cutoff, narr);
                howmany.put(cutoff, (Double)howmany.get(cutoff) + 1.0);
            }
        }
        HashMap<Double, Double> prec = new HashMap<Double, Double>();
        HashMap<Double, Double> rec = new HashMap<Double, Double>();
        ArrayList<String> output = new ArrayList<String>();
        Iterator iterator = howmany.keySet().iterator();
        while (iterator.hasNext()) {
            double cutoff = (Double)iterator.next();
            prec.put(cutoff, (Double)((ArrayList)onebatch.get(cutoff)).get(0) / (Double)howmany.get(cutoff));
            rec.put(cutoff, (Double)((ArrayList)onebatch.get(cutoff)).get(1) / (Double)howmany.get(cutoff));
            System.out.println(prec.get(cutoff) + " : " + rec.get(cutoff));
            output.add(rec.get(cutoff) + " " + prec.get(cutoff));
        }
        FileSystemTools.writeFile("/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//results/crystal.txt", output);
        System.exit(0);
    }

    public void runDockGroundRealComplementarity() {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        String scramble_run = "/Tests/form";
        String results = "TestResults/2013TPROComplement";
        HashMap<String, DockGroundStruc> strucs = this.getPairs();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1E96");
        pdbs.add("1GPW");
        pdbs.add("1MA9");
        pdbs.add("1S6V");
        pdbs.add("1XD3");
        pdbs.add("2A5T");
        pdbs.add("2CKH");
        pdbs.add("3FAP");
        pdbs.add("1AVW");
        pdbs.add("1KU6");
        pdbs.add("1OPH");
        pdbs.add("1TMQ");
        pdbs.add("2BKR");
        pdbs.add("1U7F");
        HashMap onebatch = new HashMap();
        HashMap<Double, Double> howmany = new HashMap<Double, Double>();
        for (String pdb : strucs.keySet()) {
            System.out.println(pdb);
            if (!pdbs.contains(pdb)) continue;
            ArrayList<String> complex = strucs.get(pdb).getComplex(1, 1);
            String pdb1 = String.valueOf(complex.get(0).substring(0, 6)) + ".pdb";
            String pdb2 = String.valueOf(complex.get(1).substring(0, 6)) + ".pdb";
            String rep1 = complex.get(0);
            String rep2 = complex.get(1);
            System.out.println(String.valueOf(pdb1) + " : " + pdb2);
            String psa1 = "/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//psa_out/" + pdb1;
            String psa2 = "/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//psa_out/" + pdb2;
            HashMap<Double, ArrayList<Double>> temp = iPatchLite.DockGroundAnalysisRealComplementarity(rep1, rep2, pdb1, pdb2, scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, "TPRO", constrain_msa, psa1, psa2);
            for (double cutoff : temp.keySet()) {
                if (!onebatch.containsKey(cutoff)) {
                    ArrayList<Double> nar = new ArrayList<Double>();
                    nar.add(0.0);
                    nar.add(0.0);
                    onebatch.put(cutoff, nar);
                    howmany.put(cutoff, 0.0);
                }
                ArrayList<Double> narr = new ArrayList<Double>();
                narr.add((Double)((ArrayList)onebatch.get(cutoff)).get(0) + temp.get(cutoff).get(0));
                narr.add((Double)((ArrayList)onebatch.get(cutoff)).get(1) + temp.get(cutoff).get(1));
                onebatch.put(cutoff, narr);
                howmany.put(cutoff, (Double)howmany.get(cutoff) + 1.0);
            }
        }
        HashMap<Double, Double> prec = new HashMap<Double, Double>();
        HashMap<Double, Double> rec = new HashMap<Double, Double>();
        ArrayList<String> output = new ArrayList<String>();
        Iterator iterator = howmany.keySet().iterator();
        while (iterator.hasNext()) {
            double cutoff = (Double)iterator.next();
            prec.put(cutoff, (Double)((ArrayList)onebatch.get(cutoff)).get(0) / (Double)howmany.get(cutoff));
            rec.put(cutoff, (Double)((ArrayList)onebatch.get(cutoff)).get(1) / (Double)howmany.get(cutoff));
            System.out.println(prec.get(cutoff) + " : " + rec.get(cutoff));
            output.add(rec.get(cutoff) + " " + prec.get(cutoff));
        }
        FileSystemTools.writeFile("/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//results/crystal.txt", output);
        System.exit(0);
    }

    public void runDockGround() {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        String scramble_run = "/Tests/form";
        String results = "TestResults/2013TPRO";
        HashMap<String, DockGroundStruc> strucs = this.getPairs();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1E96");
        pdbs.add("1GPW");
        pdbs.add("1HE8");
        pdbs.add("1MA9");
        pdbs.add("1S6V");
        pdbs.add("1XD3");
        pdbs.add("2A5T");
        pdbs.add("2CKH");
        pdbs.add("3FAP");
        pdbs.add("1AVW");
        pdbs.add("1KU6");
        pdbs.add("1OPH");
        pdbs.add("1TMQ");
        pdbs.add("2BKR");
        pdbs.add("1U7F");
        int i = 1;
        while (i < 7) {
            int j = 1;
            while (j < 7) {
                HashMap onebatch = new HashMap();
                HashMap<Double, Double> howmany = new HashMap<Double, Double>();
                for (String pdb : strucs.keySet()) {
                    System.out.println(pdb);
                    if (!pdbs.contains(pdb)) continue;
                    ArrayList<String> complex = strucs.get(pdb).getComplex(i, j);
                    String pdb1 = complex.get(0);
                    String pdb2 = complex.get(1);
                    System.out.println(String.valueOf(pdb1) + " : " + pdb2);
                    String psa1 = "/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//psa_out/" + pdb1;
                    String psa2 = "/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//psa_out/" + pdb2;
                    HashMap<Double, ArrayList<Double>> temp = iPatchLite.DockGroundAnalysis(pdb1, pdb2, scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, "TPRO", constrain_msa, psa1, psa2);
                    for (double cutoff : temp.keySet()) {
                        if (!onebatch.containsKey(cutoff)) {
                            ArrayList<Double> nar = new ArrayList<Double>();
                            nar.add(0.0);
                            nar.add(0.0);
                            onebatch.put(cutoff, nar);
                            howmany.put(cutoff, 0.0);
                        }
                        ArrayList<Double> narr = new ArrayList<Double>();
                        narr.add((Double)((ArrayList)onebatch.get(cutoff)).get(0) + temp.get(cutoff).get(0));
                        narr.add((Double)((ArrayList)onebatch.get(cutoff)).get(1) + temp.get(cutoff).get(1));
                        onebatch.put(cutoff, narr);
                        howmany.put(cutoff, (Double)howmany.get(cutoff) + 1.0);
                    }
                }
                HashMap<Double, Double> prec = new HashMap<Double, Double>();
                HashMap<Double, Double> rec = new HashMap<Double, Double>();
                ArrayList<String> output = new ArrayList<String>();
                Iterator iterator = howmany.keySet().iterator();
                while (iterator.hasNext()) {
                    double cutoff = (Double)iterator.next();
                    prec.put(cutoff, (Double)((ArrayList)onebatch.get(cutoff)).get(0) / (Double)howmany.get(cutoff));
                    rec.put(cutoff, (Double)((ArrayList)onebatch.get(cutoff)).get(1) / (Double)howmany.get(cutoff));
                    System.out.println(prec.get(cutoff) + " : " + rec.get(cutoff));
                    output.add(rec.get(cutoff) + " " + prec.get(cutoff));
                }
                FileSystemTools.writeFile("/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//results/" + i + "_" + j + ".txt", output);
                ++j;
            }
            ++i;
        }
    }

    public static void ab_lite_ds56(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        String scramble_run = "/Tests/ds56";
        String results = "TestResults/ds56" + method;
        iPatchLite.analyze(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa);
    }

    public static void ab_lite_run(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        String scramble_run = "/Tests/form";
        String results = "TestResults/2013" + method;
        iPatchLite.analyze(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa);
    }

    public HashMap<String, DockGroundStruc> getPairs() {
        HashMap<String, DockGroundStruc> strucs = new HashMap<String, DockGroundStruc>();
        ArrayList<String> lines = FileSystemTools.readFile("/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//pairs.txt");
        for (String line : lines) {
            String pdb = FileSystemTools.getColumnTab(line, 1);
            DockGroundStruc dstruc = new DockGroundStruc(line);
            strucs.put(pdb, dstruc);
        }
        return strucs;
    }

    public static void getBestPatches(String rep1, String rep2, SC_Structure str1, SC_Structure str2, String psa1, String psa2) {
        PrepareData.Struct_maximization struc;
        int depth = 1;
        double cutoff = 1.0;
        double cutoff_for_graph = 0.0;
        double[][] ab_dists = new double[2 * str1.residues.size() + 1][2 * str1.residues.size() + 1];
        double[][] ag_dists = new double[2 * str2.residues.size() + 1][2 * str2.residues.size() + 1];
        for (Integer ab_i_1 : str1.residues.keySet()) {
            for (Integer ab_i_2 : str1.residues.keySet()) {
                if (ab_i_1 == ab_i_2) continue;
                ab_dists[ab_i_1.intValue()][ab_i_2.intValue()] = str1.residues.get(ab_i_1).distanceFrom(str1.residues.get(ab_i_2));
            }
        }
        for (Integer ag_i_1 : str2.residues.keySet()) {
            for (Integer ag_i_2 : str2.residues.keySet()) {
                if (ag_i_1 == ag_i_2) continue;
                ag_dists[ag_i_1.intValue()][ag_i_2.intValue()] = str2.residues.get(ag_i_1).distanceFrom(str2.residues.get(ag_i_2));
            }
        }
        HashMap<Integer, Boolean> surf1 = PSA.readPSAFile(psa1, 7.5);
        HashMap<Integer, Boolean> surf2 = PSA.readPSAFile(psa2, 7.5);
        HashMap<Integer, PrepareData.Struct_maximization> samp1 = new HashMap<Integer, PrepareData.Struct_maximization>();
        HashMap<Integer, PrepareData.Struct_maximization> samp2 = new HashMap<Integer, PrepareData.Struct_maximization>();
        for (int i : str1.residues.keySet()) {
            struc = PrepareData.randomEpitopeSeeded(i, "somepdb", surf1, str1.residues, depth, new ArrayList<Integer>(), cutoff);
            samp1.put(i, struc);
        }
        for (int i : str2.residues.keySet()) {
            struc = PrepareData.randomEpitopeSeeded(i, "somepdb", surf2, str2.residues, depth, new ArrayList<Integer>(), cutoff);
            samp2.put(i, struc);
        }
        int prog = 0;
        int best1 = -1;
        int best2 = -1;
        double best_score = -1.0;
        Iterator<Object> iterator = samp1.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            System.out.println(String.valueOf(prog) + " : " + samp1.size());
            ++prog;
            PrepareData.Struct_maximization struc1 = (PrepareData.Struct_maximization)samp1.get(i);
            ArrayList<Integer> cons1 = struc1.epitope;
            Iterator iterator2 = samp2.keySet().iterator();
            while (iterator2.hasNext()) {
                int j = (Integer)iterator2.next();
                PrepareData.Struct_maximization struc2 = (PrepareData.Struct_maximization)samp2.get(j);
                ArrayList<Integer> cons2 = struc2.epitope;
                GraphCreator.Graph_struc gs = GraphCreator.createGraphProtein(cutoff_for_graph, str1.residues, str2.residues, cons1, cons2, ab_dists, ag_dists);
                if (!(gs.score_sum_deg > best_score)) continue;
                best1 = i;
                best2 = j;
                best_score = gs.score_sum_deg;
            }
            System.out.println("Best " + best1 + " " + best2 + " " + best_score);
        }
        for (Integer s_1 : ((PrepareData.Struct_maximization)samp1.get((Object)Integer.valueOf((int)best1))).epitope) {
            str1.residues.get(s_1).setTPro(str1.residues.get(s_1).getTPro());
        }
        for (Integer s_2 : ((PrepareData.Struct_maximization)samp2.get((Object)Integer.valueOf((int)best2))).epitope) {
            str2.residues.get(s_2).setTPro(str2.residues.get(s_2).getTPro());
        }
        TreeSet<Integer> sort1 = new TreeSet<Integer>();
        for (Integer i : str1.residues.keySet()) {
            sort1.add(i);
        }
        TreeSet<Integer> sort2 = new TreeSet<Integer>();
        for (Integer i : str2.residues.keySet()) {
            sort2.add(i);
        }
        ArrayList<String> out = new ArrayList<String>();
        for (Integer i : sort1) {
            for (Atom a : str1.residues.get((Object)i).atoms) {
                int color = (int)(100.0 * (str1.residues.get(i).getTPro() / 3.0));
                out.add(SC_Structure.colorBFactor(a.pdb_line, String.valueOf((double)color)));
            }
        }
        System.out.println("Done, " + rep2);
        FileSystemTools.writeFile(rep1, out);
        out = new ArrayList();
        for (Integer i : sort2) {
            for (Atom a : str2.residues.get((Object)i).atoms) {
                int color = (int)(100.0 * (str2.residues.get(i).getTPro() / 3.0));
                out.add(SC_Structure.colorBFactor(a.pdb_line, String.valueOf((double)color)));
            }
        }
        FileSystemTools.writeFile(rep2, out);
    }

    public static double annotatePropensity(SC_Structure str, SC_Structure partner) {
        double[][] props = BatchAnalyzer.getLikelihoodProteins();
        double max = 0.0;
        for (int i : str.residues.keySet()) {
            double sum = 0.0;
            int i_this = str.residues.get((Object)Integer.valueOf((int)i)).type.ordinal();
            int j = 0;
            while (j < 20) {
                sum = props[i_this][j];
                ++j;
            }
            double newtpro = str.residues.get(i).getTPro();
            str.residues.get(i).setTPro(newtpro);
            if (!(newtpro > max)) continue;
            max = newtpro;
        }
        return max;
    }

    public static void analyze(String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method, boolean constrain_msa) {
        String main_fold = String.valueOf(userdir) + scramble_run;
        double t_start = System.currentTimeMillis();
        int j = 1;
        while (j < num_iterations + 1) {
            ArrayList<HashMap<Double, Integer>> TPs = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<HashMap<Double, Integer>> FPs = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<HashMap<Double, Integer>> TNs = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<HashMap<Double, Integer>> FNs = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<String> folders = FileSystemTools.getFolders(String.valueOf(userdir) + scramble_run);
            int i = 1;
            for (String folder : folders) {
                if (++i == 3) continue;
                System.out.println(String.valueOf(scramble_run) + " [" + i + "/" + folders.size() + "]");
                HashMap<Double, Integer> TP_s = new HashMap<Double, Integer>();
                HashMap<Double, Integer> FP_s = new HashMap<Double, Integer>();
                HashMap<Double, Integer> TN_s = new HashMap<Double, Integer>();
                HashMap<Double, Integer> FN_s = new HashMap<Double, Integer>();
                ArrayList<Integer> roi = new ArrayList<Integer>();
                int inter = 0;
                while (inter < 9999) {
                    roi.add(inter);
                    ++inter;
                }
                String testFolder = userdir;
                String pdb_file1 = String.valueOf(main_fold) + "/" + folder + "/const_1";
                String pdb_file2 = String.valueOf(main_fold) + "/" + folder + "/const_2";
                MSA msa = null;
                Residue_type[] first = PDB_parser.getSeqFromPDB(pdb_file1, 'A');
                Residue_type[] second = PDB_parser.getSeqFromPDB(pdb_file2, 'A');
                SequencePair sp = new SequencePair(first, second, 0);
                ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
                sp_arr.add(sp);
                msa = new MSA(sp_arr);
                System.out.println("Creating structure from file: " + pdb_file1);
                SC_Structure strA = Main_outer.structureAndMSA(pdb_file1, msa, -1, true, roi, 'A', testFolder, use_full_alignment, false, null);
                System.out.println("Creating structure from file: " + pdb_file2);
                SC_Structure strB = Main_outer.structureAndMSA(pdb_file2, msa, -1, false, roi, 'A', testFolder, use_full_alignment, false, null);
                Main_inter mi = new Main_inter(msa, strA, strB);
                strA = iPatchLite.calculateNeighborsAWrite(strA, strB);
                strB = iPatchLite.calculateNeighborsBWrite(strA, strB);
                ArrayList<Integer> consider1 = iPatchLite.HalveStructure(strA);
                ArrayList<Integer> consider2 = iPatchLite.HalveStructure(strB);
                iPatchLite.orderScores(strA);
                iPatchLite.orderScores(strB);
                double cutoff = 0.0;
                while (cutoff < 100.0) {
                    ArrayList<Integer> forA = PDB_parser.writePDBHalf(strA, true, cutoff, "TPRO");
                    ArrayList<Integer> forB = PDB_parser.writePDBHalf(strB, false, cutoff, "TPRO");
                    TP_s.put(cutoff, forA.get(0) + forB.get(0));
                    FP_s.put(cutoff, forA.get(1) + forB.get(1));
                    TN_s.put(cutoff, forA.get(2) + forB.get(2));
                    FN_s.put(cutoff, forA.get(3) + forB.get(3));
                    double TP = forA.get(0) + forB.get(0);
                    double FP = forA.get(1) + forB.get(1);
                    double FN = forA.get(3) + forB.get(3);
                    double precision = TP / (TP + FP);
                    double d = TP / (TP + FN);
                    cutoff += 1.0;
                }
                TPs.add(TP_s);
                FPs.add(FP_s);
                TNs.add(TN_s);
                FNs.add(FN_s);
            }
            ResultWriter.writeSimpleResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TP" + j, TPs);
            ResultWriter.writeSimpleResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FP" + j, FPs);
            ResultWriter.writeSimpleResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FN" + j, FNs);
            ResultWriter.writeSimpleResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TN" + j, TNs);
            ++j;
        }
        System.out.println("Wrote results");
    }

    public static HashMap<Double, ArrayList<Double>> DockGroundAnalysisReal(String rep1, String rep2, String pdb_file1, String pdb_file2, String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method, boolean constrain_msa, String psa_file_1, String psa_file_2) {
        HashMap<Double, ArrayList<Double>> results = new HashMap<Double, ArrayList<Double>>();
        MSA msa = null;
        Residue_type[] first = PDB_parser.getSeqFromPDB("/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//dockground_raw_proc/" + pdb_file1, 'A');
        Residue_type[] second = PDB_parser.getSeqFromPDB("/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//dockground_raw_proc/" + pdb_file2, 'A');
        SequencePair sp = new SequencePair(first, second, 0);
        ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
        sp_arr.add(sp);
        msa = new MSA(sp_arr);
        ArrayList<Integer> roi = new ArrayList<Integer>();
        int inter = 0;
        while (inter < 9999) {
            roi.add(inter);
            ++inter;
        }
        System.out.println("Creating structure from file: " + pdb_file1);
        SC_Structure strA = Main_outer.structureAndMSA("/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//dockground_raw_proc/" + pdb_file1, msa, -1, true, roi, 'A', userdir, use_full_alignment, false, psa_file_1);
        System.out.println("Creating structure from file: " + pdb_file2);
        SC_Structure strB = Main_outer.structureAndMSA("/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//dockground_raw_proc/" + pdb_file2, msa, -1, false, roi, 'A', userdir, use_full_alignment, false, psa_file_2);
        Main_inter mi = new Main_inter(msa, strA, strB);
        double max1 = iPatchLite.annotateContactReal(rep1, strA);
        double max2 = iPatchLite.annotateContactReal(rep2, strB);
        double max = max1 > max2 ? max1 : max2;
        double cutoff = 0.0;
        while (cutoff < max) {
            cutoff = (double)Math.round(cutoff * 10.0) / 10.0;
            ArrayList<Integer> forA = PDB_parser.writePDBHalf(strA, true, cutoff, "TPRO");
            ArrayList<Integer> forB = PDB_parser.writePDBHalf(strB, false, cutoff, "TPRO");
            double TP = forA.get(0) + forB.get(0);
            double FP = forA.get(1) + forB.get(1);
            double FN = forA.get(3) + forB.get(3);
            double precision = TP / (FP + TP);
            double recall = TP / (TP + FN);
            results.put(cutoff, new ArrayList());
            results.get(cutoff).add(precision);
            results.get(cutoff).add(recall);
            cutoff += 0.1;
        }
        return results;
    }

    public static HashMap<Double, ArrayList<Double>> DockGroundAnalysisRealComplementarity(String rep1, String rep2, String pdb_file1, String pdb_file2, String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method, boolean constrain_msa, String psa_file_1, String psa_file_2) {
        HashMap<Double, ArrayList<Double>> results = new HashMap<Double, ArrayList<Double>>();
        MSA msa = null;
        Residue_type[] first = PDB_parser.getSeqFromPDB("/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//dockground_raw_proc/" + pdb_file1, 'A');
        Residue_type[] second = PDB_parser.getSeqFromPDB("/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//dockground_raw_proc/" + pdb_file2, 'A');
        SequencePair sp = new SequencePair(first, second, 0);
        ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
        sp_arr.add(sp);
        msa = new MSA(sp_arr);
        ArrayList<Integer> roi = new ArrayList<Integer>();
        int inter = 0;
        while (inter < 9999) {
            roi.add(inter);
            ++inter;
        }
        System.out.println("Creating structure from file: " + pdb_file1);
        SC_Structure strA = Main_outer.structureAndMSA("/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//dockground_raw_proc/" + pdb_file1, msa, -1, true, roi, 'A', userdir, use_full_alignment, false, psa_file_1);
        System.out.println("Creating structure from file: " + pdb_file2);
        SC_Structure strB = Main_outer.structureAndMSA("/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//dockground_raw_proc/" + pdb_file2, msa, -1, false, roi, 'A', userdir, use_full_alignment, false, psa_file_2);
        Main_inter mi = new Main_inter(msa, strA, strB);
        double max1 = iPatchLite.annotateContactReal(rep1, strA);
        double max2 = iPatchLite.annotateContactReal(rep2, strB);
        double max = max1 > max2 ? max1 : max2;
        iPatchLite.orderScores(strA);
        iPatchLite.orderScores(strB);
        double cutoff = 0.0;
        while (cutoff < 100.0) {
            ArrayList<Integer> forA = PDB_parser.writePDBHalf(strA, true, cutoff, "TPRO");
            ArrayList<Integer> forB = PDB_parser.writePDBHalf(strB, false, cutoff, "TPRO");
            double TP = forA.get(0) + forB.get(0);
            double FP = forA.get(1) + forB.get(1);
            double FN = forA.get(3) + forB.get(3);
            double precision = TP / (FP + TP);
            double recall = TP / (TP + FN);
            results.put(cutoff, new ArrayList());
            results.get(cutoff).add(precision);
            results.get(cutoff).add(recall);
            cutoff += 1.0;
        }
        return results;
    }

    public static void orderScores(SC_Structure str) {
        int i2;
        TreeSet<Double> sorted = new TreeSet<Double>();
        HashMap<Double, Integer> ordinals = new HashMap<Double, Integer>();
        for (int i2 : str.residues.keySet()) {
            double rand = Math.random() / 100000.0;
            str.residues.get(i2).setTPro(str.residues.get(i2).getTPro() + rand);
            ordinals.put(str.residues.get(i2).getTPro() + rand, i2);
            sorted.add(str.residues.get(i2).getTPro() + rand);
        }
        i2 = 0;
        Iterator iterator = sorted.descendingSet().iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            str.residues.get(ordinals.get((Object)Double.valueOf((double)d))).tempTPRO = ++i2;
        }
    }

    public static HashMap<Double, ArrayList<Double>> DockGroundAnalysis(String pdb_file1, String pdb_file2, String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method, boolean constrain_msa, String psa_file_1, String psa_file_2) {
        HashMap<Double, ArrayList<Double>> results = new HashMap<Double, ArrayList<Double>>();
        MSA msa = null;
        Residue_type[] first = PDB_parser.getSeqFromPDB("/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//dockground_models_proc/" + pdb_file1, 'A');
        Residue_type[] second = PDB_parser.getSeqFromPDB("/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//dockground_models_proc/" + pdb_file2, 'A');
        SequencePair sp = new SequencePair(first, second, 0);
        ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
        sp_arr.add(sp);
        msa = new MSA(sp_arr);
        ArrayList<Integer> roi = new ArrayList<Integer>();
        int inter = 0;
        while (inter < 9999) {
            roi.add(inter);
            ++inter;
        }
        System.out.println("Creating structure from file: " + pdb_file1);
        SC_Structure strA = Main_outer.structureAndMSA("/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//dockground_models_proc/" + pdb_file1, msa, -1, true, roi, 'A', userdir, use_full_alignment, false, psa_file_1);
        System.out.println("Creating structure from file: " + pdb_file2);
        SC_Structure strB = Main_outer.structureAndMSA("/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//dockground_models_proc/" + pdb_file2, msa, -1, false, roi, 'A', userdir, use_full_alignment, false, psa_file_2);
        Main_inter mi = new Main_inter(msa, strA, strB);
        double max1 = iPatchLite.annotateContact(pdb_file1, strA);
        double max2 = iPatchLite.annotateContact(pdb_file2, strB);
        double max = max1 > max2 ? max1 : max2;
        iPatchLite.orderScores(strA);
        iPatchLite.orderScores(strB);
        double cutoff = 0.0;
        while (cutoff < 100.0) {
            cutoff = (double)Math.round(cutoff * 10.0) / 10.0;
            ArrayList<Integer> forA = PDB_parser.writePDBHalf(strA, true, cutoff, "TPRO");
            ArrayList<Integer> forB = PDB_parser.writePDBHalf(strB, false, cutoff, "TPRO");
            double TP = forA.get(0) + forB.get(0);
            double FP = forA.get(1) + forB.get(1);
            double FN = forA.get(3) + forB.get(3);
            double precision = TP / (FP + TP);
            double recall = TP / (TP + FN);
            results.put(cutoff, new ArrayList());
            results.get(cutoff).add(precision);
            results.get(cutoff).add(recall);
            cutoff += 1.0;
        }
        return results;
    }

    public static void WriteResultScore(SC_Structure str, String save_file) {
        String lines = "";
        for (Integer i : str.residues.keySet()) {
            lines = String.valueOf(lines) + i + "\t" + str.residues.get(i).getTPro() + " " + "\n";
        }
        FileSystemTools.writeFile(save_file, lines);
    }

    public static ArrayList<Integer> HalveStructure(SC_Structure str) {
        ArrayList<Integer> consider = new ArrayList<Integer>();
        double cons = 0.0;
        double nons = 0.0;
        for (Integer si : str.residues.keySet()) {
            if (str.residues.get((Object)si).isContact) {
                cons += 1.0;
                continue;
            }
            nons += 1.0;
        }
        Random r = new Random();
        double ratio = cons / nons;
        nons = 0.0;
        for (Integer si : str.residues.keySet()) {
            if (str.residues.get((Object)si).isContact || !(ratio > r.nextDouble())) continue;
            consider.add(si);
            nons += 1.0;
        }
        return consider;
    }

    public static double annotateContactReal(String pdb, SC_Structure str) {
        String filename = "/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//contacts_models/" + pdb;
        ArrayList<String> data = FileSystemTools.readFile(filename);
        for (String line : data) {
            int id = Integer.parseInt(FileSystemTools.getColumnTab(line, 2));
            boolean contact = FileSystemTools.getColumnTab(line, 4).equals("T");
            if (!contact || str.residues.get(id) == null) continue;
            str.residues.get((Object)Integer.valueOf((int)id)).isContact = true;
        }
        double max = 0.0;
        for (Integer i : str.residues.keySet()) {
            double tpro = str.residues.get(i).getTPro();
            if (!(tpro > max)) continue;
            max = tpro;
        }
        return max;
    }

    public static double annotateContact(String pdb, SC_Structure str) {
        String filename = "/Users/bielasek/Sites/Dropbox/workspace/I-Patch/Tests/Transfer50//contacts_models/" + pdb;
        ArrayList<String> data = FileSystemTools.readFile(filename);
        for (String line : data) {
            int id = Integer.parseInt(FileSystemTools.getColumnTab(line, 3));
            boolean contact = FileSystemTools.getColumnTab(line, 4).equals("T");
            if (!contact || str.residues.get(id) == null) continue;
            str.residues.get((Object)Integer.valueOf((int)id)).isContact = true;
        }
        double max = 0.0;
        for (Integer i : str.residues.keySet()) {
            double tpro = str.residues.get(i).getTPro();
            if (!(tpro > max)) continue;
            max = tpro;
        }
        return max;
    }

    public static SC_Structure calculateNeighborsAWrite(SC_Structure s1, SC_Structure s2) {
        HashMap<Integer, Residue> residues_s1 = s1.residues;
        HashMap<Integer, Residue> residues_s2 = s2.residues;
        int all_count = 0;
        for (Integer i : residues_s1.keySet()) {
            s1.residues.get((Object)i).isContact = false;
            for (Integer j : residues_s2.keySet()) {
                if (!(residues_s2.get(j).distanceFrom(residues_s1.get(i)) < 5.0)) continue;
                s1.residues.get((Object)i).isContact = true;
                if (i == s1.residues.get((Object)i).site) continue;
                System.err.println("unequal");
                System.exit(0);
            }
            if (!s1.residues.get((Object)i).isContact) continue;
            ++all_count;
        }
        System.out.println("Found " + all_count + " contact residues on AB");
        return s1;
    }

    public static SC_Structure calculateNeighborsBWrite(SC_Structure s1, SC_Structure s2) {
        HashMap<Integer, Residue> residues_s1 = s1.residues;
        HashMap<Integer, Residue> residues_s2 = s2.residues;
        int all_count = 0;
        for (Integer i : residues_s2.keySet()) {
            s2.residues.get((Object)i).isContact = false;
            for (Integer j : residues_s1.keySet()) {
                if (!(residues_s1.get(j).distanceFrom(residues_s2.get(i)) < 5.0)) continue;
                s2.residues.get((Object)i).isContact = true;
                if (i == s2.residues.get((Object)i).site) continue;
                System.err.println("unequal");
                System.exit(0);
            }
            if (!s2.residues.get((Object)i).isContact) continue;
            ++all_count;
        }
        System.out.println("Found " + all_count + " contact residues on AG");
        return s2;
    }

    public static ArrayList<String> calculateSeqDist(HashMap<Integer, Residue> residues, HashMap<Integer, Boolean> surf) {
        ArrayList<Integer> dups = new ArrayList<Integer>();
        ArrayList<String> output = new ArrayList<String>();
        for (Integer i : residues.keySet()) {
            if (!surf.get(i).booleanValue()) continue;
            Residue r = residues.get(i);
            dups.add(i);
            for (Integer j : residues.keySet()) {
                if (!surf.get(j).booleanValue() || dups.contains(j)) continue;
                Residue r2 = residues.get(j);
                double dist_heavy = r.distanceFrom(r2);
                double dist_ca = r.distanceFromCA(r2);
                int dist_seq = Math.abs(i - j);
                output.add(String.valueOf(dist_seq) + " " + dist_heavy + " " + dist_ca);
            }
        }
        return output;
    }

    public static void checkDistances() {
        String db = "/Users/bielasek/Sites/Dropbox/workspace/I-Patch/protein_database/complex_pairs";
        String propensiti = "/Users/bielasek/Sites/Dropbox/workspace/I-Patch/protein_database/propensity";
        ArrayList<String> files = FileSystemTools.getFiles(db);
        HashMap pdbs = new HashMap();
        for (String file : files) {
            if (file.contains("1OLZ") || file.contains("1ITB") || file.contains("3F1L") || file.contains("3F1P") || file.contains("1N4W") || file.contains("temp") || file.contains("3CT6") || file.contains("1LQT") || file.contains("1LS1") || file.contains("2ZCG") || file.contains("1KYF") || file.contains("1C5M") || file.contains("1SH5") || file.contains("1OSJ") || file.contains("_AB_") || file.contains(".DS_")) continue;
            String pdb = file.substring(0, 4);
            if (!pdbs.containsKey(pdb)) {
                pdbs.put(pdb, new ArrayList());
            }
            ((ArrayList)pdbs.get(pdb)).add(file);
        }
        double[][] props = new double[20][20];
        double[][] props_non = new double[20][20];
        int prog = 0;
        for (String pdb : pdbs.keySet()) {
            ArrayList<String> to_write = new ArrayList<String>();
            System.out.println(String.valueOf(prog) + " " + pdbs.size());
            ++prog;
            System.out.println(pdb);
            String pdb1 = (String)((ArrayList)pdbs.get(pdb)).get(0);
            String pdb2 = (String)((ArrayList)pdbs.get(pdb)).get(1);
            System.out.println(String.valueOf(pdb1) + " : " + pdb2);
            HashMap<Integer, Boolean> surf1 = PSA.runPSA(7.0, String.valueOf(db) + "/" + pdb1);
            HashMap<Integer, Boolean> surf2 = PSA.runPSA(7.0, String.valueOf(db) + "/" + pdb2);
            HashMap<Integer, Residue> map1 = PDB_parser.parse(String.valueOf(db) + "/" + pdb1);
            HashMap<Integer, Residue> map2 = PDB_parser.parse(String.valueOf(db) + "/" + pdb2);
            ArrayList<String> out1 = iPatchLite.calculateSeqDist(map1, surf1);
            ArrayList<String> out2 = iPatchLite.calculateSeqDist(map2, surf2);
            to_write.addAll(out1);
            to_write.addAll(out2);
            FileSystemTools.append(String.valueOf(userdir) + "/dist_stats/dist_stats" + pdb + ".txt", to_write);
        }
    }

    public static void getPropensity() {
        String db = "/Users/bielasek/Sites/Dropbox/workspace/I-Patch/protein_database/complex_pairs";
        String propensiti = "/Users/bielasek/Sites/Dropbox/workspace/I-Patch/protein_database/propensity";
        ArrayList<String> files = FileSystemTools.getFiles(db);
        HashMap pdbs = new HashMap();
        for (String file : files) {
            if (file.contains("1ITB") || file.contains("3F1L") || file.contains("3F1P") || file.contains("1N4W") || file.contains("temp") || file.contains("3CT6") || file.contains("1LQT") || file.contains("1LS1") || file.contains("2ZCG") || file.contains("1KYF") || file.contains("1C5M") || file.contains("1SH5") || file.contains("1OSJ") || file.contains("_AB_") || file.contains(".DS_")) continue;
            String pdb = file.substring(0, 4);
            if (!pdbs.containsKey(pdb)) {
                pdbs.put(pdb, new ArrayList());
            }
            ((ArrayList)pdbs.get(pdb)).add(file);
        }
        double[][] props = new double[20][20];
        double[][] props_non = new double[20][20];
        int prog = 0;
        for (String pdb : pdbs.keySet()) {
            System.out.println(String.valueOf(prog) + " " + pdbs.size());
            ++prog;
            System.out.println(pdb);
            String pdb1 = (String)((ArrayList)pdbs.get(pdb)).get(0);
            String pdb2 = (String)((ArrayList)pdbs.get(pdb)).get(1);
            System.out.println(String.valueOf(pdb1) + " : " + pdb2);
            HashMap<Integer, Boolean> surf1 = PSA.runPSA(7.0, String.valueOf(db) + "/" + pdb1);
            HashMap<Integer, Boolean> surf2 = PSA.runPSA(7.0, String.valueOf(db) + "/" + pdb2);
            HashMap<Integer, Residue> map1 = PDB_parser.parse(String.valueOf(db) + "/" + pdb1);
            HashMap<Integer, Residue> map2 = PDB_parser.parse(String.valueOf(db) + "/" + pdb2);
            System.out.println("Size " + map1.size());
            System.out.println("Size " + map2.size());
            for (Integer i : map1.keySet()) {
                if (!surf1.get(i).booleanValue() || map1.get((Object)i).type == Residue_type.gap) continue;
                for (Integer j : map2.keySet()) {
                    if (!surf2.get(j).booleanValue() || map2.get((Object)j).type == Residue_type.gap) continue;
                    if (map1.get(i).distanceFrom(map2.get(j)) < 4.5) {
                        double[] dArray = props[map1.get((Object)i).type.ordinal()];
                        int n = map2.get((Object)j).type.ordinal();
                        dArray[n] = dArray[n] + 1.0;
                        continue;
                    }
                    double[] dArray = props_non[map1.get((Object)i).type.ordinal()];
                    int n = map2.get((Object)j).type.ordinal();
                    dArray[n] = dArray[n] + 1.0;
                }
            }
            MathFunctions.printParsable2DDouble(props, String.valueOf(propensiti) + "/cons.txt");
            MathFunctions.printParsable2DDouble(props_non, String.valueOf(propensiti) + "/nons.txt");
        }
        MathFunctions.print2DAAArray(props);
    }

    public class DockGroundStruc {
        private String pdb;
        private HashMap<Integer, String> p1 = new HashMap();
        private HashMap<Integer, String> p2 = new HashMap();

        public DockGroundStruc(String line) {
            this.pdb = FileSystemTools.getColumnTab(line, 1);
            char chain_1 = '-';
            int i = 2;
            while (i < 14) {
                String filename = FileSystemTools.getColumnTab(line, i);
                char chain = filename.charAt(5);
                if (chain_1 == '-') {
                    chain_1 = chain;
                }
                if (chain_1 == chain) {
                    this.p1.put(this.getCategory(filename), filename);
                } else {
                    this.p2.put(this.getCategory(filename), filename);
                }
                ++i;
            }
        }

        public ArrayList<String> getComplex(int a, int b) {
            ArrayList<String> results = new ArrayList<String>();
            results.add(this.p1.get(a));
            results.add(this.p2.get(b));
            return results;
        }

        public int getCategory(String filename) {
            if (filename.contains("_1A_")) {
                return 1;
            }
            if (filename.contains("_2A_")) {
                return 2;
            }
            if (filename.contains("_3A_")) {
                return 3;
            }
            if (filename.contains("_4A_")) {
                return 4;
            }
            if (filename.contains("_5A_")) {
                return 5;
            }
            if (filename.contains("_6A_")) {
                return 6;
            }
            System.out.println("Fuckup at the rmsd classification level " + filename);
            System.exit(0);
            return -1;
        }
    }
}

