/*
 * Decompiled with CFR 0.152.
 */
package analysis;

import Abnum.Abnum;
import data_structures.Atom;
import data_structures.Residue;
import data_structures.SC_Structure;
import java.util.ArrayList;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class Normalizer {
    public static void main(String[] args) {
        String abfile = args[0];
        String output_file = args[1];
        char Hchain = 'H';
        char Lchain = 'L';
        Normalizer.normalizeCDR(abfile, Hchain, Lchain, output_file);
    }

    public static void normalize(String abfile, char Hchain, char Lchain, String output_file) {
        String pdb_line;
        double new_bf;
        String str_bf;
        Residue r;
        PDB_parser.Chothia ab_H = new PDB_parser.Chothia(abfile, Hchain);
        PDB_parser.Chothia ab_L = new PDB_parser.Chothia(abfile, Lchain);
        ArrayList<String> output = new ArrayList<String>();
        double max = -1.0;
        for (String s : ab_H.residues.keySet()) {
            r = ab_H.residues.get(s);
            if (!(max < r.getBFactor())) continue;
            max = r.getBFactor();
        }
        for (String s : ab_L.residues.keySet()) {
            r = ab_L.residues.get(s);
            if (!(max < r.getBFactor())) continue;
            max = r.getBFactor();
        }
        for (Integer i : ab_H.ordinals) {
            r = ab_H.residues.get(ab_H.ordinals_map.get(i));
            for (Atom a : r.atoms) {
                str_bf = String.valueOf((int)(r.getBFactor() / max * 100.0));
                new_bf = Double.parseDouble(str_bf);
                pdb_line = SC_Structure.colorBFactor(a.pdb_line, String.valueOf(new_bf) + "0");
                output.add(pdb_line);
            }
        }
        for (Integer i : ab_L.ordinals) {
            r = ab_L.residues.get(ab_L.ordinals_map.get(i));
            for (Atom a : r.atoms) {
                str_bf = String.valueOf((int)(r.getBFactor() / max * 100.0));
                new_bf = Double.parseDouble(str_bf);
                pdb_line = SC_Structure.colorBFactor(a.pdb_line, String.valueOf(new_bf) + "0");
                output.add(pdb_line);
            }
        }
        FileSystemTools.writeFile(output_file, output);
    }

    public static void normalizeCDR(String abfile, char Hchain, char Lchain, String output_file) {
        String pdb_line;
        double new_bf;
        String str_bf;
        Residue r;
        String id;
        Residue r2;
        PDB_parser.Chothia ab_H = new PDB_parser.Chothia(abfile, Hchain);
        PDB_parser.Chothia ab_L = new PDB_parser.Chothia(abfile, Lchain);
        ArrayList<String> output = new ArrayList<String>();
        double max = -1.0;
        for (String s : ab_H.residues.keySet()) {
            r2 = ab_H.residues.get(s);
            if (!Abnum.isExtCDR(String.valueOf('H') + s) || !(max < r2.getBFactor())) continue;
            max = r2.getBFactor();
        }
        for (String s : ab_L.residues.keySet()) {
            r2 = ab_L.residues.get(s);
            if (!Abnum.isExtCDR(String.valueOf('L') + s) || !(max < r2.getBFactor())) continue;
            max = r2.getBFactor();
        }
        for (Integer i : ab_H.ordinals) {
            id = ab_H.ordinals_map.get(i);
            r = ab_H.residues.get(ab_H.ordinals_map.get(i));
            for (Atom a : r.atoms) {
                str_bf = String.valueOf((int)(r.getBFactor() / max * 100.0));
                new_bf = Double.parseDouble(str_bf);
                if (!Abnum.isExtCDR(String.valueOf('H') + id)) {
                    new_bf = 0.0;
                }
                pdb_line = SC_Structure.colorBFactor(a.pdb_line, String.valueOf(new_bf) + "0");
                output.add(pdb_line);
            }
        }
        for (Integer i : ab_L.ordinals) {
            id = ab_L.ordinals_map.get(i);
            r = ab_L.residues.get(ab_L.ordinals_map.get(i));
            for (Atom a : r.atoms) {
                str_bf = String.valueOf((int)(r.getBFactor() / max * 100.0));
                new_bf = Double.parseDouble(str_bf);
                if (!Abnum.isExtCDR(String.valueOf('L') + id)) {
                    new_bf = 0.0;
                }
                pdb_line = SC_Structure.colorBFactor(a.pdb_line, String.valueOf(new_bf) + "0");
                output.add(pdb_line);
            }
        }
        FileSystemTools.writeFile(output_file, output);
    }
}

