/*
 * Decompiled with CFR 0.152.
 */
package energy;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class RossAlgorithm {
    public static String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(String.valueOf(userdir) + "/result_dump/Ross/data.txt");
            out = new BufferedWriter(fstream);
            int n = 100;
            int iterations = 1000;
            ArrayList<Double> sorts = new ArrayList<Double>();
            ArrayList<Double> randoms = new ArrayList<Double>();
            ArrayList<Double> better = new ArrayList<Double>();
            ArrayList<Double> probabilities = new ArrayList<Double>();
            double probability = 0.05;
            while (probability < 0.95) {
                System.out.println((probability += 0.01) / 0.95);
                int diff = 0;
                double noises = 0.0;
                double sorties = 0.0;
                int z = 0;
                while (z < iterations) {
                    System.out.println(String.valueOf(probability) + " " + z);
                    ArrayList<Integer> permuted = RossAlgorithm.permute(n);
                    int[][] order = RossAlgorithm.createOrderMatrix(n, permuted);
                    int[][] noisy = RossAlgorithm.introduceNoise(order, probability);
                    int[][] result = RossAlgorithm.getOrderFromMatrix(noisy);
                    double sort_res = RossAlgorithm.calculateHowManyRight(result, order);
                    double noise_res = RossAlgorithm.calculateHowManyRight(noisy, order);
                    sorties += sort_res;
                    noises += noise_res;
                    if (sort_res > noise_res) {
                        ++diff;
                    }
                    ++z;
                }
                sorts.add(sorties / (double)iterations);
                randoms.add(noises / (double)iterations);
                better.add((double)diff / (double)iterations);
                probabilities.add(probability);
            }
            String data = "";
            int i = 0;
            while (i < better.size()) {
                out.write(probabilities.get(i) + " " + sorts.get(i) + " " + randoms.get(i) + " " + better.get(i) + "\n");
                ++i;
            }
            out.flush();
            fstream.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static int[][] getOrderFromMatrix(int[][] order) {
        int n = order.length;
        int[][] result = new int[n][n];
        HashMap map = new HashMap();
        int i = 0;
        while (i < n) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            int j = 0;
            while (j < n) {
                if (order[i][j] == 1) {
                    list.add(j);
                }
                ++j;
            }
            map.put(i, list);
            ++i;
        }
        i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                if (i != j) {
                    int z = 0;
                    while (z < n) {
                        ArrayList list = (ArrayList)map.get(z);
                        if (list.contains(i) && !list.contains(j)) {
                            int[] nArray = result[i];
                            int n2 = j;
                            nArray[n2] = nArray[n2] + 1;
                        }
                        if (!list.contains(i) && list.contains(j)) {
                            int[] nArray = result[i];
                            int n3 = j;
                            nArray[n3] = nArray[n3] - 1;
                        }
                        ++z;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                result[i][j] = result[i][j] > 0 ? 0 : 1;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double calculateHowManyRight(int[][] pred, int[][] right) {
        int got_right = 0;
        int i = 0;
        while (i < right.length) {
            int j = 0;
            while (j < right.length) {
                if (i != j && pred[i][j] == right[i][j]) {
                    ++got_right;
                }
                ++j;
            }
            ++i;
        }
        return (double)got_right / (double)(right.length * right.length - right.length);
    }

    public static int[][] introduceNoise(int[][] order, double prob) {
        int[][] result = new int[order.length][order.length];
        Random r = new Random();
        int i = 0;
        while (i < order.length) {
            int j = 0;
            while (j < order.length) {
                if (r.nextDouble() < prob) {
                    result[i][j] = order[i][j] == 1 ? 0 : 1;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static int[][] createOrderMatrix(int n, ArrayList<Integer> list) {
        int[][] order = new int[n][n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                order[i][j] = list.get(i) > list.get(j) ? 1 : 0;
                ++j;
            }
            ++i;
        }
        return order;
    }

    public static ArrayList<Integer> permute(int n) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < n) {
            list.add(i);
            ++i;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        Random r = new Random();
        while (list.size() > 0) {
            int chosen = r.nextInt(list.size());
            result.add((Integer)list.remove(chosen));
        }
        return result;
    }
}

