/*
 * Decompiled with CFR 0.152.
 */
package statspot;

import data_structures.Atom;
import data_structures.Residue;
import data_structures.Residue_type;
import docking_global.DockingDistances;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import parsing.PSA;
import utils.FileSystemTools;

public class DataCollector {
    public static void main(String[] args) {
        String name = args[0];
        String abfile = FileSystemTools.get_full_path(args[1]);
        String agfile = FileSystemTools.get_full_path(args[2]);
        String folder_res = FileSystemTools.get_full_path(args[3]);
        new File(String.valueOf(folder_res) + "/residue_pairs").mkdirs();
        String folder_atom = String.valueOf(folder_res) + "/residue_pairs";
        String out_file_a = String.valueOf(folder_res) + "/" + name + "_a.txt";
        String out_file_r = String.valueOf(folder_res) + "/" + name + "_r.txt";
        String out_file_cons = String.valueOf(folder_res) + "/" + name + "_cons.txt";
        String out_file_nons = String.valueOf(folder_res) + "/" + name + "_nons.txt";
        String out_file_cons_ab = String.valueOf(folder_res) + "/" + name + "_cons_ab.txt";
        String out_file_nons_ab = String.valueOf(folder_res) + "/" + name + "_nons_ab.txt";
        String out_file_cons_ag = String.valueOf(folder_res) + "/" + name + "_cons_ag.txt";
        String out_file_nons_ag = String.valueOf(folder_res) + "/" + name + "_nons_ag.txt";
        String psa_AB = args[4];
        String psa_AG = args[5];
        HashMap<Integer, Boolean> ab_surf = PSA.readPSAFile(psa_AB, 7.5);
        HashMap<Integer, Boolean> ag_surf = PSA.readPSAFile(psa_AG, 7.5);
        HashMap<Integer, Residue> abstr = PDB_parser.parse(abfile, 'A');
        HashMap<Integer, Residue> agstr = PDB_parser.parse(agfile, 'B');
        double[][] cons = new double[20][20];
        double[][] nons = new double[20][20];
        double[] ab_cons = new double[20];
        double[] ab_nons = new double[20];
        double[] ag_cons = new double[20];
        double[] ag_nons = new double[20];
        DockingDistances.extractConsSurf(abstr, agstr, ab_surf, ag_surf);
        for (Integer abi : abstr.keySet()) {
            if (!ab_surf.get(abi).booleanValue()) continue;
            Residue abr = abstr.get(abi);
            if (abr.isContact) {
                int n = abr.type.ordinal();
                ab_cons[n] = ab_cons[n] + 1.0;
                continue;
            }
            int n = abr.type.ordinal();
            ab_nons[n] = ab_nons[n] + 1.0;
        }
        for (Integer agi : agstr.keySet()) {
            if (!ag_surf.get(agi).booleanValue()) continue;
            Residue agr = agstr.get(agi);
            if (agr.isContact) {
                int n = agr.type.ordinal();
                ag_cons[n] = ag_cons[n] + 1.0;
                continue;
            }
            int n = agr.type.ordinal();
            ag_nons[n] = ag_nons[n] + 1.0;
        }
        ArrayList<String> r_out = new ArrayList<String>();
        ArrayList<String> a_out = new ArrayList<String>();
        for (Integer abi : abstr.keySet()) {
            if (!ab_surf.get(abi).booleanValue()) continue;
            Residue abr = abstr.get(abi);
            for (Integer agi : agstr.keySet()) {
                if (!ag_surf.get(agi).booleanValue()) continue;
                Residue agr = agstr.get(agi);
                if (abr.distanceFrom(agr) < 9000.0) {
                    Object pdb_line;
                    r_out.add((Object)((Object)abr.type) + "\t" + (Object)((Object)agr.type) + "\t" + abi + "\t" + agi + "\t" + abr.distanceFrom(agr));
                    ArrayList<String> residue = new ArrayList<String>();
                    for (Atom atom : abr.atoms) {
                        pdb_line = PDB_parser.renumber_line(atom.pdb_line, 1);
                        pdb_line = PDB_parser.renameChain((String)pdb_line, 'A');
                        residue.add((String)pdb_line);
                    }
                    for (Atom atom : agr.atoms) {
                        pdb_line = PDB_parser.renumber_line(atom.pdb_line, 2);
                        pdb_line = PDB_parser.renameChain((String)pdb_line, 'A');
                        residue.add((String)pdb_line);
                    }
                    if (abr.distanceFrom(agr) < 10.0) {
                        FileSystemTools.writeFile(String.valueOf(folder_atom) + "/" + name + "_" + (Object)((Object)abr.type) + "_" + (Object)((Object)agr.type) + "_" + abi + "_" + agi + ".pdb", residue);
                    }
                    if (abr.distanceFrom(agr) < 5.0) {
                        double[] dArray = cons[abr.type.ordinal()];
                        int n = agr.type.ordinal();
                        dArray[n] = dArray[n] + 1.0;
                    } else {
                        double[] dArray = nons[abr.type.ordinal()];
                        int n = agr.type.ordinal();
                        dArray[n] = dArray[n] + 1.0;
                    }
                }
                for (Atom ab_a : abr.atoms) {
                    for (Atom ag_a : agr.atoms) {
                        if (!(ab_a.distanceFrom(ag_a) < 10.0)) continue;
                        a_out.add(String.valueOf(ab_a.atom_name) + "\t" + ag_a.atom_name + "\t" + abi + "\t" + agi + "\t" + ab_a.distanceFrom(ag_a) + "\t" + ab_a.get_coords() + "\t" + ag_a.get_coords());
                    }
                }
            }
        }
        ArrayList<String> out_cons = new ArrayList<String>();
        ArrayList<String> out_nons = new ArrayList<String>();
        ArrayList<String> out_ab_cons = new ArrayList<String>();
        ArrayList<String> out_ab_nons = new ArrayList<String>();
        ArrayList<String> out_ag_cons = new ArrayList<String>();
        ArrayList<String> out_ag_nons = new ArrayList<String>();
        int i = 0;
        while (i < 20) {
            String string = (Object)((Object)Residue_type.values()[i]) + "\t" + ab_cons[i];
            out_ab_cons.add(string);
            String string2 = (Object)((Object)Residue_type.values()[i]) + "\t" + ab_nons[i];
            out_ab_nons.add(string2);
            String string3 = (Object)((Object)Residue_type.values()[i]) + "\t" + ag_cons[i];
            out_ag_cons.add(string3);
            String string4 = (Object)((Object)Residue_type.values()[i]) + "\t" + ag_nons[i];
            out_ag_nons.add(string4);
            int j = 0;
            while (j < 20) {
                String line_c = (Object)((Object)Residue_type.values()[i]) + "\t" + (Object)((Object)Residue_type.values()[j]) + "\t" + cons[i][j];
                String line_n = (Object)((Object)Residue_type.values()[i]) + "\t" + (Object)((Object)Residue_type.values()[j]) + "\t" + nons[i][j];
                out_cons.add(line_c);
                out_nons.add(line_n);
                ++j;
            }
            ++i;
        }
        FileSystemTools.writeFile(out_file_cons_ab, out_ab_cons);
        FileSystemTools.writeFile(out_file_nons_ab, out_ab_nons);
        FileSystemTools.writeFile(out_file_cons_ag, out_ag_cons);
        FileSystemTools.writeFile(out_file_nons_ag, out_ag_nons);
        FileSystemTools.writeFile(out_file_cons, out_cons);
        FileSystemTools.writeFile(out_file_nons, out_nons);
        FileSystemTools.writeFile(out_file_a, a_out);
        FileSystemTools.writeFile(out_file_r, r_out);
    }
}

