/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

public class FileSystemTools {
    public static void main(String[] args) {
        String dir = String.valueOf(System.getProperty("user.dir")) + '/';
        String filename = "/fs_test.txt";
        System.out.println(FileSystemTools.join_path(dir, filename));
    }

    public static String get_full_path(String f_name) {
        File f = new File(f_name);
        if (!f.exists()) {
            String cwd = System.getProperty("user.dir");
            return FileSystemTools.join_path(cwd, f_name);
        }
        return f_name;
    }

    public static String join_path(String f1, String f2) {
        if (f1.charAt(f1.length() - 1) == '/') {
            f1 = f1.substring(0, f1.length() - 1);
        }
        if (f2.charAt(0) == '/') {
            f2 = f2.substring(1, f2.length());
        }
        return String.valueOf(f1) + '/' + f2;
    }

    public static String getColumnTab(String line, int n) {
        if (n < 1) {
            System.err.println("getColumn: Incorrect n supplied: " + n);
            System.exit(0);
        }
        if (line.replace(" ", "").length() == 0) {
            System.err.println("getColumn: Line supplied is empty: ");
            System.exit(0);
        }
        String line_temp = line;
        int n_temp = n;
        String curr_col = "";
        int space = -2;
        while (n_temp > 0) {
            if (space == -1) {
                System.err.println("getColumn: Column index too high: " + n);
                System.exit(0);
            }
            if ((space = line_temp.indexOf("\t")) == -1) {
                curr_col = line_temp;
            } else {
                curr_col = line_temp.substring(0, space);
                line_temp = line_temp.substring(space + 1);
            }
            --n_temp;
        }
        return curr_col;
    }

    public static String getColumn(String line, int n) {
        if (n < 1) {
            System.err.println("getColumn: Incorrect n supplied: " + n);
            System.exit(0);
        }
        if (line.replace(" ", "").length() == 0) {
            System.err.println("getColumn: Line supplied is empty: ");
            System.exit(0);
        }
        String line_temp = line;
        int n_temp = n;
        String curr_col = "";
        int space = -2;
        while (n_temp > 0) {
            if (space == -1) {
                System.err.println("getColumn: Column index too high: " + n);
                System.exit(0);
            }
            if ((space = line_temp.indexOf(" ")) == -1) {
                curr_col = line_temp;
            } else {
                curr_col = line_temp.substring(0, space);
                line_temp = line_temp.substring(space + 1);
            }
            --n_temp;
        }
        return curr_col;
    }

    public static void CopyFile(String src, String out_file) {
        ArrayList<String> lines = FileSystemTools.readFile(src);
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(out_file);
            out = new BufferedWriter(fstream);
            int i = 0;
            while (i < lines.size()) {
                out.write(String.valueOf(lines.get(i)) + "\n");
                ++i;
            }
            out.flush();
            fstream.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static ArrayList<String> getFullFiles(String input_folder) {
        System.out.println("Extracting file list from " + input_folder);
        File folder = new File(input_folder);
        File[] listOfFiles = folder.listFiles();
        ArrayList<String> out_files = new ArrayList<String>();
        int i = 0;
        while (i < listOfFiles.length) {
            if (listOfFiles[i].isFile()) {
                String files = listOfFiles[i].getName();
                out_files.add(files);
            }
            ++i;
        }
        System.out.println(String.valueOf(out_files.size()) + " elements extracted from " + input_folder);
        return out_files;
    }

    public static ArrayList<String> getFiles(String input_folder) {
        System.out.println("Extracting file list from " + input_folder);
        File folder = new File(input_folder);
        File[] listOfFiles = folder.listFiles();
        ArrayList<String> out_files = new ArrayList<String>();
        int i = 0;
        while (i < listOfFiles.length) {
            if (listOfFiles[i].isFile()) {
                String files = listOfFiles[i].getName();
                out_files.add(files);
                String string = files.substring(0, 4);
            }
            ++i;
        }
        System.out.println(String.valueOf(out_files.size()) + " elements extracted from " + input_folder);
        return out_files;
    }

    public static ArrayList<String> getFolders(String input_folder) {
        System.out.println("Extracting folder list from " + input_folder);
        File folder = new File(input_folder);
        File[] listOfFiles = folder.listFiles();
        ArrayList<String> out_files = new ArrayList<String>();
        int i = 0;
        while (i < listOfFiles.length) {
            if (listOfFiles[i].isDirectory()) {
                String files = listOfFiles[i].getName();
                out_files.add(files);
            }
            ++i;
        }
        return out_files;
    }

    public static void RemoveLine(String filename, int to_remove) {
        try {
            ArrayList<String> lines = FileSystemTools.readFile(filename);
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            int i = 0;
            while (i < lines.size()) {
                if (i != to_remove) {
                    out.write(String.valueOf(lines.get(i)) + "\n");
                    out.flush();
                }
                ++i;
            }
            fstream.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void append(String filename, ArrayList<String> data) {
        ArrayList<String> contents = new File(filename).exists() ? FileSystemTools.readFile(filename) : new ArrayList();
        for (String s : data) {
            contents.add(s);
        }
        FileSystemTools.writeFile(filename, contents);
    }

    public static void append(String filename, String directory, String data) {
        ArrayList<String> contents = new File(String.valueOf(directory) + "/" + filename).exists() ? FileSystemTools.readFile(filename, directory) : new ArrayList();
        String output = "";
        int i = 0;
        while (i < contents.size()) {
            output = String.valueOf(output) + contents.get(i) + "\n";
            ++i;
        }
        output = String.valueOf(output) + data;
        FileSystemTools.writeFile(filename, directory, output);
    }

    public static void writeFile(String filename, String directory, String data) {
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(String.valueOf(directory) + "/" + filename);
            out = new BufferedWriter(fstream);
            out.write(data);
            out.flush();
            fstream.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Problem in FileSystemTools.writeFile()");
            System.err.println(e.getLocalizedMessage());
            System.err.println("Parameters given:");
            System.err.println("Filename: " + filename);
            System.err.println("Directory: " + directory);
            System.err.println("To write: \n" + data);
        }
    }

    public static void writeFile(String filename, String data) {
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(filename);
            out = new BufferedWriter(fstream);
            out.write(data);
            out.flush();
            fstream.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Problem in FileSystemTools.writeFile()");
            System.err.println(e.getLocalizedMessage());
            System.err.println("Parameters given:");
            System.err.println("Filename: " + filename);
            System.err.println("To write: \n" + data);
        }
    }

    public static void writeFile(String filename, ArrayList<String> data) {
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(filename);
            out = new BufferedWriter(fstream);
            int i = 0;
            while (i < data.size()) {
                out.write(String.valueOf(data.get(i)) + "\n");
                ++i;
            }
            out.flush();
            fstream.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Problem in FileSystemTools.writeFile()");
            System.err.println(e.getLocalizedMessage());
            System.err.println("Parameters given:");
            System.err.println("Filename: " + filename);
            System.err.println("To write: \n" + data);
        }
    }

    public static void writeFileInts(String filename, ArrayList<Integer> data) {
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(filename);
            out = new BufferedWriter(fstream);
            int i = 0;
            while (i < data.size()) {
                out.write(data.get(i) + "\n");
                ++i;
            }
            out.flush();
            fstream.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Problem in FileSystemTools.writeFile()");
            System.err.println(e.getLocalizedMessage());
            System.err.println("Parameters given:");
            System.err.println("Filename: " + filename);
            System.err.println("To write: \n" + data);
        }
    }

    public static void writeFileD(String filename, ArrayList<Double> data) {
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(filename);
            out = new BufferedWriter(fstream);
            int i = 0;
            while (i < data.size()) {
                out.write(data.get(i) + "\n");
                ++i;
            }
            out.flush();
            fstream.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Problem in FileSystemTools.writeFile()");
            System.err.println(e.getLocalizedMessage());
            System.err.println("Parameters given:");
            System.err.println("Filename: " + filename);
            System.err.println("To write: \n" + data);
        }
    }

    public static ArrayList<String> readFile(String filename) {
        String s = null;
        ArrayList<String> output = new ArrayList<String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            while ((s = in.readLine()) != null) {
                output.add(s);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("Problem in FileSystemTools.readFile()");
            System.err.println(e.getLocalizedMessage());
            System.err.println("Parameters given:");
            System.err.println("Filename: " + filename);
            e.printStackTrace();
        }
        return output;
    }

    public static ArrayList<String> readFile(String filename, String directory) {
        String s = null;
        ArrayList<String> output = new ArrayList<String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(String.valueOf(directory) + "/" + filename), "UTF-8"));
            while ((s = in.readLine()) != null) {
                output.add(s);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("Problem in FileSystemTools.readFile()");
            System.err.println(e.getLocalizedMessage());
            System.err.println("Parameters given:");
            System.err.println("Filename: " + filename);
            System.err.println("Directory: " + directory);
            e.printStackTrace();
        }
        return output;
    }

    public static ArrayList<String> readFileWith(String filename, String directory, String pattern) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        ArrayList<String> output = new ArrayList<String>();
        try {
            fis = new FileInputStream(String.valueOf(directory) + "/" + filename);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            while ((s = dis.readLine()) != null) {
                if (!s.contains(pattern)) continue;
                output.add(s);
            }
            fis.close();
            bis.close();
            dis.close();
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
        return output;
    }

    public static void SaveObject(String filename, Object object) {
        System.out.println("Saving: " + filename);
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(filename);
            out = new ObjectOutputStream(fos);
            out.writeObject(object);
            out.close();
            fos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static Object LoadObject(String filename) {
        System.out.println("Loading: " + filename);
        Object object = null;
        FileInputStream fis = null;
        ObjectInputStream in = null;
        try {
            fis = new FileInputStream(filename);
            in = new ObjectInputStream(fis);
            object = in.readObject();
            in.close();
            fis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return object;
    }

    public static boolean areEqual(String f1, String f2) {
        ArrayList<String> l1 = FileSystemTools.readFile(f1);
        ArrayList<String> l2 = FileSystemTools.readFile(f2);
        if (l1.size() != l2.size()) {
            return false;
        }
        int i = 0;
        while (i < l1.size()) {
            if (!l1.get(i).equals(l2.get(i))) {
                System.out.println("Unequal: ");
                System.out.println("f1: " + l1.get(i));
                System.out.println("f2: " + l2.get(i));
                return false;
            }
            ++i;
        }
        return true;
    }
}

