/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Tag;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.BeanCustomizer;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.CustomizerClosingListener;
import weka.gui.beans.EnvironmentField;
import weka.gui.beans.SerializedModelSaver;

public class SerializedModelSaverCustomizer
extends JPanel
implements BeanCustomizer,
CustomizerCloseRequester,
CustomizerClosingListener,
EnvironmentHandler {
    private static final long serialVersionUID = -4874208115942078471L;
    private PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private SerializedModelSaver m_smSaver;
    private PropertySheetPanel m_SaverEditor = new PropertySheetPanel();
    private JFileChooser m_fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    private Window m_parentWindow;
    private JDialog m_fileChooserFrame;
    private EnvironmentField m_prefixText;
    private JComboBox m_fileFormatBox;
    private JCheckBox m_relativeFilePath;
    private JCheckBox m_includeRelationName;
    private Environment m_env = Environment.getSystemWide();
    private EnvironmentField m_directoryText;
    private BeanCustomizer.ModifyListener m_modifyListener;
    private String m_prefixBackup;
    private File m_directoryBackup;
    private boolean m_relativeBackup;
    private boolean m_relationBackup;
    private Tag m_formatBackup;

    public SerializedModelSaverCustomizer() {
        this.setLayout(new BorderLayout());
        this.m_fileChooser.setDialogType(1);
        this.m_fileChooser.setFileSelectionMode(1);
        this.m_fileChooser.setApproveButtonText("Select directory and prefix");
        this.m_fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("ApproveSelection")) {
                    try {
                        SerializedModelSaverCustomizer.this.m_smSaver.setPrefix(SerializedModelSaverCustomizer.this.m_prefixText.getText());
                        File selectedFile = SerializedModelSaverCustomizer.this.m_fileChooser.getSelectedFile();
                        SerializedModelSaverCustomizer.this.m_directoryText.setText(selectedFile.toString());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (SerializedModelSaverCustomizer.this.m_parentWindow != null) {
                    SerializedModelSaverCustomizer.this.m_fileChooserFrame.dispose();
                }
            }
        });
    }

    @Override
    public void setParentWindow(Window parent) {
        this.m_parentWindow = parent;
    }

    public void setUpFile() {
        block6: {
            this.removeAll();
            this.m_fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "Directory";
                }
            });
            this.m_fileChooser.setAcceptAllFileFilterUsed(false);
            try {
                if (this.m_smSaver.getDirectory().getPath().equals("")) break block6;
                String dirStr = this.m_smSaver.getDirectory().toString();
                if (Environment.containsEnvVariables(dirStr)) {
                    try {
                        dirStr = this.m_env.substitute(dirStr);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                File tmp = new File(dirStr);
                tmp = new File(tmp.getAbsolutePath());
                this.m_fileChooser.setCurrentDirectory(tmp);
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        JPanel alignedP = new JPanel();
        GridBagLayout gbLayout = new GridBagLayout();
        alignedP.setLayout(gbLayout);
        JLabel prefixLab = new JLabel("Prefix for file name", 4);
        prefixLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(prefixLab, gbConstraints);
        alignedP.add(prefixLab);
        this.m_prefixText = new EnvironmentField();
        this.m_prefixText.setEnvironment(this.m_env);
        this.m_prefixText.setText(this.m_smSaver.getPrefix());
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_prefixText, gbConstraints);
        alignedP.add(this.m_prefixText);
        JLabel ffLab = new JLabel("File format", 4);
        ffLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 1;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(ffLab, gbConstraints);
        alignedP.add(ffLab);
        this.setUpFileFormatComboBox();
        this.m_fileFormatBox.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 1;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_fileFormatBox, gbConstraints);
        alignedP.add(this.m_fileFormatBox);
        JPanel about = this.m_SaverEditor.getAboutPanel();
        if (about != null) {
            innerPanel.add((Component)about, "North");
        }
        this.add((Component)innerPanel, "North");
        JLabel directoryLab = new JLabel("Directory", 4);
        directoryLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 2;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(directoryLab, gbConstraints);
        alignedP.add(directoryLab);
        this.m_directoryText = new EnvironmentField();
        this.m_directoryText.setEnvironment(this.m_env);
        this.m_directoryText.setText(this.m_smSaver.getDirectory().toString());
        JButton browseBut = new JButton("Browse...");
        browseBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JDialog jf = new JDialog((JDialog)SerializedModelSaverCustomizer.this.getTopLevelAncestor(), "Choose directory", true);
                    jf.getContentPane().setLayout(new BorderLayout());
                    jf.getContentPane().add((Component)SerializedModelSaverCustomizer.this.m_fileChooser, "Center");
                    SerializedModelSaverCustomizer.this.m_fileChooserFrame = jf;
                    jf.pack();
                    jf.setVisible(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JPanel efHolder = new JPanel();
        efHolder.setLayout(new BorderLayout());
        JPanel bP = new JPanel();
        bP.setLayout(new BorderLayout());
        bP.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        bP.add((Component)browseBut, "Center");
        efHolder.add((Component)bP, "East");
        efHolder.add((Component)this.m_directoryText, "Center");
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 2;
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 5.0;
        gbLayout.setConstraints(efHolder, gbConstraints);
        alignedP.add(efHolder);
        JLabel relativeLab = new JLabel("Use relative file paths", 4);
        relativeLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 3;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(relativeLab, gbConstraints);
        alignedP.add(relativeLab);
        this.m_relativeFilePath = new JCheckBox();
        this.m_relativeFilePath.setSelected(this.m_smSaver.getUseRelativePath());
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 3;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_relativeFilePath, gbConstraints);
        alignedP.add(this.m_relativeFilePath);
        JLabel relationLab = new JLabel("Include relation name in file name", 4);
        relationLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 4;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(relationLab, gbConstraints);
        alignedP.add(relationLab);
        this.m_includeRelationName = new JCheckBox();
        this.m_includeRelationName.setToolTipText("Include the relation name of the training data used to create the model in the file name.");
        this.m_includeRelationName.setSelected(this.m_smSaver.getIncludeRelationName());
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 4;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_includeRelationName, gbConstraints);
        alignedP.add(this.m_includeRelationName);
        JButton OKBut = new JButton("OK");
        OKBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SerializedModelSaverCustomizer.this.m_smSaver.setPrefix(SerializedModelSaverCustomizer.this.m_prefixText.getText());
                    SerializedModelSaverCustomizer.this.m_smSaver.setDirectory(new File(SerializedModelSaverCustomizer.this.m_directoryText.getText()));
                    SerializedModelSaverCustomizer.this.m_smSaver.setIncludeRelationName(SerializedModelSaverCustomizer.this.m_includeRelationName.isSelected());
                    SerializedModelSaverCustomizer.this.m_smSaver.setUseRelativePath(SerializedModelSaverCustomizer.this.m_relativeFilePath.isSelected());
                    Tag selected = (Tag)SerializedModelSaverCustomizer.this.m_fileFormatBox.getSelectedItem();
                    if (selected != null) {
                        SerializedModelSaverCustomizer.this.m_smSaver.setFileFormat(selected);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (SerializedModelSaverCustomizer.this.m_modifyListener != null) {
                    SerializedModelSaverCustomizer.this.m_modifyListener.setModifiedStatus(SerializedModelSaverCustomizer.this, true);
                }
                SerializedModelSaverCustomizer.this.m_parentWindow.dispose();
            }
        });
        JButton CancelBut = new JButton("Cancel");
        CancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SerializedModelSaverCustomizer.this.customizerClosing();
                SerializedModelSaverCustomizer.this.m_parentWindow.dispose();
            }
        });
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new FlowLayout());
        butHolder.add(OKBut);
        butHolder.add(CancelBut);
        JPanel holderPanel = new JPanel();
        holderPanel.setLayout(new BorderLayout());
        holderPanel.add((Component)alignedP, "North");
        holderPanel.add((Component)butHolder, "South");
        this.add((Component)holderPanel, "South");
    }

    @Override
    public void setObject(Object object) {
        this.m_smSaver = (SerializedModelSaver)object;
        this.m_SaverEditor.setTarget(this.m_smSaver);
        this.m_prefixBackup = this.m_smSaver.getPrefix();
        this.m_directoryBackup = this.m_smSaver.getDirectory();
        this.m_relationBackup = this.m_smSaver.getIncludeRelationName();
        this.m_relativeBackup = this.m_smSaver.getUseRelativePath();
        this.m_formatBackup = this.m_smSaver.getFileFormat();
        this.setUpFile();
    }

    private void setUpFileFormatComboBox() {
        this.m_fileFormatBox = new JComboBox();
        for (int i = 0; i < SerializedModelSaver.s_fileFormatsAvailable.size(); ++i) {
            Tag temp = SerializedModelSaver.s_fileFormatsAvailable.get(i);
            this.m_fileFormatBox.addItem(temp);
        }
        Tag result = this.m_smSaver.validateFileFormat(this.m_smSaver.getFileFormat());
        if (result == null) {
            this.m_fileFormatBox.setSelectedIndex(0);
        } else {
            this.m_fileFormatBox.setSelectedItem(result);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.removePropertyChangeListener(pcl);
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    @Override
    public void setModifiedListener(BeanCustomizer.ModifyListener l) {
        this.m_modifyListener = l;
    }

    @Override
    public void customizerClosing() {
        this.m_smSaver.setPrefix(this.m_prefixBackup);
        this.m_smSaver.setDirectory(this.m_directoryBackup);
        this.m_smSaver.setUseRelativePath(this.m_relativeBackup);
        this.m_smSaver.setIncludeRelationName(this.m_relationBackup);
        this.m_smSaver.setFileFormat(this.m_formatBackup);
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

