/*
 * Decompiled with CFR 0.152.
 */
package abModels;

import data_structures.Residue;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class CDRipatch {
    public static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        String cdr = CDRipatch.getCDRParatome("1ahw", "L1");
        System.out.println(cdr);
    }

    public static void annotateStructurePonom(String pdb_code, HashMap<Integer, Residue> str) {
        pdb_code = pdb_code.toUpperCase();
        TreeSet<Integer> tree = new TreeSet<Integer>();
        for (Integer i : str.keySet()) {
            tree.add(i);
        }
        String seq = "";
        for (Integer i : tree) {
            seq = String.valueOf(seq) + (Object)((Object)str.get((Object)i).type);
        }
        String h1 = CDRipatch.getCDR(pdb_code, "H1");
        String h2 = CDRipatch.getCDR(pdb_code, "H2");
        String h3 = CDRipatch.getCDR(pdb_code, "H3");
        String l1 = CDRipatch.getCDR(pdb_code, "L1");
        String l2 = CDRipatch.getCDR(pdb_code, "L2");
        String l3 = CDRipatch.getCDR(pdb_code, "L3");
        if (l1.length() == 3) {
            String tmp = l1;
            l1 = l2;
            l2 = tmp;
        }
        System.out.println(seq);
        System.out.println("Doing: " + pdb_code);
        int s_h1 = seq.indexOf(h1) + 1;
        System.out.println("H1");
        String H1 = CDRipatch.annotateAccordingly(s_h1, h1.length(), str, h1, "H1");
        int s_h2 = seq.indexOf(h2) + 1;
        System.out.println("H2");
        String H2 = CDRipatch.annotateAccordingly(s_h2, h2.length(), str, h2, "H2");
        int s_h3 = seq.indexOf(h3) + 1;
        System.out.println("H3");
        String H3 = CDRipatch.annotateAccordingly(s_h3, h3.length(), str, h3, "H3");
        int s_l1 = seq.indexOf(l1) + 1;
        System.out.println("L1");
        String L1 = CDRipatch.annotateAccordingly(s_l1, l1.length(), str, l1, "L1");
        int s_l2 = seq.lastIndexOf(l2) + 1;
        System.out.println("L2");
        String L2 = CDRipatch.annotateAccordingly(s_l2, l2.length(), str, l2, "L2");
        int s_l3 = seq.indexOf(l3) + 1;
        System.out.println("L3");
        String L3 = CDRipatch.annotateAccordingly(s_l3, l3.length(), str, l3, "L3");
        System.out.println("============");
        System.out.println(pdb_code);
        System.out.println(String.valueOf(s_h1) + " : " + h1);
        System.out.println(String.valueOf(s_h1) + " : " + H1);
        System.out.println(String.valueOf(s_h2) + " : " + h2);
        System.out.println(String.valueOf(s_h2) + " : " + H2);
        System.out.println(String.valueOf(s_h3) + " : " + h3);
        System.out.println(String.valueOf(s_h3) + " : " + H3);
        System.out.println(String.valueOf(s_l1) + " : " + l1);
        System.out.println(String.valueOf(s_l1) + " : " + L1);
        System.out.println(String.valueOf(s_l2) + " : " + l2);
        System.out.println(String.valueOf(s_l2) + " : " + L2);
        System.out.println(String.valueOf(s_l3) + " : " + l3);
        System.out.println(String.valueOf(s_l3) + " : " + L3);
        System.out.println("============");
        CDRipatch.writeCDRMutations(pdb_code, "H1", H1, seq);
        CDRipatch.writeCDRMutations(pdb_code, "H2", H2, seq);
        CDRipatch.writeCDRMutations(pdb_code, "H3", H3, seq);
        CDRipatch.writeCDRMutations(pdb_code, "L1", L1, seq);
        CDRipatch.writeCDRMutations(pdb_code, "L2", L2, seq);
        CDRipatch.writeCDRMutations(pdb_code, "L3", L3, seq);
        for (Integer n : tree) {
        }
    }

    public static void writeCDRMutations(String pdb, String cdr, String seq, String main_seq) {
        String output = String.valueOf(seq) + "\n";
        String mutated = "A" + seq.substring(1) + "\n";
        output = String.valueOf(output) + mutated;
        int start = main_seq.indexOf(seq);
        String map_out = String.valueOf(++start) + " " + 1 + " " + seq.charAt(0) + "\n";
        int i = 1;
        while (i < seq.length() - 1) {
            mutated = String.valueOf(seq.substring(0, i)) + "A" + seq.substring(i + 1) + "\n";
            output = String.valueOf(output) + mutated;
            map_out = String.valueOf(map_out) + (start + i) + " " + (i + 1) + " " + seq.charAt(i) + "\n";
            ++i;
        }
        mutated = String.valueOf(seq.substring(0, seq.length() - 1)) + "A";
        map_out = String.valueOf(map_out) + (start + i) + " " + (i + 1) + " " + seq.charAt(i) + "\n";
        output = String.valueOf(output) + mutated;
        FileSystemTools.writeFile(String.valueOf(userdir) + "/Tests/ABPonom/" + pdb + "/" + cdr + ".pdb", output);
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/Alanine_scanning/chain_maps/" + pdb + "_" + cdr + ".pdb", map_out);
    }

    public static void annotateStructure(String pdb_code, HashMap<Integer, Residue> str) {
        TreeSet<Integer> tree = new TreeSet<Integer>();
        for (Integer i : str.keySet()) {
            tree.add(i);
        }
        String seq = "";
        for (Integer i : tree) {
            seq = String.valueOf(seq) + (Object)((Object)str.get((Object)i).type);
        }
        String h1 = CDRipatch.getCDR(pdb_code, "H1");
        String h2 = CDRipatch.getCDR(pdb_code, "H2");
        String h3 = CDRipatch.getCDR(pdb_code, "H3");
        String l1 = CDRipatch.getCDR(pdb_code, "L1");
        String l2 = CDRipatch.getCDR(pdb_code, "L2");
        String l3 = CDRipatch.getCDR(pdb_code, "L3");
        System.out.println("L2 " + l1);
        if (l1.length() == 3) {
            String tmp = l1;
            l1 = l2;
            l2 = tmp;
        }
        System.out.println(seq);
        int s_h1 = seq.indexOf(h1) + 1;
        System.out.println("H1");
        CDRipatch.annotateAccordingly(s_h1, h1.length(), str, h1, "H1");
        int s_h2 = seq.indexOf(h2) + 1;
        System.out.println("H2");
        CDRipatch.annotateAccordingly(s_h2, h2.length(), str, h2, "H2");
        int s_h3 = seq.indexOf(h3) + 1;
        System.out.println("H3");
        CDRipatch.annotateAccordingly(s_h3, h3.length(), str, h3, "H3");
        int s_l1 = seq.indexOf(l1) + 1;
        System.out.println("L1");
        CDRipatch.annotateAccordingly(s_l1, l1.length(), str, l1, "L1");
        int s_l2 = seq.lastIndexOf(l2) + 1;
        System.out.println("L2");
        CDRipatch.annotateAccordingly(s_l2, l2.length(), str, l2, "L2");
        int s_l3 = seq.indexOf(l3) + 1;
        System.out.println("L3");
        CDRipatch.annotateAccordingly(s_l3, l3.length(), str, l3, "L3");
        System.out.println("============");
        System.out.println(pdb_code);
        System.out.println(String.valueOf(s_h1) + " : " + h1);
        System.out.println(String.valueOf(s_h2) + " : " + h2);
        System.out.println(String.valueOf(s_h3) + " : " + h3);
        System.out.println(String.valueOf(s_l1) + " : " + l1);
        System.out.println(String.valueOf(s_l2) + " : " + l2);
        System.out.println(String.valueOf(s_l3) + " : " + l3);
        System.out.println("============");
        for (Integer n : tree) {
        }
    }

    public static void annotateStructure(String pdb_code) {
        String test_folds = String.valueOf(userdir) + "/Tests/ABModels";
        HashMap<Integer, Residue> str = PDB_parser.parse(String.valueOf(test_folds) + "/" + pdb_code + "/strA.pdb");
        TreeSet<Integer> tree = new TreeSet<Integer>();
        for (Integer i : str.keySet()) {
            tree.add(i);
        }
        String seq = "";
        for (Integer i : tree) {
            System.out.println(i + " : " + (Object)((Object)str.get((Object)i).type));
            seq = String.valueOf(seq) + (Object)((Object)str.get((Object)i).type);
        }
        String h1 = CDRipatch.getCDR(pdb_code, "H1");
        String h2 = CDRipatch.getCDR(pdb_code, "H2");
        String h3 = CDRipatch.getCDR(pdb_code, "H3");
        String l1 = CDRipatch.getCDR(pdb_code, "L1");
        String l2 = CDRipatch.getCDR(pdb_code, "L2");
        String l3 = CDRipatch.getCDR(pdb_code, "L3");
        if (l1.length() == 3) {
            String tmp = l1;
            l1 = l2;
            l2 = tmp;
        }
        int s_h1 = seq.indexOf(h1) + 1;
        System.out.println("H1");
        CDRipatch.annotateAccordingly(s_h1, h1.length(), str, h1, "H1");
        int s_h2 = seq.indexOf(h2) + 1;
        System.out.println("H2");
        CDRipatch.annotateAccordingly(s_h2, h2.length(), str, h2, "H2");
        int s_h3 = seq.indexOf(h3) + 1;
        System.out.println("H3");
        CDRipatch.annotateAccordingly(s_h3, h3.length(), str, h3, "H3");
        int s_l1 = seq.indexOf(l1) + 1;
        System.out.println("L1");
        CDRipatch.annotateAccordingly(s_l1, l1.length(), str, l1, "L1");
        int s_l2 = seq.lastIndexOf(l2) + 1;
        System.out.println("L2");
        CDRipatch.annotateAccordingly(s_l2, l2.length(), str, l2, "L2");
        int s_l3 = seq.indexOf(l3) + 1;
        System.out.println("L3");
        CDRipatch.annotateAccordingly(s_l3, l3.length(), str, l3, "L3");
        System.out.println("============");
        System.out.println(pdb_code);
        System.out.println(String.valueOf(s_h1) + " : " + h1);
        System.out.println(String.valueOf(s_h2) + " : " + h2);
        System.out.println(String.valueOf(s_h3) + " : " + h3);
        System.out.println(String.valueOf(s_l1) + " : " + l1);
        System.out.println(String.valueOf(s_l2) + " : " + l2);
        System.out.println(String.valueOf(s_l3) + " : " + l3);
        System.out.println("============");
        for (Integer n : tree) {
        }
    }

    public static String annotateAccordingly(int start, int len, HashMap<Integer, Residue> str, String cdr, String code) {
        int j = 0;
        System.out.println("Start: " + start);
        System.out.println("Len: " + len);
        System.out.println("Len: " + code);
        System.out.println("Finding " + cdr);
        String tot = "";
        int i = start;
        while (i < start + len) {
            str.get((Object)Integer.valueOf((int)i)).isCDR = true;
            tot = String.valueOf(tot) + (Object)((Object)str.get((Object)Integer.valueOf((int)i)).type);
            ++j;
            ++i;
        }
        System.out.println("Processed: " + tot);
        return tot;
    }

    public static String getPonom(String pdb_code, String cdr_code) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/protein_database/antibodies/cdr_files/" + pdb_code + ".txt");
        for (String s : lines) {
            if (!s.substring(0, 2).equals(cdr_code)) continue;
            return s.substring(3);
        }
        return null;
    }

    public static String getCDRParatome(String pdb, String cdr_code) {
        String src_fold = String.valueOf(userdir) + "/result_dump/Docking/paratome_comparison/results";
        String src_file = String.valueOf(src_fold) + "/" + pdb.toLowerCase() + ".txt";
        cdr_code = cdr_code.charAt(0) == 'H' ? "L" + cdr_code.charAt(1) : "H" + cdr_code.charAt(1);
        ArrayList<String> lines = FileSystemTools.readFile(src_file);
        for (String line : lines) {
            if (!line.contains(cdr_code)) continue;
            String result = line.substring(line.indexOf(58) + 1, line.indexOf(40)).replace(" ", "");
            return result;
        }
        return "";
    }

    public static String getCDR(String _pdb_code, String cdr_code) {
        String cdr_fold;
        String filename;
        System.out.println(_pdb_code + " " + cdr_code);
        String pdb_code = _pdb_code.toUpperCase();
        if (pdb_code.equals("1MLC")) {
            pdb_code = "1MLB";
        }
        if (pdb_code.equals("1AHW")) {
            pdb_code = "1FGN";
        }
        if (pdb_code.equals("1JPS")) {
            pdb_code = "1JPT";
        }
        if (pdb_code.equals("1WEJ")) {
            pdb_code = "1QBL";
        }
        if (pdb_code.equals("1VFB")) {
            pdb_code = "1VFA";
        }
        if (pdb_code.equals("2JEL")) {
            System.out.println("Im here");
            if (cdr_code.equals("H3")) {
                return "ARVMGEQYFDG";
            }
        }
        if (pdb_code.equals("1KB5")) {
            if (cdr_code.equals("H3")) {
                return "DSTFNY";
            }
            if (cdr_code.equals("H2")) {
                return "IRSVSDK";
            }
            if (cdr_code.equals("H3")) {
                return "AARYQGGRAL";
            }
            if (cdr_code.equals("L1")) {
                return "NSQYPW";
            }
            if (cdr_code.equals("L2")) {
                return "LRSPGD";
            }
            if (cdr_code.equals("L3")) {
                return "TCSAAPDWG";
            }
        }
        if (!new File(filename = String.valueOf(cdr_fold = String.valueOf(userdir) + "/protein_database/antibodies/cdrs") + "/" + pdb_code + cdr_code + ".pdb").exists()) {
            return null;
        }
        HashMap<Integer, Residue> residues = PDB_parser.parse(filename);
        TreeSet<Integer> tree = new TreeSet<Integer>();
        for (Integer i : residues.keySet()) {
            tree.add(i);
        }
        String seq = "";
        for (Integer i : tree) {
            seq = String.valueOf(seq) + (Object)((Object)residues.get((Object)i).type);
        }
        return seq;
    }

    public static void checkCDRpresence() {
        String test_folds = String.valueOf(userdir) + "/Tests/ABModels";
        String cdr_fold = String.valueOf(userdir) + "/protein_database/antibodies/cdrs";
        for (String folder : FileSystemTools.getFolders(test_folds)) {
            String h_ok = "";
            String l_ok = "";
            File h1 = new File(String.valueOf(cdr_fold) + "/" + folder + "H1.pdb");
            File h2 = new File(String.valueOf(cdr_fold) + "/" + folder + "H2.pdb");
            File h3 = new File(String.valueOf(cdr_fold) + "/" + folder + "H3.pdb");
            File l1 = new File(String.valueOf(cdr_fold) + "/" + folder + "L1.pdb");
            File l2 = new File(String.valueOf(cdr_fold) + "/" + folder + "L2.pdb");
            File l3 = new File(String.valueOf(cdr_fold) + "/" + folder + "L3.pdb");
            h_ok = h1.exists() && h2.exists() && h3.exists() ? "pass" : "fail";
            l_ok = l1.exists() && l2.exists() && l3.exists() ? "pass" : "fail";
            System.out.println("==========");
            System.out.println(folder);
            System.out.println(h_ok);
            System.out.println(l_ok);
            System.out.println("==========");
            if (!h_ok.equals(l_ok) || !h_ok.equals("fail")) continue;
            System.out.println(String.valueOf(folder) + " has undefined cdrs");
        }
    }
}

