/*
 * Decompiled with CFR 0.152.
 */
package docking_global;

import data_structures.Residue;
import docking_global.DockingDistances;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import parsing.PSA;
import utils.FileSystemTools;

public class RandomCompare {
    private static final String userdir = System.getProperty("user.dir");
    private static final String c_dir = String.valueOf(userdir) + "/resources/DockingCases/zdock";
    private static final double prec_cut = -1.0;

    public static void main(String[] args) {
        String HR = "H";
        for (String pdb : FileSystemTools.getFolders(String.valueOf(c_dir) + "/zdock_ipatch_4_H")) {
            String rand = RandomCompare.get30Random(pdb, HR, 20.0);
            double rand_rec = (double)Math.round(Double.parseDouble(FileSystemTools.getColumn(rand, 1)) * 100.0) / 100.0;
            double rand_prec = (double)Math.round(Double.parseDouble(FileSystemTools.getColumn(rand, 2)) * 100.0) / 100.0;
            double rand_tot = (double)Math.round(Double.parseDouble(FileSystemTools.getColumn(rand, 3)) * 100.0) / 100.0;
            String pred = RandomCompare.get30(pdb, HR, 20.0);
            double pred_rec = (double)Math.round(Double.parseDouble(FileSystemTools.getColumn(pred, 1)) * 100.0) / 100.0;
            double pred_prec = (double)Math.round(Double.parseDouble(FileSystemTools.getColumn(pred, 2)) * 100.0) / 100.0;
            double pred_tot = (double)Math.round(Double.parseDouble(FileSystemTools.getColumn(pred, 3)) * 100.0) / 100.0;
            String real4 = RandomCompare.getPortionReal("4", pdb);
            double real_rec = (double)Math.round(Double.parseDouble(FileSystemTools.getColumn(real4, 3)) * 100.0) / 100.0;
            double real_prec = (double)Math.round(Double.parseDouble(FileSystemTools.getColumn(real4, 4)) * 100.0) / 100.0;
            System.out.println(String.valueOf(pdb) + " & " + rand_rec + " & " + rand_prec + " & " + rand_tot + " & " + pred_rec + " & " + pred_prec + " & " + pred_tot + " & " + real_rec + " & " + real_prec + "\\\\ \\hline");
        }
    }

    public static String getAllAverageRandom(String pdb, String rh, double total) {
        double prec_sum = 0.0;
        double rec_sum = 0.0;
        int cutoff = 0;
        while ((double)cutoff < total) {
            String line = RandomCompare.getPortionRandom(String.valueOf(cutoff), pdb, rh);
            double prec = Double.parseDouble(FileSystemTools.getColumn(line, 4));
            double rec = Double.parseDouble(FileSystemTools.getColumn(line, 3));
            prec = (double)Math.round(prec * 100.0) / 100.0;
            rec = (double)Math.round(rec * 100.0) / 100.0;
            prec_sum += prec;
            rec_sum += rec;
            ++cutoff;
        }
        return String.valueOf(rec_sum / total) + " " + prec_sum / total;
    }

    public static String get30Random(String pdb, String rh, double total) {
        double prec_sum30 = 0.0;
        double rec_sum30 = 0.0;
        double better30 = 0.0;
        int cutoff = 0;
        while ((double)cutoff < total) {
            String line = RandomCompare.getPortionRandom(String.valueOf(cutoff), pdb, rh);
            double prec = Double.parseDouble(FileSystemTools.getColumn(line, 4));
            double rec = Double.parseDouble(FileSystemTools.getColumn(line, 3));
            prec = (double)Math.round(prec * 100.0) / 100.0;
            rec = (double)Math.round(rec * 100.0) / 100.0;
            if (prec > -1.0) {
                better30 += 1.0;
                prec_sum30 += prec;
                rec_sum30 += rec;
            }
            ++cutoff;
        }
        if (better30 > 0.0) {
            return String.valueOf(rec_sum30 / better30) + " " + prec_sum30 / better30 + " " + better30 / total;
        }
        return "0 0 0";
    }

    public static String getAllAverage(String pdb, String rh, double total) {
        double prec_sum = 0.0;
        double rec_sum = 0.0;
        int cutoff = 0;
        while ((double)cutoff < total) {
            String line = RandomCompare.getPortionPredicted(String.valueOf(cutoff), pdb, rh);
            double prec = Double.parseDouble(FileSystemTools.getColumn(line, 4));
            double rec = Double.parseDouble(FileSystemTools.getColumn(line, 3));
            prec = (double)Math.round(prec * 100.0) / 100.0;
            rec = (double)Math.round(rec * 100.0) / 100.0;
            prec_sum += prec;
            rec_sum += rec;
            ++cutoff;
        }
        return String.valueOf(rec_sum / total) + " " + prec_sum / total;
    }

    public static String get30(String pdb, String rh, double total) {
        double prec_sum30 = 0.0;
        double rec_sum30 = 0.0;
        double better30 = 0.0;
        int cutoff = 0;
        while ((double)cutoff < total) {
            String line = RandomCompare.getPortionPredicted(String.valueOf(cutoff), pdb, rh);
            double prec = Double.parseDouble(FileSystemTools.getColumn(line, 4));
            double rec = Double.parseDouble(FileSystemTools.getColumn(line, 3));
            prec = (double)Math.round(prec * 100.0) / 100.0;
            rec = (double)Math.round(rec * 100.0) / 100.0;
            if (prec > -1.0) {
                better30 += 1.0;
                prec_sum30 += prec;
                rec_sum30 += rec;
            }
            ++cutoff;
        }
        if (better30 > 0.0) {
            return String.valueOf(rec_sum30 / better30) + " " + prec_sum30 / better30 + " " + better30 / total;
        }
        return "0 0 0";
    }

    public static String getPortionRandom(String cutoff, String pdb_code, String rh) {
        String _case = "zdock_ipatch_4_" + rh;
        _case = _case.replace("_4_", "_" + cutoff + "_");
        String ag_folder = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution/" + pdb_code.toLowerCase();
        HashMap<Integer, Residue> ab_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/AB.pdb", 'A');
        HashMap<Integer, Residue> ag_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/AG.pdb", 'A');
        DockingDistances.extractCons(ab_sol, ag_sol);
        ArrayList<String> epi_file = FileSystemTools.readFile("/Users/bielasek/Desktop/GraphAnalyzer/resources/GlobalDockingCases/zdock/" + _case + "/" + pdb_code + "/epitope.txt");
        ArrayList<Integer> ex_epi = new ArrayList<Integer>();
        HashMap<Integer, Boolean> surface_exp = RandomCompare.getPSA(ag_folder, pdb_code, ag_sol);
        double got_right = 0.0;
        double tot_cons = 0.0;
        for (Integer i : ag_sol.keySet()) {
            if (!surface_exp.get(i).booleanValue()) continue;
            if (ag_sol.get((Object)i).isContact) {
                tot_cons += 1.0;
            }
            if (epi_file.contains("" + i)) continue;
            ex_epi.add(i);
            if (!ag_sol.get((Object)i).isContact) continue;
            got_right += 1.0;
        }
        double prec = got_right / (double)ex_epi.size();
        double rec = got_right / tot_cons;
        return String.valueOf(_case) + " " + pdb_code + " " + rec + " " + prec;
    }

    public static String getPortionPredicted(String cutoff, String pdb_code, String rh) {
        String _case = "zdock_ipatch_4_" + rh;
        _case = _case.replace("_4_", "_" + cutoff + "_");
        String ag_folder = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution/" + pdb_code.toLowerCase();
        HashMap<Integer, Residue> ab_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/AB.pdb", 'A');
        HashMap<Integer, Residue> ag_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/AG.pdb", 'A');
        DockingDistances.extractCons(ab_sol, ag_sol);
        ArrayList<String> epi_file = FileSystemTools.readFile("/Users/bielasek/Desktop/GraphAnalyzer/resources/GlobalDockingCases_predicted/zdock/" + _case + "/" + pdb_code + "/epitope.txt");
        ArrayList<Integer> ex_epi = new ArrayList<Integer>();
        HashMap<Integer, Boolean> surface_exp = RandomCompare.getPSA(ag_folder, pdb_code, ag_sol);
        double got_right = 0.0;
        double tot_cons = 0.0;
        for (Integer i : ag_sol.keySet()) {
            if (!surface_exp.get(i).booleanValue()) continue;
            if (ag_sol.get((Object)i).isContact) {
                tot_cons += 1.0;
            }
            if (epi_file.contains("" + i)) continue;
            ex_epi.add(i);
            if (!ag_sol.get((Object)i).isContact) continue;
            got_right += 1.0;
        }
        double prec = got_right / (double)ex_epi.size();
        double rec = got_right / tot_cons;
        return String.valueOf(_case) + " " + pdb_code + " " + rec + " " + prec;
    }

    public static HashMap<Integer, Boolean> getPSA(String ag_folder, String pdb_code, HashMap<Integer, Residue> ag_sol) {
        HashMap<Integer, Boolean> surface_exp = new HashMap<Integer, Boolean>();
        if (!pdb_code.equals("1vfb")) {
            surface_exp = PSA.runPSA(7.5, String.valueOf(ag_folder) + "/AG.pdb");
        } else {
            for (Integer i : ag_sol.keySet()) {
                surface_exp.put(i, true);
            }
        }
        return surface_exp;
    }

    public static String getPortionReal(String cutoff, String pdb_code) {
        String _case = "zdock_ipatch_4_H";
        _case = _case.replace("_4_", "_" + cutoff + "_");
        String ag_folder = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution/" + pdb_code.toLowerCase();
        HashMap<Integer, Residue> ab_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/AB.pdb", 'A');
        HashMap<Integer, Residue> ag_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/AG.pdb", 'A');
        DockingDistances.extractCons(ab_sol, ag_sol);
        ArrayList<String> epi_file = FileSystemTools.readFile(String.valueOf(c_dir) + "/" + _case + "/" + pdb_code + "/epitope.txt");
        ArrayList<Integer> ex_epi = new ArrayList<Integer>();
        HashMap<Integer, Boolean> surface_exp = RandomCompare.getPSA(ag_folder, pdb_code, ag_sol);
        double got_right = 0.0;
        double tot_cons = 0.0;
        for (Integer i : ag_sol.keySet()) {
            if (!surface_exp.get(i).booleanValue()) continue;
            if (ag_sol.get((Object)i).isContact) {
                tot_cons += 1.0;
            }
            if (epi_file.contains("" + i)) continue;
            ex_epi.add(i);
            if (!ag_sol.get((Object)i).isContact) continue;
            got_right += 1.0;
        }
        double prec = got_right / (double)ex_epi.size();
        double rec = got_right / tot_cons;
        return String.valueOf(_case) + " " + pdb_code + " " + rec + " " + prec;
    }
}

