/*
 * Decompiled with CFR 0.152.
 */
package parsing;

import data_structures.MSA;
import data_structures.Residue_type;
import data_structures.SequencePair;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import parsing.Clustal;
import utils.FileSystemTools;

public class FASTA_parser {
    private static int reference = -1;
    public static double single_diffs_A = 0.0;
    public static double single_diffs_B = 0.0;
    public static double class_diffs_A = 0.0;
    public static double class_diffs_B = 0.0;
    private static String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        Residue_type[] r1 = new Residue_type[5];
        Residue_type[] r2 = new Residue_type[5];
        Residue_type[] r3 = new Residue_type[5];
        Residue_type[] r4 = new Residue_type[5];
        Residue_type[] r5 = new Residue_type[5];
        Residue_type[] r6 = new Residue_type[5];
        r1[0] = Residue_type.P;
        r1[1] = Residue_type.P;
        r1[2] = Residue_type.G;
        r1[3] = Residue_type.G;
        r1[4] = Residue_type.A;
        r2[0] = Residue_type.A;
        r2[1] = Residue_type.G;
        r2[2] = Residue_type.G;
        r2[3] = Residue_type.G;
        r2[4] = Residue_type.A;
        r3[0] = Residue_type.G;
        r3[1] = Residue_type.P;
        r3[2] = Residue_type.G;
        r3[3] = Residue_type.G;
        r3[4] = Residue_type.A;
        r4[0] = Residue_type.G;
        r4[1] = Residue_type.R;
        r4[2] = Residue_type.G;
        r4[3] = Residue_type.G;
        r4[4] = Residue_type.A;
        r5[0] = Residue_type.L;
        r5[1] = Residue_type.L;
        r5[2] = Residue_type.L;
        r5[3] = Residue_type.G;
        r5[4] = Residue_type.A;
        r6[0] = Residue_type.P;
        r6[1] = Residue_type.P;
        r6[2] = Residue_type.P;
        r6[3] = Residue_type.G;
        r6[4] = Residue_type.A;
        SequencePair sp1 = new SequencePair(r1, r2, 0);
        SequencePair sp2 = new SequencePair(r3, r4, 0);
        SequencePair sp3 = new SequencePair(r5, r6, 0);
        ArrayList<SequencePair> spl = new ArrayList<SequencePair>();
        spl.add(sp2);
        spl.add(sp3);
        MSA msa = new MSA(spl);
    }

    public static MSA splitToPairs(int lengthA, String alignment_file) {
        ArrayList<Residue_type[]> sequences = FASTA_parser.parse(alignment_file);
        ArrayList<SequencePair> pairs = new ArrayList<SequencePair>();
        Residue_type[] ref = sequences.get(reference);
        int split = 0;
        int j = 0;
        while (j != lengthA) {
            if (ref[split] != Residue_type.gap) {
                ++j;
            }
            ++split;
        }
        int i = 0;
        while (i < sequences.size()) {
            Residue_type[] rt = sequences.get(i);
            Residue_type[] seqA = Arrays.copyOfRange(rt, 0, split);
            Residue_type[] seqB = Arrays.copyOfRange(rt, split, rt.length);
            SequencePair sp = new SequencePair(seqA, seqB, i);
            pairs.add(sp);
            ++i;
        }
        MSA msa = new MSA(pairs);
        return msa;
    }

    public static ArrayList<Residue_type[]> parse(String alignment_file) {
        File file = new File(alignment_file);
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        ArrayList<Residue_type[]> sequences = new ArrayList<Residue_type[]>();
        ArrayList<Residue_type> res_tmp = new ArrayList<Residue_type>();
        try {
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            while (dis.available() != 0) {
                String line = dis.readLine();
                if ((line = line.replace(" ", "")).length() > 0 && line.charAt(0) == '>') {
                    if (res_tmp.size() != 0) {
                        Residue_type[] ar_tmp = new Residue_type[res_tmp.size()];
                        int i = 0;
                        while (i < res_tmp.size()) {
                            Residue_type res;
                            ar_tmp[i] = res = (Residue_type)((Object)res_tmp.get(i));
                            ++i;
                        }
                        sequences.add(ar_tmp);
                        res_tmp = new ArrayList();
                    }
                    if (line.length() <= 8 || !line.subSequence(0, 10).equals(">reference")) continue;
                    reference = sequences.size();
                    continue;
                }
                int i = 0;
                while (i < line.length()) {
                    if (reference == sequences.size()) {
                        res_tmp.add(Residue_type.mapResidue_char(line.charAt(i)));
                    } else {
                        res_tmp.add(Residue_type.mapResidue_char(line.charAt(i)));
                    }
                    ++i;
                }
            }
            if (res_tmp.size() != 0) {
                Residue_type[] ar_tmp = new Residue_type[res_tmp.size()];
                int i = 0;
                while (i < res_tmp.size()) {
                    Residue_type res;
                    ar_tmp[i] = res = (Residue_type)((Object)res_tmp.get(i));
                    ++i;
                }
                sequences.add(ar_tmp);
                res_tmp = new ArrayList();
            }
            fis.close();
            bis.close();
            dis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sequences;
    }

    public static int getReference() {
        return reference;
    }

    public static MSA RandomFastaParser(int spacing, String alignment) {
        ArrayList<String> lines = FileSystemTools.readFile(alignment);
        String output = "";
        boolean refdonttouch = false;
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i);
            if (line.contains(">")) {
                refdonttouch = line.contains(">reference");
            }
            if (!line.contains(">") && !refdonttouch) {
                int j = 0;
                while (j < line.length()) {
                    output = line.charAt(j) != '-' ? String.valueOf(output) + (Object)((Object)Residue_type.getRandomType()) : String.valueOf(output) + '-';
                    ++j;
                }
                output = String.valueOf(output) + "\n";
            } else {
                output = String.valueOf(output) + line + "\n";
            }
            ++i;
        }
        FileSystemTools.writeFile(alignment, output);
        return FASTA_parser.splitToPairs(spacing, alignment);
    }

    public static MSA ClustalFastaParser(int spacing, String alignment, boolean minimal) {
        MSA msa = FASTA_parser.splitToPairs(spacing, alignment);
        int reference = FASTA_parser.getReference();
        SequencePair ref_sp = msa.sequences.get(reference);
        SequencePair chosen = minimal ? FASTA_parser.GetMinimalCandidate(msa, ref_sp) : FASTA_parser.GetMaximalCandidate(msa, ref_sp);
        System.out.println("ID=" + chosen.seq_id);
        SequencePair r = msa.sequences.get(reference);
        String seqA = "";
        String refA = "";
        String seqB = "";
        String refB = "";
        int i = 0;
        while (i < r.sequenceA.length) {
            if (r.sequenceA[i] != Residue_type.gap) {
                refA = String.valueOf(refA) + (Object)((Object)r.sequenceA[i]);
                System.out.print((Object)r.sequenceA[i]);
            }
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < r.sequenceB.length) {
            if (r.sequenceB[i] != Residue_type.gap) {
                refB = String.valueOf(refB) + (Object)((Object)r.sequenceB[i]);
                System.out.print((Object)r.sequenceB[i]);
            }
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < chosen.sequenceA.length) {
            if (chosen.sequenceA[i] != Residue_type.gap) {
                seqA = String.valueOf(seqA) + (Object)((Object)chosen.sequenceA[i]);
                System.out.print((Object)chosen.sequenceA[i]);
            }
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < chosen.sequenceB.length) {
            if (chosen.sequenceB[i] != Residue_type.gap) {
                seqB = String.valueOf(seqB) + (Object)((Object)chosen.sequenceB[i]);
                System.out.print((Object)chosen.sequenceB[i]);
            }
            ++i;
        }
        System.out.println();
        FileSystemTools.writeFile(String.valueOf(userdir) + "/alA", ">ref\n" + refA + "\n>seq1\n" + seqA);
        FileSystemTools.writeFile(String.valueOf(userdir) + "/alB", ">ref\n" + refB + "\n>seq1\n" + seqB);
        Clustal.runClustal(String.valueOf(userdir) + "/alA", String.valueOf(userdir) + "/alA_out");
        Clustal.runClustal(String.valueOf(userdir) + "/alB", String.valueOf(userdir) + "/alB_out");
        ArrayList<String> linesA = FileSystemTools.readFile(String.valueOf(userdir) + "/alA_out");
        ArrayList<String> linesB = FileSystemTools.readFile(String.valueOf(userdir) + "/alB_out");
        String final_align = "";
        int j = 1;
        int i2 = 0;
        while (i2 < linesA.size()) {
            if (linesA.get(i2).charAt(0) != '>') continue;
            System.out.println(i2);
            final_align = String.valueOf(final_align) + linesA.get(i2) + "\n";
            ++i2;
            while (i2 < linesA.size() && linesA.get(i2).charAt(0) != '>') {
                final_align = String.valueOf(final_align) + linesA.get(i2) + "\n";
                ++i2;
            }
            while (j < linesB.size() && linesB.get(j).charAt(0) != '>') {
                final_align = String.valueOf(final_align) + linesB.get(j) + "\n";
                ++j;
            }
            ++j;
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/final_alignment", final_align);
        FASTA_parser.reference = 0;
        return FASTA_parser.splitToPairs(spacing, String.valueOf(userdir) + "/final_alignment");
    }

    public static SequencePair GetMinimalCandidate(MSA msa, SequencePair ref_sp) {
        double miniA = 2.0;
        double miniB = 2.0;
        SequencePair candidate = null;
        for (SequencePair sp : msa.sequences) {
            Residue_type[] seq_A = sp.sequenceA;
            Residue_type[] seq_B = sp.sequenceB;
            double identity = FASTA_parser.GetIdentity(ref_sp.sequenceA, seq_A);
            if (identity > miniA) continue;
            miniA = identity;
            identity = FASTA_parser.GetIdentity(ref_sp.sequenceB, seq_B);
            if (identity > miniB) continue;
            miniB = identity;
            candidate = sp;
        }
        System.out.println(String.valueOf(miniA) + ":" + miniB);
        return candidate;
    }

    public static SequencePair GetMaximalCandidate(MSA msa, SequencePair ref_sp) {
        double miniA = 0.0;
        double miniB = 0.0;
        SequencePair candidate = null;
        for (SequencePair sp : msa.sequences) {
            double identityB;
            Residue_type[] seq_A = sp.sequenceA;
            Residue_type[] seq_B = sp.sequenceB;
            double identityA = FASTA_parser.GetIdentity(ref_sp.sequenceA, seq_A);
            if (identityA < miniA || identityA == 1.0 || (identityB = FASTA_parser.GetIdentity(ref_sp.sequenceB, seq_B)) < miniB || identityB == 1.0) continue;
            miniA = identityA;
            miniB = identityB;
            candidate = sp;
        }
        System.out.println(String.valueOf(miniA) + ":" + miniB);
        return candidate;
    }

    private static double GetIdentity(Residue_type[] s1, Residue_type[] s2) {
        if (s1.length != s2.length) {
            System.err.println("GetIdentity: Structures of unequal length submitted for comparison");
            System.exit(0);
        }
        double equals = 0.0;
        int i = 0;
        while (i < s1.length) {
            if (s1[i] == s2[i]) {
                equals += 1.0;
            }
            ++i;
        }
        return equals / (double)s1.length;
    }
}

