/*
 * Decompiled with CFR 0.152.
 */
package utils;

import data_structures.Residue_type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.Set;
import utils.FileSystemTools;

public class MathFunctions {
    private static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        ArrayList<Integer> set = new ArrayList<Integer>();
        set.add(2);
        set.add(4);
        set.add(4);
        set.add(4);
        set.add(5);
        set.add(5);
        set.add(7);
        set.add(10);
        System.out.println(MathFunctions.getMean(set));
        System.out.println(MathFunctions.getStdDev(set));
    }

    public static double getStdDev(ArrayList<Integer> set) {
        if (set == null || set.size() == 1) {
            System.err.println("The set of numbers you supplied has no elements");
            System.exit(0);
        }
        double mean = MathFunctions.getMean(set);
        double sum = 0.0;
        for (Integer i : set) {
            sum += Math.pow(mean - (double)i.intValue(), 2.0);
        }
        return Math.sqrt(sum / (double)(set.size() - 1));
    }

    public static double getStdDevDouble(ArrayList<Double> set) {
        if (set == null || set.size() == 1) {
            System.err.println("The set of numbers you supplied has no elements");
            System.exit(0);
        }
        double mean = MathFunctions.getMeanDouble(set);
        double sum = 0.0;
        for (Double i : set) {
            sum += Math.pow(mean - i, 2.0);
        }
        return Math.sqrt(sum / (double)(set.size() - 1));
    }

    public static double getMean(ArrayList<Integer> set) {
        if (set == null || set.size() == 0) {
            System.err.println("The set of numbers you supplied has no elements");
            System.exit(0);
        }
        double sum = 0.0;
        for (Integer i : set) {
            sum += (double)i.intValue();
        }
        return sum / (double)set.size();
    }

    public static double getMeanDouble(ArrayList<Double> set) {
        if (set == null || set.size() == 0) {
            System.err.println("The set of numbers you supplied has no elements");
            System.exit(0);
        }
        double sum = 0.0;
        for (Double i : set) {
            sum += i.doubleValue();
        }
        return sum / (double)set.size();
    }

    public static ArrayList<String> NoutOfKString(ArrayList<String> list, int k) {
        Random r = new Random();
        ArrayList<String> result = new ArrayList<String>();
        while (result.size() < k) {
            int index = r.nextInt(list.size());
            result.add(list.remove(index));
        }
        return result;
    }

    public static ArrayList<Integer> NoutOfK(ArrayList<Integer> list, int k) {
        Random r = new Random();
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (result.size() < k) {
            int index = r.nextInt(list.size());
            result.add(list.remove(index));
        }
        return result;
    }

    public static double[][] getRemovedRows(double[][] mat, ArrayList<Integer> to_remove) {
        double[][] ret_mat = new double[to_remove.size()][mat[0].length];
        int index = 0;
        int i = 0;
        while (i < mat.length) {
            if (to_remove.contains(i)) {
                int j = 0;
                while (j < mat[0].length) {
                    ret_mat[index][j] = mat[i][j];
                    ++j;
                }
                ++index;
            }
            ++i;
        }
        return ret_mat;
    }

    public static double[][] removeRows(double[][] mat, ArrayList<Integer> to_remove) {
        double[][] ret_mat = new double[mat.length - to_remove.size()][mat[0].length];
        int index = 0;
        int i = 0;
        while (i < mat.length) {
            if (!to_remove.contains(i)) {
                int j = 0;
                while (j < mat[0].length) {
                    ret_mat[index][j] = mat[i][j];
                    ++j;
                }
                ++index;
            }
            ++i;
        }
        return ret_mat;
    }

    public static double[][] removeRow(double[][] mat, int row) {
        double[][] n_mat = new double[mat.length - 1][mat[0].length];
        int j = 0;
        int i = 0;
        while (i < mat.length) {
            if (row != i) {
                int l = 0;
                while (l < mat[0].length) {
                    n_mat[j][l] = mat[i][l];
                    ++l;
                }
                ++j;
            }
            ++i;
        }
        return n_mat;
    }

    public static double[][] crossMatrix(double[][] m1, double[][] m2) {
        int MAT_SIZE = m1.length * m2.length;
        double[][] matres = new double[MAT_SIZE][m1[0].length + m2[0].length];
        int matres_row = 0;
        int m1_i = 0;
        while (m1_i < m1.length) {
            double[] m1_row = MathFunctions.getRow(m1, m1_i);
            int m2_i = 0;
            while (m2_i < m2.length) {
                double[] m2_row = MathFunctions.getRow(m2, m2_i);
                int i = 0;
                while (i < m1[0].length + m2[0].length) {
                    matres[matres_row][i] = i < m1[0].length ? m1_row[i] : m2_row[i - m1[0].length];
                    ++i;
                }
                ++matres_row;
                ++m2_i;
            }
            ++m1_i;
        }
        return matres;
    }

    public static double[][] mergeMatrices(double[][] m1, double[][] m2) {
        if (m1.length != m2.length) {
            System.err.println("mergeMatrices: dimensions do not agree) m1=" + m1.length + " m2=" + m2.length);
            System.exit(0);
        }
        double[][] m_res = new double[m1.length][m1[0].length + m2[0].length];
        int i = 0;
        while (i < m1.length) {
            int j = 0;
            while (j < m1[0].length + m2[0].length) {
                m_res[i][j] = j < m1[0].length ? m1[i][j] : m2[i][j - m1[0].length];
                ++j;
            }
            ++i;
        }
        return m_res;
    }

    /*
     * Unable to fully structure code
     */
    public static double[][] removeZeroColumns(double[][] mat, double tolerance) {
        col = 0;
        ** GOTO lbl7
        {
            mat = MathFunctions.removeColumn(mat, col);
            do {
                if (col < mat[0].length && MathFunctions.isZero(mat, col, tolerance)) continue block0;
                ++col;
lbl7:
                // 2 sources

            } while (col < mat[0].length);
        }
        return mat;
    }

    public static double[][] removeColumn(double[][] mat, int col) {
        int j;
        double[][] result = new double[mat.length][mat[0].length - 1];
        int i = 0;
        while (i < mat.length) {
            j = 0;
            while (j < col) {
                result[i][j] = mat[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < mat.length) {
            j = col + 1;
            while (j < mat[0].length) {
                result[i][j - 1] = mat[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static boolean isZero(double[][] mat, int col, double tolerance) {
        double sum = 0.0;
        int i = 0;
        while (i < mat.length) {
            if (mat[i][col] != 0.0) {
                sum += 1.0;
            }
            ++i;
        }
        System.out.println(sum / (double)mat.length);
        return !(sum / (double)mat.length < tolerance);
    }

    public static boolean isZero(int[][] mat, int col) {
        int i = 0;
        while (i < mat.length) {
            if (mat[i][col] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static double[] scoreTriangle(double ad1, double ad2, double ad3, double bd1, double bd2, double bd3) {
        double min = Double.MAX_VALUE;
        double combination = -1.0;
        double score = Double.MAX_VALUE;
        score = MathFunctions.scoreParticular(ad1, ad2, ad3, bd1, bd2, bd3);
        if (score < min) {
            min = score;
            combination = 0.0;
        }
        if ((score = MathFunctions.scoreParticular(ad1, ad2, ad3, bd1, bd3, bd2)) < min) {
            min = score;
            combination = 1.0;
        }
        if ((score = MathFunctions.scoreParticular(ad1, ad2, ad3, bd2, bd1, bd3)) < min) {
            min = score;
            combination = 2.0;
        }
        if ((score = MathFunctions.scoreParticular(ad1, ad2, ad3, bd2, bd3, bd1)) < min) {
            min = score;
            combination = 3.0;
        }
        if ((score = MathFunctions.scoreParticular(ad1, ad2, ad3, bd3, bd1, bd2)) < min) {
            min = score;
            combination = 4.0;
        }
        if ((score = MathFunctions.scoreParticular(ad1, ad2, ad3, bd3, bd2, bd1)) < min) {
            min = score;
            combination = 5.0;
        }
        return new double[]{min, combination};
    }

    public static double scoreParticular(double ad1, double ad2, double ad3, double bd1, double bd2, double bd3) {
        return Math.abs(ad1 - bd1) + Math.abs(ad2 - bd2) + Math.abs(ad3 - bd3);
    }

    public static double Average(double[] a1) {
        double sum = 0.0;
        int i = 0;
        while (i < a1.length) {
            sum += a1[i];
            ++i;
        }
        return sum / (double)a1.length;
    }

    public static ArrayList<Integer> chooseRandom(ArrayList<Integer> keys, int how_many) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        Random r = new Random();
        int j = 0;
        while (j < how_many) {
            int index = r.nextInt(keys.size());
            int value = keys.get(index);
            keys.remove(index);
            res.add(value);
            ++j;
        }
        return res;
    }

    public static ArrayList<Integer> chooseRandom(int max, int how_many) {
        ArrayList<Integer> keys = new ArrayList<Integer>();
        ArrayList<Integer> res = new ArrayList<Integer>();
        Random r = new Random();
        int i = 0;
        while (i < max) {
            keys.add(i);
            ++i;
        }
        i = 0;
        while (i < how_many) {
            int index = r.nextInt(keys.size());
            int value = (Integer)keys.get(index);
            keys.remove(index);
            if (res.contains(value)) {
                System.err.println("Duplicate");
                System.exit(0);
            }
            res.add(value);
            ++i;
        }
        return res;
    }

    public static boolean equals(int[][] a1, int[][] a2) {
        int i = 0;
        while (i < 20) {
            int j = 0;
            while (j < 20) {
                if (a1[i][j] != a2[i][j]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(int[][][] a1, int[][][] a2) {
        int i = 0;
        while (i < 20) {
            int j = 0;
            while (j < 20) {
                int k = 0;
                while (k < 20) {
                    if (a1[i][j][k] != a2[i][j][k]) {
                        return false;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static int[][][] readParsable3D(String filename) {
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        int[][][] arr = new int[20][20][20];
        for (String line : lines) {
            int val;
            int i = Integer.parseInt(line.substring(0, line.indexOf(32)));
            line = line.substring(line.indexOf(32) + 1);
            int j = Integer.parseInt(line.substring(0, line.indexOf(32)));
            line = line.substring(line.indexOf(32) + 1);
            int k = Integer.parseInt(line.substring(0, line.indexOf(32)));
            line = line.substring(line.indexOf(32) + 1);
            arr[i][j][k] = val = Integer.parseInt(line);
        }
        return arr;
    }

    public static double[][] readAdjustableParsable2DDouble(String filename) {
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        int max_i = 0;
        int max_j = 0;
        for (String line : lines) {
            int i = Integer.parseInt(line.substring(0, line.indexOf(32)));
            line = line.substring(line.indexOf(32) + 1);
            int j = Integer.parseInt(line.substring(0, line.indexOf(32)));
            if (i > max_i) {
                max_i = i;
            }
            if (j <= max_j) continue;
            max_j = j;
        }
        double[][] arr = new double[max_i + 1][max_j + 1];
        for (String line : lines) {
            double val;
            int i = Integer.parseInt(line.substring(0, line.indexOf(32)));
            line = line.substring(line.indexOf(32) + 1);
            int j = Integer.parseInt(line.substring(0, line.indexOf(32)));
            line = line.substring(line.indexOf(32) + 1);
            arr[i][j] = val = Double.parseDouble(line);
        }
        return arr;
    }

    public static int[][] readAdjustableParsable2D(String filename) {
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        int max_i = 0;
        int max_j = 0;
        for (String line : lines) {
            int i = Integer.parseInt(line.substring(0, line.indexOf(32)));
            line = line.substring(line.indexOf(32) + 1);
            int j = Integer.parseInt(line.substring(0, line.indexOf(32)));
            if (i > max_i) {
                max_i = i;
            }
            if (j <= max_j) continue;
            max_j = j;
        }
        int[][] arr = new int[max_i + 1][max_j + 1];
        for (String line : lines) {
            int val;
            int i = Integer.parseInt(line.substring(0, line.indexOf(32)));
            line = line.substring(line.indexOf(32) + 1);
            int j = Integer.parseInt(line.substring(0, line.indexOf(32)));
            line = line.substring(line.indexOf(32) + 1);
            arr[i][j] = val = Integer.parseInt(line);
        }
        return arr;
    }

    public static int[][] readParsable2D(String filename) {
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        int[][] arr = new int[20][20];
        for (String line : lines) {
            int val;
            int i = Integer.parseInt(line.substring(0, line.indexOf(32)));
            line = line.substring(line.indexOf(32) + 1);
            int j = Integer.parseInt(line.substring(0, line.indexOf(32)));
            line = line.substring(line.indexOf(32) + 1);
            arr[i][j] = val = Integer.parseInt(line);
        }
        return arr;
    }

    public static double[][] readParsable2DDouble(String filename) {
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        double[][] arr = new double[20][20];
        for (String line : lines) {
            double val;
            int i = Integer.parseInt(line.substring(0, line.indexOf(32)));
            line = line.substring(line.indexOf(32) + 1);
            int j = Integer.parseInt(line.substring(0, line.indexOf(32)));
            line = line.substring(line.indexOf(32) + 1);
            arr[i][j] = val = Double.parseDouble(line);
        }
        return arr;
    }

    public static int[] readParsable1D(String filename) {
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        int[] arr = new int[20];
        for (String line : lines) {
            int val;
            int i = Integer.parseInt(line.substring(0, line.indexOf(32)));
            line = line.substring(line.indexOf(32) + 1);
            arr[i] = val = Integer.parseInt(line);
        }
        return arr;
    }

    public static void printParsable1D(int[] arr, String filename) {
        String output = "";
        int i = 0;
        while (i < arr.length) {
            output = String.valueOf(output) + i + " " + arr[i] + "\n";
            ++i;
        }
        FileSystemTools.writeFile(filename, output);
    }

    public static void printParsable2D(long[][] arr, String filename) {
        String output = "";
        int i = 0;
        while (i < arr.length) {
            int j = 0;
            while (j < arr[0].length) {
                output = String.valueOf(output) + i + " " + j + " " + arr[i][j] + "\n";
                ++j;
            }
            ++i;
        }
        FileSystemTools.writeFile(filename, output);
    }

    public static void printParsable2DDouble(double[][] arr, String filename) {
        String output = "";
        int i = 0;
        while (i < arr.length) {
            int j = 0;
            while (j < arr[0].length) {
                output = String.valueOf(output) + i + " " + j + " " + arr[i][j] + "\n";
                ++j;
            }
            ++i;
        }
        FileSystemTools.writeFile(filename, output);
    }

    public static int[][] copy2Darray(int[][] arr) {
        int[][] copy = new int[arr.length][arr[0].length];
        int i = 0;
        while (i < arr.length) {
            int j = 0;
            while (j < arr[0].length) {
                copy[i][j] = arr[i][j];
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static void printParsable2D(int[][] arr, String filename) {
        String output = "";
        int i = 0;
        while (i < arr.length) {
            int j = 0;
            while (j < arr[0].length) {
                output = String.valueOf(output) + i + " " + j + " " + arr[i][j] + "\n";
                ++j;
            }
            ++i;
        }
        FileSystemTools.writeFile(filename, output);
    }

    public static void printParsable2D(double[][] arr, String filename) {
        String output = "";
        int i = 0;
        while (i < arr.length) {
            int j = 0;
            while (j < arr[0].length) {
                output = String.valueOf(output) + i + " " + j + " " + arr[i][j] + "\n";
                ++j;
            }
            ++i;
        }
        FileSystemTools.writeFile(filename, output);
    }

    public static void printParsable3D(int[][][] arr, String filename) {
        String output = "";
        int i = 0;
        while (i < arr.length) {
            int j = 0;
            while (j < arr[0].length) {
                int k = 0;
                while (k < arr[0][0].length) {
                    output = String.valueOf(output) + i + " " + j + " " + k + " " + arr[i][j][k] + "\n";
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        FileSystemTools.writeFile(filename, output);
    }

    public static double Mean(ArrayList<Double> input) {
        if (input.size() == 0) {
            System.err.println("Input of size zero on input.");
            System.exit(-1);
            return -1.0;
        }
        double sum = 0.0;
        for (Double d : input) {
            sum += d.doubleValue();
        }
        return sum / (double)input.size();
    }

    public static int findMIN(Set<Integer> set) {
        int min = Integer.MAX_VALUE;
        for (Integer i : set) {
            if (i >= min) continue;
            min = i;
        }
        return min;
    }

    public static int findMAX(Set<Integer> set) {
        int max = Integer.MIN_VALUE;
        for (Integer i : set) {
            if (i <= max) continue;
            max = i;
        }
        return max;
    }

    public static double getNumber(String line) {
        String number = "";
        int i = 0;
        while (i < line.length()) {
            if (MathFunctions.isNumeral(line.charAt(i))) {
                number = String.valueOf(number) + line.charAt(i);
            }
            ++i;
        }
        if (number.length() == 0) {
            System.out.println("No number found in line " + line);
            return -1.0;
        }
        String proper_number = "";
        int i_start = 0;
        while (i_start < number.length() && number.charAt(i_start) == '.') {
            ++i_start;
        }
        int i_end = number.length() - 1;
        while (i_end > -1 && number.charAt(i_end) == '.') {
            --i_end;
        }
        if (i_end == -1) {
            return -1.0;
        }
        proper_number = number.substring(i_start, i_end + 1);
        if (proper_number.length() == 0) {
            System.out.println("No number found in line " + line);
            return -1.0;
        }
        return Double.parseDouble(proper_number);
    }

    public static double vectorDistance(double[] a1, double[] a2) {
        if (a1.length != a2.length) {
            System.out.println("in vectorDistance: dimensions do not agree:first: " + a1.length + "\n " + "second: " + a2.length + "\n ");
            System.exit(0);
        }
        double sum = 0.0;
        int i = 0;
        while (i < a1.length) {
            sum += Math.pow(a1[i] - a2[i], 2.0);
            ++i;
        }
        return Math.pow(sum, 0.5);
    }

    public static double vectorDistance(int[] a1, int[] a2) {
        if (a1.length != a2.length) {
            System.out.println("in vectorDistance: dimensions do not agree:first: " + a1.length + "\n " + "second: " + a2.length + "\n ");
            System.exit(0);
        }
        double sum = 0.0;
        int i = 0;
        while (i < a1.length) {
            sum += Math.pow(a1[i] - a2[i], 2.0);
            ++i;
        }
        return Math.pow(sum, 0.5);
    }

    public static int[] addVector(int[] a1, int[] a2) {
        if (a1.length != a2.length) {
            System.out.println("in addMatrix: dimensions do not agree:first: " + a1.length + "\n " + "second: " + a2.length + "\n ");
            System.exit(0);
        }
        int[] result = new int[a1.length];
        int i = 0;
        while (i < result.length) {
            result[i] = a1[i] + a2[i];
            ++i;
        }
        return result;
    }

    public static int[][] addMatrix(int[][] a1, int[][] a2) {
        if (a1.length != a2.length || a1[0].length != a2[0].length) {
            System.out.println("in addMatrix: dimensions do not agree:first: " + a1.length + " " + a1[0].length + "second: " + a2.length + " " + a2[0].length);
            System.exit(0);
        }
        int[][] result = new int[a1.length][a1[0].length];
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result[0].length) {
                result[i][j] = a1[i][j] + a2[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static int[][][] addMatrix(int[][][] a1, int[][][] a2) {
        if (a1.length != a2.length || a1[0].length != a2[0].length || a1[0][0].length != a2[0][0].length) {
            System.out.println("in addMatrix: dimensions do not agree:first: " + a1.length + " " + a1[0].length + " " + a1[0][0].length + "second: " + a2.length + " " + a2[0].length + " " + a2[0][0].length);
            System.exit(0);
        }
        int[][][] nMat = new int[a1.length][a1[0].length][a1[0][0].length];
        int i = 0;
        while (i < a1.length) {
            int j = 0;
            while (j < a1[0].length) {
                int l = 0;
                while (l < a1[0][0].length) {
                    nMat[i][j][l] = a1[i][j][l] + a2[i][j][l];
                    ++l;
                }
                ++j;
            }
            ++i;
        }
        return nMat;
    }

    public static double[][] addMatrix(double[][] a1, double[][] a2) {
        if (a1.length != a2.length || a1[0].length != a2[0].length) {
            System.out.println("in addMatrix: dimensions do not agree:first: " + a1.length + " " + a1[0].length + "second: " + a2.length + " " + a2[0].length);
            System.exit(0);
        }
        double[][] result = new double[a1.length][a1[0].length];
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result[0].length) {
                result[i][j] = a1[i][j] + a2[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static void print1Drray(double[] arr) {
        int j = 0;
        while (j < arr.length) {
            System.out.println(String.valueOf(j) + " : " + arr[j]);
            ++j;
        }
    }

    public static void print1Drray(int[] arr) {
        int j = 0;
        while (j < arr.length) {
            System.out.println(String.valueOf(j) + " : " + arr[j]);
            ++j;
        }
    }

    public static void print2Drray(int[][] arr) {
        int j = 0;
        while (j < arr.length) {
            int i = 0;
            while (i < arr[0].length) {
                System.out.print(" : " + arr[j][i]);
                ++i;
            }
            System.out.println();
            ++j;
        }
    }

    public static void print2Drray(double[][] arr) {
        int j = 0;
        while (j < arr.length) {
            System.out.print("{");
            int i = 0;
            while (i < arr[0].length) {
                if (i != 0) {
                    System.out.print(" , " + arr[j][i]);
                } else {
                    System.out.print(arr[j][i]);
                }
                ++i;
            }
            System.out.println("},");
            ++j;
        }
    }

    public static void write1Drray(int[] arr, String filename) {
        String out = "";
        int i = 0;
        while (i < arr.length) {
            out = String.valueOf(out) + arr[i] + "\n";
            ++i;
        }
        FileSystemTools.writeFile(filename, out);
    }

    public static void write1Drray(long[] arr, String filename) {
        String out = "";
        int i = 0;
        while (i < arr.length) {
            out = String.valueOf(out) + arr[i] + "\n";
            ++i;
        }
        FileSystemTools.writeFile(filename, out);
    }

    public static void write2Drray(int[][] arr, String filename) {
        String out = "";
        int j = 0;
        while (j < arr.length) {
            int i = 0;
            while (i < arr[0].length) {
                out = String.valueOf(out) + arr[j][i] + " ";
                ++i;
            }
            out = String.valueOf(out) + "\n";
            ++j;
        }
        FileSystemTools.writeFile(filename, out);
    }

    public static double[][] normalizeAARows(int[][] arr) {
        double[][] res = new double[20][20];
        int i = 0;
        while (i < 20) {
            double row_sum = 0.0;
            int j = 0;
            while (j < 20) {
                row_sum += (double)arr[i][j];
                ++j;
            }
            j = 0;
            while (j < 20) {
                if (arr[i][j] != 0 && row_sum != 0.0) {
                    res[i][j] = (double)arr[i][j] / row_sum;
                }
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static void print3DArray(int[][][] arr) {
        int i = 0;
        while (i < arr.length) {
            System.out.println(String.valueOf(i) + " : ");
            MathFunctions.print2Drray(arr[i]);
            ++i;
        }
    }

    public static void print3DArray(double[][][] arr) {
        int i = 0;
        while (i < arr.length) {
            System.out.println(String.valueOf(i) + " : ");
            MathFunctions.print2Drray(arr[i]);
            ++i;
        }
    }

    public static void write2Drray(double[][] arr, String filename) {
        String out = "";
        int j = 0;
        while (j < arr.length) {
            int i = 0;
            while (i < arr[0].length) {
                out = String.valueOf(out) + arr[j][i] + " ";
                ++i;
            }
            out = String.valueOf(out) + "\n";
            ++j;
        }
        FileSystemTools.writeFile(filename, out);
    }

    public static void printAAArray(double[] arr) {
        if (arr.length != 20) {
            System.err.println("printAAArray called on an array with length!=20, length=" + arr.length);
            System.exit(0);
        }
        int i = 0;
        while (i < 20) {
            System.out.println((Object)((Object)Residue_type.values()[i]) + " : " + arr[i]);
            ++i;
        }
    }

    public static void printClusterArray(double[] arr) {
        if (arr.length != 7) {
            System.err.println("printClusterAray called on an array with length!=7, length=" + arr.length);
            System.exit(0);
        }
        int i = 0;
        while (i < 7) {
            System.out.println((Object)((Object)Residue_type.values()[i].classification) + " : " + arr[i]);
            ++i;
        }
    }

    public static void printAAArray(int[] arr) {
        if (arr.length != 20) {
            System.err.println("printAAAray called on an array with length!=20, length=" + arr.length);
            System.exit(0);
        }
        int i = 0;
        while (i < 20) {
            System.out.println((Object)((Object)Residue_type.values()[i]) + " : " + arr[i]);
            ++i;
        }
    }

    public static void print2DAAArray(double[][] arr) {
        if (arr.length != 20 || arr[0].length != 20) {
            System.err.println("print2DAAAray called on an array with length!=20, length=" + arr.length + " " + arr[0].length);
            System.exit(0);
        }
        System.out.print("  ");
        int i = 0;
        while (i < 20) {
            System.out.print((Object)((Object)Residue_type.values()[i]) + "   ");
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < 20) {
            System.out.print((Object)((Object)Residue_type.values()[i]) + " ");
            int j = 0;
            while (j < 20) {
                System.out.print(String.valueOf(arr[i][j]) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public static void print3DAAArray(double[][][] arr) {
        if (arr.length != 20 || arr[0].length != 20 || arr[0][0].length != 20) {
            System.err.println("print3DAAAray called on an array with length!=20, length=" + arr.length + " " + arr[0].length + " " + arr[0][0].length);
            System.exit(0);
        }
        System.out.print("  ");
        int i = 0;
        while (i < 20) {
            System.out.println((Object)((Object)Residue_type.values()[i]) + "   ");
            MathFunctions.print2DAAArray(MathFunctions.getRow(arr, i));
            ++i;
        }
    }

    public static void print3DAAArray(int[][][] arr) {
        if (arr.length != 20 || arr[0].length != 20 || arr[0][0].length != 20) {
            System.err.println("print3DAAAray called on an array with length!=20, length=" + arr.length + " " + arr[0].length + " " + arr[0][0].length);
            System.exit(0);
        }
        System.out.print("  ");
        int i = 0;
        while (i < 20) {
            System.out.println((Object)((Object)Residue_type.values()[i]) + "   ");
            MathFunctions.print2DAAArray(MathFunctions.getRow(arr, i));
            ++i;
        }
    }

    public static double[] getRow(double[][] arr, int which_row) {
        double[] row = new double[arr[0].length];
        int i = 0;
        while (i < arr[0].length) {
            row[i] = arr[which_row][i];
            ++i;
        }
        return row;
    }

    public static int[][] getRow(int[][][] arr, int row) {
        if (arr.length < row) {
            System.err.println("Not enough rows: length=" + arr.length + "; suppied row=" + row);
            System.exit(0);
        }
        int[][] res = new int[arr[0].length][arr[0][0].length];
        int i = 0;
        while (i < arr[0].length) {
            int j = 0;
            while (j < arr[0][0].length) {
                res[i][j] = arr[row][i][j];
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static double[][] getRow(double[][][] arr, int row) {
        if (arr.length < row) {
            System.err.println("Not enough rows: length=" + arr.length + "; suppied row=" + row);
            System.exit(0);
        }
        double[][] res = new double[arr[0].length][arr[0][0].length];
        int i = 0;
        while (i < arr[0].length) {
            int j = 0;
            while (j < arr[0][0].length) {
                res[i][j] = arr[row][i][j];
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static void print2DAAArray(int[][] arr) {
        if (arr.length != 20 || arr[0].length != 20) {
            System.err.println("print2DAAAray called on an array with length!=20, length=" + arr.length + " " + arr[0].length);
            System.exit(0);
        }
        System.out.print("  ");
        int i = 0;
        while (i < 20) {
            System.out.print((Object)((Object)Residue_type.values()[i]) + " ");
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < 20) {
            System.out.print((Object)((Object)Residue_type.values()[i]) + " ");
            int j = 0;
            while (j < 20) {
                System.out.print(String.valueOf(arr[i][j]) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public static boolean isNumeral(char c) {
        switch (c) {
            case '0': {
                return true;
            }
            case '1': {
                return true;
            }
            case '2': {
                return true;
            }
            case '3': {
                return true;
            }
            case '4': {
                return true;
            }
            case '5': {
                return true;
            }
            case '6': {
                return true;
            }
            case '7': {
                return true;
            }
            case '8': {
                return true;
            }
            case '9': {
                return true;
            }
            case '.': {
                return true;
            }
        }
        return false;
    }

    public static void arrayTests() {
        String arr_file = String.valueOf(userdir) + "/result_dump/test.txt";
        int[][][] a1 = new int[20][20][20];
        int[][][] a2 = new int[20][20][20];
        a1[0][0][2] = 9;
        a1[0][2][1] = 2;
        a1[1][1][2] = 3;
        MathFunctions.printParsable3D(a1, arr_file);
        a2 = MathFunctions.readParsable3D(arr_file);
        System.out.println("3D test: " + Arrays.equals((Object[])a1, (Object[])a2) + " " + MathFunctions.equals(a1, a2));
        int[][] a1_2 = new int[20][20];
        int[][] a2_2 = new int[20][20];
        a1_2[0][2] = 9;
        a1_2[2][1] = 2;
        a1_2[1][2] = 3;
        MathFunctions.printParsable2D(a1_2, arr_file);
        a2_2 = MathFunctions.readParsable2D(arr_file);
        System.out.println(a1_2[0][0]);
        System.out.println("2D test: " + Arrays.equals((Object[])a1_2, (Object[])a2_2) + " " + MathFunctions.equals(a1_2, a2_2));
        int[] a1_1 = new int[20];
        int[] a2_1 = new int[20];
        a1_1[0] = 9;
        a1_1[2] = 2;
        a1_1[1] = 3;
        MathFunctions.printParsable1D(a1_1, arr_file);
        a2_1 = MathFunctions.readParsable1D(arr_file);
        System.out.println("1D test: " + Arrays.equals(a1_1, a2_1));
    }
}

