/*
 * Decompiled with CFR 0.152.
 */
package analysis;

import data_structures.Residue;
import data_structures.SC_Structure;
import db_interface.Complex_Structure;
import java.util.ArrayList;
import utils.FileSystemTools;
import utils.MathFunctions;

public class MaxClique {
    public static final String userdir = System.getProperty("user.dir");
    public static final String temp_folder = String.valueOf(userdir) + "/temp";

    public static void main(String[] args) {
        String complex_folder = String.valueOf(userdir) + "/protein_database/general_proteins/complex";
        String code = "_CC";
        MaxClique.GenerateData(complex_folder, code);
        complex_folder = String.valueOf(userdir) + "/protein_database/general_proteins/domain";
        code = "_DD";
        MaxClique.GenerateData(complex_folder, code);
    }

    public static void GenerateForSingle(SC_Structure s1, SC_Structure s2, String id) {
        String save_folder = String.valueOf(userdir) + "/result_dump/MaxClique/tolerance";
        System.out.println("Intra A");
        double[][] distA = MaxClique.CalculateDistances(s1);
        System.out.println("Intra B");
        double[][] distB = MaxClique.CalculateDistances(s2);
        System.out.println("Inter A/B");
        double[][] dists = MaxClique.CalculateDistances(s1, s2);
        int bins = 10000;
        long[] out_I = new long[bins];
        long[] out_II = new long[bins];
        long[] out_III = new long[bins];
        double basic_unit = 50.0 / (double)bins;
        System.out.println("Distance Calculations");
        int prog = 0;
        for (int a_1 : s1.residues.keySet()) {
            System.out.println("Progress " + id + ": " + ++prog + "/" + s1.residues.size());
            for (int a_2 : s1.residues.keySet()) {
                if (a_1 == a_2) continue;
                for (int b_1 : s2.residues.keySet()) {
                    for (int b_2 : s2.residues.keySet()) {
                        double dB;
                        double dA;
                        double diff;
                        if (b_1 == b_2 || (diff = Math.abs((dA = distA[a_1][a_2]) - (dB = distB[b_1][b_2]))) > 50.0) continue;
                        int clas = (int)(diff / basic_unit);
                        if (dists[a_1][b_1] <= 4.5 && dists[a_2][b_2] <= 4.5 || dists[a_1][b_2] <= 4.5 && dists[a_2][b_1] <= 4.5) {
                            int n = clas;
                            out_I[n] = out_I[n] + 1L;
                        }
                        if (dists[a_1][b_1] > 4.5 && dists[a_2][b_2] < 4.5 || dists[a_1][b_2] > 4.5 && dists[a_2][b_1] < 4.5 || dists[a_1][b_1] < 4.5 && dists[a_2][b_2] > 4.5 || dists[a_1][b_2] < 4.5 && dists[a_2][b_1] > 4.5) {
                            int n = clas;
                            out_II[n] = out_II[n] + 1L;
                        }
                        if (!(dists[a_1][b_1] > 4.5 && dists[a_2][b_2] > 4.5) && (!(dists[a_1][b_2] > 4.5) || !(dists[a_2][b_1] > 4.5))) continue;
                        int n = clas;
                        out_III[n] = out_III[n] + 1L;
                    }
                }
            }
        }
        System.out.println("Saving results");
        MathFunctions.write1Drray(out_I, String.valueOf(save_folder) + "/" + id + "_I");
        MathFunctions.write1Drray(out_II, String.valueOf(save_folder) + "/" + id + "_II");
        MathFunctions.write1Drray(out_III, String.valueOf(save_folder) + "/" + id + "_III");
    }

    public static void GenerateData(String complex_folder, String code) {
        ArrayList<String> filenames = FileSystemTools.getFiles(complex_folder);
        ArrayList<String> unique_pdbs = new ArrayList<String>();
        int progress = 0;
        for (String filename : filenames) {
            System.out.println("Progress: " + ++progress + "/" + filenames.size());
            String pdb_code = filename.substring(0, 4);
            if (unique_pdbs.contains(pdb_code)) continue;
            unique_pdbs.add(pdb_code);
            System.out.println("============================");
            System.out.println(filename);
            System.out.println(pdb_code);
            Complex_Structure cp = new Complex_Structure(String.valueOf(pdb_code) + code);
            System.out.println(cp.resolution);
            System.out.println(cp.source);
            System.out.println(cp.m1.pdb_src);
            System.out.println(cp.m2.pdb_src);
            System.out.println("============================");
            SC_Structure s1 = null;
            SC_Structure s2 = null;
            for (char chain : cp.m1.chains.keySet()) {
                s1 = cp.m1.chains.get(Character.valueOf(chain));
            }
            for (char chain : cp.m2.chains.keySet()) {
                s2 = cp.m2.chains.get(Character.valueOf(chain));
            }
            s1 = s1.GetSurfaceResidues(7.0);
            s2 = s2.GetSurfaceResidues(7.0);
            MaxClique.GenerateForSingle(s1, s2, String.valueOf(progress) + code);
        }
        System.out.println("Total: " + unique_pdbs.size());
    }

    public static double[][] CalculateDistances(SC_Structure str) {
        int max = -1;
        for (Integer i : str.residues.keySet()) {
            if (i <= max) continue;
            max = i;
        }
        double[][] dists = new double[max + 1][max + 1];
        for (Integer i : str.residues.keySet()) {
            Residue r1 = str.residues.get(i);
            for (Integer j : str.residues.keySet()) {
                if (i == j) continue;
                Residue r2 = str.residues.get(j);
                dists[i.intValue()][j.intValue()] = r1.distanceFrom(r2);
            }
        }
        return dists;
    }

    public static double[][] CalculateDistances(SC_Structure s1, SC_Structure s2) {
        int max1 = -1;
        for (Integer i : s1.residues.keySet()) {
            if (i <= max1) continue;
            max1 = i;
        }
        int max2 = -1;
        for (Integer i : s2.residues.keySet()) {
            if (i <= max2) continue;
            max2 = i;
        }
        double[][] dists = new double[max1 + 1][max2 + 1];
        for (Integer i : s1.residues.keySet()) {
            Residue r1 = s1.residues.get(i);
            for (Integer j : s2.residues.keySet()) {
                Residue r2 = s2.residues.get(j);
                dists[i.intValue()][j.intValue()] = r1.distanceFrom(r2);
            }
        }
        return dists;
    }
}

