/*
 * Decompiled with CFR 0.152.
 */
package data_structures;

import data_structures.Residue_classification;
import java.util.Random;

public enum Residue_type {
    R(Residue_classification.fP, 1.061640677522799, 2.05, 1.57),
    N(Residue_classification.P, 0.819217566559976, 2.27, 1.29),
    D(Residue_classification.N, 0.699090166341689, 2.1, 1.37),
    C(Residue_classification.H, 1.801914600932664, 0.26, 0.41),
    Q(Residue_classification.P, 0.830679801693058, 0.37, 1.29),
    E(Residue_classification.N, 0.655112284016974, 0.96, 0.94),
    G(Residue_classification.S, 0.808683521492881, 0.9, 0.97),
    H(Residue_classification.fP, 1.139445137592264, 3.26, 1.5),
    I(Residue_classification.H, 1.60716822466544, 0.78, 0.79),
    L(Residue_classification.H, 1.606550672527021, 0.45, 0.79),
    K(Residue_classification.dfP, 0.601329697609149, 0.37, 1.35),
    M(Residue_classification.H, 1.649083481801667, 0.44, 0.77),
    F(Residue_classification.A, 1.949811232844933, 1.18, 0.61),
    P(Residue_classification.S, 0.924310331356006, 0.39, 1.31),
    S(Residue_classification.S, 0.839179786673085, 0.78, 0.85),
    T(Residue_classification.P, 0.902342498485995, 0.59, 0.98),
    W(Residue_classification.A, 1.627091555567172, 3.27, 1.47),
    Y(Residue_classification.A, 1.560429666007116, 4.36, 1.61),
    V(Residue_classification.H, 1.359899869511208, 0.35, 0.52),
    A(Residue_classification.S, 0.97343039129673, 0.46, 0.63),
    DNA(Residue_classification.A, 1.560429666007116, 0.0, 0.0),
    gap(Residue_classification.GAPS, Residue_classification.GAPS, Residue_classification.GAPS, -1.0E9);

    public final Residue_classification classification;
    public Residue_classification ab_classification;
    public Residue_classification ag_classification;
    public final double propensity;
    public final double prop_score;
    public final double prop_score_ag;
    public static final Residue_type[] sA1;
    public static final Residue_type[] sA2;
    public static final Residue_type[] sB1;
    public static final Residue_type[] sB2;
    public static double[] bias_CON;
    public static double[] bias3_CON;
    public static double[] bias3_PROP;
    public static double[] surface_bias;

    static {
        sA1 = new Residue_type[]{A, gap, D, A, F, D, E, M, D, E, I, W, A, L, Y, A, D, D, G, A, Q, gap, A, L, D, A, M, E, A, S, L, L, A, L, gap, gap, gap, gap, Q, gap, gap, gap, A, gap, gap, gap, gap, gap, gap, gap, G, E, D, gap, gap, A, A, A, H, V, G, P, L, F, R, A, V, H, T, F, K, G, N, S, R, V, L, G, gap, L, S, V, V, E, S, R, A, H, L, C, E, D, L, I, G, L, V, R, D, A, G, V, P, M, gap, gap, D, G, E, I, V, E, I, L, L, F, A, S, D, gap, T, L, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, R, A, gap, gap, M, L, E, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, M, P, Y};
        sA2 = new Residue_type[]{gap, gap, M, I, V, D, D, A, A, M, M, R, L, Y, I, A, S, F, I, K, T, gap, gap, gap, gap, gap, L, P, D, F, gap, gap, gap, K, V, V, A, Q, A, A, N, G, Q, E, A, L, D, K, L, gap, gap, gap, gap, A, A, Q, gap, gap, gap, gap, P, N, V, D, L, I, L, L, D, I, E, M, P, V, M, D, G, M, E, F, L, R, H, A, K, gap, L, K, T, R, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, A, K, I, C, M, L, S, S, V, A, V, S, G, S, P, H, A, A, R, A, R, E, L, G, A, D, G, V, V, A, K, P, S, G, T, V, S, H, D, L, E, E, K, T, G, G, E, L, A, R, T, M, R, T, L, M, A, A, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap};
        sB1 = new Residue_type[]{A, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, F, L, E, D, A, A, E, gap, H, L, E, A, A, E, S, S, L, L, L, L, E, K, R, V, N, gap, gap, gap, D, gap, gap, gap, gap, gap, gap, gap, G, L, H, gap, gap, D, E, G, G, V, T, L, L, L, G, N, L, H, T, L, K, G, N, A, G, M, M, G, gap, L, T, P, L, Q, Q, Y, V, H, K, M, E, S, V, L, K, Q, V, V, D, G, S, L, S, L, gap, gap, T, S, N, L, F, E, S, F, Y, S, A, I, N, gap, S, L, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, R, E, gap, gap, S, L, E, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, M, L, N};
        sB2 = new Residue_type[]{gap, gap, L, V, V, D, D, S, S, L, I, H, Q, M, Y, R, L, V, M, T, R, gap, gap, gap, gap, gap, gap, gap, gap, Y, gap, K, C, E, I, L, gap, D, A, M, N, G, Q, E, A, L, D, I, L, gap, gap, A, L, Q, N, D, gap, gap, gap, gap, I, gap, gap, Q, L, I, L, L, D, I, N, M, P, V, M, N, G, L, Q, F, L, E, K, A, S, V, L, G, I, A, gap, gap, gap, gap, gap, gap, gap, gap, gap, K, R, I, P, I, V, V, I, S, T, E, G, K, E, E, D, T, I, R, C, L, gap, gap, K, L, G, A, R, G, Y, L, K, K, P, F, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, N, P, S, D, L, H, D, L, I, D, R, I, M, P, G, A, V, A, A, Q, V, F, N, I, C, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap, gap};
        bias_CON = new double[]{0.0475, 0.0386, 0.0338, 0.0697, 0.039, 0.032, 0.0382, 0.0501, 0.0645, 0.0644, 0.0298, 0.0656, 0.0734, 0.0426, 0.0394, 0.0417, 0.065, 0.0631, 0.0572, 0.0443};
        bias3_CON = new double[]{0.0349, 0.0187, 0.0126, 0.1104, 0.0194, 0.0107, 0.0182, 0.041, 0.0873, 0.0872, 0.0086, 0.0921, 0.1291, 0.0251, 0.0199, 0.0237, 0.0896, 0.082, 0.061, 0.0284};
        bias3_PROP = new double[]{0.0267, 0.0123, 0.0076, 0.1304, 0.0128, 0.0063, 0.0118, 0.033, 0.0925, 0.0924, 0.0048, 0.0999, 0.1652, 0.0176, 0.0132, 0.0164, 0.096, 0.0847, 0.056, 0.0206};
        surface_bias = new double[]{0.0667, 0.0497, 0.0724, 0.0071, 0.0448, 0.0914, 0.0745, 0.0265, 0.0391, 0.068, 0.0789, 0.0182, 0.0304, 0.0529, 0.0611, 0.0559, 0.0124, 0.0349, 0.0492, 0.066};
    }

    private Residue_type(Residue_classification cls, double prop, double prop_sc, double prop_ag) {
        this.classification = cls;
        this.propensity = prop;
        this.prop_score = prop_sc;
        this.prop_score_ag = prop_ag;
    }

    private Residue_type(Residue_classification cls, Residue_classification ab, Residue_classification ag, double prop) {
        this.classification = cls;
        this.ab_classification = ab;
        this.ag_classification = ag;
        this.propensity = prop;
        this.prop_score = 0.0;
        this.prop_score_ag = 0.0;
    }

    public static Residue_type mapResidue(String resid) {
        if ((resid = resid.replace(" ", "")).equals("ALA")) {
            return A;
        }
        if (resid.equals("ARG")) {
            return R;
        }
        if (resid.equals("ASN")) {
            return N;
        }
        if (resid.equals("ASP")) {
            return D;
        }
        if (resid.equals("CYS")) {
            return C;
        }
        if (resid.equals("GLN")) {
            return Q;
        }
        if (resid.equals("GLU")) {
            return E;
        }
        if (resid.equals("GLY")) {
            return G;
        }
        if (resid.equals("HIS")) {
            return H;
        }
        if (resid.equals("ILE")) {
            return I;
        }
        if (resid.equals("LEU")) {
            return L;
        }
        if (resid.equals("LYS")) {
            return K;
        }
        if (resid.equals("MET")) {
            return M;
        }
        if (resid.equals("PHE")) {
            return F;
        }
        if (resid.equals("PRO")) {
            return P;
        }
        if (resid.equals("SER")) {
            return S;
        }
        if (resid.equals("THR")) {
            return T;
        }
        if (resid.equals("TRP")) {
            return W;
        }
        if (resid.equals("TYR")) {
            return Y;
        }
        if (resid.equals("VAL")) {
            return V;
        }
        if (resid.equals("MSA")) {
            return M;
        }
        if (resid.equals("CSE")) {
            return C;
        }
        if (resid.equals("U")) {
            return DNA;
        }
        if (resid.equals("G")) {
            return DNA;
        }
        if (resid.equals("T")) {
            return DNA;
        }
        if (resid.equals("A")) {
            return DNA;
        }
        if (resid.equals("C")) {
            return DNA;
        }
        System.out.println("PDB_parser: It was impossible to map residue name " + resid);
        System.exit(0);
        return gap;
    }

    public static Residue_type mapResidue(String resid, String pdb_file) {
        if ((resid = resid.replace(" ", "")).equals("ALA")) {
            return A;
        }
        if (resid.equals("ARG")) {
            return R;
        }
        if (resid.equals("ASN")) {
            return N;
        }
        if (resid.equals("ASP")) {
            return D;
        }
        if (resid.equals("CYS")) {
            return C;
        }
        if (resid.equals("GLN")) {
            return Q;
        }
        if (resid.equals("GLU")) {
            return E;
        }
        if (resid.equals("GLY")) {
            return G;
        }
        if (resid.equals("HIS") || resid.equals("HSD")) {
            return H;
        }
        if (resid.equals("ILE")) {
            return I;
        }
        if (resid.equals("LEU")) {
            return L;
        }
        if (resid.equals("LYS")) {
            return K;
        }
        if (resid.equals("MET")) {
            return M;
        }
        if (resid.equals("PHE")) {
            return F;
        }
        if (resid.equals("PRO")) {
            return P;
        }
        if (resid.equals("SER")) {
            return S;
        }
        if (resid.equals("THR")) {
            return T;
        }
        if (resid.equals("TRP")) {
            return W;
        }
        if (resid.equals("TYR")) {
            return Y;
        }
        if (resid.equals("VAL")) {
            return V;
        }
        if (resid.equals("MSA")) {
            return M;
        }
        if (resid.equals("CSE")) {
            return C;
        }
        if (resid.equals("U")) {
            return DNA;
        }
        if (resid.equals("G")) {
            return DNA;
        }
        if (resid.equals("T")) {
            return DNA;
        }
        if (resid.equals("A")) {
            return DNA;
        }
        if (resid.equals("C")) {
            return DNA;
        }
        System.out.println("PDB_parser: It was impossible to map residue name " + resid);
        System.out.println(pdb_file);
        System.exit(0);
        return gap;
    }

    public static String mapResidueTo3(Residue_type r) {
        if (r == A) {
            return "ALA";
        }
        if (r == R) {
            return "ARG";
        }
        if (r == N) {
            return "ASN";
        }
        if (r == D) {
            return "ASP";
        }
        if (r == C) {
            return "CYS";
        }
        if (r == Q) {
            return "GLN";
        }
        if (r == E) {
            return "GLU";
        }
        if (r == G) {
            return "GLY";
        }
        if (r == H) {
            return "HIS";
        }
        if (r == I) {
            return "ILE";
        }
        if (r == L) {
            return "LEU";
        }
        if (r == K) {
            return "LYS";
        }
        if (r == M) {
            return "MET";
        }
        if (r == F) {
            return "PHE";
        }
        if (r == P) {
            return "PRO";
        }
        if (r == S) {
            return "SER";
        }
        if (r == T) {
            return "THR";
        }
        if (r == W) {
            return "TRP";
        }
        if (r == Y) {
            return "TYR";
        }
        if (r == V) {
            return "VAL";
        }
        System.out.println("It was impossible to map residue name " + (Object)((Object)r));
        System.exit(0);
        return null;
    }

    public static Residue_type mapResidue_char(char resid) {
        if (resid == 'A') {
            return A;
        }
        if (resid == 'R') {
            return R;
        }
        if (resid == 'N') {
            return N;
        }
        if (resid == 'D') {
            return D;
        }
        if (resid == 'C') {
            return C;
        }
        if (resid == 'Q') {
            return Q;
        }
        if (resid == 'E') {
            return E;
        }
        if (resid == 'G') {
            return G;
        }
        if (resid == 'H') {
            return H;
        }
        if (resid == 'I') {
            return I;
        }
        if (resid == 'L') {
            return L;
        }
        if (resid == 'K') {
            return K;
        }
        if (resid == 'M') {
            return M;
        }
        if (resid == 'F') {
            return F;
        }
        if (resid == 'P') {
            return P;
        }
        if (resid == 'S') {
            return S;
        }
        if (resid == 'T') {
            return T;
        }
        if (resid == 'W') {
            return W;
        }
        if (resid == 'Y') {
            return Y;
        }
        if (resid == 'V') {
            return V;
        }
        if (resid == '-') {
            return gap;
        }
        System.out.println("Residue_type: It was impossible to map residue name " + resid);
        return gap;
    }

    public static Residue_type mapResidue_randomized(char resid) {
        Residue_type[] residues = new Residue_type[]{R, N, D, C, Q, E, G, H, I, L, K, M, F, P, S, T, W, Y, V, A, gap};
        int rand_ind = (int)Math.round(Math.random() * 21.0);
        if (rand_ind == 21) {
            --rand_ind;
        }
        if (resid == 'A') {
            return residues[rand_ind];
        }
        if (resid == 'R') {
            return residues[rand_ind];
        }
        if (resid == 'N') {
            return residues[rand_ind];
        }
        if (resid == 'D') {
            return residues[rand_ind];
        }
        if (resid == 'C') {
            return residues[rand_ind];
        }
        if (resid == 'Q') {
            return residues[rand_ind];
        }
        if (resid == 'E') {
            return residues[rand_ind];
        }
        if (resid == 'G') {
            return residues[rand_ind];
        }
        if (resid == 'H') {
            return residues[rand_ind];
        }
        if (resid == 'I') {
            return residues[rand_ind];
        }
        if (resid == 'L') {
            return residues[rand_ind];
        }
        if (resid == 'K') {
            return residues[rand_ind];
        }
        if (resid == 'M') {
            return residues[rand_ind];
        }
        if (resid == 'F') {
            return residues[rand_ind];
        }
        if (resid == 'P') {
            return residues[rand_ind];
        }
        if (resid == 'S') {
            return residues[rand_ind];
        }
        if (resid == 'T') {
            return residues[rand_ind];
        }
        if (resid == 'W') {
            return residues[rand_ind];
        }
        if (resid == 'Y') {
            return residues[rand_ind];
        }
        if (resid == 'V') {
            return residues[rand_ind];
        }
        if (resid == '-') {
            return residues[rand_ind];
        }
        System.out.println("It was impossible to map residue name " + resid);
        return gap;
    }

    public static Residue_type getRandomType() {
        Random r = new Random();
        int index = r.nextInt(20);
        return Residue_type.values()[index];
    }

    public static Residue_type getRandomBiasedType_CON() {
        Random r = new Random();
        int index = r.nextInt(20);
        double prob = r.nextDouble();
        while (bias_CON[index] < prob) {
            index = r.nextInt(20);
            prob = r.nextDouble();
        }
        return Residue_type.values()[index];
    }

    public static Residue_type getRandomBiasedType_CON3() {
        Random r = new Random();
        int index = r.nextInt(20);
        double prob = r.nextDouble();
        while (bias3_CON[index] < prob) {
            index = r.nextInt(20);
            prob = r.nextDouble();
        }
        return Residue_type.values()[index];
    }

    public static Residue_type getRandomBiasedType_PROP3() {
        Random r = new Random();
        int index = r.nextInt(20);
        double prob = r.nextDouble();
        while (bias3_PROP[index] < prob) {
            index = r.nextInt(20);
            prob = r.nextDouble();
        }
        return Residue_type.values()[index];
    }

    public static Residue_type getRandomBiasedType_SURFACE() {
        Random r = new Random();
        int index = r.nextInt(20);
        double prob = r.nextDouble();
        while (surface_bias[index] < prob) {
            index = r.nextInt(20);
            prob = r.nextDouble();
        }
        return Residue_type.values()[index];
    }
}

