/*
 * Decompiled with CFR 0.152.
 */
package db_interface;

import data_structures.Atom;
import db_interface.Complex_Structure;
import for_terry.DBStats;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import utils.WebTools;

public class Inserter {
    static final String userdir = System.getProperty("user.dir");
    static final String new_folder = String.valueOf(userdir) + "/protein_database/complex_pairs";
    static final String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
    static final String temp_folder = String.valueOf(userdir) + "/temp_dump";

    public static void main(String[] args) {
        Inserter.insertAntibody("3GJF");
    }

    public static void annotateWithCDR(String pdb_code) {
        Complex_Structure cs = new Complex_Structure(pdb_code);
        if (cs.m1.chains.containsKey(Character.valueOf('H'))) {
            String sequence = cs.m1.chains.get(Character.valueOf('H')).toString();
            String H1 = Inserter.readInSingleCDR(pdb_code.substring(0, 4), "H1");
            int startH1 = sequence.indexOf(H1);
            System.out.println(H1);
            System.out.println(sequence);
            int i = startH1;
            while (i < startH1 + H1.length()) {
                System.out.println(H1);
                System.out.println(sequence);
                for (Atom a : cs.m1.chains.get((Object)Character.valueOf((char)'H')).residues.get((Object)Integer.valueOf((int)i)).atoms) {
                    System.out.println("===============");
                    System.out.println(a.pdb_line);
                    System.out.println(String.valueOf(a.pdb_line.substring(0, 20)) + "C" + a.pdb_line.substring(22));
                    System.out.println("===============");
                }
                ++i;
            }
        }
        cs.m1.chains.containsKey(Character.valueOf('L'));
    }

    public static void insertAntibody(String pdb) {
        HashMap<String, DBStats.PDB_record> map = DBStats.getLHMapping();
        char heavy = map.get((Object)pdb).H;
        char light = map.get((Object)pdb).L;
        String temp = String.valueOf(System.getProperty("user.dir")) + "/temp_dump/temp.txt";
        String pdb_file_out = String.valueOf(temp_folder) + "/antibody/" + pdb + "_AB_A.pdb";
        String pdb_file_annot = String.valueOf(temp_folder) + "/web/" + pdb + "AB_A.pdb";
        String cdr_folder = String.valueOf(temp_folder) + "/cdr";
        if (!new File(String.valueOf(raw_folder) + "/" + pdb + ".pdb").exists()) {
            String url = "http://www.pdb.org/pdb/files/" + pdb + ".pdb";
            WebTools.writeWebPage(String.valueOf(pdb) + ".pdb", raw_folder, url);
        }
        PDB_parser.writeConstrainingPDB(temp, pdb_file_out, heavy, light);
        System.out.println("In this case heavy is: " + heavy);
        ArrayList<Integer> heavy_const = null;
        if (heavy != 'N') {
            heavy_const = Inserter.bindConstrain(pdb, 'H', heavy, light);
        }
        ArrayList<Integer> light_const = null;
        System.out.println("In this case light is: " + light);
        if (light != 'N') {
            light_const = Inserter.bindConstrain(pdb, 'L', heavy, light);
        }
        PDB_parser.writeConstrainingPDB(temp, pdb_file_annot, heavy_const, light_const);
        PDB_parser.writeCDR(pdb_file_annot, pdb, cdr_folder);
    }

    public static ArrayList<Integer> bindConstrain(String pdb_code, char chain, char src_heavy, char src_light) {
        int i;
        String original = String.valueOf(System.getProperty("user.dir")) + "/protein_database/raw_files/" + pdb_code + ".pdb";
        String temp = String.valueOf(System.getProperty("user.dir")) + "/temp_dump/temp.txt";
        PDB_parser.writeConstrainingPDB(original, temp, src_heavy, src_light);
        String chain_seq = PDB_parser.getSequenceFromPDB(temp, chain);
        if (chain_seq == null) {
            return null;
        }
        ArrayList<Integer> constraints = new ArrayList<Integer>();
        String cdr1 = Inserter.readInSingleCDR(pdb_code, String.valueOf(chain) + "1");
        int start = chain_seq.indexOf(cdr1) - 2;
        if (start == -3) {
            i = 0;
            while (i < cdr1.length()) {
                String cdr_tmp = Inserter.removeChar(cdr1, i);
                start = chain_seq.indexOf(cdr_tmp) - 2;
                if (start != -3) break;
                ++i;
            }
        }
        System.out.println("1 want to start: " + start);
        System.out.println(cdr1);
        System.out.println(chain_seq);
        i = start;
        while (i < start + cdr1.length()) {
            constraints.add(i);
            ++i;
        }
        String cdr2 = Inserter.readInSingleCDR(pdb_code, String.valueOf(chain) + "2");
        start = chain_seq.indexOf(cdr2) - 2;
        if (start == -3) {
            int i2 = 0;
            while (i2 < cdr2.length()) {
                String cdr_tmp = Inserter.removeChar(cdr2, i2);
                start = chain_seq.indexOf(cdr_tmp) - 2;
                if (start != -3) break;
                ++i2;
            }
        }
        System.out.println(cdr2);
        System.out.println(chain_seq);
        System.out.println("2 want to start: " + start);
        int i3 = start;
        while (i3 < start + cdr2.length()) {
            constraints.add(i3);
            ++i3;
        }
        String cdr3 = Inserter.readInSingleCDR(pdb_code, String.valueOf(chain) + "3");
        start = chain_seq.indexOf(cdr3) - 2;
        if (start == -3) {
            int i4 = 0;
            while (i4 < cdr3.length()) {
                String cdr_tmp = Inserter.removeChar(cdr3, i4);
                start = chain_seq.indexOf(cdr_tmp) - 2;
                if (start != -3) break;
                ++i4;
            }
        }
        System.out.println(cdr3);
        System.out.println(chain_seq);
        System.out.println("3 want to start: " + start);
        int i5 = start;
        while (i5 < start + cdr3.length()) {
            constraints.add(i5);
            ++i5;
        }
        System.out.println(cdr2);
        return constraints;
    }

    public static String removeChar(String str, int i) {
        if (i == 0) {
            return str.substring(1);
        }
        if (i == str.length() - 1) {
            return str.substring(0, i);
        }
        return String.valueOf(str.substring(0, i)) + str.substring(i + 1);
    }

    public static String readInSingleCDR(String pdb_code, String cdr_code) {
        System.out.println(String.valueOf(pdb_code) + " : " + cdr_code);
        if (pdb_code.equals("3GJF") && cdr_code.equals("H1")) {
            return "GFTFSTYQ";
        }
        if (pdb_code.equals("3GJF") && cdr_code.equals("H2")) {
            return "IVSSGGST";
        }
        if (pdb_code.equals("3GJF") && cdr_code.equals("H3")) {
            return "AGELLPYYGMDV";
        }
        if (pdb_code.equals("3GJF") && cdr_code.equals("L1")) {
            return "SRDVGGYNY";
        }
        if (pdb_code.equals("3GJF") && cdr_code.equals("L2")) {
            return "DVI";
        }
        if (pdb_code.equals("3GJF") && cdr_code.equals("L3")) {
            return "WSFAGSYYV";
        }
        try {
            System.out.println("Attempting to download " + pdb_code + cdr_code);
            String chains = cdr_code.charAt(0) == 'H' ? "H_" : "_L";
            HashMap<String, String> cdr_results = WebTools.downloadCDR(pdb_code, chains);
            String hopefully_cdr = null;
            if (cdr_results != null) {
                hopefully_cdr = cdr_results.get(cdr_code);
            }
            if (hopefully_cdr != null && hopefully_cdr.length() > 0) {
                System.out.println("Success");
                return hopefully_cdr;
            }
            System.out.println("Failure");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        return null;
    }
}

