/*
 * Decompiled with CFR 0.152.
 */
package docking;

import data_structures.Residue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class Auxiliary {
    public static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        Auxiliary.copyOver();
    }

    public static void copyOver() {
        String source = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/H";
        String target = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/newnew_cases";
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("case_1H");
        cases.add("case_part_3H");
        cases.add("case_part_5H");
        cases.add("case_part_7H");
        cases.add("case_part_9H");
        ArrayList<String> pdbs = FileSystemTools.getFolders(source);
        for (String _case : cases) {
            for (String pdb : pdbs) {
                FileSystemTools.CopyFile(String.valueOf(source) + "/" + pdb + "/AB.pdb", String.valueOf(target) + "/" + _case + "/" + pdb + "/AB.pdb");
            }
        }
    }

    public static String calculate_f_nat(String pdb_path) {
        HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(pdb_path) + "/AB.pdb", 'A');
        TreeSet<Integer> ab_sort = new TreeSet<Integer>();
        for (Integer i : ab.keySet()) {
            ab_sort.add(i);
        }
        HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(pdb_path) + "/AG.pdb", 'A');
        TreeSet<Integer> ag_sort = new TreeSet<Integer>();
        for (Integer i : ag.keySet()) {
            ag_sort.add(i);
        }
        String out = "";
        for (Integer ab_i : ab_sort) {
            Residue ab_res = ab.get(ab_i);
            for (Integer ag_i : ag_sort) {
                Residue ag_res = ag.get(ag_i);
                if (!(ag_res.distanceFrom(ab_res) < 4.5)) continue;
                out = String.valueOf(out) + ab_i + " " + ag_i + "\n";
            }
        }
        return out;
    }
}

