/*
 * Decompiled with CFR 0.152.
 */
package utils;

import data_structures.Atom_class;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import utils.FileSystemTools;

public class AAKMeans {
    public static void main(String[] args) {
        double[][] dist = new double[][]{{0.0, 1.0, 1.0, 100.0, 100.0, 100.0, 1.0}, {1.0, 0.0, 1.0, 100.0, 100.0, 100.0, 1.0}, {1.0, 1.0, 0.0, 100.0, 100.0, 100.0, 1.0}, {100.0, 100.0, 100.0, 0.0, 1.0, 1.0, 1.0}, {100.0, 100.0, 100.0, 1.0, 0.0, 1.0, 1.0}, {100.0, 100.0, 100.0, 1.0, 1.0, 0.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0}};
        double[][] dist2 = new double[5][5];
        ArrayList<Integer> cluster_1 = new ArrayList<Integer>();
        cluster_1.add(0);
        cluster_1.add(3);
        ArrayList<Integer> cluster_2 = new ArrayList<Integer>();
        cluster_2.add(2);
        cluster_2.add(1);
        ArrayList<ArrayList<Integer>> clusters = new ArrayList<ArrayList<Integer>>();
        clusters.add(cluster_1);
        clusters.add(cluster_2);
        AAKMeans.IterativeKMeans(3, dist, 10000, true);
    }

    public static void BowMethod(double[][] dist, int ITERATIONS, String filename) {
        String output = "";
        int K = 1;
        while (K <= dist.length) {
            System.out.println("K=" + K + " out of " + dist.length + " >> " + filename);
            double score = AAKMeans.IterativeKMeans(K, dist, ITERATIONS, false);
            output = String.valueOf(output) + K + " " + score + "\n";
            ++K;
        }
        FileSystemTools.writeFile(filename, output);
    }

    public static HashMap<Integer, ArrayList<Integer>> GetClusters(int K, double[][] dist, int ITERATIONS, boolean verbose) {
        verbose = false;
        HashMap<Integer, ArrayList<Integer>> clusters = new HashMap<Integer, ArrayList<Integer>>();
        int improvements = 0;
        double current_score = Double.MAX_VALUE;
        int iteration = 0;
        while (iteration < ITERATIONS) {
            HashMap<Integer, ArrayList<Integer>> new_clustering;
            double new_score;
            if (verbose) {
                System.out.println("Iteration " + (iteration + 1) + "/" + ITERATIONS);
            }
            if ((new_score = AAKMeans.score(new_clustering = AAKMeans.singleKMeans(K, dist), dist)) < current_score) {
                current_score = new_score;
                clusters = new_clustering;
                if (verbose) {
                    System.out.println("================");
                    System.out.println("Improvement! " + ++improvements);
                    for (int clust_i : clusters.keySet()) {
                        System.out.println("Cluster " + clust_i);
                        for (Integer c_i : clusters.get(clust_i)) {
                            System.out.print((Object)((Object)Atom_class.values()[c_i]) + " ; ");
                        }
                        System.out.println();
                    }
                    System.out.println("================");
                }
            }
            ++iteration;
        }
        if (verbose) {
            System.out.println("Final Clustering:");
            for (int clust_i : clusters.keySet()) {
                System.out.println("Cluster " + clust_i);
                for (Integer c_i : clusters.get(clust_i)) {
                    System.out.print((Object)((Object)Atom_class.values()[c_i]) + " ; ");
                }
                System.out.println();
            }
            System.out.println("================");
        }
        return clusters;
    }

    public static double IterativeKMeans(int K, double[][] dist, int ITERATIONS, boolean verbose) {
        HashMap<Object, Object> clusters = new HashMap();
        int improvements = 0;
        double current_score = Double.MAX_VALUE;
        int iteration = 0;
        while (iteration < ITERATIONS) {
            HashMap<Integer, ArrayList<Integer>> new_clustering;
            double new_score;
            if (verbose) {
                System.out.println("Iteration " + (iteration + 1) + "/" + ITERATIONS);
            }
            if ((new_score = AAKMeans.score(new_clustering = AAKMeans.singleKMeans(K, dist), dist)) < current_score) {
                current_score = new_score;
                clusters = new_clustering;
                if (verbose) {
                    System.out.println("================");
                    System.out.println("Improvement! " + ++improvements);
                    Iterator<Object> iterator = clusters.keySet().iterator();
                    while (iterator.hasNext()) {
                        int clust_i = (Integer)iterator.next();
                        System.out.println("Cluster " + clust_i);
                        for (Integer c_i : (ArrayList)clusters.get(clust_i)) {
                            System.out.print((Object)((Object)Atom_class.values()[c_i]) + " ; ");
                        }
                        System.out.println();
                    }
                    System.out.println("================");
                }
            }
            ++iteration;
        }
        if (verbose) {
            System.out.println("Final Clustering:");
            Iterator iterator = clusters.keySet().iterator();
            while (iterator.hasNext()) {
                int clust_i = (Integer)iterator.next();
                System.out.println("Cluster " + clust_i);
                for (Integer c_i : (ArrayList)clusters.get(clust_i)) {
                    System.out.print((Object)((Object)Atom_class.values()[c_i]) + " ; ");
                }
                System.out.println();
            }
            System.out.println("================");
        }
        return current_score;
    }

    public static HashMap<Integer, ArrayList<Integer>> singleKMeans(int K, double[][] dist) {
        int CAP = 1000;
        if (K > dist.length) {
            System.err.println("K=" + K + " is bigger than the number of elements=" + dist.length);
            System.exit(0);
        }
        if (dist.length != dist[0].length) {
            System.err.println("Distance matrix dimensions do not agree: " + dist.length + "x" + dist[0].length);
            System.exit(0);
        }
        HashMap<Integer, ArrayList<Integer>> clusters = new HashMap<Integer, ArrayList<Integer>>();
        int i = 0;
        while (i < K) {
            clusters.put(i, new ArrayList());
            ++i;
        }
        ArrayList<Integer> elems = new ArrayList<Integer>();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        int i2 = 0;
        while (i2 < dist.length) {
            elems.add(i2);
            ++i2;
        }
        int curr = 0;
        Random r = new Random();
        while (elems.size() > 0) {
            if (curr == K) {
                curr = 0;
            }
            int index = 0;
            if (elems.size() > 1) {
                index = r.nextInt(elems.size());
            }
            int element = (Integer)elems.get(index);
            elems.remove(index);
            map.put(element, curr);
            clusters.get(curr++).add(element);
        }
        boolean change = true;
        while (change && CAP > 0) {
            change = false;
            --CAP;
            int elem = 0;
            while (elem < dist.length) {
                double best_dist = AAKMeans.distanceTo(clusters.get(map.get(elem)), elem, dist);
                int best_clust = (Integer)map.get(elem);
                for (Integer i3 : clusters.keySet()) {
                    ArrayList<Integer> cluster;
                    double new_dist;
                    if (i3 == map.get(elem) || !((new_dist = AAKMeans.distanceTo(cluster = clusters.get(i3), elem, dist)) < best_dist)) continue;
                    best_dist = new_dist;
                    best_clust = i3;
                }
                if (best_clust != (Integer)map.get(elem)) {
                    change = true;
                    int to_remove = (Integer)map.get(elem);
                    clusters.get(to_remove).remove(clusters.get(to_remove).indexOf(elem));
                    clusters.get(best_clust).add(elem);
                    map.put(elem, best_clust);
                }
                ++elem;
            }
            for (int clust_i : clusters.keySet()) {
                if (clusters.get(clust_i).size() != 0) continue;
                System.err.println("Zero cluster!");
                System.exit(0);
            }
        }
        return clusters;
    }

    public static double score(HashMap<Integer, ArrayList<Integer>> clusters, double[][] dist) {
        double sum = 0.0;
        for (Integer c_i : clusters.keySet()) {
            ArrayList<Integer> cluster = clusters.get(c_i);
            double temp_sum = 0.0;
            for (Integer c_i_1 : cluster) {
                for (Integer c_i_2 : cluster) {
                    if (c_i_1 == c_i_2) continue;
                    temp_sum += dist[c_i_1][c_i_2];
                }
            }
            temp_sum /= 2.0;
            sum += (temp_sum /= (double)cluster.size());
        }
        return sum / (double)clusters.size();
    }

    public static double distanceTo(ArrayList<Integer> cluster, int i_from, double[][] dist) {
        double sum = 0.0;
        for (int i : cluster) {
            sum += dist[i][i_from];
        }
        if (cluster.contains(i_from)) {
            if (cluster.size() == 1) {
                return 0.0;
            }
            return sum / (double)(cluster.size() - 1);
        }
        return sum / (double)cluster.size();
    }
}

