/*
 * Decompiled with CFR 0.152.
 */
package DockSorter;

import data_structures.Residue;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class DockSorterGlobal {
    private static final String userdir = System.getProperty("user.dir");
    private static final double[][] prop_mat = new double[][]{{0.05465194673858082, 0.056473769133487416, 0.06396276162885323, 0.0, 0.07238435070727667, 0.07187039002044567, 0.044342784672524685, 0.02969547947796482, 0.07228239069394304, 0.02328607322325915, 0.041751217532467536, 0.022358050506675244, 0.047875754075214993, 0.028353808353808355, 0.03581460674157303, 0.053033855387789555, 0.006079587324981577, 0.12473057820260519, 0.03484118227745195, 0.03220409870347135}, {0.06152864209350566, 0.026784364131256615, 0.037738879074995985, 0.006522093592043046, 0.03725259012116499, 0.01830730693385919, 0.05819611176033146, 0.055729859080031904, 0.034086715867158675, 0.013200874659179872, 0.054936089203154743, 0.08054447719784984, 0.025735024561918028, 0.041509944527127585, 0.03830677245549822, 0.04109705357900993, 0.005268903973038402, 0.06394676741759946, 0.03461922418710781, 0.04777874384134476}, {0.058853874281205906, 0.04663663127843697, 0.012456930824277764, 0.00648508430609598, 0.03317929452441903, 0.021515955171528788, 0.05115026163420751, 0.07396429774334792, 0.03022354694485842, 0.05335462072550403, 0.06469711858496846, 0.033785852812085335, 0.08160436791264175, 0.02935939690116301, 0.036417745597349206, 0.03218269768666294, 0.015676407973679116, 0.03414587270572408, 0.020607424071991003, 0.023434343434343436}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0035400020228582986, 0.04393196285088177, 0.014337458496830668, 0.0, 0.002998765214323514, 0.0, 0.011217419993401518, 0.0, 0.012308839985080195, 0.016324511501360377, 0.0387285745280972, 0.009022556390977444, 0.07407407407407407, 0.011065573770491803, 0.045495093666369314, 0.08100686498855836, 0.0, 0.0, 0.0, 0.07042682926829268}, {0.11178461383037834, 0.07415560294421132, 0.019574755315558554, 0.0, 0.03579817720567509, 0.0025988236903296403, 0.059931506849315065, 0.009328782707622298, 0.012021453671167005, 0.015302404663589992, 0.048334227307944455, 0.004467912266450041, 0.051644064647965816, 0.010568852968604289, 0.056553911205074, 0.043405014369239915, 0.15284142988084326, 0.030120481927710843, 0.006172839506172839, 0.0077534405892614846}, {0.04923978574688348, 0.02323969134313962, 0.029381045365787204, 0.02557883131201764, 0.04831940575673166, 0.0420102080879466, 0.04170209750566893, 0.06287028647103925, 0.06254130369480325, 0.015043933611431614, 0.042625691140542626, 0.09124589816873081, 0.055981920052733176, 0.05217186949199013, 0.023964676138589183, 0.04840313407310186, 0.02937546284867934, 0.05397041319503486, 0.03278178328751491, 0.035307598653584474}, {0.0324897778760084, 0.054471091280907234, 0.07944286819705958, 0.0, 0.07163944105491045, 0.05443719875248086, 0.07128917460681897, 0.08991381318425344, 0.1029191616766467, 0.031449154890551397, 0.04846822130772748, 0.18544474393530996, 0.05948637316561845, 0.10943833236826868, 0.022314239705544053, 0.11560350960398387, 0.15001079214331967, 0.1191919191919192, 0.06847308678139875, 0.01769041769041769}, {0.03537304330148404, 0.006085878507832751, 0.012504665920119448, 0.0, 0.043579931972789115, 0.0769923457901846, 0.009281324470086541, 0.0, 0.07203502255240117, 0.07718331036211001, 0.11947608200455581, 0.22667306308467258, 0.2788756388415673, 0.0, 0.02480192903892525, 0.032473850644612015, 0.14460562103354488, 0.07208221878079685, 0.07109574627987374, 0.0}, {0.06086405854207712, 0.014182568334192883, 0.018665474460713087, 0.0, 0.04845679012345679, 0.05676218288008761, 0.042603317954255426, 0.02528216704288939, 0.0818594459226796, 0.17024661893396978, 0.037127592139817076, 0.23430232558139535, 0.07464439514550437, 0.04727753137680476, 0.07918739635157546, 0.008064516129032258, 0.1583043550256665, 0.11999325406863985, 0.08390941597139452, 0.01179122594069707}, {0.019555014774900053, 0.02407667134174848, 0.01927413293246, 0.0, 0.004109964380308704, 0.09416749750747756, 0.042407234175241657, 0.03209502148091989, 0.04056351712411951, 0.0593672698867335, 0.04276479363500746, 0.019762845849802372, 0.0, 0.04670644939178334, 0.06838524883637666, 0.05437191068689279, 0.16557575757575757, 0.02589889640441438, 0.0033719989209603455, 0.0}, {0.030072463768115943, 0.0, 0.0, 0.4113345521023766, 0.0, 0.0, 0.0, 0.07719714964370546, 0.1291248206599713, 0.0, 0.03646112600536193, 0.22762148337595908, 0.0, 0.037579306979014154, 0.0062836624775583485, 0.011276681433749497, 0.0, 0.08608414239482201, 0.0, 0.0}, {0.0557740300990698, 0.013114112350753573, 0.050468198954152985, 0.03205479452054794, 0.08196949325420742, 0.06180099158307391, 0.11936497155955514, 0.11501126038673604, 0.08865509123013537, 0.10519967259725153, 0.07657182999648753, 0.08789089406254305, 0.13693131132917039, 0.06546675370698499, 0.04257561869844179, 0.02274946299550869, 0.047373637264618434, 0.02655349280559212, 0.0634856682398987, 0.07411476379616327}, {0.058912037037037034, 0.00410958904109589, 0.005779531998872286, 0.0, 0.044076163610719324, 0.0015429934072099874, 0.019498104350965877, 0.11911191119111911, 0.06086764054891545, 0.029858657243816256, 0.014559018168692095, 0.11248966087675766, 0.15695952615992104, 0.018642012731130645, 0.055200269269606195, 0.05084994138335287, 0.04933028422084286, 0.081104033970276, 0.014369256474519632, 7.49063670411985E-4}, {0.04296268187693439, 0.036099250156217455, 0.06766637089618456, 0.0, 0.057274726073446844, 0.05089509080866825, 0.042579261755245824, 0.031353002652946375, 0.010594864527448797, 0.025507342708181877, 0.02204859252916622, 0.07135909905298182, 0.07221588749524896, 0.035913061141580334, 0.024341182549641988, 0.0653259456871195, 0.05056845923135942, 0.041707452831999385, 0.008245341997095671, 0.012404036340474035}, {0.04060617381964227, 0.03428208386277001, 0.045724907063197026, 0.019961977186311788, 0.0405852417302799, 0.03774850591535553, 0.03859180616166222, 0.04231173380035026, 0.05190586675505469, 0.03730321697467488, 0.025524511840465308, 0.15373219373219374, 0.058189357290946785, 0.032173088405746196, 0.029293615969346765, 0.06295579699360024, 0.03489490314603654, 0.0667184828229442, 0.026696872778962332, 0.016443222184026583}, {0.07366926622454735, 0.05576971956282301, 0.034834767706121234, 0.09958452350038952, 0.11131947363315982, 0.06256163464952073, 0.04949474580448567, 0.0920632718190648, 0.044869336547416865, 0.02062032525904069, 0.09459678289970852, 0.16905090407377824, 0.047585040405938736, 0.07370947649864795, 0.059756474789797814, 0.0709829767736933, 0.06600405963463288, 0.1608565438754118, 0.06950759035216152, 0.061959252023444045}, {0.0716482852732601, 0.04426890691436327, 0.062450349793711404, 4.19639110365086E-4, 0.042364000375387116, 0.04385232905519302, 0.06643479701053764, 0.06854649800890138, 0.06209556993529119, 0.06271137522478853, 0.06253944694515921, 0.04350107113190224, 0.05552811979476191, 0.07408599711733331, 0.06531658443396875, 0.04270944052565465, 0.0979912088541443, 0.033202692879041686, 0.031464247543077604, 0.04592099771683893}, {0.0394704281118535, 0.02214968524131499, 0.03095632946379215, 0.0, 0.037204162445897415, 0.09627699989145773, 0.09661121380160197, 0.08643617021276596, 0.047619047619047616, 0.12433214603739982, 0.04436308818778938, 0.19576217583807717, 0.18021806853582553, 0.09676100950240114, 0.008933333333333333, 0.08708769106999195, 0.13317619328226282, 0.11251336898395722, 0.07294794794794794, 0.02123334086288683}, {0.06435385949696444, 0.022902796271637816, 0.03892123812442538, 0.0, 0.06175115207373272, 0.020823970037453184, 0.036695278969957085, 0.02933488237002614, 0.04436955911260882, 0.1133861309638787, 0.024045067326188514, 0.12719703977798336, 0.07578155916106055, 0.07841752031084423, 0.013391362571141614, 0.021307982297983936, 0.03216879972327914, 0.1095890410958904, 0.038314176245210725, 0.012588116817724069}};

    public static void main(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals("-h") || s.equals("--help")) {
                DockSorterGlobal.printUsage();
            }
            ++n2;
        }
        HashMap<String, String> options = DockSorterGlobal.readInOptions(args);
        HashMap<Character, HashMap<Integer, Residue>> ab_struc = DockSorterGlobal.ChainAvailability(options, "b");
        HashMap<Character, HashMap<Integer, Residue>> ag_struc = DockSorterGlobal.ChainAvailability(options, "g");
        HashMap<Character, ArrayList<Integer>> ab_constr = null;
        if (options.get("-constab").length() > 0) {
            ab_constr = DockSorterGlobal.CheckConstraints(options, "b", ab_struc);
        }
        HashMap<Character, ArrayList<Integer>> ag_constr = null;
        if (options.get("-constag").length() > 0) {
            ag_constr = DockSorterGlobal.CheckConstraints(options, "g", ag_struc);
        }
        double sum = 0.0;
        int total_sums = 0;
        for (Character chain_ag : ag_struc.keySet()) {
            for (Character chain_ab : ab_struc.keySet()) {
                HashMap<Integer, Residue> ab = ab_struc.get(chain_ab);
                HashMap<Integer, Residue> ag = ag_struc.get(chain_ag);
                for (Integer i_ab : ab.keySet()) {
                    for (Integer i_ag : ag.keySet()) {
                        if (ab_constr != null && ab_constr.containsKey(chain_ab)) {
                            System.out.println("By constraint");
                            if (!ab_constr.get(chain_ab).contains(i_ab)) continue;
                        }
                        if (ag_constr != null && ag_constr.containsKey(chain_ag) && !ag_constr.get(chain_ag).contains(i_ag) || !(ab.get(i_ab).distanceFrom(ag.get(i_ag)) < 4.5)) continue;
                        sum += prop_mat[ab.get((Object)i_ab).type.ordinal()][ag.get((Object)i_ag).type.ordinal()];
                        ++total_sums;
                    }
                }
            }
        }
        System.out.println(sum);
    }

    public static void printUsage() {
        System.out.println("Usage:");
        System.out.println("java -jar DockSorter.jar -abf [antibody file] -agf [antigen file] -abc [antibody chain(s)] -agc [antigen chain(s)] -constab [constraint file for antibody] -constag [constraint file for antigen]");
        System.out.println("The constraint files are optional - if not provided the calcualation will involve all interface (<4.5A apart) residues");
        System.out.println("The decoys should be sorted in descending order by the output of this program (ie highest score decoys are 'the best')");
        System.out.println("Since the command is fairly long, it is strongly suggested that the user adapts the example distributed with program at http://www.stats.ox.ac.uk/research/proteins/resources");
        System.exit(0);
    }

    public static HashMap<Character, ArrayList<Integer>> CheckConstraints(HashMap<String, String> options, String abag, HashMap<Character, HashMap<Integer, Residue>> struc) {
        ArrayList<String> constr = FileSystemTools.readFile(String.valueOf(userdir) + options.get("-consta" + abag));
        HashMap<Character, ArrayList<Integer>> constr_map = new HashMap<Character, ArrayList<Integer>>();
        for (String line : constr) {
            ArrayList<Integer> temp;
            char chain;
            if (!line.contains(" ")) {
                System.out.println("The constraints file " + options.get("-consta" + abag) + " appears to be badly formatted. Check line: \n" + line);
            }
            Integer res_id = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            String chain_part = line.substring(line.indexOf(" ") + 1);
            if (chain_part.length() > 1) {
                System.out.println("The constraints file " + options.get("-consta" + abag) + " appears to be badly formatted. Check line: \n" + line);
            }
            if (!struc.containsKey(Character.valueOf(chain = chain_part.charAt(0)))) {
                System.out.println("The constraint file for  " + (abag.equals("b") ? "antibody" : "antigen") + ", contains a chain " + chain + " which was not specified as one of the chains of the structure. Stopping");
                DockSorterGlobal.printUsage();
            }
            if (!struc.get(Character.valueOf(chain)).containsKey(res_id)) {
                System.out.println("The constraint file for  " + (abag.equals("b") ? "antibody" : "antigen") + ", lists residue " + res_id + " on chain " + chain + " - there is no such residue on this chain in the structure. Stopping");
                DockSorterGlobal.printUsage();
            }
            if (constr_map.containsKey(Character.valueOf(chain))) {
                temp = constr_map.get(Character.valueOf(chain));
                temp.add(res_id);
                constr_map.put(Character.valueOf(chain), temp);
                continue;
            }
            if (!constr_map.containsKey(Character.valueOf(chain))) continue;
            temp = new ArrayList();
            temp.add(res_id);
            constr_map.put(Character.valueOf(chain), temp);
        }
        return constr_map;
    }

    public static HashMap<Character, HashMap<Integer, Residue>> ChainAvailability(HashMap<String, String> options, String abag) {
        HashMap<Character, HashMap<Integer, Residue>> struc = new HashMap<Character, HashMap<Integer, Residue>>();
        String chains = PDB_parser.getChains(String.valueOf(userdir) + options.get("-a" + abag + "f"));
        System.out.println("Chains found in the " + (abag.equals("b") ? "antibody" : "antigen") + " file: " + chains);
        int i = 0;
        while (i < options.get("-a" + abag + "c").length()) {
            String chain = String.valueOf(options.get("-a" + abag + "c").charAt(i));
            if (!chains.contains(chain)) {
                System.out.println("The " + (abag.equals("b") ? "antibody" : "antigen") + " file does not have chain " + chain + " - Stopping");
                DockSorterGlobal.printUsage();
            } else {
                HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(userdir) + options.get("-a" + abag + "f"), chain.charAt(0));
                if (ab.size() < 5) {
                    System.out.println("The " + (abag.equals("b") ? "antibody" : "antigen") + " you provided appears incomplete - size of chain " + chain + " is " + ab.size() + ". Stopping");
                    DockSorterGlobal.printUsage();
                }
                if (!struc.containsKey(Character.valueOf(chain.charAt(0)))) {
                    struc.put(Character.valueOf(chain.charAt(0)), ab);
                } else {
                    System.out.println("You have supplied multiple instances of one chain for the " + (abag.equals("b") ? "antibody" : "antigen") + " : " + chain.charAt(0));
                    DockSorterGlobal.printUsage();
                }
            }
            ++i;
        }
        for (Character chain : struc.keySet()) {
            System.out.println("Chain " + chain + " of the " + (abag.equals("b") ? "antibody" : "antigen") + "; size = " + struc.get(chain).size());
        }
        return struc;
    }

    public static HashMap<String, String> readInOptions(String[] args) {
        System.out.println("Listing the arguments:");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("-agf", "");
        options.put("-abf", "");
        options.put("-agc", "");
        options.put("-abc", "");
        options.put("-constab", "");
        options.put("-constag", "");
        int i = 0;
        while (i < args.length) {
            String opt;
            if (i == args.length) {
                System.err.println("Not enough arguments supplied");
                DockSorterGlobal.printUsage();
            }
            if (!options.containsKey(opt = args[i])) {
                System.err.println("Unknown option : " + opt);
                DockSorterGlobal.printUsage();
            }
            if (i == args.length - 1) {
                System.err.println("Not enough arguments supplied");
                DockSorterGlobal.printUsage();
            }
            String input = args[i + 1];
            ++i;
            options.put(opt, input);
            ++i;
        }
        System.out.println("Executing with options:");
        for (String opt : options.keySet()) {
            File f;
            if (options.get(opt).length() == 0 && !opt.contains("-cons")) {
                System.err.println(String.valueOf(opt) + " uninitialized");
                DockSorterGlobal.printUsage();
                continue;
            }
            System.out.println(String.valueOf(opt) + " : " + options.get(opt));
            if (opt.equals("-agc") || opt.equals("-abc") || (f = new File(String.valueOf(userdir) + "/" + options.get(opt))).exists()) continue;
            System.out.println("The file " + options.get(opt) + " doesn't exist - Stopping");
            DockSorterGlobal.printUsage();
        }
        return options;
    }
}

