/*
 * Decompiled with CFR 0.152.
 */
package abModels;

import data_structures.Atom;
import data_structures.MSA;
import data_structures.Residue;
import data_structures.Residue_type;
import data_structures.SC_Structure;
import data_structures.SequencePair;
import db_interface.Controller;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.TreeSet;
import main.Main_inter;
import main.Main_inter_lite;
import main.Main_outer;
import main.ResultWriter;
import parsing.PDB_parser;
import propensity.FrequencyCalculator;
import utils.FileSystemTools;

public class ModelAnalyzer {
    public static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
    }

    public static void ab_lite_runFULLH3TOPN(String method) {
        double max_tmp;
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = false;
        double max = 0.0;
        Controller.createNewTestSetNoSplit();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/ABModelsFULLH3";
        String results = "TestResults/ABModelsFULLH3TOPN" + method;
        File f = new File(String.valueOf(userdir) + "/" + results);
        if (!f.exists()) {
            f.mkdir();
        }
        if ((max_tmp = ModelAnalyzer.analyzeABModelTOPN(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only)) > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static void ab_lite_runCDRH3TOPN(String method) {
        double max_tmp;
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = true;
        double max = 0.0;
        Controller.createNewTestSetNoSplit();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/ABModelsCDRH3";
        String results = "TestResults/ABModelsCDRH3TOPN" + method;
        File f = new File(String.valueOf(userdir) + "/" + results);
        if (!f.exists()) {
            f.mkdir();
        }
        if ((max_tmp = ModelAnalyzer.analyzeABModelTOPN(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only)) > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static void ab_lite_runCDRTOPN(String method) {
        double max_tmp;
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = true;
        double max = 0.0;
        Controller.createNewTestSetNoSplit();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/ABControl";
        String results = "TestResults/ABControlCDRTOPN" + method;
        File f = new File(String.valueOf(userdir) + "/" + results);
        if (!f.exists()) {
            f.mkdir();
        }
        if ((max_tmp = ModelAnalyzer.analyzeABTOPN(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only)) > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static void ab_lite_runModelCDRTOPN(String method) {
        double max_tmp;
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = true;
        double max = 0.0;
        Controller.createNewTestSetNoSplit();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/ABModels";
        String results = "TestResults/ABModelsCDRTOPN" + method;
        File f = new File(String.valueOf(userdir) + "/" + results);
        if (!f.exists()) {
            f.mkdir();
        }
        if ((max_tmp = ModelAnalyzer.analyzeABModelTOPN(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only)) > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static void ab_lite_runTOPN(String method) {
        double max_tmp;
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = false;
        double max = 0.0;
        Controller.createNewTestSetNoSplit();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/ABControl";
        String results = "TestResults/ABControlTOPN" + method;
        File f = new File(String.valueOf(userdir) + "/" + results);
        if (!f.exists()) {
            f.mkdir();
        }
        if ((max_tmp = ModelAnalyzer.analyzeABTOPN(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only)) > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static void ab_lite_runModelTOPN(String method) {
        double max_tmp;
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = false;
        double max = 0.0;
        Controller.createNewTestSetNoSplit();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/ABModels";
        String results = "TestResults/ABModelsTOPN" + method;
        File f = new File(String.valueOf(userdir) + "/" + results);
        if (!f.exists()) {
            f.mkdir();
        }
        if ((max_tmp = ModelAnalyzer.analyzeABModelTOPN(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only)) > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static void ab_lite_runModel2TOPN(String method) {
        double max_tmp;
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = false;
        double max = 0.0;
        Controller.createNewTestSetNoSplit();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/ABModelsNS";
        String results = "TestResults/ABModelsNSTOPN" + method;
        File f = new File(String.valueOf(userdir) + "/" + results);
        if (!f.exists()) {
            f.mkdir();
        }
        if ((max_tmp = ModelAnalyzer.analyzeABModelTOPN(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only)) > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static void ab_lite_runFULLH3(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = false;
        double max = 0.0;
        Controller.createNewTestSetNoSplit();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/ABModelsFULLH3";
        String results = "TestResults/ABModelsFULLH3" + method;
        double max_tmp = ModelAnalyzer.analyzeABModel(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only);
        if (max_tmp > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static void ab_lite_runCDRH3(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = true;
        double max = 0.0;
        Controller.createNewTestSetNoSplit();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/ABModelsCDRH3";
        String results = "TestResults/ABModelsCDRH3" + method;
        double max_tmp = ModelAnalyzer.analyzeABModel(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only);
        if (max_tmp > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static void ab_lite_runCDRDocking(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = true;
        double max = 0.0;
        Controller.createNewTestSetNoSplit();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/ABControl_docking";
        String results = "TestResults/ABControl_docking" + method;
        double max_tmp = ModelAnalyzer.analyzeABPonom(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only);
        if (max_tmp > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static void ab_lite_runCDRDockingPonom(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = true;
        double max = 0.0;
        Controller.createNewTestSetNoSplitPonom();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/case_5R";
        String results = "TestResults/case_5R" + method;
        double max_tmp = ModelAnalyzer.analyzeABPonomDOCK(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only);
        if (max_tmp > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static void ab_lite_runCDRDockingTOPN(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = true;
        double max = 0.0;
        Controller.createNewTestSetNoSplit();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/ABControl_docking";
        String results = "TestResults/ABControlCDRTOPN_docking" + method;
        double max_tmp = ModelAnalyzer.analyzeABModelTOPNDocking(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only);
        if (max_tmp > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static void case_runner(String method, String _case) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = true;
        double max = 0.0;
        Controller.createNewTestSetNoSplit();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/" + _case;
        String results = "TestResults/" + _case + method;
        double max_tmp = ModelAnalyzer.analyzeABDocking(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only);
        if (max_tmp > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static void case_runnerTOPN(String method, String _case) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = true;
        double max = 0.0;
        Controller.createNewTestSetNoSplit();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/" + _case;
        String results = "TestResults/" + _case + "_TOPN_" + method;
        double max_tmp = ModelAnalyzer.analyzeABModelTOPNDocking(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only);
        if (max_tmp > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static void ab_lite_runCDR(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = true;
        double max = 0.0;
        Controller.createNewTestSetNoSplit();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/ABControl";
        String results = "TestResults/ABControlCDR" + method;
        double max_tmp = ModelAnalyzer.analyzeAB(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only);
        if (max_tmp > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static void ab_lite_runModelCDR(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = true;
        double max = 0.0;
        Controller.createNewTestSetNoSplit();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/ABModels";
        String results = "TestResults/ABModelsCDR" + method;
        double max_tmp = ModelAnalyzer.analyzeABModel(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only);
        if (max_tmp > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static void abPonom(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = true;
        double max = 0.0;
        Controller.createNewTestSetNoSplitPonom();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/ABPonom";
        String results = "TestResults/ABPonom" + method;
        double max_tmp = ModelAnalyzer.analyzeABPonom(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only);
        if (max_tmp > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static resStr abPonomND(String name, String method, String f1, String f2, String dataset) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = false;
        double max = 0.0;
        FrequencyCalculator.initializeResiduesTriangleCustom("ab", "recalc_data_protein");
        FrequencyCalculator.initializeResiduesTriangleCustom("ag", "recalc_data_protein");
        String results = String.valueOf(userdir) + "/result_dump/DP_recalculation/Test_res/" + dataset;
        resStr res = ModelAnalyzer.AbIpatchCore(dataset, name, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only, f1, f2);
        System.out.println("Done");
        return res;
    }

    public static void abPonomRelease(String method, String f1, String f2, String psa_ab, String psa_ag, String out_folder) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = false;
        double max = 0.0;
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/ABPonom";
        String results = "TestResults/ABPonom" + method;
        double max_tmp = ModelAnalyzer.analyzeABPonomRelease(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only, f1, f2, psa_ab, psa_ag, out_folder);
        System.out.println("Done");
    }

    public static void ab_lite_run(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = false;
        double max = 0.0;
        Controller.createNewTestSetNoSplit();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/ABControl";
        String results = "TestResults/ABControl" + method;
        double max_tmp = ModelAnalyzer.analyzeAB(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only);
        if (max_tmp > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static void ab_lite_runModel(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = false;
        double max = 0.0;
        Controller.createNewTestSetNoSplit();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/ABModels";
        String results = "TestResults/ABModels" + method;
        double max_tmp = ModelAnalyzer.analyzeABModel(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only);
        if (max_tmp > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static void ab_lite_runModel2(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        boolean cdr_only = false;
        double max = 0.0;
        Controller.createNewTestSetNoSplit();
        FrequencyCalculator.initializeResiduesTriangle("ab");
        FrequencyCalculator.initializeResiduesTriangle("ag");
        String scramble_run = "/Tests/ABModelsNS";
        String results = "TestResults/ABModelsNS" + method;
        double max_tmp = ModelAnalyzer.analyzeABModel(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, 0, cdr_only);
        if (max_tmp > max) {
            max = max_tmp;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static double analyzeABPonom(String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method, boolean constrain_msa, int test_id, boolean cdr_only) {
        double maxTP = 0.0;
        double max_c = -1.0;
        double min_c = 100.0;
        int test_ind = 1;
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/test_ponom.txt");
        int total_cdrs = 0;
        int total_contacts = 0;
        int total_recall = 0;
        double t_start = System.currentTimeMillis();
        ArrayList<HashMap<Double, Integer>> TPs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> FPs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> TNs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> FNs = new ArrayList<HashMap<Double, Integer>>();
        int progress = 0;
        for (String test_pdb : pdbcodes) {
            Residue res_central;
            test_pdb = test_pdb.substring(0, 4);
            test_pdb = test_pdb.replace("_AB", "");
            String tpstring = "";
            String fpstring = "";
            String tnstring = "";
            String fnstring = "";
            System.out.println("Sample " + test_id + ": " + scramble_run + "/" + test_pdb + " [" + ++progress + "/" + pdbcodes.size() + "]");
            HashMap<Double, Integer> TP_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> FP_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> TN_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> FN_s = new HashMap<Double, Integer>();
            String testFolder = String.valueOf(scramble_run) + "/" + test_pdb;
            String pdb_file1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/strA.pdb";
            String pdb_file2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/strB.pdb";
            ArrayList<Integer> roi_1 = new ArrayList<Integer>();
            ArrayList<Integer> roi_2 = new ArrayList<Integer>();
            int lll = 0;
            while (lll < 9999) {
                roi_1.add(lll);
                roi_2.add(lll);
                ++lll;
            }
            Residue_type[] first = ModelAnalyzer.getNewSequence(pdb_file1, roi_1, 'A', System.getProperty("user.dir"), true);
            Residue_type[] second = ModelAnalyzer.getNewSequence(pdb_file2, roi_2, 'A', System.getProperty("user.dir"), false);
            SequencePair sp = new SequencePair(first, second, 0);
            ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
            sp_arr.add(sp);
            MSA msa = new MSA(sp_arr);
            SC_Structure strA = Main_outer.structureAndMSA(pdb_file1, msa, 0, true, roi_1, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only, null);
            SC_Structure strB = Main_outer.structureAndMSA(pdb_file2, msa, 0, false, roi_2, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only, null);
            Main_inter mi = use_full_alignment ? new Main_inter(msa, strA, strB) : new Main_inter_lite(msa, strA, strB, true);
            strA = ModelAnalyzer.calculateNeighborsAWrite(strA, strB);
            strB = ModelAnalyzer.calculateNeighborsBWrite(strA, strB);
            String out_singles = "";
            TreeSet<Integer> sorted = new TreeSet<Integer>();
            for (Integer ab_i : strA.residues.keySet()) {
                sorted.add(ab_i);
            }
            for (Integer str_i : sorted) {
                res_central = strA.residues.get(str_i);
                out_singles = String.valueOf(out_singles) + str_i + " " + (Object)((Object)res_central.type) + " " + res_central.getTPro() + " " + res_central.isCDR + "\n";
                if (!(maxTP < res_central.getTPro())) continue;
                maxTP = res_central.getTPro();
            }
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/Alanine_scanning/single_tpro/" + test_pdb, out_singles);
            for (Integer str_i : strB.residues.keySet()) {
                res_central = strB.residues.get(str_i);
                if (!(maxTP < res_central.getTPro())) continue;
                maxTP = res_central.getTPro();
            }
            String outname_1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_1";
            String outname_2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_2";
            String folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
            File f1 = new File(folder);
            f1.mkdir();
            FileSystemTools.CopyFile(outname_1, String.valueOf(folder) + "/str.pdb");
            folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
            File f2 = new File(folder);
            f2.mkdir();
            FileSystemTools.CopyFile(outname_2, String.valueOf(folder) + "/str.pdb");
            String over_w1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultA.pdb";
            String over_w2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultB.pdb";
            double[] res = PDB_parser.writeResultPDB(strA, outname_1, over_w1, true);
            if (res[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            if ((res = PDB_parser.writeResultPDB(strB, outname_2, over_w2, false))[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            for (Integer res_i : strA.residues.keySet()) {
                if (strA.residues.get((Object)res_i).isCDR) {
                    ++total_cdrs;
                }
                if (strA.residues.get((Object)res_i).isCDR && strA.residues.get((Object)res_i).isContact) {
                    ++total_contacts;
                }
                if (!strA.residues.get((Object)res_i).isContact) continue;
                ++total_recall;
            }
            double cutoff = 0.0;
            while (cutoff < 150.0) {
                ArrayList<Integer> forB;
                ArrayList<Integer> forA;
                if (cdr_only) {
                    forA = PDB_parser.writePDBHalfCDR(test_pdb, strA, true, cutoff, method);
                    forB = PDB_parser.writePDBHalf(strB, false, cutoff, method);
                } else {
                    forA = PDB_parser.writePDBHalf(strA, true, cutoff, method);
                    forB = PDB_parser.writePDBHalf(strB, false, cutoff, method);
                }
                TP_s.put(cutoff, forA.get(0));
                FP_s.put(cutoff, forA.get(1));
                TN_s.put(cutoff, forA.get(2));
                FN_s.put(cutoff, forA.get(3));
                cutoff += 0.1;
            }
            TPs.add(TP_s);
            FPs.add(FP_s);
            TNs.add(TN_s);
            FNs.add(FN_s);
        }
        System.out.println(max_c);
        System.out.println(min_c);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TP" + test_id, TPs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FP" + test_id, FPs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FN" + test_id, FNs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TN" + test_id, TNs);
        System.out.println("Program takes: " + ((double)System.currentTimeMillis() - t_start) / 1000.0 / (double)pdbcodes.size() + "s/test on average over " + pdbcodes.size() + " tests");
        double prec = (double)total_contacts / (double)total_cdrs;
        double rec = (double)total_contacts / (double)total_recall;
        System.out.println("Wrote results+ " + maxTP);
        System.out.println("Total cdrs: " + total_cdrs);
        System.out.println("Total precision: " + prec);
        System.out.println("Total recall: " + rec);
        return maxTP;
    }

    public static resStr AbIpatchCore(String dataset, String name, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method, boolean constrain_msa, int test_id, boolean cdr_only, String f1, String f2) {
        String folder = "";
        double maxTP = 0.0;
        HashMap<Integer, Residue> ab = PDB_parser.parse(f1, 'A');
        HashMap<Integer, Residue> ag = PDB_parser.parse(f2, 'A');
        String testFolder = folder;
        String pdb_file1 = f1;
        String pdb_file2 = f2;
        ArrayList<Integer> roi_1 = new ArrayList<Integer>();
        ArrayList<Integer> roi_2 = new ArrayList<Integer>();
        int lll = 0;
        while (lll < 9999) {
            roi_1.add(lll);
            roi_2.add(lll);
            ++lll;
        }
        Residue_type[] first = ModelAnalyzer.getNewSequence(pdb_file1, roi_1, 'A', System.getProperty("user.dir"), true);
        Residue_type[] second = ModelAnalyzer.getNewSequence(pdb_file2, roi_2, 'A', System.getProperty("user.dir"), false);
        SequencePair sp = new SequencePair(first, second, 0);
        ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
        sp_arr.add(sp);
        MSA msa = new MSA(sp_arr);
        SC_Structure strA = Main_outer.structureAndMSACore(name, dataset, pdb_file1, msa, 0, true, roi_1, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only);
        SC_Structure strB = Main_outer.structureAndMSACore(name, dataset, pdb_file2, msa, 0, false, roi_2, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only);
        Main_inter_lite mi = new Main_inter_lite(msa, strA, strB, true);
        return new resStr(strA.residues, strB.residues);
    }

    public static double analyzeABPonomRelease(String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method, boolean constrain_msa, int test_id, boolean cdr_only, String f1, String f2, String psa_ab, String psa_ag, String out_folder) {
        String test_pdb = "1AHW";
        results_folder = "";
        scramble_run = "";
        String folder = "";
        double maxTP = 0.0;
        HashMap<Integer, Residue> ab = PDB_parser.parse(f1, 'A');
        HashMap<Integer, Residue> ag = PDB_parser.parse(f2, 'A');
        test_pdb = test_pdb.substring(0, 4);
        test_pdb = test_pdb.replace("_AB", "");
        String testFolder = folder;
        String pdb_file1 = f1;
        String pdb_file2 = f2;
        ArrayList<Integer> roi_1 = new ArrayList<Integer>();
        ArrayList<Integer> roi_2 = new ArrayList<Integer>();
        int lll = 0;
        while (lll < 9999) {
            roi_1.add(lll);
            roi_2.add(lll);
            ++lll;
        }
        Residue_type[] first = ModelAnalyzer.getNewSequence(pdb_file1, roi_1, 'A', System.getProperty("user.dir"), true);
        Residue_type[] second = ModelAnalyzer.getNewSequence(pdb_file2, roi_2, 'A', System.getProperty("user.dir"), false);
        SequencePair sp = new SequencePair(first, second, 0);
        ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
        sp_arr.add(sp);
        MSA msa = new MSA(sp_arr);
        SC_Structure strA = Main_outer.structureAndMSA(pdb_file1, msa, 0, true, roi_1, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only, psa_ab);
        SC_Structure strB = Main_outer.structureAndMSA(pdb_file2, msa, 0, false, roi_2, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only, psa_ag);
        Main_inter_lite mi = new Main_inter_lite(msa, strA, strB, true);
        ModelAnalyzer.writeResult(strA, String.valueOf(out_folder) + "/antibody.pdb", ab);
        return maxTP;
    }

    public static void writeResult(SC_Structure str, String name, HashMap<Integer, Residue> zeros) {
        TreeSet sorted = new TreeSet();
        ArrayList<String> output = new ArrayList<String>();
        int i = 1;
        while (i <= zeros.keySet().size()) {
            Residue r = null;
            double tpro = 0.0;
            if (str.residues.containsKey(i)) {
                r = str.residues.get(i);
                tpro = r.getTPro();
                tpro *= 100.0;
                tpro = Math.round(tpro);
                tpro /= 100.0;
            } else {
                r = zeros.get(i);
            }
            for (Atom a : r.atoms) {
                output.add(SC_Structure.colorBFactor(a.pdb_line, String.valueOf(tpro)));
            }
            FileSystemTools.writeFile(name, output);
            ++i;
        }
    }

    public static double analyzeABPonomDOCK(String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method, boolean constrain_msa, int test_id, boolean cdr_only) {
        double maxTP = 0.0;
        double max_c = -1.0;
        double min_c = 100.0;
        int test_ind = 1;
        ArrayList<String> pdbcodes = FileSystemTools.getFolders(String.valueOf(userdir) + scramble_run);
        int total_cdrs = 0;
        int total_contacts = 0;
        int total_recall = 0;
        double t_start = System.currentTimeMillis();
        ArrayList<HashMap<Double, Integer>> TPs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> FPs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> TNs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> FNs = new ArrayList<HashMap<Double, Integer>>();
        int progress = 0;
        for (String test_pdb : pdbcodes) {
            Residue res_central;
            test_pdb = test_pdb.substring(0, 4);
            test_pdb = test_pdb.replace("_AB", "");
            String tpstring = "";
            String fpstring = "";
            String tnstring = "";
            String fnstring = "";
            System.out.println("Sample " + test_id + ": " + scramble_run + "/" + test_pdb + " [" + ++progress + "/" + pdbcodes.size() + "]");
            HashMap<Double, Integer> TP_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> FP_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> TN_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> FN_s = new HashMap<Double, Integer>();
            String testFolder = String.valueOf(scramble_run) + "/" + test_pdb;
            String pdb_file1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/AB.pdb";
            String pdb_file2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/AG.pdb";
            ArrayList<Integer> roi_1 = new ArrayList<Integer>();
            ArrayList<Integer> roi_2 = new ArrayList<Integer>();
            int lll = 0;
            while (lll < 9999) {
                roi_1.add(lll);
                roi_2.add(lll);
                ++lll;
            }
            Residue_type[] first = ModelAnalyzer.getNewSequence(pdb_file1, roi_1, 'A', System.getProperty("user.dir"), true);
            Residue_type[] second = ModelAnalyzer.getNewSequence(pdb_file2, roi_2, 'A', System.getProperty("user.dir"), false);
            SequencePair sp = new SequencePair(first, second, 0);
            ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
            sp_arr.add(sp);
            MSA msa = new MSA(sp_arr);
            SC_Structure strA = Main_outer.structureAndMSA(pdb_file1, msa, 0, true, roi_1, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only, null);
            SC_Structure strB = Main_outer.structureAndMSA(pdb_file2, msa, 0, false, roi_2, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only, null);
            Main_inter mi = use_full_alignment ? new Main_inter(msa, strA, strB) : new Main_inter_lite(msa, strA, strB, true);
            strA = ModelAnalyzer.calculateNeighborsModelAB(strA, String.valueOf(userdir) + "/" + testFolder);
            strB = ModelAnalyzer.calculateNeighborsModelAG(strB, String.valueOf(userdir) + "/" + testFolder);
            String out_singles = "";
            TreeSet<Integer> sorted = new TreeSet<Integer>();
            for (Integer ab_i : strA.residues.keySet()) {
                sorted.add(ab_i);
            }
            for (Integer str_i : sorted) {
                res_central = strA.residues.get(str_i);
                out_singles = String.valueOf(out_singles) + str_i + " " + (Object)((Object)res_central.type) + " " + res_central.getTPro() + " " + res_central.isCDR + " " + res_central.isContact + "\n";
                if (!(maxTP < res_central.getTPro())) continue;
                maxTP = res_central.getTPro();
            }
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/Alanine_scanning/single_tpro/" + test_pdb, out_singles);
            for (Integer str_i : strB.residues.keySet()) {
                res_central = strB.residues.get(str_i);
                if (!(maxTP < res_central.getTPro())) continue;
                maxTP = res_central.getTPro();
            }
            String outname_1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_1";
            String outname_2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_2";
            String folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
            File f1 = new File(folder);
            f1.mkdir();
            FileSystemTools.CopyFile(outname_1, String.valueOf(folder) + "/str.pdb");
            folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
            File f2 = new File(folder);
            f2.mkdir();
            FileSystemTools.CopyFile(outname_2, String.valueOf(folder) + "/str.pdb");
            String over_w1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultA.pdb";
            String over_w2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultB.pdb";
            double[] res = PDB_parser.writeResultPDB(strA, outname_1, over_w1, true);
            if (res[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            if ((res = PDB_parser.writeResultPDB(strB, outname_2, over_w2, false))[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            for (Integer res_i : strA.residues.keySet()) {
                if (strA.residues.get((Object)res_i).isCDR) {
                    ++total_cdrs;
                }
                if (strA.residues.get((Object)res_i).isCDR && strA.residues.get((Object)res_i).isContact) {
                    ++total_contacts;
                }
                if (!strA.residues.get((Object)res_i).isContact) continue;
                ++total_recall;
            }
            double cutoff = 0.0;
            while (cutoff < 50.0) {
                ArrayList<Integer> forB;
                ArrayList<Integer> forA;
                if (cdr_only) {
                    forA = PDB_parser.writePDBHalfCDR(test_pdb, strA, true, cutoff, method);
                    forB = PDB_parser.writePDBHalf(strB, false, cutoff, method);
                } else {
                    forA = PDB_parser.writePDBHalf(strA, true, cutoff, method);
                    forB = PDB_parser.writePDBHalf(strB, false, cutoff, method);
                }
                TP_s.put(cutoff, forA.get(0));
                FP_s.put(cutoff, forA.get(1));
                TN_s.put(cutoff, forA.get(2));
                FN_s.put(cutoff, forA.get(3));
                cutoff += 0.1;
            }
            TPs.add(TP_s);
            FPs.add(FP_s);
            TNs.add(TN_s);
            FNs.add(FN_s);
        }
        System.out.println(max_c);
        System.out.println(min_c);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TP" + test_id, TPs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FP" + test_id, FPs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FN" + test_id, FNs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TN" + test_id, TNs);
        System.out.println("Program takes: " + ((double)System.currentTimeMillis() - t_start) / 1000.0 / (double)pdbcodes.size() + "s/test on average over " + pdbcodes.size() + " tests");
        double prec = (double)total_contacts / (double)total_cdrs;
        double rec = (double)total_contacts / (double)total_recall;
        System.out.println("Wrote results+ " + maxTP);
        System.out.println("Total cdrs: " + total_cdrs);
        System.out.println("Total precision: " + prec);
        System.out.println("Total recall: " + rec);
        return maxTP;
    }

    public static double analyzeABDocking(String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method, boolean constrain_msa, int test_id, boolean cdr_only) {
        double maxTP = 0.0;
        double max_c = -1.0;
        double min_c = 100.0;
        int test_ind = 1;
        ArrayList<String> pdbcodes = FileSystemTools.getFolders(String.valueOf(userdir) + scramble_run);
        double t_start = System.currentTimeMillis();
        ArrayList<HashMap<Double, Integer>> TPs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> FPs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> TNs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> FNs = new ArrayList<HashMap<Double, Integer>>();
        int progress = 0;
        for (String test_pdb : pdbcodes) {
            Residue res_central;
            test_pdb = test_pdb.replace("_AB", "");
            String tpstring = "";
            String fpstring = "";
            String tnstring = "";
            String fnstring = "";
            System.out.println("Sample " + test_id + ": " + scramble_run + "/" + test_pdb + " [" + ++progress + "/" + pdbcodes.size() + "]");
            HashMap<Double, Integer> TP_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> FP_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> TN_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> FN_s = new HashMap<Double, Integer>();
            String testFolder = String.valueOf(scramble_run) + "/" + test_pdb;
            String pdb_file1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/strA.pdb";
            String pdb_file2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/strB.pdb";
            ArrayList<Integer> roi_1 = new ArrayList<Integer>();
            ArrayList<Integer> roi_2 = new ArrayList<Integer>();
            int lll = 0;
            while (lll < 9999) {
                roi_1.add(lll);
                roi_2.add(lll);
                ++lll;
            }
            Residue_type[] first = ModelAnalyzer.getNewSequence(pdb_file1, roi_1, 'A', System.getProperty("user.dir"), true);
            Residue_type[] second = ModelAnalyzer.getNewSequence(pdb_file2, roi_2, 'A', System.getProperty("user.dir"), false);
            SequencePair sp = new SequencePair(first, second, 0);
            ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
            sp_arr.add(sp);
            MSA msa = new MSA(sp_arr);
            SC_Structure strA = Main_outer.structureAndMSA(pdb_file1, msa, 0, true, roi_1, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only, null);
            SC_Structure strB = Main_outer.structureAndMSA(pdb_file2, msa, 0, false, roi_2, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only, null);
            Main_inter mi = use_full_alignment ? new Main_inter(msa, strA, strB) : new Main_inter_lite(msa, strA, strB, true);
            strA = ModelAnalyzer.calculateNeighborsModelAB(strA, String.valueOf(userdir) + "/" + testFolder);
            strB = ModelAnalyzer.calculateNeighborsModelAG(strB, String.valueOf(userdir) + "/" + testFolder);
            String out_1 = "";
            String out_2 = "";
            String out_3 = "";
            String out_4 = "";
            String out_5 = "";
            String out_6 = "";
            String out_7 = "";
            String out_8 = "";
            String out_9 = "";
            for (Integer str_i : strA.residues.keySet()) {
                res_central = strA.residues.get(str_i);
                if (res_central.getTPro() > 1.0) {
                    System.out.println("Adding 1 = " + str_i + " " + res_central.getTPro());
                    out_1 = String.valueOf(out_1) + str_i + "\n";
                }
                if (res_central.getTPro() > 2.0) {
                    System.out.println("Adding 2 = " + str_i + " " + res_central.getTPro());
                    out_2 = String.valueOf(out_2) + str_i + "\n";
                }
                if (res_central.getTPro() > 3.0) {
                    System.out.println("Adding 3 = " + str_i + " " + res_central.getTPro());
                    out_3 = String.valueOf(out_3) + str_i + "\n";
                }
                if (res_central.getTPro() > 4.0) {
                    System.out.println("Adding 4 = " + str_i + " " + res_central.getTPro());
                    out_4 = String.valueOf(out_4) + str_i + "\n";
                }
                if (res_central.getTPro() > 5.0) {
                    System.out.println("Adding 5 = " + str_i + " " + res_central.getTPro());
                    out_5 = String.valueOf(out_5) + str_i + "\n";
                }
                if (res_central.getTPro() > 6.0) {
                    System.out.println("Adding 6 = " + str_i + " " + res_central.getTPro());
                    out_6 = String.valueOf(out_6) + str_i + "\n";
                }
                if (res_central.getTPro() > 7.0) {
                    System.out.println("Adding 7 = " + str_i + " " + res_central.getTPro());
                    out_7 = String.valueOf(out_7) + str_i + "\n";
                }
                if (res_central.getTPro() > 8.0) {
                    System.out.println("Adding 8 = " + str_i + " " + res_central.getTPro());
                    out_8 = String.valueOf(out_8) + str_i + "\n";
                }
                if (res_central.getTPro() > 9.0) {
                    System.out.println("Adding 9 = " + str_i + " " + res_central.getTPro());
                    out_9 = String.valueOf(out_9) + str_i + "\n";
                }
                if (!(maxTP < res_central.getTPro())) continue;
                maxTP = res_central.getTPro();
            }
            FileSystemTools.writeFile(String.valueOf(userdir) + scramble_run + "/" + test_pdb + "/ipatch_1.txt", out_1);
            FileSystemTools.writeFile(String.valueOf(userdir) + scramble_run + "/" + test_pdb + "/ipatch_2.txt", out_2);
            FileSystemTools.writeFile(String.valueOf(userdir) + scramble_run + "/" + test_pdb + "/ipatch_3.txt", out_3);
            FileSystemTools.writeFile(String.valueOf(userdir) + scramble_run + "/" + test_pdb + "/ipatch_4.txt", out_4);
            FileSystemTools.writeFile(String.valueOf(userdir) + scramble_run + "/" + test_pdb + "/ipatch_5.txt", out_5);
            FileSystemTools.writeFile(String.valueOf(userdir) + scramble_run + "/" + test_pdb + "/ipatch_6.txt", out_6);
            FileSystemTools.writeFile(String.valueOf(userdir) + scramble_run + "/" + test_pdb + "/ipatch_7.txt", out_7);
            FileSystemTools.writeFile(String.valueOf(userdir) + scramble_run + "/" + test_pdb + "/ipatch_8.txt", out_8);
            FileSystemTools.writeFile(String.valueOf(userdir) + scramble_run + "/" + test_pdb + "/ipatch_9.txt", out_9);
            for (Integer str_i : strB.residues.keySet()) {
                res_central = strB.residues.get(str_i);
                if (!(maxTP < res_central.getTPro())) continue;
                maxTP = res_central.getTPro();
            }
            String outname_1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_1";
            String outname_2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_2";
            String folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
            File f1 = new File(folder);
            f1.mkdir();
            FileSystemTools.CopyFile(outname_1, String.valueOf(folder) + "/str.pdb");
            folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
            File f2 = new File(folder);
            f2.mkdir();
            FileSystemTools.CopyFile(outname_2, String.valueOf(folder) + "/str.pdb");
            String over_w1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultA.pdb";
            String over_w2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultB.pdb";
            double[] res = PDB_parser.writeResultPDB(strA, outname_1, over_w1, true);
            if (res[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            if ((res = PDB_parser.writeResultPDB(strB, outname_2, over_w2, false))[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            double cutoff = 0.0;
            while (cutoff < 150.0) {
                ArrayList<Integer> forB;
                ArrayList<Integer> forA;
                if (cdr_only) {
                    forA = PDB_parser.writePDBHalfCDR(test_pdb, strA, true, cutoff, method);
                    forB = PDB_parser.writePDBHalf(strB, false, cutoff, method);
                } else {
                    forA = PDB_parser.writePDBHalf(strA, true, cutoff, method);
                    forB = PDB_parser.writePDBHalf(strB, false, cutoff, method);
                }
                TP_s.put(cutoff, forA.get(0));
                FP_s.put(cutoff, forA.get(1));
                TN_s.put(cutoff, forA.get(2));
                FN_s.put(cutoff, forA.get(3));
                cutoff += 0.1;
            }
            TPs.add(TP_s);
            FPs.add(FP_s);
            TNs.add(TN_s);
            FNs.add(FN_s);
        }
        System.out.println(max_c);
        System.out.println(min_c);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TP" + test_id, TPs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FP" + test_id, FPs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FN" + test_id, FNs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TN" + test_id, TNs);
        System.out.println("Program takes: " + ((double)System.currentTimeMillis() - t_start) / 1000.0 / (double)pdbcodes.size() + "s/test on average over " + pdbcodes.size() + " tests");
        return maxTP;
    }

    public static double analyzeAB(String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method, boolean constrain_msa, int test_id, boolean cdr_only) {
        double maxTP = 0.0;
        double max_c = -1.0;
        double min_c = 100.0;
        int test_ind = 1;
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/test_pdbs.txt");
        double t_start = System.currentTimeMillis();
        ArrayList<HashMap<Double, Integer>> TPs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> FPs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> TNs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> FNs = new ArrayList<HashMap<Double, Integer>>();
        int progress = 0;
        for (String test_pdb : pdbcodes) {
            Residue res_central;
            test_pdb = test_pdb.replace("_AB", "");
            String tpstring = "";
            String fpstring = "";
            String tnstring = "";
            String fnstring = "";
            System.out.println("Sample " + test_id + ": " + scramble_run + "/" + test_pdb + " [" + ++progress + "/" + pdbcodes.size() + "]");
            HashMap<Double, Integer> TP_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> FP_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> TN_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> FN_s = new HashMap<Double, Integer>();
            String testFolder = String.valueOf(scramble_run) + "/" + test_pdb;
            String pdb_file1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/strA.pdb";
            String pdb_file2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/strB.pdb";
            ArrayList<Integer> roi_1 = new ArrayList<Integer>();
            ArrayList<Integer> roi_2 = new ArrayList<Integer>();
            int lll = 0;
            while (lll < 9999) {
                roi_1.add(lll);
                roi_2.add(lll);
                ++lll;
            }
            Residue_type[] first = ModelAnalyzer.getNewSequence(pdb_file1, roi_1, 'A', System.getProperty("user.dir"), true);
            Residue_type[] second = ModelAnalyzer.getNewSequence(pdb_file2, roi_2, 'A', System.getProperty("user.dir"), false);
            SequencePair sp = new SequencePair(first, second, 0);
            ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
            sp_arr.add(sp);
            MSA msa = new MSA(sp_arr);
            SC_Structure strA = Main_outer.structureAndMSA(pdb_file1, msa, 0, true, roi_1, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only, null);
            SC_Structure strB = Main_outer.structureAndMSA(pdb_file2, msa, 0, false, roi_2, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only, null);
            Main_inter mi = use_full_alignment ? new Main_inter(msa, strA, strB) : new Main_inter_lite(msa, strA, strB, true);
            strA = ModelAnalyzer.calculateNeighborsAWrite(strA, strB);
            strB = ModelAnalyzer.calculateNeighborsBWrite(strA, strB);
            for (Integer str_i : strA.residues.keySet()) {
                res_central = strA.residues.get(str_i);
                if (!(maxTP < res_central.getTPro())) continue;
                maxTP = res_central.getTPro();
            }
            for (Integer str_i : strB.residues.keySet()) {
                res_central = strB.residues.get(str_i);
                if (!(maxTP < res_central.getTPro())) continue;
                maxTP = res_central.getTPro();
            }
            String outname_1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_1";
            String outname_2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_2";
            String folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
            File f1 = new File(folder);
            f1.mkdir();
            FileSystemTools.CopyFile(outname_1, String.valueOf(folder) + "/str.pdb");
            folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
            File f2 = new File(folder);
            f2.mkdir();
            FileSystemTools.CopyFile(outname_2, String.valueOf(folder) + "/str.pdb");
            String over_w1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultA.pdb";
            String over_w2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultB.pdb";
            double[] res = PDB_parser.writeResultPDB(strA, outname_1, over_w1, true);
            if (res[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            if ((res = PDB_parser.writeResultPDB(strB, outname_2, over_w2, false))[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            double cutoff = 0.0;
            while (cutoff < 150.0) {
                ArrayList<Integer> forB;
                ArrayList<Integer> forA;
                if (cdr_only) {
                    forA = PDB_parser.writePDBHalfCDR(test_pdb, strA, true, cutoff, method);
                    forB = PDB_parser.writePDBHalf(strB, false, cutoff, method);
                } else {
                    forA = PDB_parser.writePDBHalf(strA, true, cutoff, method);
                    forB = PDB_parser.writePDBHalf(strB, false, cutoff, method);
                }
                TP_s.put(cutoff, forA.get(0));
                FP_s.put(cutoff, forA.get(1));
                TN_s.put(cutoff, forA.get(2));
                FN_s.put(cutoff, forA.get(3));
                cutoff += 0.1;
            }
            TPs.add(TP_s);
            FPs.add(FP_s);
            TNs.add(TN_s);
            FNs.add(FN_s);
        }
        System.out.println(max_c);
        System.out.println(min_c);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TP" + test_id, TPs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FP" + test_id, FPs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FN" + test_id, FNs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TN" + test_id, TNs);
        System.out.println("Program takes: " + ((double)System.currentTimeMillis() - t_start) / 1000.0 / (double)pdbcodes.size() + "s/test on average over " + pdbcodes.size() + " tests");
        System.out.println("Wrote results+ " + maxTP);
        return maxTP;
    }

    public static double analyzeABModel(String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method, boolean constrain_msa, int test_id, boolean cdr_only) {
        double maxTP = 0.0;
        double max_c = -1.0;
        double min_c = 100.0;
        int test_ind = 1;
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/test_pdbs.txt");
        double t_start = System.currentTimeMillis();
        ArrayList<HashMap<Double, Integer>> TPs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> FPs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> TNs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> FNs = new ArrayList<HashMap<Double, Integer>>();
        int progress = 0;
        for (String test_pdb : pdbcodes) {
            Residue res_central;
            test_pdb = test_pdb.replace("_AB", "");
            System.out.println("Sample " + test_id + ": " + scramble_run + "/" + test_pdb + " [" + ++progress + "/" + pdbcodes.size() + "]");
            HashMap<Double, Integer> TP_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> FP_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> TN_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> FN_s = new HashMap<Double, Integer>();
            String testFolder = String.valueOf(scramble_run) + "/" + test_pdb;
            String pdb_file1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/strA.pdb";
            String pdb_file2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/strB.pdb";
            ArrayList<Integer> roi_1 = new ArrayList<Integer>();
            ArrayList<Integer> roi_2 = new ArrayList<Integer>();
            int lll = 0;
            while (lll < 9999) {
                roi_1.add(lll);
                roi_2.add(lll);
                ++lll;
            }
            Residue_type[] first = ModelAnalyzer.getNewSequence(pdb_file1, roi_1, 'A', System.getProperty("user.dir"), true);
            Residue_type[] second = ModelAnalyzer.getNewSequence(pdb_file2, roi_2, 'A', System.getProperty("user.dir"), false);
            SequencePair sp = new SequencePair(first, second, 0);
            ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
            sp_arr.add(sp);
            MSA msa = new MSA(sp_arr);
            SC_Structure strA = Main_outer.structureAndMSA(pdb_file1, msa, 0, true, roi_1, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only, null);
            SC_Structure strB = Main_outer.structureAndMSA(pdb_file2, msa, 0, false, roi_2, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only, null);
            Main_inter mi = use_full_alignment ? new Main_inter(msa, strA, strB) : new Main_inter_lite(msa, strA, strB, true);
            strA = ModelAnalyzer.calculateNeighborsModelAB(strA, String.valueOf(userdir) + "/" + testFolder);
            strB = ModelAnalyzer.calculateNeighborsModelAG(strB, String.valueOf(userdir) + "/" + testFolder);
            for (Integer str_i : strA.residues.keySet()) {
                res_central = strA.residues.get(str_i);
                if (!(maxTP < res_central.getTPro())) continue;
                maxTP = res_central.getTPro();
            }
            for (Integer str_i : strB.residues.keySet()) {
                res_central = strB.residues.get(str_i);
                if (!(maxTP < res_central.getTPro())) continue;
                maxTP = res_central.getTPro();
            }
            String outname_1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_1";
            String outname_2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_2";
            String folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
            File f1 = new File(folder);
            f1.mkdir();
            FileSystemTools.CopyFile(outname_1, String.valueOf(folder) + "/str.pdb");
            folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
            File f2 = new File(folder);
            f2.mkdir();
            FileSystemTools.CopyFile(outname_2, String.valueOf(folder) + "/str.pdb");
            String over_w1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultA.pdb";
            String over_w2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultB.pdb";
            double[] res = PDB_parser.writeResultPDB(strA, outname_1, over_w1, true);
            if (res[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            if ((res = PDB_parser.writeResultPDB(strB, outname_2, over_w2, false))[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            double cutoff = 0.0;
            while (cutoff < 150.0) {
                ArrayList<Integer> forB;
                ArrayList<Integer> forA;
                if (cdr_only) {
                    forA = PDB_parser.writePDBHalfCDR(test_pdb, strA, true, cutoff, method);
                    forB = PDB_parser.writePDBHalf(strB, false, cutoff, method);
                } else {
                    forA = PDB_parser.writePDBHalf(strA, true, cutoff, method);
                    forB = PDB_parser.writePDBHalf(strB, false, cutoff, method);
                }
                TP_s.put(cutoff, forA.get(0));
                FP_s.put(cutoff, forA.get(1));
                TN_s.put(cutoff, forA.get(2));
                FN_s.put(cutoff, forA.get(3));
                cutoff += 0.1;
            }
            TPs.add(TP_s);
            FPs.add(FP_s);
            TNs.add(TN_s);
            FNs.add(FN_s);
        }
        System.out.println(max_c);
        System.out.println(min_c);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TP" + test_id, TPs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FP" + test_id, FPs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FN" + test_id, FNs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TN" + test_id, TNs);
        System.out.println("Program takes: " + ((double)System.currentTimeMillis() - t_start) / 1000.0 / (double)pdbcodes.size() + "s/test on average over " + pdbcodes.size() + " tests");
        System.out.println("Wrote results+ " + maxTP);
        return maxTP;
    }

    public static double analyzeABTOPN(String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method, boolean constrain_msa, int test_id, boolean cdr_only) {
        double maxTP = 0.0;
        double max_c = -1.0;
        double min_c = 100.0;
        int test_ind = 1;
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/test_pdbs.txt");
        double t_start = System.currentTimeMillis();
        ArrayList<HashMap<Double, Integer>> TPs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> FPs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> TNs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> FNs = new ArrayList<HashMap<Double, Integer>>();
        int progress = 0;
        for (String test_pdb : pdbcodes) {
            Residue res_central;
            test_pdb = test_pdb.replace("_AB", "");
            System.out.println("Sample " + test_id + ": " + scramble_run + "/" + test_pdb + " [" + ++progress + "/" + pdbcodes.size() + "]");
            HashMap<Double, Integer> TP_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> FP_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> TN_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> FN_s = new HashMap<Double, Integer>();
            String testFolder = String.valueOf(scramble_run) + "/" + test_pdb;
            String pdb_file1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/strA.pdb";
            String pdb_file2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/strB.pdb";
            ArrayList<Integer> roi_1 = new ArrayList<Integer>();
            ArrayList<Integer> roi_2 = new ArrayList<Integer>();
            int lll = 0;
            while (lll < 9999) {
                roi_1.add(lll);
                roi_2.add(lll);
                ++lll;
            }
            Residue_type[] first = ModelAnalyzer.getNewSequence(pdb_file1, roi_1, 'A', System.getProperty("user.dir"), true);
            Residue_type[] second = ModelAnalyzer.getNewSequence(pdb_file2, roi_2, 'A', System.getProperty("user.dir"), false);
            SequencePair sp = new SequencePair(first, second, 0);
            ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
            sp_arr.add(sp);
            MSA msa = new MSA(sp_arr);
            SC_Structure strA = Main_outer.structureAndMSA(pdb_file1, msa, 0, true, roi_1, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only, null);
            SC_Structure strB = Main_outer.structureAndMSA(pdb_file2, msa, 0, false, roi_2, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only, null);
            Main_inter mi = use_full_alignment ? new Main_inter(msa, strA, strB) : new Main_inter_lite(msa, strA, strB, true);
            strA = ModelAnalyzer.calculateNeighborsAWrite(strA, strB);
            strB = ModelAnalyzer.calculateNeighborsBWrite(strA, strB);
            for (Integer str_i : strA.residues.keySet()) {
                res_central = strA.residues.get(str_i);
                if (!(maxTP < res_central.getTPro())) continue;
                maxTP = res_central.getTPro();
            }
            for (Integer str_i : strB.residues.keySet()) {
                res_central = strB.residues.get(str_i);
                if (!(maxTP < res_central.getTPro())) continue;
                maxTP = res_central.getTPro();
            }
            String outname_1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_1";
            String outname_2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_2";
            String folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
            File f1 = new File(folder);
            f1.mkdir();
            FileSystemTools.CopyFile(outname_1, String.valueOf(folder) + "/str.pdb");
            folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
            File f2 = new File(folder);
            f2.mkdir();
            FileSystemTools.CopyFile(outname_2, String.valueOf(folder) + "/str.pdb");
            String over_w1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultA.pdb";
            String over_w2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultB.pdb";
            double[] res = PDB_parser.writeResultPDB(strA, outname_1, over_w1, true);
            if (res[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            if ((res = PDB_parser.writeResultPDB(strB, outname_2, over_w2, false))[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            TreeMap<Integer, Double> sorted_A = PDB_parser.sortResidues(strA);
            TreeMap<Integer, Double> sorted_B = PDB_parser.sortResidues(strB);
            double cutoff = 0.0;
            while (cutoff < 350.0) {
                ArrayList<Integer> forB;
                ArrayList<Integer> forA;
                if (cdr_only) {
                    forA = PDB_parser.writePDBHalfCDRTOPN(test_pdb, strA, true, cutoff, method, sorted_A);
                    forB = PDB_parser.writePDBHalfTOPN(strB, false, cutoff, method, sorted_B);
                } else {
                    forA = PDB_parser.writePDBHalfTOPN(strA, true, cutoff, method, sorted_A);
                    forB = PDB_parser.writePDBHalfTOPN(strB, false, cutoff, method, sorted_B);
                }
                TP_s.put(cutoff, forA.get(0));
                FP_s.put(cutoff, forA.get(1));
                TN_s.put(cutoff, forA.get(2));
                FN_s.put(cutoff, forA.get(3));
                cutoff += 1.0;
            }
            TPs.add(TP_s);
            FPs.add(FP_s);
            TNs.add(TN_s);
            FNs.add(FN_s);
        }
        System.out.println(max_c);
        System.out.println(min_c);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TP" + test_id, TPs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FP" + test_id, FPs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FN" + test_id, FNs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TN" + test_id, TNs);
        System.out.println("Program takes: " + ((double)System.currentTimeMillis() - t_start) / 1000.0 / (double)pdbcodes.size() + "s/test on average over " + pdbcodes.size() + " tests");
        System.out.println("Wrote results+ " + maxTP);
        return maxTP;
    }

    public static double analyzeABModelTOPN(String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method, boolean constrain_msa, int test_id, boolean cdr_only) {
        double maxTP = 0.0;
        double max_c = -1.0;
        double min_c = 100.0;
        int test_ind = 1;
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/test_pdbs.txt");
        double t_start = System.currentTimeMillis();
        ArrayList<HashMap<Double, Integer>> TPs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> FPs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> TNs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> FNs = new ArrayList<HashMap<Double, Integer>>();
        int progress = 0;
        for (String test_pdb : pdbcodes) {
            Residue res_central;
            test_pdb = test_pdb.replace("_AB", "");
            System.out.println("Sample " + test_id + ": " + scramble_run + "/" + test_pdb + " [" + ++progress + "/" + pdbcodes.size() + "]");
            HashMap<Double, Integer> TP_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> FP_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> TN_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> FN_s = new HashMap<Double, Integer>();
            String testFolder = String.valueOf(scramble_run) + "/" + test_pdb;
            String pdb_file1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/strA.pdb";
            String pdb_file2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/strB.pdb";
            ArrayList<Integer> roi_1 = new ArrayList<Integer>();
            ArrayList<Integer> roi_2 = new ArrayList<Integer>();
            int lll = 0;
            while (lll < 9999) {
                roi_1.add(lll);
                roi_2.add(lll);
                ++lll;
            }
            Residue_type[] first = ModelAnalyzer.getNewSequence(pdb_file1, roi_1, 'A', System.getProperty("user.dir"), true);
            Residue_type[] second = ModelAnalyzer.getNewSequence(pdb_file2, roi_2, 'A', System.getProperty("user.dir"), false);
            SequencePair sp = new SequencePair(first, second, 0);
            ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
            sp_arr.add(sp);
            MSA msa = new MSA(sp_arr);
            SC_Structure strA = Main_outer.structureAndMSA(pdb_file1, msa, 0, true, roi_1, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only, null);
            SC_Structure strB = Main_outer.structureAndMSA(pdb_file2, msa, 0, false, roi_2, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only, null);
            Main_inter mi = use_full_alignment ? new Main_inter(msa, strA, strB) : new Main_inter_lite(msa, strA, strB, true);
            strA = ModelAnalyzer.calculateNeighborsModelAB(strA, String.valueOf(userdir) + "/" + testFolder);
            strB = ModelAnalyzer.calculateNeighborsModelAG(strB, String.valueOf(userdir) + "/" + testFolder);
            for (Integer str_i : strA.residues.keySet()) {
                res_central = strA.residues.get(str_i);
                if (!(maxTP < res_central.getTPro())) continue;
                maxTP = res_central.getTPro();
            }
            for (Integer str_i : strB.residues.keySet()) {
                res_central = strB.residues.get(str_i);
                if (!(maxTP < res_central.getTPro())) continue;
                maxTP = res_central.getTPro();
            }
            String outname_1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_1";
            String outname_2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_2";
            String folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
            File f1 = new File(folder);
            f1.mkdir();
            FileSystemTools.CopyFile(outname_1, String.valueOf(folder) + "/str.pdb");
            folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
            File f2 = new File(folder);
            f2.mkdir();
            FileSystemTools.CopyFile(outname_2, String.valueOf(folder) + "/str.pdb");
            String over_w1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultA.pdb";
            String over_w2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultB.pdb";
            double[] res = PDB_parser.writeResultPDB(strA, outname_1, over_w1, true);
            if (res[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            if ((res = PDB_parser.writeResultPDB(strB, outname_2, over_w2, false))[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            TreeMap<Integer, Double> sorted_A = PDB_parser.sortResidues(strA);
            TreeMap<Integer, Double> sorted_B = PDB_parser.sortResidues(strB);
            double cutoff = 0.0;
            while (cutoff < 350.0) {
                ArrayList<Integer> forB;
                ArrayList<Integer> forA;
                if (cdr_only) {
                    forA = PDB_parser.writePDBHalfCDRTOPN(test_pdb, strA, true, cutoff, method, sorted_A);
                    forB = PDB_parser.writePDBHalfTOPN(strB, false, cutoff, method, sorted_B);
                } else {
                    forA = PDB_parser.writePDBHalfTOPN(strA, true, cutoff, method, sorted_A);
                    forB = PDB_parser.writePDBHalfTOPN(strB, false, cutoff, method, sorted_B);
                }
                TP_s.put(cutoff, forA.get(0));
                FP_s.put(cutoff, forA.get(1));
                TN_s.put(cutoff, forA.get(2));
                FN_s.put(cutoff, forA.get(3));
                cutoff += 1.0;
            }
            TPs.add(TP_s);
            FPs.add(FP_s);
            TNs.add(TN_s);
            FNs.add(FN_s);
        }
        System.out.println(max_c);
        System.out.println(min_c);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TP" + test_id, TPs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FP" + test_id, FPs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FN" + test_id, FNs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TN" + test_id, TNs);
        System.out.println("Program takes: " + ((double)System.currentTimeMillis() - t_start) / 1000.0 / (double)pdbcodes.size() + "s/test on average over " + pdbcodes.size() + " tests");
        System.out.println("Wrote results+ " + maxTP);
        return maxTP;
    }

    public static double analyzeABModelTOPNDocking(String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method, boolean constrain_msa, int test_id, boolean cdr_only) {
        double maxTP = 0.0;
        double max_c = -1.0;
        double min_c = 100.0;
        int test_ind = 1;
        ArrayList<String> pdbcodes = FileSystemTools.getFolders(String.valueOf(userdir) + scramble_run);
        double t_start = System.currentTimeMillis();
        ArrayList<HashMap<Double, Integer>> TPs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> FPs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> TNs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> FNs = new ArrayList<HashMap<Double, Integer>>();
        int progress = 0;
        for (String test_pdb : pdbcodes) {
            Residue res_central;
            test_pdb = test_pdb.replace("_AB", "");
            System.out.println("Sample " + test_id + ": " + scramble_run + "/" + test_pdb + " [" + ++progress + "/" + pdbcodes.size() + "]");
            HashMap<Double, Integer> TP_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> FP_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> TN_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> FN_s = new HashMap<Double, Integer>();
            String testFolder = String.valueOf(scramble_run) + "/" + test_pdb;
            String pdb_file1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/strA.pdb";
            String pdb_file2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/strB.pdb";
            ArrayList<Integer> roi_1 = new ArrayList<Integer>();
            ArrayList<Integer> roi_2 = new ArrayList<Integer>();
            int lll = 0;
            while (lll < 9999) {
                roi_1.add(lll);
                roi_2.add(lll);
                ++lll;
            }
            Residue_type[] first = ModelAnalyzer.getNewSequence(pdb_file1, roi_1, 'A', System.getProperty("user.dir"), true);
            Residue_type[] second = ModelAnalyzer.getNewSequence(pdb_file2, roi_2, 'A', System.getProperty("user.dir"), false);
            SequencePair sp = new SequencePair(first, second, 0);
            ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
            sp_arr.add(sp);
            MSA msa = new MSA(sp_arr);
            SC_Structure strA = Main_outer.structureAndMSA(pdb_file1, msa, 0, true, roi_1, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only, null);
            SC_Structure strB = Main_outer.structureAndMSA(pdb_file2, msa, 0, false, roi_2, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, cdr_only, null);
            Main_inter mi = use_full_alignment ? new Main_inter(msa, strA, strB) : new Main_inter_lite(msa, strA, strB, true);
            strA = ModelAnalyzer.calculateNeighborsModelAB(strA, String.valueOf(userdir) + "/" + testFolder);
            strB = ModelAnalyzer.calculateNeighborsModelAG(strB, String.valueOf(userdir) + "/" + testFolder);
            for (Integer str_i : strA.residues.keySet()) {
                res_central = strA.residues.get(str_i);
                if (!(maxTP < res_central.getTPro())) continue;
                maxTP = res_central.getTPro();
            }
            for (Integer str_i : strB.residues.keySet()) {
                res_central = strB.residues.get(str_i);
                if (!(maxTP < res_central.getTPro())) continue;
                maxTP = res_central.getTPro();
            }
            String outname_1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_1";
            String outname_2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_2";
            String folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
            File f1 = new File(folder);
            f1.mkdir();
            FileSystemTools.CopyFile(outname_1, String.valueOf(folder) + "/str.pdb");
            folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
            File f2 = new File(folder);
            f2.mkdir();
            FileSystemTools.CopyFile(outname_2, String.valueOf(folder) + "/str.pdb");
            String over_w1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultA.pdb";
            String over_w2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultB.pdb";
            double[] res = PDB_parser.writeResultPDB(strA, outname_1, over_w1, true);
            if (res[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            if ((res = PDB_parser.writeResultPDB(strB, outname_2, over_w2, false))[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            TreeMap<Integer, Double> sorted_A = PDB_parser.sortResidues(strA);
            TreeMap<Integer, Double> sorted_B = PDB_parser.sortResidues(strB);
            String top_30 = "";
            String top_20 = "";
            String top_10 = "";
            int count_best = 30;
            for (Integer i : sorted_A.keySet()) {
                Residue res_cdr = strA.residues.get(i);
                if (!res_cdr.isCDR) continue;
                System.out.println("Adding " + i + " " + sorted_A.get(i));
                if (count_best > 20) {
                    top_10 = String.valueOf(top_10) + i + "\n";
                }
                if (count_best > 10) {
                    top_20 = String.valueOf(top_20) + i + "\n";
                }
                top_30 = String.valueOf(top_30) + i + "\n";
                if (--count_best < 1) break;
            }
            FileSystemTools.writeFile(String.valueOf(userdir) + scramble_run + "/" + test_pdb + "/top30.txt", top_30);
            FileSystemTools.writeFile(String.valueOf(userdir) + scramble_run + "/" + test_pdb + "/top20.txt", top_20);
            FileSystemTools.writeFile(String.valueOf(userdir) + scramble_run + "/" + test_pdb + "/top10.txt", top_10);
            double cutoff = 0.0;
            while (cutoff < 30.0) {
                ArrayList<Integer> forB;
                ArrayList<Integer> forA;
                if (cdr_only) {
                    forA = PDB_parser.writePDBHalfCDRTOPN(test_pdb, strA, true, cutoff, method, sorted_A);
                    forB = PDB_parser.writePDBHalfTOPN(strB, false, cutoff, method, sorted_B);
                } else {
                    forA = PDB_parser.writePDBHalfTOPN(strA, true, cutoff, method, sorted_A);
                    forB = PDB_parser.writePDBHalfTOPN(strB, false, cutoff, method, sorted_B);
                }
                TP_s.put(cutoff, forA.get(0));
                FP_s.put(cutoff, forA.get(1));
                TN_s.put(cutoff, forA.get(2));
                FN_s.put(cutoff, forA.get(3));
                cutoff += 1.0;
            }
            TPs.add(TP_s);
            FPs.add(FP_s);
            TNs.add(TN_s);
            FNs.add(FN_s);
        }
        System.out.println(max_c);
        System.out.println(min_c);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TP" + test_id, TPs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FP" + test_id, FPs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FN" + test_id, FNs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TN" + test_id, TNs);
        System.out.println("Program takes: " + ((double)System.currentTimeMillis() - t_start) / 1000.0 / (double)pdbcodes.size() + "s/test on average over " + pdbcodes.size() + " tests");
        System.out.println("Wrote results+ " + maxTP);
        return maxTP;
    }

    public static SC_Structure calculateNeighborsAWrite(SC_Structure s1, SC_Structure s2) {
        HashMap<Integer, Residue> residues_s1 = s1.residues;
        HashMap<Integer, Residue> residues_s2 = s2.residues;
        for (Integer i : residues_s1.keySet()) {
            s1.residues.get((Object)i).isContact = false;
            for (Integer j : residues_s2.keySet()) {
                if (!(residues_s2.get(j).distanceFrom(residues_s1.get(i)) < 4.5)) continue;
                s1.residues.get((Object)i).isContact = true;
                if (i == s1.residues.get((Object)i).site) continue;
                System.err.println("unequal");
                System.exit(0);
            }
        }
        return s1;
    }

    public static SC_Structure calculateNeighborsBWrite(SC_Structure s1, SC_Structure s2) {
        HashMap<Integer, Residue> residues_s1 = s1.residues;
        HashMap<Integer, Residue> residues_s2 = s2.residues;
        for (Integer i : residues_s2.keySet()) {
            s2.residues.get((Object)i).isContact = false;
            for (Integer j : residues_s1.keySet()) {
                if (!(residues_s1.get(j).distanceFrom(residues_s2.get(i)) < 4.5)) continue;
                s2.residues.get((Object)i).isContact = true;
                if (i == s2.residues.get((Object)i).site) continue;
                System.err.println("unequal");
                System.exit(0);
            }
        }
        return s2;
    }

    public static SC_Structure calculateNeighborsModelAB(SC_Structure str, String folder) {
        HashMap<Integer, Residue> residues = str.residues;
        ArrayList<String> con_map = FileSystemTools.readFile(String.valueOf(folder) + "/map_con.txt");
        for (Integer i : residues.keySet()) {
            str.residues.get((Object)i).isContact = false;
            if (!con_map.contains(i + "_AB")) continue;
            str.residues.get((Object)i).isContact = true;
        }
        return str;
    }

    public static SC_Structure calculateNeighborsModelAG(SC_Structure str, String folder) {
        HashMap<Integer, Residue> residues = str.residues;
        ArrayList<String> con_map = FileSystemTools.readFile(String.valueOf(folder) + "/map_con.txt");
        for (Integer i : residues.keySet()) {
            str.residues.get((Object)i).isContact = false;
            if (!con_map.contains(i + "_AG")) continue;
            str.residues.get((Object)i).isContact = true;
        }
        return str;
    }

    public static HashMap<Integer, String> readMapping(String filename) {
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        HashMap<Integer, String> map_seq = new HashMap<Integer, String>();
        for (String line : lines) {
            if (line.length() <= 0) continue;
            int index = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            String seq_id = line.substring(line.indexOf(" ") + 1).replace(" ", "");
            if (map_seq.containsKey(index)) {
                System.err.println("Key duplicate in readMapping " + index);
                System.exit(0);
            }
            map_seq.put(index, seq_id);
        }
        return map_seq;
    }

    public static Residue_type[] getNewSequence(String pdb, ArrayList<Integer> roi, char chain, String directory, boolean isA) {
        String outname = String.valueOf(directory) + (isA ? "/const_1" : "/const_2");
        PDB_parser.writeConstrainingPDB(pdb, outname, roi, chain);
        Residue_type[] new_ref = new Residue_type[10000];
        ArrayList<Residue_type> ref_final = new ArrayList<Residue_type>();
        HashMap<Integer, Residue> pdb_residues = PDB_parser.parse(outname, roi, chain);
        for (Integer inte : pdb_residues.keySet()) {
            new_ref[inte.intValue()] = pdb_residues.get((Object)inte).type;
        }
        int i = 0;
        while (i < new_ref.length) {
            if (new_ref[i] != null) {
                ref_final.add(new_ref[i]);
            }
            ++i;
        }
        Residue_type[] to_return = new Residue_type[ref_final.size()];
        int i2 = 0;
        while (i2 < ref_final.size()) {
            to_return[i2] = (Residue_type)((Object)ref_final.get(i2));
            ++i2;
        }
        return to_return;
    }

    public static class resStr {
        public final HashMap<Integer, Residue> ab;
        public final HashMap<Integer, Residue> ag;

        resStr(HashMap<Integer, Residue> ab_, HashMap<Integer, Residue> ag_) {
            this.ab = ab_;
            this.ag = ag_;
        }
    }
}

