/*
 * Decompiled with CFR 0.152.
 */
package data_structures;

import data_structures.Residue_type;
import data_structures.SequencePair;
import java.util.ArrayList;
import java.util.HashMap;
import utils.FileSystemTools;

public class MSA {
    public final ArrayList<SequencePair> sequences;
    public final int sAlen;
    public final int sBlen;
    public HashMap<Integer, Integer> mapA;
    public HashMap<Integer, Integer> mapB;

    public MSA(ArrayList<SequencePair> sqs) {
        this.sequences = sqs;
        this.sAlen = sqs.get((int)0).sequenceA.length;
        this.sBlen = sqs.get((int)0).sequenceB.length;
    }

    public void Output() {
        for (SequencePair sp : this.sequences) {
            sp.Output();
        }
    }

    public static void constrainMSA(MSA msa, String save_folder, String save_name) {
        String lines = "";
        int i = 0;
        while (i < msa.sequences.size()) {
            SequencePair sp = msa.sequences.get(i);
            lines = String.valueOf(lines) + i + "\t";
            int a_i = 0;
            while (a_i < sp.sequenceA.length) {
                lines = String.valueOf(lines) + (sp.sequenceA[a_i] == Residue_type.gap ? "-" : sp.sequenceA[a_i].name());
                ++a_i;
            }
            int b_i = 0;
            while (b_i < sp.sequenceB.length) {
                lines = String.valueOf(lines) + (sp.sequenceB[b_i] == Residue_type.gap ? "-" : sp.sequenceB[b_i].name());
                ++b_i;
            }
            lines = String.valueOf(lines) + "\n";
            ++i;
        }
        FileSystemTools.writeFile(save_name, save_folder, lines);
    }

    public ArrayList<Integer> gapColumnsA(double cutoff) {
        Residue_type[] ref = this.sequences.get((int)0).sequenceA;
        ArrayList<Integer> nogaps = new ArrayList<Integer>();
        int i = 0;
        while (i < this.sAlen) {
            double gapCount = 0.0;
            double total = 0.0;
            for (SequencePair sp : this.sequences) {
                if (sp.sequenceA[i] == Residue_type.gap) {
                    gapCount += 1.0;
                }
                total += 1.0;
            }
            if (gapCount / total < cutoff) {
                nogaps.add(i);
            }
            ++i;
        }
        return nogaps;
    }

    public ArrayList<Integer> gapColumnsB(double cutoff) {
        Residue_type[] ref = this.sequences.get((int)0).sequenceB;
        ArrayList<Integer> nogaps = new ArrayList<Integer>();
        int i = 0;
        while (i < this.sBlen) {
            double gapCount = 0.0;
            double total = 0.0;
            for (SequencePair sp : this.sequences) {
                if (sp.sequenceB[i] == Residue_type.gap) {
                    gapCount += 1.0;
                }
                total += 1.0;
            }
            if (gapCount / total < cutoff) {
                nogaps.add(i);
            }
            ++i;
        }
        return nogaps;
    }
}

