/*
 * Decompiled with CFR 0.152.
 */
package docking;

import data_structures.Residue;
import docking.BatchFactory;
import docking.DockingAnalyzer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import parsing.PDB_parser;
import utils.FileSystemTools;
import utils.MathFunctions;

public class BatchAnalyzer {
    private static final String userdir = System.getProperty("user.dir");
    private static final String decoy_fold = String.valueOf(userdir) + "/resources/decoy_temp";
    private static final String temp_dir = String.valueOf(userdir) + "/temp_dump";
    private static final String temp_AB = String.valueOf(temp_dir) + "/tempAB.pdb";
    private static final String temp_AG = String.valueOf(temp_dir) + "/tempAG.pdb";

    public static void main(String[] args) {
        ArrayList<String> _cases = new ArrayList<String>();
        _cases.add("patchdock_correct_5_R");
        _cases.add("patchdock_ipatch_5_R");
        _cases.add("patchdock_paratome_5_R");
        _cases.add("patchdock_cdr_5_R");
        _cases.add("patchdock_paratome_5_H");
        _cases.add("patchdock_cdr_5_H");
        _cases.add("patchdock_correct_5_H");
        _cases.add("patchdock_ipatch_5_H");
        _cases.add("patchdock_correct_6_R");
        _cases.add("patchdock_ipatch_6_R");
        _cases.add("patchdock_paratome_6_R");
        _cases.add("patchdock_cdr_6_R");
        _cases.add("patchdock_paratome_6_H");
        _cases.add("patchdock_cdr_6_H");
        _cases.add("patchdock_correct_6_H");
        _cases.add("patchdock_ipatch_6_H");
        for (String _case : _cases) {
            BatchAnalyzer.AnalyzeCasePatchDock(_case, 10);
        }
    }

    public static void AnalyzeZdock() {
        ArrayList _cases = new ArrayList();
        ArrayList<String> runs = new ArrayList<String>();
        int i = 1;
        while (i < 5) {
            runs.add(String.valueOf(i));
            ++i;
        }
        for (String run : runs) {
            for (String _case : _cases) {
                BatchAnalyzer.AnalyzeCase(_case, run, 10);
            }
        }
    }

    public static void AnalyzeCase(String _case, String run, int n) {
        File run_fold;
        double[][] prop_mat = BatchAnalyzer.getLikelihood();
        String main_fold = String.valueOf(userdir) + "/result_dump/docking_results";
        int acc_orig = 0;
        int med_orig = 0;
        int high_orig = 0;
        int acc_scr = 0;
        int med_scr = 0;
        int high_scr = 0;
        File case_fold = new File(String.valueOf(main_fold) + "/" + _case);
        if (!case_fold.exists()) {
            case_fold.mkdir();
        }
        if (!(run_fold = new File(String.valueOf(main_fold) + "/" + _case + "/" + run)).exists()) {
            run_fold.mkdir();
        }
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/resources/docking_cases/" + _case + "/input/" + _case);
        for (String pdb : pdbs) {
            System.out.println(String.valueOf(pdb) + " " + _case + " " + run);
            BatchAnalyzer.generateDecoys(pdb, _case, run);
            ResultStruc rs = BatchAnalyzer.AnalyzePDB(pdb, _case, run, prop_mat);
            int orig_best = 0;
            int score_best = 0;
            HashMap<Double, Integer> score = rs.getTopLikely(n);
            for (Double d : score.keySet()) {
                System.out.println("Likelihood: " + d + " " + score.get(d));
                if (score.get(d) <= score_best) continue;
                score_best = score.get(d);
            }
            HashMap<Integer, Integer> orig = rs.getTopOrig(n);
            for (Integer d : orig.keySet()) {
                System.out.println("Original: " + d + " " + orig.get(d));
                if (orig.get(d) <= orig_best) continue;
                orig_best = orig.get(d);
            }
            FileSystemTools.writeFile(String.valueOf(run_fold.getAbsolutePath()) + "/score_" + pdb + "_" + n + ".txt", String.valueOf(score_best));
            FileSystemTools.writeFile(String.valueOf(run_fold.getAbsolutePath()) + "/orig_" + pdb + "_" + n + ".txt", String.valueOf(orig_best));
            switch (orig_best) {
                case 1: {
                    ++acc_orig;
                    break;
                }
                case 2: {
                    ++med_orig;
                    break;
                }
                case 3: {
                    ++high_orig;
                }
            }
            switch (score_best) {
                case 1: {
                    ++acc_scr;
                    break;
                }
                case 2: {
                    ++med_scr;
                    break;
                }
                case 3: {
                    ++high_scr;
                }
            }
            FileSystemTools.writeFile(String.valueOf(run_fold.getAbsolutePath()) + "/orig_" + n + ".txt", String.valueOf(acc_orig) + " " + med_orig + " " + high_orig);
            FileSystemTools.writeFile(String.valueOf(run_fold.getAbsolutePath()) + "/score_" + n + ".txt", String.valueOf(acc_scr) + " " + med_scr + " " + high_scr);
        }
    }

    public static void AnalyzeCasePatchDock(String _case, int n) {
        File run_fold;
        double[][] prop_mat = BatchAnalyzer.getLikelihood();
        String main_fold = "/Volumes/D/PatchDock/input";
        String write_fold = String.valueOf(userdir) + "/patch_dock_results/" + _case;
        File f = new File(write_fold);
        if (!f.exists()) {
            f.mkdir();
        }
        int acc_orig = 0;
        int med_orig = 0;
        int high_orig = 0;
        int acc_scr = 0;
        int med_scr = 0;
        int high_scr = 0;
        int acc_scr200 = 0;
        int med_scr200 = 0;
        int high_scr200 = 0;
        File case_fold = new File(String.valueOf(main_fold) + "/" + _case);
        if (!case_fold.exists()) {
            case_fold.mkdir();
        }
        if (!(run_fold = new File(String.valueOf(main_fold) + "/" + _case)).exists()) {
            run_fold.mkdir();
        }
        String res_fold = String.valueOf(main_fold) + "/" + _case;
        ArrayList<String> pdbs = FileSystemTools.getFolders(res_fold);
        for (String pdb : pdbs) {
            System.out.println(String.valueOf(pdb) + " " + _case + " ");
            ResultStruc rs = BatchAnalyzer.AnalyzePDBPatchDock(pdb, _case, prop_mat);
            int orig_best = 0;
            int score_best = 0;
            HashMap<Double, Integer> score = rs.getTopLikely(n);
            for (Double d : score.keySet()) {
                System.out.println("Likelihood: " + d + " " + score.get(d));
                if (score.get(d) <= score_best) continue;
                score_best = score.get(d);
            }
            HashMap<Integer, Integer> orig = rs.getTopOrig(n);
            for (Integer n2 : orig.keySet()) {
                System.out.println("Original: " + n2 + " " + orig.get(n2));
                if (orig.get(n2) <= orig_best) continue;
                orig_best = orig.get(n2);
            }
            switch (orig_best) {
                case 1: {
                    ++acc_orig;
                    break;
                }
                case 2: {
                    ++med_orig;
                    break;
                }
                case 3: {
                    ++high_orig;
                }
            }
            switch (score_best) {
                case 1: {
                    ++acc_scr;
                    break;
                }
                case 2: {
                    ++med_scr;
                    break;
                }
                case 3: {
                    ++high_scr;
                }
            }
            FileSystemTools.writeFile(String.valueOf(write_fold) + "/orig_" + n + ".txt", String.valueOf(acc_orig) + " " + med_orig + " " + high_orig);
            FileSystemTools.writeFile(String.valueOf(write_fold) + "/score_" + n + ".txt", String.valueOf(acc_scr) + " " + med_scr + " " + high_scr);
            score = rs.getTopLikely(200);
            for (Double d : score.keySet()) {
                System.out.println("Likelihood: " + d + " " + score.get(d));
                if (score.get(d) <= score_best) continue;
                score_best = score.get(d);
            }
            switch (score_best) {
                case 1: {
                    ++acc_scr200;
                    break;
                }
                case 2: {
                    ++med_scr200;
                    break;
                }
                case 3: {
                    ++high_scr200;
                }
            }
            FileSystemTools.writeFile(String.valueOf(write_fold) + "/top_200.txt", String.valueOf(acc_scr200) + " " + med_scr200 + " " + high_scr200);
        }
    }

    public static ResultStruc AnalyzePDB(String pdb, String _case, String run, double[][] prop_mat) {
        HashMap<Integer, Integer> orig = new HashMap<Integer, Integer>();
        HashMap<Double, Integer> ours = new HashMap<Double, Integer>();
        HashMap<Integer, Double> lrmsds = BatchAnalyzer.getLRMSD(_case, run, pdb);
        HashMap<Integer, Double> irmsds = BatchAnalyzer.getIRMSD(_case, run, pdb);
        HashMap<Integer, Residue> ab_sol = BatchFactory.getSolution(pdb, "AB");
        HashMap<Integer, Residue> ag_sol = BatchFactory.getSolution(pdb, "AG");
        System.out.println("Size of ab_sol = " + ab_sol.size());
        System.out.println("Size of ag_sol = " + ag_sol.size());
        ArrayList<Integer> Ag_constr = BatchAnalyzer.getEpitope(_case, pdb, ag_sol.keySet());
        ArrayList<Integer> Ab_constr = BatchAnalyzer.getParatope(_case, pdb, ab_sol.keySet());
        HashMap<Integer, Integer> clash_map = new HashMap<Integer, Integer>();
        HashMap<Integer, Double> score_map = new HashMap<Integer, Double>();
        ArrayList<Integer> clashes = new ArrayList<Integer>();
        double tot_cons = 0.0;
        for (Integer ab_i : ab_sol.keySet()) {
            Residue ab_r = ab_sol.get(ab_i);
            for (Integer ag_i : ag_sol.keySet()) {
                Residue ag_r = ag_sol.get(ag_i);
                if (!(ab_r.distanceFrom(ag_r) < 4.5)) continue;
                tot_cons += 1.0;
            }
        }
        int i = 1;
        while (i < 201) {
            String decoy_file = String.valueOf(decoy_fold) + "/complex." + i + ".pdb";
            DockingAnalyzer.createTemp(decoy_file, "");
            HashMap<Integer, Residue> ab = PDB_parser.parse(temp_AB);
            HashMap<Integer, Residue> ag = PDB_parser.parse(temp_AG);
            int clash_single = BatchAnalyzer.getClashes(ab, ag);
            clashes.add(clash_single);
            double fnat = BatchAnalyzer.getFnat(i, tot_cons, ab_sol, ag_sol, ab, ag);
            double score = BatchAnalyzer.getScore(prop_mat, Ab_constr, Ag_constr, i, tot_cons, ab, ag);
            int classification = BatchAnalyzer.getClassification(lrmsds.get(i), irmsds.get(i), fnat);
            orig.put(i, classification);
            ours.put(score, classification);
            clash_map.put(i, clash_single);
            score_map.put(i, score);
            System.out.println("fnat = " + fnat + ", lrmsd = " + lrmsds.get(i) + ", irmsd = " + irmsds.get(i));
            System.out.println("clashes = " + clash_single);
            System.out.println("class = " + classification);
            ++i;
        }
        double mean = MathFunctions.getMean(clashes);
        double stddev = MathFunctions.getStdDev(clashes);
        System.out.println("Clashes mean = " + mean);
        System.out.println("Clashes std = " + stddev);
        for (Integer i2 : clash_map.keySet()) {
            if (!((double)((Integer)clash_map.get(i2)).intValue() > mean + 2.0 * stddev)) continue;
            System.out.println("Removing id = " + i2 + " due to " + clash_map.get(i2) + " clashes");
            orig.remove(i2);
            ours.remove(score_map.get(i2));
        }
        return new ResultStruc(orig, ours);
    }

    public static ResultStruc AnalyzePDBPatchDock(String pdb, String _case, double[][] prop_mat) {
        HashMap<Integer, Integer> orig = new HashMap<Integer, Integer>();
        HashMap<Double, Integer> ours = new HashMap<Double, Integer>();
        String rmsd_fold = "/Volumes/D/PatchDock/ProFitV3.1/output";
        HashMap<Integer, Double> lrmsds = DockingAnalyzer.getLRMSD(rmsd_fold, _case, pdb);
        HashMap<Integer, Double> irmsds = DockingAnalyzer.getIRMSD(rmsd_fold, _case, pdb);
        HashMap<Integer, Residue> ab_sol = BatchFactory.getSolution(pdb, "AB");
        HashMap<Integer, Residue> ag_sol = BatchFactory.getSolution(pdb, "AG");
        System.out.println("Size of ab_sol = " + ab_sol.size());
        System.out.println("Size of ag_sol = " + ag_sol.size());
        ArrayList<Integer> Ag_constr = BatchAnalyzer.getEpitope(_case, pdb, ag_sol.keySet());
        ArrayList<Integer> Ab_constr = BatchAnalyzer.getParatope(_case, pdb, ab_sol.keySet());
        HashMap<Integer, Integer> clash_map = new HashMap<Integer, Integer>();
        HashMap<Integer, Double> score_map = new HashMap<Integer, Double>();
        ArrayList<Integer> clashes = new ArrayList<Integer>();
        double tot_cons = 0.0;
        for (Integer ab_i : ab_sol.keySet()) {
            Residue ab_r = ab_sol.get(ab_i);
            for (Integer ag_i : ag_sol.keySet()) {
                Residue ag_r = ag_sol.get(ag_i);
                if (!(ab_r.distanceFrom(ag_r) < 4.5)) continue;
                tot_cons += 1.0;
            }
        }
        String source_fold = "/Volumes/D/PatchDock/input/" + _case + "/" + pdb + "/output";
        int i = 1;
        while (i < 201) {
            String decoy_file = String.valueOf(source_fold) + "/out.txt." + i + ".pdb";
            DockingAnalyzer.createTemp(decoy_file, "");
            HashMap<Integer, Residue> ab = PDB_parser.parse(temp_AB);
            HashMap<Integer, Residue> ag = PDB_parser.parse(temp_AG);
            int clash_single = BatchAnalyzer.getClashes(ab, ag);
            clashes.add(clash_single);
            double fnat = BatchAnalyzer.getFnat(i, tot_cons, ab_sol, ag_sol, ab, ag);
            double score = BatchAnalyzer.getScore(prop_mat, Ab_constr, Ag_constr, i, tot_cons, ab, ag);
            int classification = BatchAnalyzer.getClassification(lrmsds.get(i), irmsds.get(i), fnat);
            orig.put(i, classification);
            ours.put(score, classification);
            clash_map.put(i, clash_single);
            score_map.put(i, score);
            System.out.println("fnat = " + fnat + ", lrmsd = " + lrmsds.get(i) + ", irmsd = " + irmsds.get(i));
            System.out.println("clashes = " + clash_single);
            System.out.println("class = " + classification);
            ++i;
        }
        double mean = MathFunctions.getMean(clashes);
        double stddev = MathFunctions.getStdDev(clashes);
        System.out.println("Clashes mean = " + mean);
        System.out.println("Clashes std = " + stddev);
        for (Integer i2 : clash_map.keySet()) {
            if (!((double)((Integer)clash_map.get(i2)).intValue() > mean + 2.0 * stddev)) continue;
            System.out.println("Removing id = " + i2 + " due to " + clash_map.get(i2) + " clashes");
            orig.remove(i2);
            ours.remove(score_map.get(i2));
        }
        return new ResultStruc(orig, ours);
    }

    public static int getClashes(HashMap<Integer, Residue> ab, HashMap<Integer, Residue> ag) {
        int clash = 0;
        for (Integer ab_i : ab.keySet()) {
            Residue ab_r = ab.get(ab_i);
            for (Integer ag_i : ag.keySet()) {
                Residue ag_r = ag.get(ag_i);
                if (!(ab_r.distanceFrom(ag_r) < 3.0)) continue;
                ++clash;
            }
        }
        return clash;
    }

    public static ArrayList<Integer> getEpitope(String _case, String pdb, Set<Integer> res_ids) {
        String filename = String.valueOf(userdir) + "/resources/docking_cases/" + _case + "/input/" + _case + "/" + pdb + "/epitope.txt";
        if (_case.contains("patchdock")) {
            filename = "/Volumes/D/PatchDock/input/" + _case + "/" + pdb + "/epitope.txt";
        }
        ArrayList<Integer> constr_tmp = new ArrayList<Integer>();
        ArrayList<Integer> constr = new ArrayList<Integer>();
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        for (String line : lines) {
            constr_tmp.add(Integer.parseInt(line.replace(" A", "")));
        }
        if (_case.contains("zdock")) {
            for (Integer i : res_ids) {
                if (constr_tmp.contains(i)) continue;
                constr.add(i);
            }
        } else if (_case.contains("patchdock")) {
            for (Integer i : constr_tmp) {
                constr.add(i);
            }
        } else {
            System.err.println("Unknown docker case: " + _case);
            System.exit(0);
        }
        return constr;
    }

    public static int getClassification(double lrmsd, double irmsd, double fnat) {
        int score = 0;
        if (fnat > 0.1 && fnat < 0.3 && (lrmsd < 10.0 || irmsd < 4.0) || fnat > 0.3 && lrmsd > 5.0 && irmsd > 2.0) {
            score = 1;
        }
        if (fnat > 0.3 && fnat < 0.5 && (lrmsd < 5.0 || irmsd < 2.0) || fnat > 0.5 && lrmsd > 1.0 && irmsd > 1.0) {
            score = 2;
        }
        if (fnat > 0.5 && (lrmsd < 1.0 || irmsd < 1.0)) {
            score = 3;
        }
        return score;
    }

    public static ArrayList<Integer> getParatope(String _case, String pdb, Set<Integer> res_ids) {
        String filename = String.valueOf(userdir) + "/resources/docking_cases/" + _case + "/input/" + _case + "/" + pdb + "/paratope.txt";
        if (_case.contains("patchdock")) {
            filename = "/Volumes/D/PatchDock/input/" + _case + "/" + pdb + "/paratope.txt";
        }
        ArrayList<Integer> constr_tmp = new ArrayList<Integer>();
        ArrayList<Integer> constr = new ArrayList<Integer>();
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        for (String line : lines) {
            constr_tmp.add(Integer.parseInt(line.replace(" A", "")));
        }
        if (_case.contains("zdock")) {
            for (Integer i : res_ids) {
                if (constr_tmp.contains(i)) continue;
                constr.add(i);
            }
        } else if (_case.contains("patchdock")) {
            for (Integer i : constr_tmp) {
                constr.add(i);
            }
        } else {
            System.err.println("Unknown docker case: " + _case);
            System.exit(0);
        }
        return constr;
    }

    public static HashMap<Integer, Double> getLRMSD(String _case, String run, String pdb) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/resources/docking_cases/" + _case + "/ProFitV3.1/output/" + run + "/" + pdb + "/lrmsds.txt");
        HashMap<Integer, Double> rmsd_map = new HashMap<Integer, Double>();
        for (String line : lines) {
            int id = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            double rmsd = Double.parseDouble(line.substring(line.indexOf(" ")));
            rmsd_map.put(id, rmsd);
        }
        return rmsd_map;
    }

    public static HashMap<Integer, Double> getIRMSD(String _case, String run, String pdb) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/resources/docking_cases/" + _case + "/ProFitV3.1/output/" + run + "/" + pdb + "/irmsds.txt");
        HashMap<Integer, Double> rmsd_map = new HashMap<Integer, Double>();
        for (String line : lines) {
            int id = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            if (id > 200) continue;
            double rmsd = Double.parseDouble(line.substring(line.indexOf(" ")));
            rmsd_map.put(id, rmsd);
        }
        return rmsd_map;
    }

    public static double getFnat(int i, double tot_cons, HashMap<Integer, Residue> ab_sol, HashMap<Integer, Residue> ag_sol, HashMap<Integer, Residue> ab, HashMap<Integer, Residue> ag) {
        double ok_cons = 0.0;
        for (Integer ab_i : ab.keySet()) {
            Residue ab_r = ab.get(ab_i);
            for (Integer ag_i : ag.keySet()) {
                Residue ag_r = ag.get(ag_i);
                if (!(ab_r.distanceFrom(ag_r) < 4.5) || !(ab_sol.get(ab_i).distanceFrom(ag_sol.get(ag_i)) < 4.5)) continue;
                ok_cons += 1.0;
            }
        }
        double f_nat = ok_cons / tot_cons;
        System.out.println("Id = " + i + ", ok_cons = " + ok_cons);
        System.out.println("Id = " + i + ", tot_cons = " + tot_cons);
        System.out.println("Id = " + i + ", f_nat = " + f_nat);
        return f_nat;
    }

    public static double getScore(double[][] prop_mat, ArrayList<Integer> ab_constr, ArrayList<Integer> ag_constr, int i, double tot_cons, HashMap<Integer, Residue> ab, HashMap<Integer, Residue> ag) {
        double score = 0.0;
        for (Integer ab_i : ab_constr) {
            Residue ab_r = ab.get(ab_i);
            for (Integer ag_i : ag_constr) {
                Residue ag_r = ag.get(ag_i);
                if (!(ab_r.distanceFrom(ag_r) < 4.5)) continue;
                score += prop_mat[ab_r.type.ordinal()][ag_r.type.ordinal()];
            }
        }
        System.out.println("Id = " + i + ", score = " + score);
        return score;
    }

    public static double[][] getLikelihood() {
        int[][] corr_tmp = MathFunctions.readParsable2D(String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/corr_pars.txt");
        int[][] incorr_tmp = MathFunctions.readParsable2D(String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/incorr_pars.txt");
        double[][] prop_mat = new double[20][20];
        int i = 0;
        while (i < 20) {
            int j = 0;
            while (j < 20) {
                double summa = corr_tmp[i][j] + incorr_tmp[i][j];
                if (summa > 0.0) {
                    prop_mat[i][j] = (double)corr_tmp[i][j] / summa;
                }
                ++j;
            }
            ++i;
        }
        return prop_mat;
    }

    public static double[][] getLikelihoodFrom(String folder) {
        int[][] corr_tmp = MathFunctions.readParsable2D(String.valueOf(folder) + "/result_dump/Docking/binding_profiles/corr_pars.txt");
        int[][] incorr_tmp = MathFunctions.readParsable2D(String.valueOf(folder) + "/result_dump/Docking/binding_profiles/incorr_pars.txt");
        double[][] prop_mat = new double[20][20];
        int i = 0;
        while (i < 20) {
            int j = 0;
            while (j < 20) {
                double summa = corr_tmp[i][j] + incorr_tmp[i][j];
                if (summa > 0.0) {
                    prop_mat[i][j] = (double)corr_tmp[i][j] / summa;
                }
                ++j;
            }
            ++i;
        }
        return prop_mat;
    }

    public static void generateDecoys(String pdb, String _case, String run) {
        System.out.println("Generating decoys...");
        System.out.println("Pdb= " + pdb);
        System.out.println("case= " + _case);
        System.out.println("run= " + run);
        String src_fold = String.valueOf(userdir) + "/resources/docking_cases/" + _case + "/done_runs/" + run + "/" + pdb;
        String command = String.valueOf(userdir) + "/resources/./create_decoys.sh " + src_fold;
        System.out.println("Command : \n " + command);
        try {
            Runtime.getRuntime().exec(command);
            try {
                Thread.currentThread();
                Thread.sleep(10000L);
            }
            catch (Exception exception) {}
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class ResultStruc {
        public final HashMap<Integer, Integer> orig_score;
        public final HashMap<Double, Integer> likely_score;
        private final TreeSet<Double> sorted_set;

        public ResultStruc(HashMap<Integer, Integer> os, HashMap<Double, Integer> ls) {
            this.orig_score = os;
            this.likely_score = ls;
            this.sorted_set = this.sort(ls);
        }

        public HashMap<Integer, Integer> getTopOrig(int n) {
            HashMap<Integer, Integer> res_map = new HashMap<Integer, Integer>();
            int i = 1;
            while (n > 0) {
                if (this.orig_score.containsKey(i)) {
                    res_map.put(i, this.orig_score.get(i));
                    --n;
                }
                ++i;
            }
            return res_map;
        }

        public HashMap<Double, Integer> getTopLikely(int n) {
            HashMap<Double, Integer> res_map = new HashMap<Double, Integer>();
            boolean added = false;
            Iterator<Double> iter = this.sorted_set.descendingIterator();
            while (n > 0 && iter.hasNext()) {
                double val = iter.next();
                res_map.put(val, this.likely_score.get(val));
                --n;
            }
            return res_map;
        }

        private TreeSet<Double> sort(HashMap<Double, Integer> map) {
            TreeSet<Double> set = new TreeSet<Double>();
            HashMap sorted = new HashMap();
            for (Double d : map.keySet()) {
                set.add(d);
            }
            return set;
        }
    }
}

