/*
 * Decompiled with CFR 0.152.
 */
package score_calculators;

import data_structures.Gap_function;
import data_structures.Residue;
import data_structures.Residue_combinations;
import data_structures.SC_Structure;
import data_structures.SequencePair;
import java.util.ArrayList;
import java.util.HashMap;

public class PPro_calculator {
    public static void calculate_PPro(SC_Structure struc, SC_Structure struc_other, double[][] w_intra, Gap_function g, boolean isA) {
        HashMap<Integer, Double> Sis = PPro_calculator.calculateSi(struc, struc_other, g, isA);
        for (Integer i : struc.residues.keySet()) {
            Residue res_central = struc.residues.get(i);
            double sum = 0.0;
            for (Residue res_inpatch : res_central.getPatch().patch_residues) {
                sum += w_intra[res_central.getRefSite()][res_inpatch.getRefSite()] * Sis.get(res_inpatch.getRefSite());
            }
            if (res_central.getPatch().patch_residues.size() == 0) continue;
            res_central.setPPro(sum / (double)res_central.getPatch().patch_residues.size());
        }
    }

    public static HashMap<Integer, Double> calculateSi(SC_Structure struc, SC_Structure struc_other, Gap_function g, boolean isA) {
        HashMap<Integer, Double> Sis = new HashMap<Integer, Double>();
        for (Integer i : struc.residues.keySet()) {
            Residue res_it = struc.residues.get(i);
            int it = res_it.getRefSite();
            double totalsum = 0.0;
            for (Integer l : struc_other.residues.keySet()) {
                double partialsum = 0.0;
                int num_of_sequences = 0;
                int k = struc_other.residues.get(l).getRefSite();
                ArrayList<SequencePair> eligible = isA ? g.g_func_pair[it][k] : g.g_func_pair[k][it];
                if (eligible != null) {
                    for (SequencePair sp : eligible) {
                        partialsum = isA ? (partialsum += Residue_combinations.pair_lookup[sp.sequenceA[it].classification.ordinal()][sp.sequenceB[k].classification.ordinal()].propensity) : (partialsum += Residue_combinations.pair_lookup[sp.sequenceB[it].classification.ordinal()][sp.sequenceA[k].classification.ordinal()].propensity);
                        ++num_of_sequences;
                    }
                }
                if (num_of_sequences == 0) continue;
                totalsum += partialsum / (double)num_of_sequences;
            }
            Sis.put(it, totalsum / (double)struc_other.residues.size());
        }
        return Sis;
    }
}

