/*
 * Decompiled with CFR 0.152.
 */
package main;

import analysis.SurfaceAnalyzer;
import data_structures.Gap_function;
import data_structures.MSA;
import data_structures.Patch;
import data_structures.Residue;
import data_structures.Residue_type;
import data_structures.SC_Structure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import score_calculators.Score_calculator;
import utils.FileSystemTools;

public class Main_inter {
    private final SC_Structure structureA;
    private final SC_Structure structureB;
    private final MSA msa;

    public Main_inter() {
        this.msa = null;
        this.structureA = null;
        this.structureB = null;
    }

    public Main_inter(MSA _msa, SC_Structure strA, SC_Structure strB) {
        this.msa = _msa;
        Main_inter.calculatePatches(strA);
        Main_inter.calculatePatches(strB);
        Gap_function g = new Gap_function(this.msa);
        Score_calculator sc = new Score_calculator(this.msa, g, strA, strB);
        this.structureA = sc.structure_A;
        this.structureB = sc.structure_B;
    }

    public Main_inter(MSA _msa, SC_Structure strA, SC_Structure strB, String soure_folder) {
        this.msa = _msa;
        Main_inter.calculatePatches(strA);
        Gap_function g = new Gap_function(this.msa);
        Score_calculator sc = new Score_calculator(this.msa, g, strA, strB);
        this.structureA = sc.structure_A;
        this.structureB = sc.structure_B;
    }

    public SC_Structure getStructureA() {
        return this.structureA;
    }

    public SC_Structure getStructureB() {
        return this.structureB;
    }

    public static void calculatePatche(SC_Structure str) {
        HashMap<Integer, Residue> residues_ = str.residues;
        for (Integer res_central : residues_.keySet()) {
            Residue r_c = residues_.get(res_central);
            ArrayList<Residue> patch_residues = new ArrayList<Residue>();
            for (Integer res_neighbor : residues_.keySet()) {
                if (res_central != res_neighbor) continue;
                patch_residues.add(residues_.get(res_neighbor));
            }
            Patch patch = new Patch(r_c, patch_residues);
            r_c.setPatch(patch);
        }
    }

    public static void calculatePatches(SC_Structure str) {
        HashMap<Integer, Residue> residues_ = str.residues;
        Collection<Residue> residues = residues_.values();
        for (Residue res_central : residues) {
            ArrayList<Residue> patch_residues = new ArrayList<Residue>();
            for (Residue res_neighbor : residues) {
                if (res_neighbor == res_central || !(res_neighbor.distanceFrom(res_central) < 4.5)) continue;
                patch_residues.add(res_neighbor);
            }
            Patch patch = new Patch(res_central, patch_residues);
            res_central.setPatch(patch);
        }
    }

    public static HashMap<Residue_type, ArrayList<SurfaceAnalyzer.PatchVector>> createPatchLookup(String source_folder) {
        System.out.println("Creating the patch lookup table");
        HashMap<Residue_type, ArrayList<SurfaceAnalyzer.PatchVector>> map = new HashMap<Residue_type, ArrayList<SurfaceAnalyzer.PatchVector>>();
        ArrayList<Residue_type> AAs = new ArrayList<Residue_type>();
        int i = 0;
        while (i < 20) {
            AAs.add(Residue_type.values()[i]);
            ++i;
        }
        boolean attempts = true;
        while (map.keySet().size() < 20) {
            ArrayList<String> folders = Main_inter.getInputFolders(source_folder);
            Random r = new Random();
            String chosen_protein = folders.get(r.nextInt(folders.size()));
            ArrayList<String> available_aas = Main_inter.getInputFiles(String.valueOf(source_folder) + "/" + chosen_protein);
            int random_index = r.nextInt(AAs.size());
            Residue_type AA_chosen = (Residue_type)((Object)AAs.get(random_index));
            String AA = null;
            if (!available_aas.contains("" + (Object)((Object)AA_chosen))) continue;
            AA = "" + (Object)((Object)AA_chosen);
            int index_of = AAs.indexOf((Object)AA_chosen);
            AAs.remove(index_of);
            Residue_type typ = Residue_type.mapResidue_char(AA.charAt(0));
            ArrayList<String> entries = FileSystemTools.readFile(String.valueOf(source_folder) + "/" + chosen_protein + "/" + AA);
            ArrayList<SurfaceAnalyzer.PatchVector> pv_list = new ArrayList<SurfaceAnalyzer.PatchVector>();
            for (String entry : entries) {
                SurfaceAnalyzer.PatchVector pv = SurfaceAnalyzer.PatchVector.vectorize(entry);
                pv_list.add(pv);
            }
            map.put(typ, pv_list);
        }
        return map;
    }

    public static ArrayList<String> getInputFolders(String input_folder) {
        File folder = new File(input_folder);
        File[] listOfFiles = folder.listFiles();
        ArrayList<String> out_files = new ArrayList<String>();
        int i = 0;
        while (i < listOfFiles.length) {
            if (listOfFiles[i].isDirectory()) {
                String files = listOfFiles[i].getName();
                if (!files.contains(".")) {
                    out_files.add(files);
                }
                String string = files.substring(0, 4);
            }
            ++i;
        }
        return out_files;
    }

    public static ArrayList<String> getInputFiles(String input_folder) {
        File folder = new File(input_folder);
        File[] listOfFiles = folder.listFiles();
        ArrayList<String> out_files = new ArrayList<String>();
        int i = 0;
        while (i < listOfFiles.length) {
            String files;
            if (listOfFiles[i].isFile() && !(files = listOfFiles[i].getName()).contains(".")) {
                out_files.add(files);
            }
            ++i;
        }
        System.out.println(String.valueOf(out_files.size()) + " elements extracted from " + input_folder);
        return out_files;
    }

    public static Residue_type[] annotateFakePatches(SC_Structure str, HashMap<Residue_type, ArrayList<SurfaceAnalyzer.PatchVector>> map) {
        HashMap<Integer, Residue> residues_ = str.residues;
        Collection<Residue> residues = residues_.values();
        HashMap<Integer, Residue_type> newsequence = new HashMap<Integer, Residue_type>();
        int indexing = 0;
        for (Residue res_central : residues) {
            Patch patch = Main_inter.generatePatch(map.get((Object)res_central.type), res_central);
            newsequence.put(indexing, res_central.type);
            res_central.setRefSite(indexing++);
            int i = 0;
            while (i < patch.patch_residues.size()) {
                newsequence.put(indexing, patch.patch_residues.get((int)i).type);
                patch.patch_residues.get(i).setRefSite(indexing++);
                ++i;
            }
            res_central.setPatch(patch);
        }
        Residue_type[] sequence = new Residue_type[newsequence.size()];
        int i = 0;
        while (i < indexing) {
            sequence[i] = (Residue_type)((Object)newsequence.get(i));
            ++i;
        }
        return sequence;
    }

    public static Patch generatePatch(ArrayList<SurfaceAnalyzer.PatchVector> list, Residue central_res) {
        Random r = new Random();
        int index = r.nextInt(list.size());
        SurfaceAnalyzer.PatchVector pv = list.get(index);
        ArrayList<Residue> patch_residues = new ArrayList<Residue>();
        int i = 0;
        while (i < 20) {
            int j = 0;
            while (j < pv.AAs[i]) {
                Residue res = new Residue(Residue_type.values()[i], null, i);
                patch_residues.add(res);
                ++j;
            }
            ++i;
        }
        Patch p = new Patch(central_res, patch_residues);
        return p;
    }
}

