/*
 * Decompiled with CFR 0.152.
 */
package db_interface;

import data_structures.Residue;
import data_structures.Residue_type;
import data_structures.SC_Structure;
import db_interface.Complex_Structure;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import parsing.PDB_parser;
import utils.FileSystemTools;
import utils.MathFunctions;

public class Energetics {
    static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        Energetics.BinMolarity(10);
    }

    public static HashMap<String, Integer> BinMolarity(int n_bins) {
        HashMap<String, Double> mapping = Energetics.AllAntigenEnergiesLog();
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        int[] molarities = new int[n_bins + 1];
        for (String map_i : mapping.keySet()) {
            double molarity = -mapping.get(map_i).doubleValue();
            if (molarity > max) {
                max = molarity;
            }
            if (!(molarity < min)) continue;
            min = molarity;
        }
        double d_bin = (max - min) / (double)n_bins;
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (String map_i : mapping.keySet()) {
            int bin;
            double molarity = -mapping.get(map_i).doubleValue();
            int n = bin = (int)((molarity - min) / d_bin);
            molarities[n] = molarities[n] + 1;
            result.put(map_i, bin);
        }
        System.out.println("Molarities");
        MathFunctions.print1Drray(molarities);
        return result;
    }

    public static String ClassifyMolarity(double d) {
        if (d > 1.0) {
            return "micro";
        }
        if (d > 0.001) {
            return "nano";
        }
        return "pico";
    }

    public static void energyStats() {
        String filename = String.valueOf(userdir) + "/result_dump/test_training_sets/energetics_test.txt";
        ArrayList<String> pdbs = FileSystemTools.readFile(filename);
        String std_folder = String.valueOf(userdir) + "/protein_database/standardized";
        String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
        int pep_count = 0;
        for (String pdb_code : pdbs) {
            Complex_Structure cs = new Complex_Structure(pdb_code, raw_folder, std_folder);
            if (cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.size() >= 50) continue;
            ++pep_count;
        }
        System.out.println("Got " + pep_count + " peptides");
    }

    public static void CDRpacking() {
        String src_folder = String.valueOf(userdir) + "/protein_database/non_protein_complexes";
        String res_tag = "small";
        String cdrs_folder = String.valueOf(userdir) + "/protein_database/antibodies/cdrs";
        ArrayList<String> pdbnames = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/energetics_test.txt");
        ArrayList<String> done = new ArrayList<String>();
        ArrayList<String> duplicates = new ArrayList<String>();
        int progress = 0;
        int complete = 0;
        int incomplete = 0;
        for (String pdb_name : pdbnames) {
            String pdb_code;
            int sc_Y = 0;
            System.out.println(String.valueOf(++progress) + "/" + pdbnames.size());
            if (!pdb_name.contains("_AB") || done.contains(pdb_code = pdb_name.substring(0, 4))) continue;
            done.add(pdb_code);
            File fl1 = new File(String.valueOf(cdrs_folder) + "/" + pdb_code + "L1.pdb");
            File fl2 = new File(String.valueOf(cdrs_folder) + "/" + pdb_code + "L2.pdb");
            File fl3 = new File(String.valueOf(cdrs_folder) + "/" + pdb_code + "L3.pdb");
            File fh1 = new File(String.valueOf(cdrs_folder) + "/" + pdb_code + "H1.pdb");
            File fh2 = new File(String.valueOf(cdrs_folder) + "/" + pdb_code + "H2.pdb");
            File fh3 = new File(String.valueOf(cdrs_folder) + "/" + pdb_code + "H3.pdb");
            if (fl1.exists() && fl2.exists() && fl3.exists() && fh1.exists() && fh2.exists() && fh3.exists()) {
                ++complete;
                HashMap<Integer, Residue> l1 = PDB_parser.parse(fl1.getAbsolutePath());
                HashMap<Integer, Residue> l2 = PDB_parser.parse(fl2.getAbsolutePath());
                HashMap<Integer, Residue> l3 = PDB_parser.parse(fl3.getAbsolutePath());
                HashMap<Integer, Residue> h1 = PDB_parser.parse(fh1.getAbsolutePath());
                HashMap<Integer, Residue> h2 = PDB_parser.parse(fh2.getAbsolutePath());
                HashMap<Integer, Residue> h3 = PDB_parser.parse(fh3.getAbsolutePath());
                HashMap<String, HashMap<Integer, Residue>> cdrs = new HashMap<String, HashMap<Integer, Residue>>();
                if (l1.size() == 0 || l2.size() == 0 || l3.size() == 0 || h1.size() == 0 || h2.size() == 0 || h3.size() == 0) {
                    System.err.println("One is empty " + pdb_code);
                    System.exit(0);
                }
                SC_Structure sh1 = new SC_Structure(h1, 'C', null);
                SC_Structure sh2 = new SC_Structure(h2, 'C', null);
                SC_Structure sh3 = new SC_Structure(h3, 'C', null);
                SC_Structure sl1 = new SC_Structure(l1, 'C', null);
                SC_Structure sl2 = new SC_Structure(l2, 'C', null);
                SC_Structure sl3 = new SC_Structure(l3, 'C', null);
                String all = String.valueOf(sh1.toString()) + sh2 + sh3 + sl1 + sl2 + sl3;
                if (!duplicates.contains(all)) {
                    duplicates.add(all);
                    cdrs.put("H1", h1);
                    cdrs.put("H2", h2);
                    cdrs.put("H3", h3);
                    cdrs.put("L1", l1);
                    cdrs.put("L2", l2);
                    cdrs.put("L3", l3);
                    HashMap<String, Integer> name_map = new HashMap<String, Integer>();
                    name_map.put("H1", 1);
                    name_map.put("H2", 2);
                    name_map.put("H3", 3);
                    name_map.put("L1", 4);
                    name_map.put("L2", 5);
                    name_map.put("L3", 6);
                    for (String chain : cdrs.keySet()) {
                        HashMap cdr = (HashMap)cdrs.get(chain);
                        Iterator iterator = cdr.keySet().iterator();
                        while (iterator.hasNext()) {
                            int i = (Integer)iterator.next();
                            if (((Residue)cdr.get((Object)Integer.valueOf((int)i))).type != Residue_type.Y) continue;
                            ++sc_Y;
                        }
                    }
                    continue;
                }
                System.out.println("duplicate_found " + all);
                continue;
            }
            ++incomplete;
        }
        System.out.println("Incomplete: " + incomplete);
        System.out.println("Complete: " + complete);
    }

    public static void alternativeScore() {
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/energetics_test.txt");
        int progress = 0;
        String std_folder = String.valueOf(userdir) + "/protein_database/standardized";
        String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
        String output_all = "";
        String output_ab = "";
        String output_ag = "";
        HashMap<String, Double> kds = Energetics.BigAntigenEnergies();
        for (String pdb_code : pdbcodes) {
            Residue res;
            System.out.println("alt_score: " + ++progress + "/" + pdbcodes.size() + " : " + pdb_code);
            Complex_Structure cs = new Complex_Structure(pdb_code, raw_folder, std_folder);
            cs.runPSA();
            double abasa_sum = 0.0;
            double agasa_sum = 0.0;
            for (Integer i_res : cs.m1.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                res = cs.m1.chains.get((Object)Character.valueOf((char)'A')).residues.get(i_res);
                abasa_sum += Math.abs(res.d_asa);
            }
            for (Integer i_res : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(i_res);
                agasa_sum += Math.abs(res.d_asa);
            }
            output_ab = String.valueOf(output_ab) + pdb_code + " " + abasa_sum + " " + kds.get(pdb_code.subSequence(0, 4)) + "\n";
            output_ag = String.valueOf(output_ag) + pdb_code + " " + agasa_sum + " " + kds.get(pdb_code.subSequence(0, 4)) + "\n";
            output_all = String.valueOf(output_all) + pdb_code + " " + (abasa_sum + agasa_sum) + " " + kds.get(pdb_code.subSequence(0, 4)) + "\n";
            System.out.println(String.valueOf(pdb_code) + " " + (abasa_sum + agasa_sum) + " " + kds.get(pdb_code.subSequence(0, 4)));
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/energetics_corr/all_ab", output_ab);
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/energetics_corr/all_ag", output_ag);
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/energetics_corr/all_asa", output_all);
    }

    public static void generateCorrelationTPRO() {
        Energetics.generateScores(String.valueOf(userdir) + "/TestResults/ABAGEnergeticsTPRO", 5);
        Energetics.generateScores(String.valueOf(userdir) + "/TestResults/ABAGEnergeticsTPRO", 10);
        Energetics.generateScores(String.valueOf(userdir) + "/TestResults/ABAGEnergeticsTPRO", 15);
        Energetics.generateScores(String.valueOf(userdir) + "/TestResults/ABAGEnergeticsTPRO", 20);
        Energetics.generateScores(String.valueOf(userdir) + "/TestResults/ABAGEnergeticsTPRO", 30);
        Energetics.generateScores(String.valueOf(userdir) + "/TestResults/ABAGEnergeticsTPRO", 9999);
    }

    public static void generateScores(String folder, int howmany) {
        ArrayList<String> files = FileSystemTools.getFullFiles(folder);
        HashMap<Integer, Double> all = new HashMap<Integer, Double>();
        HashMap<Integer, Double> ab = new HashMap<Integer, Double>();
        HashMap<Integer, Double> ag = new HashMap<Integer, Double>();
        for (String file : files) {
            if (!file.contains("TPRO_")) continue;
            System.out.println(file);
            int index = Integer.parseInt(file.substring(5));
            int pdb_index = index % 2 != 0 ? index / 2 + 1 : index / 2;
            double s1 = Energetics.readTPRO(String.valueOf(folder) + "/" + file, howmany);
            if (all.containsKey(pdb_index)) {
                all.put(pdb_index, (Double)all.get(pdb_index) + s1);
            } else {
                all.put(pdb_index, s1);
            }
            if (index % 2 != 0) {
                if (ab.containsKey(pdb_index)) {
                    ab.put(pdb_index, (Double)ab.get(pdb_index) + s1);
                    continue;
                }
                ab.put(pdb_index, s1);
                continue;
            }
            if (ag.containsKey(pdb_index)) {
                ag.put(pdb_index, (Double)ag.get(pdb_index) + s1);
                continue;
            }
            ag.put(pdb_index, s1);
        }
        HashMap<Integer, Double> kds = Energetics.energeticsList(String.valueOf(userdir) + "/Tests/ABAGEnergetics");
        String out_all = "";
        String out_ab = "";
        String out_ag = "";
        for (Integer i : all.keySet()) {
            out_all = String.valueOf(out_all) + i + " " + all.get(i) + " " + kds.get(i) + "\n";
            out_ab = String.valueOf(out_ab) + i + " " + ab.get(i) + " " + kds.get(i) + "\n";
            out_ag = String.valueOf(out_ag) + i + " " + ag.get(i) + " " + kds.get(i) + "\n";
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/energetics_corr/all_tpro_" + howmany, out_all);
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/energetics_corr/ab_tpro_" + howmany, out_ab);
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/energetics_corr/ag_tpro_" + howmany, out_ag);
    }

    public static HashMap<String, Integer> readMapIn(String folder) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(folder) + "/name_mapping.txt");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String line : lines) {
            map.put(String.valueOf(line.substring(line.indexOf(32) + 1)), Integer.parseInt(String.valueOf(line.substring(0, line.indexOf(32)))));
        }
        return map;
    }

    public static double readTPRO(String filename, int n) {
        double score;
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        TreeSet<Double> scores = new TreeSet<Double>();
        for (String line : lines) {
            score = Double.parseDouble(line.substring(line.indexOf(9) + 1));
            scores.add(score);
        }
        double sum = 0.0;
        Iterator iterator = scores.descendingSet().iterator();
        while (iterator.hasNext()) {
            score = (Double)iterator.next();
            if (n-- == 0) break;
            sum += score;
        }
        return sum;
    }

    public static HashMap<Integer, Double> energeticsList(String folder) {
        HashMap<String, Integer> name_map = Energetics.readMapIn(folder);
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/eligible_pdbs.txt");
        int overlap = 0;
        HashMap<Integer, Double> affinity_map = new HashMap<Integer, Double>();
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/resources/bindingdata/pdbbindcn.txt");
        for (String line : lines) {
            if (!pdbcodes.contains(String.valueOf((line = line.substring(line.indexOf("\t\t") + 2)).substring(0, 4).toUpperCase()) + "_AB") || line.contains("Ki")) continue;
            ++overlap;
            String Kd_s = "" + line.subSequence(line.indexOf(61) + 1, line.indexOf(77));
            char units = Kd_s.charAt(Kd_s.length() - 1);
            double Kd = Double.parseDouble(Kd_s.substring(0, Kd_s.length() - 1));
            switch (units) {
                case 'u': {
                    break;
                }
                case 'n': {
                    Kd *= 0.001;
                    break;
                }
                case 'p': {
                    Kd *= 1.0E-6;
                    break;
                }
                default: {
                    System.err.println("Unknown units " + units);
                    System.exit(0);
                }
            }
            affinity_map.put(name_map.get(String.valueOf(line.substring(0, 4).toUpperCase()) + "_AB"), Kd);
            System.out.println(String.valueOf(line.substring(0, 4)) + " " + Kd_s + " = " + Kd + " micromolar");
            System.out.println(name_map.get(String.valueOf(line.substring(0, 4).toUpperCase()) + "_AB") + " " + affinity_map.get(name_map.get(String.valueOf(line.substring(0, 4).toUpperCase()) + "_AB")));
        }
        return affinity_map;
    }

    public static HashMap<String, Double> PeptideEnergies() {
        String src_file = String.valueOf(userdir) + "/result_dump/pdb_lists/peptide_antigen.txt";
        return Energetics.getEnergyList(src_file);
    }

    public static HashMap<String, Double> BigAntigenEnergies() {
        String src_file = String.valueOf(userdir) + "/result_dump/pdb_lists/big_antigen.txt";
        return Energetics.getEnergyList(src_file);
    }

    public static HashMap<String, Double> AllAntigenEnergies() {
        String src_file = String.valueOf(userdir) + "/result_dump/pdb_lists/all_antigen.txt";
        return Energetics.getEnergyList(src_file);
    }

    public static HashMap<String, Double> AllAntigenEnergiesLog() {
        String src_file = String.valueOf(userdir) + "/result_dump/pdb_lists/all_antigen.txt";
        return Energetics.getEnergyListLog(src_file);
    }

    public static HashMap<String, Double> getEnergyList(String file) {
        ArrayList<String> pdbcodes = FileSystemTools.readFile(file);
        int overlap = 0;
        HashMap<String, Double> affinity_map = new HashMap<String, Double>();
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/resources/bindingdata/pdbbindcn.txt");
        for (String line : lines) {
            if (!pdbcodes.contains(String.valueOf((line = line.substring(line.indexOf("\t\t") + 2)).substring(0, 4).toUpperCase()) + "_AB") || line.contains("Ki")) continue;
            ++overlap;
            String Kd_s = "" + line.subSequence(line.indexOf(61) + 1, line.indexOf(77));
            char units = Kd_s.charAt(Kd_s.length() - 1);
            double Kd = Double.parseDouble(Kd_s.substring(0, Kd_s.length() - 1));
            switch (units) {
                case 'u': {
                    break;
                }
                case 'n': {
                    Kd *= 0.001;
                    break;
                }
                case 'p': {
                    Kd *= 1.0E-6;
                    break;
                }
                default: {
                    System.err.println("Unknown units " + units);
                    System.exit(0);
                }
            }
            affinity_map.put(line.substring(0, 4).toUpperCase(), Kd);
        }
        return affinity_map;
    }

    public static HashMap<String, Double> getEnergyListLog(String file) {
        ArrayList<String> pdbcodes = FileSystemTools.readFile(file);
        int overlap = 0;
        HashMap<String, Double> affinity_map = new HashMap<String, Double>();
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/resources/bindingdata/pdbbindcn.txt");
        for (String line : lines) {
            if (!pdbcodes.contains(String.valueOf((line = line.substring(line.indexOf("\t\t") + 2)).substring(0, 4).toUpperCase()) + "_AB") || line.contains("Ki")) continue;
            ++overlap;
            String Kd_s = "" + line.subSequence(line.indexOf(61) + 1, line.indexOf(77));
            char units = Kd_s.charAt(Kd_s.length() - 1);
            double Kd = Double.parseDouble(Kd_s.substring(0, Kd_s.length() - 1));
            switch (units) {
                case 'u': {
                    Kd *= 0.01;
                    break;
                }
                case 'n': {
                    Kd *= 1.0E-5;
                    break;
                }
                case 'p': {
                    Kd *= 1.0E-8;
                    break;
                }
                default: {
                    System.err.println("Unknown units " + units);
                    System.exit(0);
                }
            }
            double Kd_log = Math.log10(Kd);
            affinity_map.put(line.substring(0, 4).toUpperCase(), Kd_log);
        }
        return affinity_map;
    }
}

