/*
 * Decompiled with CFR 0.152.
 */
package docking;

import data_structures.Atom;
import data_structures.Residue;
import data_structures.SC_Structure;
import docking.BatchFactory;
import docking.DockingAnalyzer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class LikelihoodMatrix {
    public static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        boolean prog = false;
        String pdb = "1ahw";
        String ag_folder = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution";
        HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb + "/AB.pdb", 'A');
        HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb + "/AG.pdb", 'A');
        ArrayList<Integer> ep_real = DockingAnalyzer.loadTruesListAg(pdb);
        ArrayList<Integer> pa_real = DockingAnalyzer.loadTruesList(pdb);
        ArrayList<Integer> ep = DockingAnalyzer.loadEPConsPartialParametrized("R", pdb, "4");
        ArrayList<Integer> pa_0 = DockingAnalyzer.loadIPCons("R", pdb, 1);
        ArrayList<Integer> pa_1 = DockingAnalyzer.loadOurCDRs(pdb);
        ArrayList<Integer> pa = new ArrayList<Integer>();
        for (Integer i : pa_0) {
            if (!pa_1.contains(i)) continue;
            pa.add(i);
        }
        LikelihoodMatrix.colorCons(ab, pa, pa_real, "1ahw_ab");
        LikelihoodMatrix.colorCons(ag, ep, ep_real, "1ahw_ag");
    }

    public static void writeCase(String pdb) {
        String ag_folder = String.valueOf(userdir) + "/protein_database/standard_pono";
        HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb + "_A.pdb", 'A');
        HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb + "_B.pdb", 'A');
        ArrayList<Integer> ep = LikelihoodMatrix.getContactsAg(ab, ag);
        ArrayList<Integer> pa = LikelihoodMatrix.getContactsAb(ab, ag);
        ArrayList<Integer> pa_a = LikelihoodMatrix.augmentBinding(ab, pa, 6.0);
        ArrayList<Integer> ep_a = LikelihoodMatrix.augmentBinding(ag, ep, 6.0);
        for (Integer a : ep_a) {
            ep.add(a);
        }
        for (Integer a : pa_a) {
            pa.add(a);
        }
        ep = BatchFactory.zdock_constraint(ep, ag);
        pa = BatchFactory.zdock_constraint(pa, ab);
        File f = new File(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/likelihood_dataset/" + pdb.toLowerCase());
        if (!f.exists()) {
            f.mkdir();
        }
        FileSystemTools.CopyFile(String.valueOf(ag_folder) + "/" + pdb + "_A.pdb", String.valueOf(f.getAbsolutePath()) + "/AB.pdb");
        FileSystemTools.CopyFile(String.valueOf(ag_folder) + "/" + pdb + "_B.pdb", String.valueOf(f.getAbsolutePath()) + "/AG.pdb");
        String ep_str = "";
        String pa_str = "";
        for (Integer i : ep) {
            ep_str = String.valueOf(ep_str) + i + "\n";
        }
        for (Integer i : pa) {
            pa_str = String.valueOf(pa_str) + i + "\n";
        }
        FileSystemTools.writeFile(String.valueOf(f.getAbsolutePath()) + "/paratope.txt", pa_str);
        FileSystemTools.writeFile(String.valueOf(f.getAbsolutePath()) + "/epitope.txt", ep_str);
    }

    public static ArrayList<Integer> augmentBinding(HashMap<Integer, Residue> s, ArrayList<Integer> cons, double d) {
        ArrayList<Integer> aug = new ArrayList<Integer>();
        block0: for (Integer i : s.keySet()) {
            if (cons.contains(i)) continue;
            Residue r = s.get(i);
            for (Integer i_con : cons) {
                Residue r_con = s.get(i_con);
                if (!(r.distanceFrom(r_con) < d)) continue;
                aug.add(i);
                continue block0;
            }
        }
        return aug;
    }

    public static void colorCons(HashMap<Integer, Residue> str, ArrayList<Integer> cons, ArrayList<Integer> real, String name) {
        ArrayList<String> out_list = new ArrayList<String>();
        int i = 1;
        while (i < 1500) {
            if (str.containsKey(i)) {
                Residue r = str.get(i);
                for (Atom a : r.atoms) {
                    if (cons.contains(i) && real.contains(i)) {
                        out_list.add(SC_Structure.colorBFactor(a.pdb_line, "100"));
                        continue;
                    }
                    if (real.contains(i)) {
                        out_list.add(SC_Structure.colorBFactor(a.pdb_line, "75"));
                        continue;
                    }
                    if (cons.contains(i)) {
                        out_list.add(SC_Structure.colorBFactor(a.pdb_line, "25"));
                        continue;
                    }
                    out_list.add(SC_Structure.colorBFactor(a.pdb_line, "0"));
                }
            }
            ++i;
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/pymol_temp/" + name, out_list);
    }

    public static ArrayList<String> getBigAntigens() {
        String filename = String.valueOf(userdir) + "/result_dump/test_training_sets/training_ponom.txt";
        String ag_folder = String.valueOf(userdir) + "/protein_database/standard_pono";
        ArrayList<String> pdbs = FileSystemTools.readFile(filename);
        ArrayList<String> big_ags = new ArrayList<String>();
        int big_count = 0;
        String out_big = "";
        for (String line : pdbs) {
            String pdb = line.substring(0, 4);
            HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb + "_B.pdb", 'A');
            if (ag.size() > 50) {
                ++big_count;
                big_ags.add(pdb);
            }
            if (ag.size() > 30 && ag.size() < 35) {
                System.out.println("The pep one is: " + pdb);
            }
            out_big = String.valueOf(out_big) + ag.size() + "\n";
            if (ag.size() <= 1000) continue;
            System.out.println("The big ass one is: " + pdb);
        }
        System.out.println("Total big antigens " + big_count);
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/Docking/training_ag_size.txt", out_big);
        return big_ags;
    }

    public static ArrayList<Integer> getContactsAb(HashMap<Integer, Residue> ab, HashMap<Integer, Residue> ag) {
        ArrayList<Integer> cons = new ArrayList<Integer>();
        block0: for (Integer ab_i : ab.keySet()) {
            Residue ab_r = ab.get(ab_i);
            for (Integer ag_i : ag.keySet()) {
                Residue ag_r = ag.get(ag_i);
                if (!(ab_r.distanceFrom(ag_r) < 4.5)) continue;
                cons.add(ab_i);
                continue block0;
            }
        }
        return cons;
    }

    public static ArrayList<Integer> getContactsAg(HashMap<Integer, Residue> ab, HashMap<Integer, Residue> ag) {
        ArrayList<Integer> cons = new ArrayList<Integer>();
        block0: for (Integer ag_i : ag.keySet()) {
            Residue ag_r = ag.get(ag_i);
            for (Integer ab_i : ab.keySet()) {
                Residue ab_r = ab.get(ab_i);
                if (!(ab_r.distanceFrom(ag_r) < 4.5)) continue;
                cons.add(ag_i);
                continue block0;
            }
        }
        return cons;
    }
}

