/*
 * Decompiled with CFR 0.152.
 */
package POMBA;

import java.util.ArrayList;
import utils.FileSystemTools;

public class DiffParser {
    public static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        DiffParser.doDiff();
        DiffParser.doUsage();
    }

    public static void doUsage() {
        String out = "<data>";
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/POMBA/diff_files/usage");
        for (String line : lines) {
            String word = DiffParser.parseLine(line);
            out = String.valueOf(out) + "<di>" + word + "</di>";
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/POMBA/diff_processed/usage", String.valueOf(out) + "</data>");
    }

    public static void doDiff() {
        ArrayList<String> db_names = new ArrayList<String>();
        db_names.add("meiotic");
        db_names.add("quiescent7days");
        db_names.add("quiescentpt2");
        for (String name : db_names) {
            String out = "<data>";
            ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/POMBA/diff_files/diff_" + name);
            for (String line : lines) {
                System.out.println(String.valueOf(name) + " : " + line);
                String word = DiffParser.parseLine(line);
                out = String.valueOf(out) + "<di>" + word + "</di>";
            }
            FileSystemTools.writeFile(String.valueOf(userdir) + "/POMBA/diff_processed/diff_" + name, String.valueOf(out) + "</data>");
        }
    }

    public static String parseLine(String line) {
        String chromosome = line.substring(0, line.indexOf(" "));
        line = line.substring(line.indexOf(" ") + 1);
        String position = line.substring(0, line.indexOf(" "));
        line = line.substring(line.indexOf(" ") + 1);
        String value = line.substring(0, line.indexOf(" "));
        line = line.substring(line.indexOf(" ") + 1);
        line = line.substring(line.indexOf(" ") + 1);
        line = line.substring(line.indexOf(" ") + 1);
        String name = line.substring(0, line.indexOf(" "));
        String dataset = line = line.substring(line.indexOf(" ") + 1);
        int data = -1;
        if (dataset.equals("UCLstrandspecific")) {
            data = 0;
        }
        if (dataset.equals("meiotic")) {
            data = 1;
        }
        if (dataset.equals("quiescent7days")) {
            data = 2;
        }
        if (dataset.equals("quiescentpt2")) {
            data = 3;
        }
        String word = "<ch>" + chromosome + "</ch>\n" + "<p>" + position + "</p>\n" + "<v>" + value + "</v>\n" + "<n>" + name + "</n>\n" + "<d>" + data + "</d>\n";
        return word;
    }
}

