/*
 * Decompiled with CFR 0.152.
 */
package energy;

import java.util.ArrayList;
import utils.FileSystemTools;

public class DescriptorsCalculator {
    public static final String userdir = System.getProperty("user.dir");
    public static final String pyDock_fld = String.valueOf(userdir) + "/auxiliarysoftware/en_descriptors/pyDock3/input";
    public static final String dcomplex_fld = String.valueOf(userdir) + "/auxiliarysoftware/en_descriptors/dcomplex_single_file";

    public static void main(String[] args) {
        String input_folder = String.valueOf(userdir) + "/protein_database/combined_input";
        DescriptorsCalculator.runDcomplexBatch(input_folder);
    }

    public static void runDcomplexBatch(String src_fld) {
        ArrayList<String> files = FileSystemTools.getFiles(src_fld);
        String script = "";
        for (String file : files) {
            script = String.valueOf(script) + "./dcomplex " + src_fld + "/" + file + " A B >outputs/output_" + file.substring(0, 4) + ".txt \n";
        }
        FileSystemTools.writeFile(String.valueOf(dcomplex_fld) + "/script.sc", script);
    }

    public static void pyDockIn(String src_fld) {
        ArrayList<String> files = FileSystemTools.getFiles(src_fld);
        for (String file : files) {
            String pdb_code = file.substring(0, 4);
            String out = "[receptor]\npdb         = 1PPE_r_u.pdb \nmol         =  \nnewmol      = A\n[ligand]\npdb         = 1PPE_l_u.pdb\nmol         = A \nnewmol      = B\n";
            out = String.valueOf(out) + "[reference]\n";
            out = String.valueOf(out) + "pdb         = " + src_fld + "/" + file + "\n";
            out = String.valueOf(out) + "recmol      = E\n";
            out = String.valueOf(out) + "ligmol      = I\n";
            out = String.valueOf(out) + "newrecmol   = A \n";
            out = String.valueOf(out) + "newligmol   = B\n";
            FileSystemTools.writeFile(String.valueOf(pyDock_fld) + "/" + pdb_code + ".ini", out);
        }
    }
}

