/*
 * Decompiled with CFR 0.152.
 */
package energy;

import db_interface.Energetics;
import energy.Atom_clustering;
import energy.CombinedClassifier;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import utils.FileSystemTools;
import utils.MathFunctions;

public class InputGenerator {
    public static final String userdir = System.getProperty("user.dir");
    public static final String descr_fold = String.valueOf(userdir) + "/resources/BindingAffinity/Descriptors";
    public static final String arff_fold = String.valueOf(userdir) + "/resources/BindingAffinity/ARFF";

    public static void main(String[] args) {
        InputGenerator.prepareInputForCorrelation();
    }

    public static void prepareInputForCorrelation() {
        double[][] pf_desc = InputGenerator.readDescriptors();
        HashMap<Integer, String> descriptors = InputGenerator.readDescriptorNames();
        int i = 0;
        while (i < descriptors.size()) {
            System.out.print(String.valueOf(descriptors.get(i)) + " ");
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < pf_desc.length) {
            int att = 0;
            while (att < pf_desc[0].length) {
                System.out.print(String.valueOf(pf_desc[i][att]) + ", ");
                ++att;
            }
            System.out.println();
            ++i;
        }
        HashMap<Integer, String> pdb_map = InputGenerator.getBackwardsMapping();
        HashMap<String, Double> classification_log = Energetics.AllAntigenEnergiesLog();
        HashMap<String, Double> classification_nlog = Energetics.AllAntigenEnergies();
        int att = 0;
        while (att < pf_desc[0].length) {
            String filename = String.valueOf(userdir) + "/result_dump/energetics_corr/" + descriptors.get(att);
            String log_out = "";
            String nlog_out = "";
            int i2 = 0;
            while (i2 < pf_desc.length) {
                log_out = String.valueOf(log_out) + pf_desc[i2][att] + " " + classification_log.get(pdb_map.get(i2)) + "\n";
                nlog_out = String.valueOf(nlog_out) + pf_desc[i2][att] + " " + classification_nlog.get(pdb_map.get(i2)) + "\n";
                ++i2;
            }
            FileSystemTools.writeFile(String.valueOf(filename) + "_nlog.txt", nlog_out);
            FileSystemTools.writeFile(String.valueOf(filename) + "_log.txt", log_out);
            ++att;
        }
    }

    public static void CreateInputForComparison(int x) {
        double[][] pf_desc = InputGenerator.readDescriptors();
        int instances = pf_desc.length;
        ArrayList<Integer> training = new ArrayList<Integer>();
        int i = 0;
        while (i < instances) {
            training.add(i);
            ++i;
        }
        ArrayList<Integer> test = MathFunctions.NoutOfK(training, x);
        InputGenerator.writeDifferenceARFFCLASS(pf_desc, training, "diff_train");
        InputGenerator.writeDifferenceARFFNUMERIC(pf_desc, training, "diff_train");
        InputGenerator.writeDifferenceARFFCLASS(pf_desc, test, "diff_test");
        InputGenerator.writeDifferenceARFFNUMERIC(pf_desc, test, "diff_test");
    }

    public static void writeDifferenceARFFCLASS(double[][] attributes, ArrayList<Integer> original_indices, String filename) {
        HashMap<Integer, String> pdb_map = InputGenerator.getBackwardsMapping();
        HashMap<String, Double> classification = Energetics.AllAntigenEnergies();
        for (String s : classification.keySet()) {
            System.out.println(String.valueOf(s) + "=" + -classification.get(s).doubleValue());
        }
        String output = "@RELATION energetics\n\n";
        int i = 0;
        while (i < attributes[0].length) {
            output = String.valueOf(output) + "@ATTRIBUTE att_" + i + " NUMERIC\n";
            ++i;
        }
        output = String.valueOf(output) + "@ATTRIBUTE class {mol_0,mol_1}\n\n";
        output = String.valueOf(output) + "@DATA\n";
        for (int inst_1 : original_indices) {
            for (int inst_2 : original_indices) {
                if (inst_1 == inst_2) continue;
                int j = 0;
                while (j < attributes[0].length) {
                    output = String.valueOf(output) + (attributes[inst_1][j] - attributes[inst_2][j]) + ",";
                    ++j;
                }
                output = classification.get(pdb_map.get(inst_1)) > classification.get(pdb_map.get(inst_2)) ? String.valueOf(output) + "mol_0\n" : String.valueOf(output) + "mol_1\n";
            }
        }
        FileSystemTools.writeFile(String.valueOf(arff_fold) + "/" + filename + "_class", output);
    }

    public static void writeDifferenceARFFNUMERIC(double[][] attributes, ArrayList<Integer> original_indices, String filename) {
        HashMap<Integer, String> pdb_map = InputGenerator.getBackwardsMapping();
        HashMap<String, Double> classification = Energetics.AllAntigenEnergies();
        for (String s : classification.keySet()) {
            System.out.println(String.valueOf(s) + "=" + -classification.get(s).doubleValue());
        }
        String output = "@RELATION energetics\n\n";
        int i = 0;
        while (i < attributes[0].length) {
            output = String.valueOf(output) + "@ATTRIBUTE att_" + i + " NUMERIC\n";
            ++i;
        }
        output = String.valueOf(output) + "@ATTRIBUTE class NUMERIC\n\n";
        output = String.valueOf(output) + "@DATA\n";
        boolean ordinals = false;
        for (int inst_1 : original_indices) {
            for (int inst_2 : original_indices) {
                if (inst_1 == inst_2) continue;
                int j = 0;
                while (j < attributes[0].length) {
                    output = String.valueOf(output) + (attributes[inst_1][j] - attributes[inst_2][j]) + ",";
                    ++j;
                }
                output = classification.get(pdb_map.get(inst_1)) > classification.get(pdb_map.get(inst_2)) ? String.valueOf(output) + "0\n" : String.valueOf(output) + "1\n";
            }
        }
        FileSystemTools.writeFile(String.valueOf(arff_fold) + "/" + filename + "_num", output);
    }

    public static void RunClassifierOverfit() {
        int n_bins = 10;
        boolean got_right = false;
        int sofar = 1;
        int test_size = 1;
        double[][] pf_desc = InputGenerator.readDescriptors();
        double score = 0.0;
        int num = 0;
        while (num < 1000) {
            ArrayList<Integer> training = new ArrayList<Integer>();
            ArrayList<Object> test = new ArrayList();
            int i = 0;
            while (i < pf_desc.length) {
                training.add(i);
                ++i;
            }
            test = MathFunctions.NoutOfK(training, test_size);
            System.out.println("Training: " + training.size());
            System.out.println("Test: " + test.size());
            double[][] training_mat = MathFunctions.getRemovedRows(pf_desc, training);
            double[][] test_mat = MathFunctions.getRemovedRows(pf_desc, test);
            InputGenerator.translateToARFFNumCOMPOverfit(training_mat, "REAL", n_bins, training);
            InputGenerator.translateToARFFClassOverfit(training_mat, "REAL", n_bins, training);
            InputGenerator.translateToARFFNumCOMPOverfit(test_mat, "SINGLE", n_bins, test);
            InputGenerator.translateToARFFClassOverfit(test_mat, "SINGLE", n_bins, test);
            System.out.println("Done: " + sofar);
            System.out.println("Score: " + (score += CombinedClassifier.RunCombinedClassifierAloneOverfit()) / (double)sofar);
            ++sofar;
            ++num;
        }
    }

    public static void RunClassifierRemover() {
        int n_bins = 10;
        double cutoff = 6.0;
        int got_right = 0;
        int sofar = 1;
        Random rando = new Random();
        double[][] pf_desc = InputGenerator.readDescriptors();
        while (true) {
            boolean val;
            int j;
            int i;
            if ((i = rando.nextInt(pf_desc.length)) == (j = rando.nextInt(pf_desc.length))) {
                continue;
            }
            double[][] new_desc = MathFunctions.removeRow(pf_desc, i);
            new_desc = i > j ? MathFunctions.removeRow(new_desc, j) : MathFunctions.removeRow(new_desc, j - 1);
            double[] r1 = MathFunctions.getRow(pf_desc, i);
            double[] r2 = MathFunctions.getRow(pf_desc, j);
            double[][] merged = new double[1][r1.length * 2];
            int k = 0;
            while (k < r1.length * 2) {
                merged[0][k] = k < r1.length ? r1[k] : r2[k - r1.length];
                ++k;
            }
            Random r = new Random();
            if (r.nextBoolean()) {
                System.out.println("Setting random true");
                val = true;
            } else {
                System.out.println("Setting random false");
                val = false;
            }
            InputGenerator.translateToARFFNumCOMPSingle(merged, "SINGLE", n_bins, i, j, val);
            InputGenerator.translateToARFFClassCOMPSingle(merged, "SINGLE", n_bins, i, j, val);
            InputGenerator.translateToARFFNumCOMP(new_desc, "REAL", n_bins, i, j);
            InputGenerator.translateToARFFClassCOMP(new_desc, "REAL", n_bins, i, j);
            boolean gotit = CombinedClassifier.RunCombinedClassifierAloneREMOVER();
            if (gotit) {
                ++got_right;
            }
            System.out.println("Currently at: " + sofar + "/" + pf_desc.length * pf_desc.length);
            System.out.println("Current score: " + (double)got_right / (double)sofar);
            ++sofar;
        }
    }

    public static void PrepareInputsComparison() {
        int n_bins = 10;
        double cutoff = 4.5;
        double[][] pf_desc = InputGenerator.readDescriptors();
    }

    public static void PrepareInputsEnergy() {
        int n_bins = 10;
        double cutoff = 4.5;
        double[][] pf_desc = InputGenerator.readDescriptors();
        double[][] atom_desc = Atom_clustering.getAtomDescriptors(cutoff);
        double[][] final_desc = MathFunctions.mergeMatrices(pf_desc, atom_desc);
        InputGenerator.translateToARFFNum(final_desc, "REAL", n_bins);
        InputGenerator.translateToARFFClass(final_desc, "REAL", n_bins);
    }

    public static void translateToARFFClass(double[][] attributes, String filename, int n_bins) {
        HashMap<Integer, String> pdb_map = InputGenerator.getBackwardsMapping();
        HashMap<String, Integer> classification = Energetics.BinMolarity(n_bins);
        String output = "@RELATION energetics\n\n";
        int i = 0;
        while (i < attributes[0].length) {
            output = String.valueOf(output) + "@ATTRIBUTE att_" + i + " NUMERIC\n";
            ++i;
        }
        ArrayList<String> classes = new ArrayList<String>();
        for (String i2 : classification.keySet()) {
            if (classes.contains("mol_" + classification.get(i2))) continue;
            classes.add("mol_" + classification.get(i2));
        }
        output = String.valueOf(output) + "@ATTRIBUTE class {";
        int i3 = 0;
        while (i3 < classes.size()) {
            String _class = (String)classes.get(i3);
            output = i3 + 1 == classes.size() ? String.valueOf(output) + _class + "}\n\n" : String.valueOf(output) + _class + ",";
            ++i3;
        }
        output = String.valueOf(output) + "@DATA\n";
        i3 = 0;
        while (i3 < attributes.length) {
            int j = 0;
            while (j < attributes[0].length) {
                output = String.valueOf(output) + attributes[i3][j] + ",";
                ++j;
            }
            output = String.valueOf(output) + "mol_" + classification.get(pdb_map.get(i3)) + "\n";
            ++i3;
        }
        FileSystemTools.writeFile(String.valueOf(arff_fold) + "/" + filename + "_" + n_bins + "_class", output);
    }

    public static void translateToARFFNum(double[][] attributes, String filename, int n_bins) {
        HashMap<Integer, String> pdb_map = InputGenerator.getBackwardsMapping();
        HashMap<String, Integer> classification = Energetics.BinMolarity(n_bins);
        String output = "@RELATION energetics\n\n";
        int i = 0;
        while (i < attributes[0].length) {
            output = String.valueOf(output) + "@ATTRIBUTE att_" + i + " NUMERIC\n";
            ++i;
        }
        ArrayList classes = new ArrayList();
        output = String.valueOf(output) + "@ATTRIBUTE class NUMERIC\n\n";
        output = String.valueOf(output) + "@DATA\n";
        int i2 = 0;
        while (i2 < attributes.length) {
            int j = 0;
            while (j < attributes[0].length) {
                output = String.valueOf(output) + attributes[i2][j] + ",";
                ++j;
            }
            output = String.valueOf(output) + classification.get(pdb_map.get(i2)) + "\n";
            ++i2;
        }
        FileSystemTools.writeFile(String.valueOf(arff_fold) + "/" + filename + "_" + n_bins + "_num", output);
    }

    public static void translateToARFFClassCOMP(double[][] attributes, String filename, int n_bins, int _i, int _j) {
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(String.valueOf(arff_fold) + "/" + filename + "_class");
            out = new BufferedWriter(fstream);
            HashMap<String, Double> energies = Energetics.AllAntigenEnergies();
            HashMap<Integer, String> pdb_map = InputGenerator.getBackwardsMapping(_i, _j);
            out.write("@RELATION energetics\n\n");
            int i = 0;
            while (i < 2 * attributes[0].length) {
                out.write("@ATTRIBUTE att_" + i + " NUMERIC\n");
                ++i;
            }
            out.write("@ATTRIBUTE class {mol_0,mol_1}\n\n");
            out.write("@DATA\n");
            i = 0;
            while (i < attributes.length) {
                int j = 0;
                while (j < attributes.length) {
                    if (i != j) {
                        double mol1 = energies.get(pdb_map.get(i));
                        double mol2 = energies.get(pdb_map.get(j));
                        String tmp = "";
                        int k = 0;
                        while (k < attributes[0].length) {
                            tmp = String.valueOf(tmp) + attributes[i][k] + ",";
                            ++k;
                        }
                        k = 0;
                        while (k < attributes[0].length) {
                            tmp = String.valueOf(tmp) + attributes[j][k] + ",";
                            ++k;
                        }
                        out.write(tmp);
                        out.write("mol_" + (mol1 < mol2 ? 0 : 1) + "\n");
                    }
                    ++j;
                }
                ++i;
            }
            out.flush();
            fstream.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            System.exit(0);
        }
    }

    public static void translateToARFFNumCOMP(double[][] attributes, String filename, int n_bins, int _i, int _j) {
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(String.valueOf(arff_fold) + "/" + filename + "_num");
            out = new BufferedWriter(fstream);
            HashMap<String, Double> energies = Energetics.AllAntigenEnergies();
            HashMap<Integer, String> pdb_map = InputGenerator.getBackwardsMapping(_i, _j);
            out.write("@RELATION energetics\n\n");
            int i = 0;
            while (i < 2 * attributes[0].length) {
                out.write("@ATTRIBUTE att_" + i + " NUMERIC\n");
                ++i;
            }
            out.write("@ATTRIBUTE class NUMERIC\n\n");
            out.write("@DATA\n");
            i = 0;
            while (i < attributes.length) {
                int j = 0;
                while (j < attributes.length) {
                    if (i != j) {
                        double mol1 = energies.get(pdb_map.get(i));
                        double mol2 = energies.get(pdb_map.get(j));
                        String tmp = "";
                        int k = 0;
                        while (k < attributes[0].length) {
                            tmp = String.valueOf(tmp) + attributes[i][k] + ",";
                            ++k;
                        }
                        k = 0;
                        while (k < attributes[0].length) {
                            tmp = String.valueOf(tmp) + attributes[j][k] + ",";
                            ++k;
                        }
                        out.write(tmp);
                        out.write(String.valueOf(mol1 < mol2 ? 0 : 1) + "\n");
                    }
                    ++j;
                }
                ++i;
            }
            out.flush();
            fstream.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            System.exit(0);
        }
    }

    public static void translateToARFFClassCOMPSingle(double[][] attributes, String filename, int n_bins, int _i, int _j, boolean val) {
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(String.valueOf(arff_fold) + "/" + filename + "_class");
            out = new BufferedWriter(fstream);
            HashMap<String, Double> energies = Energetics.AllAntigenEnergies();
            HashMap<Integer, String> pdb_map = InputGenerator.getBackwardsMapping();
            out.write("@RELATION energetics\n\n");
            int i = 0;
            while (i < attributes[0].length) {
                out.write("@ATTRIBUTE att_" + i + " NUMERIC\n");
                ++i;
            }
            out.write("@ATTRIBUTE class {mol_0,mol_1}\n\n");
            out.write("@DATA\n");
            double mol1 = energies.get(pdb_map.get(_i));
            double mol2 = energies.get(pdb_map.get(_j));
            String tmp = "";
            int k = 0;
            while (k < attributes[0].length / 2) {
                tmp = String.valueOf(tmp) + attributes[0][k] + ",";
                ++k;
            }
            k = attributes[0].length / 2;
            while (k < attributes[0].length) {
                tmp = String.valueOf(tmp) + attributes[0][k] + ",";
                ++k;
            }
            out.write(tmp);
            out.write("mol_" + (mol1 < mol2 ? 0 : 1) + "\n");
            out.flush();
            fstream.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            System.exit(0);
        }
    }

    public static void translateToARFFNumCOMPSingle(double[][] attributes, String filename, int n_bins, int _i, int _j, boolean val) {
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(String.valueOf(arff_fold) + "/" + filename + "_num");
            out = new BufferedWriter(fstream);
            HashMap<String, Double> energies = Energetics.AllAntigenEnergies();
            HashMap<Integer, String> pdb_map = InputGenerator.getBackwardsMapping();
            out.write("@RELATION energetics\n\n");
            int i = 0;
            while (i < attributes[0].length) {
                out.write("@ATTRIBUTE att_" + i + " NUMERIC\n");
                ++i;
            }
            out.write("@ATTRIBUTE class NUMERIC\n\n");
            out.write("@DATA\n");
            double mol1 = energies.get(pdb_map.get(_i));
            double mol2 = energies.get(pdb_map.get(_j));
            String tmp = "";
            int k = 0;
            while (k < attributes[0].length / 2) {
                tmp = String.valueOf(tmp) + attributes[0][k] + ",";
                ++k;
            }
            k = attributes[0].length / 2;
            while (k < attributes[0].length) {
                tmp = String.valueOf(tmp) + attributes[0][k] + ",";
                ++k;
            }
            out.write(tmp);
            out.write((mol1 < mol2 ? 0 : 1) + "\n");
            out.flush();
            fstream.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            System.exit(0);
        }
    }

    public static double[][] readDescriptors() {
        HashMap<String, Integer> pdb_map = InputGenerator.getEnergyMapping();
        ArrayList<String> desc_files = FileSystemTools.getFullFiles(descr_fold);
        double[][] descriptors = new double[pdb_map.size()][desc_files.size()];
        int att_i = 0;
        for (String desc_file : desc_files) {
            String filename = String.valueOf(descr_fold) + "/" + desc_file;
            HashMap<String, String> res = InputGenerator.readDescriptor(filename);
            for (String key : res.keySet()) {
                descriptors[pdb_map.get((Object)key).intValue()][att_i] = Double.parseDouble(res.get(key));
            }
            ++att_i;
        }
        return descriptors;
    }

    public static HashMap<Integer, String> readDescriptorNames() {
        ArrayList<String> desc_files = FileSystemTools.getFullFiles(descr_fold);
        int att_i = 0;
        HashMap<Integer, String> mapping = new HashMap<Integer, String>();
        for (String desc_file : desc_files) {
            mapping.put(att_i, desc_file.replace(".txt", ""));
            ++att_i;
        }
        return mapping;
    }

    public static void translateToARFFClassOverfit(double[][] attributes, String filename, int n_bins, ArrayList<Integer> to_rem) {
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(String.valueOf(arff_fold) + "/" + filename + "_class");
            out = new BufferedWriter(fstream);
            HashMap<String, Double> energies = Energetics.AllAntigenEnergies();
            HashMap<Integer, String> pdb_map = InputGenerator.getBackwardsMapping(to_rem);
            out.write("@RELATION energetics\n\n");
            int i = 0;
            while (i < 2 * attributes[0].length) {
                out.write("@ATTRIBUTE att_" + i + " NUMERIC\n");
                ++i;
            }
            out.write("@ATTRIBUTE class {mol_0,mol_1}\n\n");
            out.write("@DATA\n");
            i = 0;
            while (i < attributes.length) {
                int j = 0;
                while (j < attributes.length) {
                    if (i != j) {
                        double mol1 = energies.get(pdb_map.get(i));
                        double mol2 = energies.get(pdb_map.get(j));
                        String tmp = String.valueOf(pdb_map.get(i)) + "(" + mol1 + ") : " + pdb_map.get(j) + "(" + mol2 + ") = ";
                        int k = 0;
                        while (k < attributes[0].length) {
                            tmp = String.valueOf(tmp) + attributes[i][k] + ",";
                            ++k;
                        }
                        k = 0;
                        while (k < attributes[0].length) {
                            tmp = String.valueOf(tmp) + attributes[j][k] + ",";
                            ++k;
                        }
                        out.write(tmp);
                        out.write("mol_" + (mol1 < mol2 ? 0 : 1) + "\n");
                    }
                    ++j;
                }
                ++i;
            }
            out.flush();
            fstream.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Class " + e.getLocalizedMessage());
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static void translateToARFFNumCOMPOverfit(double[][] attributes, String filename, int n_bins, ArrayList<Integer> to_rem) {
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(String.valueOf(arff_fold) + "/" + filename + "_num");
            out = new BufferedWriter(fstream);
            HashMap<String, Double> energies = Energetics.AllAntigenEnergies();
            HashMap<Integer, String> pdb_map = InputGenerator.getBackwardsMapping(to_rem);
            out.write("@RELATION energetics\n\n");
            int i = 0;
            while (i < 2 * attributes[0].length) {
                out.write("@ATTRIBUTE att_" + i + " NUMERIC\n");
                ++i;
            }
            out.write("@ATTRIBUTE class NUMERIC\n\n");
            out.write("@DATA\n");
            i = 0;
            while (i < attributes.length) {
                int j = 0;
                while (j < attributes.length) {
                    if (i != j) {
                        double mol1 = energies.get(pdb_map.get(i));
                        double mol2 = energies.get(pdb_map.get(j));
                        String tmp = "";
                        int k = 0;
                        while (k < attributes[0].length) {
                            tmp = String.valueOf(tmp) + attributes[i][k] + ",";
                            ++k;
                        }
                        k = 0;
                        while (k < attributes[0].length) {
                            tmp = String.valueOf(tmp) + attributes[j][k] + ",";
                            ++k;
                        }
                        out.write(tmp);
                        out.write(String.valueOf(mol1 < mol2 ? 0 : 1) + "\n");
                    }
                    ++j;
                }
                ++i;
            }
            out.flush();
            fstream.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Class " + e.getLocalizedMessage());
            System.exit(0);
        }
    }

    public static HashMap<Integer, String> getBackwardsMapping(ArrayList<Integer> to_rem) {
        HashMap<String, Double> energy_map = Energetics.AllAntigenEnergies();
        HashMap<Integer, String> pdb_map = new HashMap<Integer, String>();
        int index = 0;
        for (String pdb_code : energy_map.keySet()) {
            pdb_map.put(index++, pdb_code);
        }
        HashMap<Integer, String> pdb_map_res = new HashMap<Integer, String>();
        index = 0;
        int _i = 0;
        while (_i < pdb_map.size() + 2) {
            if (to_rem.contains(_i)) {
                pdb_map_res.put(index++, (String)pdb_map.get(_i));
            }
            ++_i;
        }
        return pdb_map_res;
    }

    public static HashMap<Integer, String> getBackwardsMapping(int i, int j) {
        HashMap<String, Double> energy_map = Energetics.AllAntigenEnergies();
        HashMap<Integer, String> pdb_map = new HashMap<Integer, String>();
        int index = 0;
        for (String pdb_code : energy_map.keySet()) {
            pdb_map.put(index++, pdb_code);
        }
        HashMap<Integer, String> pdb_map_res = new HashMap<Integer, String>();
        pdb_map.remove(i);
        pdb_map.remove(j);
        index = 0;
        int _i = 0;
        while (_i < pdb_map.size() + 2) {
            if (pdb_map.containsKey(_i)) {
                pdb_map_res.put(index++, (String)pdb_map.get(_i));
            }
            ++_i;
        }
        return pdb_map_res;
    }

    public static HashMap<Integer, String> getBackwardsMapping() {
        HashMap<String, Double> energy_map = Energetics.AllAntigenEnergies();
        HashMap<Integer, String> pdb_map = new HashMap<Integer, String>();
        int index = 0;
        for (String pdb_code : energy_map.keySet()) {
            pdb_map.put(index++, pdb_code);
        }
        return pdb_map;
    }

    public static HashMap<String, Integer> getEnergyMapping() {
        HashMap<String, Double> energy_map = Energetics.AllAntigenEnergies();
        HashMap<String, Integer> pdb_map = new HashMap<String, Integer>();
        int index = 0;
        for (String pdb_code : energy_map.keySet()) {
            pdb_map.put(pdb_code, index++);
        }
        return pdb_map;
    }

    public static HashMap<String, String> readDescriptor(String filename) {
        ArrayList<String> d_lines = FileSystemTools.readFile(filename);
        HashMap<String, String> values = new HashMap<String, String>();
        for (String val : d_lines) {
            String pdb_code = val.substring(0, val.indexOf(32));
            String attr_val = val.substring(val.indexOf(32) + 1);
            if (values.containsKey(pdb_code)) {
                System.err.println("InputGenerator: file " + filename + " declares " + pdb_code + " twice");
                System.exit(0);
            }
            values.put(pdb_code, attr_val);
        }
        return values;
    }
}

