/*
 * Decompiled with CFR 0.152.
 */
package DockSorter;

import data_structures.Residue;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class DockSorterScaled {
    private static final String userdir = System.getProperty("user.dir");
    private static final double[][] prop_mat = new double[][]{{0.20119760479041915, 0.16464979831316465, 0.19397590361445782, 0.058426966292134834, 0.1823579304495335, 0.16307541625857003, 0.12472487160674982, 0.06822107081174439, 0.17605216360403084, 0.0788002033553635, 0.06890611541774333, 0.06890459363957598, 0.24400181077410593, 0.0697495183044316, 0.12006788290199406, 0.18106796116504853, 0.07259713701431493, 0.2622300572939621, 0.18409236690186018, 0.1175115207373272}, {0.1955128205128205, 0.08192955589586524, 0.10311552247036118, 0.046625766871165646, 0.11073387307390964, 0.08014126596033687, 0.13916083916083916, 0.13264753654574987, 0.1145788798631894, 0.035398230088495575, 0.12048192771084337, 0.16612641815235007, 0.1493156366652841, 0.09712722298221614, 0.12166301969365427, 0.11726027397260275, 0.025775447793796417, 0.13956238911886457, 0.12734864300626306, 0.15661103979460847}, {0.1536503683858004, 0.1394772420009013, 0.03768115942028986, 0.015053763440860216, 0.11133266866068461, 0.07813911472448058, 0.12145319543887563, 0.1709819247679531, 0.10945505356311132, 0.1450719822812846, 0.1785221946512269, 0.11163522012578617, 0.1921079958463136, 0.09119387399930386, 0.11667913238593867, 0.07498463429625077, 0.07610241820768136, 0.09829746225505943, 0.08059873344847437, 0.08271236959761549}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.008057296329453895, 0.08288148721920992, 0.05155746509129968, 0.0, 0.03177257525083612, 0.0, 0.0438489646772229, 0.0, 0.03954802259887006, 0.0210727969348659, 0.059233449477351915, 0.01893939393939394, 0.16164383561643836, 0.0286144578313253, 0.10428736964078796, 0.15462610899873258, 0.0, 0.0, 0.0, 0.13043478260869565}, {0.3967657013915006, 0.15918045705279749, 0.03590425531914894, 0.08056872037914692, 0.09623797025371829, 0.007267441860465116, 0.12302284710017575, 0.14348462664714495, 0.045662100456621, 0.05589307411907655, 0.13842696629213483, 0.012012012012012012, 0.0594679186228482, 0.046416938110749185, 0.12180579216354344, 0.08781645569620253, 0.3175355450236967, 0.07, 0.03428571428571429, 0.1326530612244898}, {0.18282722513089006, 0.07873353880638835, 0.09255831173639392, 0.05417956656346749, 0.13243243243243244, 0.13123718386876282, 0.11120495495495496, 0.1195436507936508, 0.1243825774584643, 0.07207989578810248, 0.12692882030861125, 0.2569686411149826, 0.16870843542177108, 0.14890282131661442, 0.10203461888855148, 0.1303030303030303, 0.056929269695227144, 0.1241486068111455, 0.14278506559031282, 0.11080523055746731}, {0.18960538979788258, 0.11842105263157894, 0.35951327433628316, 0.23127035830618892, 0.17325949367088608, 0.13636363636363635, 0.22922134733158356, 0.3943089430894309, 0.21331521739130435, 0.10554561717352415, 0.15859449192782527, 0.3157894736842105, 0.3366013071895425, 0.27852998065764023, 0.09538461538461539, 0.31653888280394304, 0.24778761061946902, 0.23014959723820483, 0.22532188841201717, 0.07191011235955057}, {0.04852320675105485, 0.02564102564102564, 0.0370843989769821, 0.0, 0.12121212121212122, 0.16575192096597147, 0.029525032092426188, 0.0, 0.16897233201581027, 0.20024570024570024, 0.16349310571240971, 0.3498789346246973, 0.3426632739609839, 0.014925373134328358, 0.06796116504854369, 0.07142857142857142, 0.2495921696574225, 0.14115092290988057, 0.24414715719063546, 0.0}, {0.18006042296072508, 0.05608974358974359, 0.0391304347826087, 0.0, 0.08518518518518518, 0.146875, 0.17207207207207206, 0.10344827586206896, 0.272608125819135, 0.3748939779474131, 0.10148731408573929, 0.5067567567567568, 0.24654088050314465, 0.09948542024013722, 0.23581429624170966, 0.02518891687657431, 0.3543859649122807, 0.2716297786720322, 0.24379562043795622, 0.08936651583710407}, {0.10410958904109589, 0.0670391061452514, 0.03488372093023256, 0.0, 0.03517110266159696, 0.19552306989492918, 0.09762308998302208, 0.07529411764705882, 0.0811965811965812, 0.11892583120204604, 0.09209621993127148, 0.059322033898305086, 0.0, 0.09952153110047847, 0.13249211356466878, 0.10393700787401575, 0.3482587064676617, 0.07934893184130214, 0.026717557251908396, 0.0}, {0.3458904109589041, 0.0, 0.0, 0.9285714285714286, 0.0, 0.0, 0.0, 0.23255813953488372, 0.2146341463414634, 0.0, 0.12077294685990338, 0.5084745762711864, 0.0, 0.3680297397769517, 0.01912568306010929, 0.044854881266490766, 0.0, 0.1875, 0.0, 0.0}, {0.19763138415988157, 0.08890549122151663, 0.1636060100166945, 0.11781609195402298, 0.3064213293278258, 0.20790378006872853, 0.24649423496416328, 0.24114746750336172, 0.254694270582571, 0.2505003335557038, 0.1722702529618956, 0.29689174705251875, 0.35, 0.19239593575876762, 0.13287836210357287, 0.10142348754448399, 0.14254265272427077, 0.08181818181818182, 0.23880597014925373, 0.2674339878131347}, {0.13168395849960096, 0.12981199641897942, 0.03615960099750624, 0.0, 0.0778498609823911, 0.02882205513784461, 0.0425, 0.28205128205128205, 0.16611842105263158, 0.07407407407407407, 0.050220264317180616, 0.12062937062937062, 0.33873144399460187, 0.04249667994687915, 0.10344827586206896, 0.09700722394220847, 0.1590909090909091, 0.211340206185567, 0.06457925636007827, 0.04159132007233273}, {0.13231492361927144, 0.08877781744615018, 0.1770375380453162, 0.01804511278195489, 0.15256089943785134, 0.15529088410444342, 0.10287213476940071, 0.08727053866987662, 0.038461538461538464, 0.07664914363235543, 0.07249114521841794, 0.12522045855379188, 0.19600443951165372, 0.12147465437788019, 0.07207062600321028, 0.17856516400631467, 0.13467902051621441, 0.11152882205513784, 0.026859504132231406, 0.0469208211143695}, {0.13729809104258445, 0.07774607703281027, 0.12840685585838718, 0.07377049180327869, 0.12344177561568866, 0.1023296962547921, 0.0950375939849624, 0.09906759906759907, 0.11490978157644824, 0.11747967479674797, 0.08094117647058824, 0.2343612334801762, 0.1375968992248062, 0.10053577056413489, 0.0763101440392277, 0.1450335161486898, 0.10971524288107203, 0.1684334511189635, 0.11837837837837838, 0.07701283547257877}, {0.30602452461347074, 0.188135593220339, 0.13254637436762226, 0.23523093447905477, 0.34087481146304677, 0.20157426420260097, 0.1876865671641791, 0.31308121512709236, 0.11484593837535013, 0.10342342342342342, 0.3216190014541929, 0.36976439790575916, 0.17008196721311475, 0.2538318625174176, 0.2402763561924258, 0.2551081730769231, 0.1551507537688442, 0.38564102564102565, 0.3063849333945797, 0.23709167544783982}, {0.22023622870283266, 0.1389127570602051, 0.19077778635977446, 0.032229965156794424, 0.17334112832505116, 0.14523903595416832, 0.17924577645274334, 0.2117308798159862, 0.19306887909428744, 0.18188405797101448, 0.18730553827006846, 0.2026058631921824, 0.18810276359510494, 0.20666935592308727, 0.18844951461635495, 0.1569969069266098, 0.22880056610449345, 0.11714136203932123, 0.13787954206072672, 0.16099107562235793}, {0.1056563500533618, 0.1404109589041096, 0.1127348643006263, 0.0, 0.13848396501457727, 0.1608730800323363, 0.17964601769911503, 0.1529709228824273, 0.08613138686131387, 0.22782750203417412, 0.06562756357670221, 0.2434108527131783, 0.3445692883895131, 0.18293755496921724, 0.023086269744835967, 0.18036711891460494, 0.25726744186046513, 0.142578125, 0.2533557046979866, 0.10288808664259928}, {0.10401891252955082, 0.06044905008635579, 0.07275320970042796, 0.0, 0.14822335025380712, 0.13019390581717452, 0.10408921933085502, 0.048589341692789965, 0.10222222222222223, 0.145985401459854, 0.034358047016274866, 0.17857142857142858, 0.2775423728813559, 0.16643159379407615, 0.06965174129353234, 0.04461538461538461, 0.055299539170506916, 0.1961950059453032, 0.11405295315682282, 0.03289473684210526}};

    public static void main(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals("-h") || s.equals("--help")) {
                DockSorterScaled.printUsage();
            }
            ++n2;
        }
        HashMap<String, String> options = DockSorterScaled.readInOptions(args);
        HashMap<Character, HashMap<Integer, Residue>> ab_struc = DockSorterScaled.ChainAvailability(options, "b");
        HashMap<Character, HashMap<Integer, Residue>> ag_struc = DockSorterScaled.ChainAvailability(options, "g");
        HashMap<Character, ArrayList<Integer>> ab_constr = null;
        if (options.get("-constab").length() > 0) {
            ab_constr = DockSorterScaled.CheckConstraints(options, "b", ab_struc);
        }
        HashMap<Character, ArrayList<Integer>> ag_constr = null;
        if (options.get("-constag").length() > 0) {
            ag_constr = DockSorterScaled.CheckConstraints(options, "g", ag_struc);
        }
        double sum = 0.0;
        double total_sums = 0.0;
        for (Character chain_ag : ag_struc.keySet()) {
            for (Character chain_ab : ab_struc.keySet()) {
                HashMap<Integer, Residue> ab = ab_struc.get(chain_ab);
                HashMap<Integer, Residue> ag = ag_struc.get(chain_ag);
                for (Integer i_ab : ab.keySet()) {
                    for (Integer i_ag : ag.keySet()) {
                        if (ab_constr != null && ab_constr.containsKey(chain_ab)) {
                            System.out.println("By constraint");
                            if (!ab_constr.get(chain_ab).contains(i_ab)) continue;
                        }
                        if (ag_constr != null && ag_constr.containsKey(chain_ag) && !ag_constr.get(chain_ag).contains(i_ag) || !(ab.get(i_ab).distanceFrom(ag.get(i_ag)) < 4.5)) continue;
                        sum += prop_mat[ab.get((Object)i_ab).type.ordinal()][ag.get((Object)i_ag).type.ordinal()];
                        total_sums += 1.0;
                    }
                }
            }
        }
        System.out.println(sum / total_sums);
    }

    public static void printUsage() {
        System.out.println("Usage:");
        System.out.println("java -jar DockSorter.jar -abf [antibody file] -agf [antigen file] -abc [antibody chain(s)] -agc [antigen chain(s)] -constab [constraint file for antibody] -constag [constraint file for antigen]");
        System.out.println("The constraint files are optional - if not provided the calcualation will involve all interface (<4.5A apart) residues");
        System.out.println("The decoys should be sorted in descending order by the output of this program (ie highest score decoys are 'the best')");
        System.out.println("Since the command is fairly long, it is strongly suggested that the user adapts the example distributed with program at http://www.stats.ox.ac.uk/research/proteins/resources");
        System.exit(0);
    }

    public static HashMap<Character, ArrayList<Integer>> CheckConstraints(HashMap<String, String> options, String abag, HashMap<Character, HashMap<Integer, Residue>> struc) {
        ArrayList<String> constr = FileSystemTools.readFile(String.valueOf(userdir) + options.get("-consta" + abag));
        HashMap<Character, ArrayList<Integer>> constr_map = new HashMap<Character, ArrayList<Integer>>();
        for (String line : constr) {
            ArrayList<Integer> temp;
            char chain;
            if (!line.contains(" ")) {
                System.out.println("The constraints file " + options.get("-consta" + abag) + " appears to be badly formatted. Check line: \n" + line);
            }
            Integer res_id = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            String chain_part = line.substring(line.indexOf(" ") + 1);
            if (chain_part.length() > 1) {
                System.out.println("The constraints file " + options.get("-consta" + abag) + " appears to be badly formatted. Check line: \n" + line);
            }
            if (!struc.containsKey(Character.valueOf(chain = chain_part.charAt(0)))) {
                System.out.println("The constraint file for  " + (abag.equals("b") ? "antibody" : "antigen") + ", contains a chain " + chain + " which was not specified as one of the chains of the structure. Stopping");
                DockSorterScaled.printUsage();
            }
            if (!struc.get(Character.valueOf(chain)).containsKey(res_id)) {
                System.out.println("The constraint file for  " + (abag.equals("b") ? "antibody" : "antigen") + ", lists residue " + res_id + " on chain " + chain + " - there is no such residue on this chain in the structure. Stopping");
                DockSorterScaled.printUsage();
            }
            if (constr_map.containsKey(Character.valueOf(chain))) {
                temp = constr_map.get(Character.valueOf(chain));
                temp.add(res_id);
                constr_map.put(Character.valueOf(chain), temp);
                continue;
            }
            if (!constr_map.containsKey(Character.valueOf(chain))) continue;
            temp = new ArrayList();
            temp.add(res_id);
            constr_map.put(Character.valueOf(chain), temp);
        }
        return constr_map;
    }

    public static HashMap<Character, HashMap<Integer, Residue>> ChainAvailability(HashMap<String, String> options, String abag) {
        HashMap<Character, HashMap<Integer, Residue>> struc = new HashMap<Character, HashMap<Integer, Residue>>();
        String chains = PDB_parser.getChains(String.valueOf(userdir) + options.get("-a" + abag + "f"));
        System.out.println("Chains found in the " + (abag.equals("b") ? "antibody" : "antigen") + " file: " + chains);
        int i = 0;
        while (i < options.get("-a" + abag + "c").length()) {
            String chain = String.valueOf(options.get("-a" + abag + "c").charAt(i));
            if (!chains.contains(chain)) {
                System.out.println("The " + (abag.equals("b") ? "antibody" : "antigen") + " file does not have chain " + chain + " - Stopping");
                DockSorterScaled.printUsage();
            } else {
                HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(userdir) + options.get("-a" + abag + "f"), chain.charAt(0));
                if (ab.size() < 5) {
                    System.out.println("The " + (abag.equals("b") ? "antibody" : "antigen") + " you provided appears incomplete - size of chain " + chain + " is " + ab.size() + ". Stopping");
                    DockSorterScaled.printUsage();
                }
                if (!struc.containsKey(Character.valueOf(chain.charAt(0)))) {
                    struc.put(Character.valueOf(chain.charAt(0)), ab);
                } else {
                    System.out.println("You have supplied multiple instances of one chain for the " + (abag.equals("b") ? "antibody" : "antigen") + " : " + chain.charAt(0));
                    DockSorterScaled.printUsage();
                }
            }
            ++i;
        }
        for (Character chain : struc.keySet()) {
            System.out.println("Chain " + chain + " of the " + (abag.equals("b") ? "antibody" : "antigen") + "; size = " + struc.get(chain).size());
        }
        return struc;
    }

    public static HashMap<String, String> readInOptions(String[] args) {
        System.out.println("Listing the arguments:");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("-agf", "");
        options.put("-abf", "");
        options.put("-agc", "");
        options.put("-abc", "");
        options.put("-constab", "");
        options.put("-constag", "");
        int i = 0;
        while (i < args.length) {
            String opt;
            if (i == args.length) {
                System.err.println("Not enough arguments supplied");
                DockSorterScaled.printUsage();
            }
            if (!options.containsKey(opt = args[i])) {
                System.err.println("Unknown option : " + opt);
                DockSorterScaled.printUsage();
            }
            if (i == args.length - 1) {
                System.err.println("Not enough arguments supplied");
                DockSorterScaled.printUsage();
            }
            String input = args[i + 1];
            ++i;
            options.put(opt, input);
            ++i;
        }
        System.out.println("Executing with options:");
        for (String opt : options.keySet()) {
            File f;
            if (options.get(opt).length() == 0 && !opt.contains("-cons")) {
                System.err.println(String.valueOf(opt) + " uninitialized");
                DockSorterScaled.printUsage();
                continue;
            }
            System.out.println(String.valueOf(opt) + " : " + options.get(opt));
            if (opt.equals("-agc") || opt.equals("-abc") || (f = new File(String.valueOf(userdir) + "/" + options.get(opt))).exists()) continue;
            System.out.println("The file " + options.get(opt) + " doesn't exist - Stopping");
            DockSorterScaled.printUsage();
        }
        return options;
    }
}

