/*
 * Decompiled with CFR 0.152.
 */
package analysis;

import Abnum.Abnum;
import analysis.Normalizer;
import data_structures.Atom;
import data_structures.Residue;
import data_structures.SC_Structure;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class DockContacts {
    public static void main(String[] args) {
        String pdb_line;
        String chid;
        Residue r;
        String main_folder = args[0];
        double cutoff = Double.parseDouble(args[1]);
        String output_file = String.valueOf(main_folder) + "/Docking_raw.pdb";
        ArrayList<String> ch_decoys = FileSystemTools.getFiles(String.valueOf(main_folder) + "/output_docking/chothia");
        HashMap<String, Integer> Hcount = new HashMap<String, Integer>();
        HashMap<String, Integer> Lcount = new HashMap<String, Integer>();
        Results result = new Results(Hcount, Lcount);
        char Hchain = 'H';
        char Lchain = 'L';
        char Agchain = 'B';
        for (String decoy : ch_decoys) {
            System.out.println(decoy);
            String abfile = String.valueOf(main_folder) + "/output_docking/chothia/" + decoy;
            String agfile = String.valueOf(main_folder) + "/output_docking/top_decoys/" + decoy;
            DockContacts.CountSingle(abfile, agfile, Hchain, Lchain, Agchain, cutoff, result);
        }
        PDB_parser.Chothia ab_H = new PDB_parser.Chothia(String.valueOf(main_folder) + "/output_docking/chothia/complexed.1.pdb", Hchain);
        PDB_parser.Chothia ab_L = new PDB_parser.Chothia(String.valueOf(main_folder) + "/output_docking/chothia/complexed.1.pdb", Lchain);
        ArrayList<String> output = new ArrayList<String>();
        ArrayList<String> alignmentH = new ArrayList<String>();
        ArrayList<String> alignmentL = new ArrayList<String>();
        for (Integer i : ab_H.ordinals) {
            r = ab_H.residues.get(ab_H.ordinals_map.get(i));
            chid = "H" + ab_H.ordinals_map.get(i);
            alignmentH.add(String.valueOf(chid) + "\t" + (Object)((Object)r.type) + "\t" + Hcount.get(ab_H.ordinals_map.get(i)) + ".00" + Abnum.isCDR(chid));
            for (Atom a : r.atoms) {
                pdb_line = SC_Structure.colorBFactor(a.pdb_line, Hcount.get(ab_H.ordinals_map.get(i)) + ".00");
                output.add(String.valueOf(pdb_line) + " ");
            }
        }
        for (Integer i : ab_L.ordinals) {
            r = ab_L.residues.get(ab_L.ordinals_map.get(i));
            chid = "L" + ab_L.ordinals_map.get(i);
            alignmentL.add(String.valueOf(chid) + "\t" + (Object)((Object)r.type) + "\t" + Lcount.get(ab_L.ordinals_map.get(i)) + ".00" + "\t" + Abnum.isCDR(chid));
            for (Atom a : r.atoms) {
                pdb_line = SC_Structure.colorBFactor(a.pdb_line, Lcount.get(ab_L.ordinals_map.get(i)) + ".00");
                output.add(String.valueOf(pdb_line) + " ");
            }
        }
        FileSystemTools.writeFile(String.valueOf(main_folder) + "/output_docking/AlignH.txt", alignmentH);
        FileSystemTools.writeFile(String.valueOf(main_folder) + "/output_docking/AlignL.txt", alignmentL);
        Normalizer.normalize(output_file, 'H', 'L', String.valueOf(main_folder) + "/Docking_normalized.pdb");
    }

    public static void CountSingle(String abfile, String agfile, char Hchain, char Lchain, char Agchain, double cutoff, Results r) {
        HashMap<String, Integer> Hcount = r.Hcount;
        HashMap<String, Integer> Lcount = r.Lcount;
        PDB_parser.Chothia ab_H = new PDB_parser.Chothia(abfile, Hchain);
        PDB_parser.Chothia ab_L = new PDB_parser.Chothia(abfile, Lchain);
        PDB_parser.Chothia ag = new PDB_parser.Chothia(agfile, Agchain);
        DockContacts.getCounts(ab_H.residues, ag.residues, cutoff);
        DockContacts.getCounts(ab_L.residues, ag.residues, cutoff);
        for (String s : ab_H.residues.keySet()) {
            if (!Hcount.containsKey(s)) {
                Hcount.put(s, 0);
            }
            if (!ab_H.residues.get((Object)s).isContact) continue;
            Hcount.put(s, Hcount.get(s) + 1);
        }
        for (String s : ab_L.residues.keySet()) {
            if (!Lcount.containsKey(s)) {
                Lcount.put(s, 0);
            }
            if (!ab_L.residues.get((Object)s).isContact) continue;
            Lcount.put(s, Lcount.get(s) + 1);
        }
    }

    public static void getCounts(HashMap<String, Residue> ab, HashMap<String, Residue> ag, double cutoff) {
        block0: for (String sAB : ab.keySet()) {
            Residue rAB = ab.get(sAB);
            for (String sAG : ag.keySet()) {
                Residue rAG = ag.get(sAG);
                if (!(rAG.distanceFrom(rAB) < cutoff)) continue;
                rAB.isContact = true;
                continue block0;
            }
        }
        block2: for (String sAG : ag.keySet()) {
            Residue rAG = ag.get(sAG);
            for (String sAB : ab.keySet()) {
                Residue rAB = ab.get(sAB);
                if (!(rAB.distanceFrom(rAG) < cutoff)) continue;
                rAG.isContact = true;
                continue block2;
            }
        }
    }

    public static class Results {
        public HashMap<String, Integer> Hcount;
        public HashMap<String, Integer> Lcount;

        Results(HashMap<String, Integer> h, HashMap<String, Integer> l) {
            this.Hcount = h;
            this.Lcount = l;
        }
    }
}

