/*
 * Decompiled with CFR 0.152.
 */
package docking_global;

import data_structures.Residue;
import docking_global.DockingDistances;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import parsing.PSA;
import utils.FileSystemTools;

public class DistanceAnalyzer {
    public static void main(String[] args) {
        String papa = "/Users/bielasek/Desktop/EpitopePrediction_R/EpitopePrediction_R_2/EpiPred_R";
        String outpapa = "/Users/bielasek/Desktop/distances";
        ArrayList<String> folders = FileSystemTools.getFolders("/Users/bielasek/Desktop/EpitopePrediction_R/EpitopePrediction_R_2/EpiPred_R");
        HashMap<Integer, Integer> con_hist = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> non_hist = new HashMap<Integer, Integer>();
        int prog2 = 0;
        for (String fold : folders) {
            ++prog2;
            if (!fold.contains("out_")) continue;
            System.out.println(fold);
            HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(papa) + "/" + fold + "/AB.pdb", 'A');
            HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(papa) + "/" + fold + "/AG.pdb", 'A');
            HashMap<Integer, Boolean> abs = PSA.readPSAFile(String.valueOf(papa) + "/" + fold + "/tempAB.txt", 7.0);
            HashMap<Integer, Boolean> ags = PSA.readPSAFile(String.valueOf(papa) + "/" + fold + "/tempAG.txt", 7.0);
            double[][] intra_ab = DockingDistances.extractDistances(ab, ab);
            double[][] intra_ag = DockingDistances.extractDistances(ag, ag);
            double[][] inter = DockingDistances.extractDistances(ab, ag);
            int prog = 0;
            for (Integer abi : ab.keySet()) {
                System.out.println(String.valueOf(++prog) + "/" + ab.size() + " : " + prog2 + "/" + folders.size());
                if (!abs.get(abi).booleanValue()) continue;
                for (Integer agi : ag.keySet()) {
                    if (!ags.get(agi).booleanValue()) continue;
                    for (Integer abi_2 : ab.keySet()) {
                        if (!abs.get(abi_2).booleanValue()) continue;
                        for (Integer agi_2 : ag.keySet()) {
                            if (!ags.get(agi_2).booleanValue()) continue;
                            double d1 = inter[abi][agi];
                            double d2 = inter[abi_2][agi_2];
                            double di1 = intra_ab[abi][abi_2];
                            double di2 = intra_ag[agi][agi_2];
                            double delta2 = Math.abs(di1 - di2) * 100.0;
                            int delta = (int)delta2;
                            if (d1 < 4.5 && d2 < 4.5) {
                                if (!con_hist.containsKey(delta)) {
                                    con_hist.put(delta, 0);
                                }
                                con_hist.put(delta, (Integer)con_hist.get(delta) + 1);
                                continue;
                            }
                            if (!non_hist.containsKey(delta)) {
                                non_hist.put(delta, 0);
                            }
                            non_hist.put(delta, (Integer)non_hist.get(delta) + 1);
                        }
                    }
                }
            }
            ArrayList<String> out = new ArrayList<String>();
            for (Integer d : con_hist.keySet()) {
                out.add(d + " " + con_hist.get(d));
            }
            FileSystemTools.writeFile(String.valueOf(outpapa) + "/con.txt", out);
            out = new ArrayList();
            for (Integer d : non_hist.keySet()) {
                out.add(d + " " + non_hist.get(d));
            }
            FileSystemTools.writeFile(String.valueOf(outpapa) + "/non.txt", out);
        }
    }
}

