/*
 * Decompiled with CFR 0.152.
 */
package energy;

import data_structures.Atom;
import data_structures.Atom_class;
import data_structures.Atom_grouping;
import data_structures.Residue;
import db_interface.Complex_Structure;
import db_interface.Energetics;
import java.util.ArrayList;
import java.util.HashMap;
import utils.AAKMeans;
import utils.FileSystemTools;
import utils.MathFunctions;

public class Atom_clustering {
    public static final String userdir = System.getProperty("user.dir");
    private static final int ATOM_GR = Atom_grouping.values().length;

    public static void main(String[] args) {
    }

    public static double[][] getAtomDescriptors(double cutoff) {
        return Atom_clustering.EnergyInput("all", cutoff);
    }

    public static void translateToARFF(int[][] attributes, HashMap<Integer, String> classification, String filename) {
        String output = "@RELATION energetics\n\n";
        int i = 0;
        while (i < attributes[0].length) {
            output = String.valueOf(output) + "@ATTRIBUTE att_" + i + " NUMERIC\n";
            ++i;
        }
        ArrayList<String> classes = new ArrayList<String>();
        for (Integer i2 : classification.keySet()) {
            if (classes.contains(classification.get(i2))) continue;
            classes.add(classification.get(i2));
        }
        output = String.valueOf(output) + "@ATTRIBUTE class {";
        int i3 = 0;
        while (i3 < classes.size()) {
            String _class = (String)classes.get(i3);
            output = i3 + 1 == classes.size() ? String.valueOf(output) + _class + "}\n\n" : String.valueOf(output) + _class + ",";
            ++i3;
        }
        output = String.valueOf(output) + "@DATA\n";
        i3 = 0;
        while (i3 < attributes.length) {
            int j = 0;
            while (j < attributes[0].length) {
                output = String.valueOf(output) + attributes[i3][j] + ",";
                ++j;
            }
            output = String.valueOf(output) + classification.get(i3) + "\n";
            ++i3;
        }
        FileSystemTools.writeFile(filename, output);
    }

    public static double[][] EnergyInput(String abag, double cutoff) {
        String std_folder = String.valueOf(userdir) + "/protein_database/standardized";
        String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
        HashMap<String, Double> energy_map = null;
        if (abag.equals("big")) {
            energy_map = Energetics.BigAntigenEnergies();
        } else if (abag.equals("pep")) {
            energy_map = Energetics.PeptideEnergies();
        } else if (abag.equals("all")) {
            energy_map = Energetics.AllAntigenEnergies();
        }
        int micro = 0;
        int nano = 0;
        int pico = 0;
        double[][] attribute_matrix = new double[energy_map.size()][ATOM_GR * ATOM_GR];
        HashMap<Integer, String> kd_class_list = new HashMap<Integer, String>();
        int specimen = 0;
        int progress = 0;
        for (String pdb : energy_map.keySet()) {
            System.out.println("Progress: " + ++progress + "/" + energy_map.size());
            double Kd = energy_map.get(pdb);
            String molarity_class = Energetics.ClassifyMolarity(Kd);
            kd_class_list.put(specimen, molarity_class);
            Complex_Structure cs = new Complex_Structure(String.valueOf(pdb) + "_AB", raw_folder, std_folder);
            System.out.println(String.valueOf(pdb) + " : " + Kd + " class=" + molarity_class);
            if (molarity_class.equals("micro")) {
                ++micro;
            }
            if (molarity_class.equals("nano")) {
                ++nano;
            }
            if (molarity_class.equals("pico")) {
                ++pico;
            }
            for (Integer r_i : cs.m1.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                Residue res = cs.m1.chains.get((Object)Character.valueOf((char)'A')).residues.get(r_i);
                for (Atom atom_1 : res.atoms) {
                    for (Integer r_a2 : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                        Residue res_2 = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(r_a2);
                        for (Atom atom_2 : res_2.atoms) {
                            atom_1.distanceFrom(atom_2);
                        }
                    }
                }
            }
            ++specimen;
        }
        System.out.println("Stats: ");
        System.out.println("micro: " + micro);
        System.out.println("nano: " + nano);
        System.out.println("pico: " + pico);
        attribute_matrix = MathFunctions.removeZeroColumns(attribute_matrix, 0.8);
        return attribute_matrix;
    }

    public static void dynamicGrouping() {
        ArrayList<Integer> cluster;
        double[][] ag_dist = MathFunctions.readAdjustableParsable2DDouble(String.valueOf(userdir) + "/temp/antigen_distances.txt");
        double[][] ab_dist = MathFunctions.readAdjustableParsable2DDouble(String.valueOf(userdir) + "/temp/antibody_distances.txt");
        HashMap<Integer, ArrayList<Integer>> ab_clusts = AAKMeans.GetClusters(ATOM_GR, ab_dist, 100, false);
        HashMap<Integer, ArrayList<Integer>> ag_clusts = AAKMeans.GetClusters(ATOM_GR, ag_dist, 100, false);
        for (Integer clus_id : ab_clusts.keySet()) {
            cluster = ab_clusts.get(clus_id);
            for (Integer n : cluster) {
            }
        }
        for (Integer clus_id : ag_clusts.keySet()) {
            cluster = ag_clusts.get(clus_id);
            for (Integer n : cluster) {
            }
        }
    }

    public static void bowMethod() {
        int ITERATIONS = 1000;
        double[][] ag_dist = MathFunctions.readAdjustableParsable2DDouble(String.valueOf(userdir) + "/temp/antigen_distances.txt");
        double[][] ab_dist = MathFunctions.readAdjustableParsable2DDouble(String.valueOf(userdir) + "/temp/antibody_distances.txt");
        AAKMeans.BowMethod(ag_dist, ITERATIONS, String.valueOf(userdir) + "/result_dump/atom_clustering/bow_method/ag_bow.txt");
        AAKMeans.BowMethod(ab_dist, ITERATIONS, String.valueOf(userdir) + "/result_dump/atom_clustering/bow_method/ab_bow.txt");
    }

    public static void compareProfile(String abag, Atom_class ac_1, Atom_class ac_2) {
        double[][] profile_arr = MathFunctions.readAdjustableParsable2DDouble(String.valueOf(userdir) + "/temp/" + abag + "_relative.txt");
        int i = 0;
        while (i < Atom_class.values().length) {
            System.out.println((Object)((Object)Atom_class.values()[i]) + ":");
            System.out.println((Object)((Object)ac_1) + " : " + profile_arr[ac_1.ordinal()][i]);
            System.out.println((Object)((Object)ac_2) + " : " + profile_arr[ac_2.ordinal()][i]);
            ++i;
        }
    }

    public static void GetDistances(double cutoff) {
        ArrayList<String> pdbcodes = null;
        pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/pdb_lists/big_antigen.txt");
        String std_folder = String.valueOf(userdir) + "/protein_database/standardized";
        String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
        int progress = 0;
        long[][] dist_ab = new long[Atom_class.values().length][Atom_class.values().length];
        long[][] dist_ag = new long[Atom_class.values().length][Atom_class.values().length];
        double[][] ag_dist = new double[Atom_class.values().length][Atom_class.values().length];
        double[][] ab_dist = new double[Atom_class.values().length][Atom_class.values().length];
        ArrayList atom_names = new ArrayList();
        for (String pdb_code : pdbcodes) {
            System.out.println("Single: " + ++progress + "/" + pdbcodes.size() + " : " + pdb_code);
            Complex_Structure cs = new Complex_Structure(pdb_code, raw_folder, std_folder);
            for (Integer r_i : cs.m1.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                Residue res = cs.m1.chains.get((Object)Character.valueOf((char)'A')).residues.get(r_i);
                for (Atom atom_1 : res.atoms) {
                    for (Integer r_a2 : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                        Residue res_2 = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(r_a2);
                        for (Atom atom_2 : res_2.atoms) {
                            atom_1.distanceFrom(atom_2);
                        }
                    }
                }
            }
        }
        double[][] counts_ab = Atom_clustering.normalizeByRow(dist_ab);
        double[][] counts_ag = Atom_clustering.normalizeByRow(dist_ag);
        MathFunctions.printParsable2D(counts_ag, String.valueOf(userdir) + "/temp/antigen_relative.txt");
        MathFunctions.printParsable2D(counts_ab, String.valueOf(userdir) + "/temp/antibody_relative.txt");
        int i = 0;
        while (i < Atom_class.values().length) {
            int j = 0;
            while (j < Atom_class.values().length) {
                if (i != j) {
                    double[] row_i = MathFunctions.getRow(counts_ab, i);
                    double[] row_j = MathFunctions.getRow(counts_ab, j);
                    ab_dist[i][j] = MathFunctions.vectorDistance(row_i, row_j);
                    row_i = MathFunctions.getRow(counts_ag, i);
                    row_j = MathFunctions.getRow(counts_ag, j);
                    ag_dist[i][j] = MathFunctions.vectorDistance(row_i, row_j);
                }
                ++j;
            }
            ++i;
        }
        MathFunctions.printParsable2D(ag_dist, String.valueOf(userdir) + "/temp/antigen_distances.txt");
        MathFunctions.printParsable2D(ab_dist, String.valueOf(userdir) + "/temp/antibody_distances.txt");
    }

    public static double[][] normalizeByRow(long[][] arr) {
        double[][] result = new double[arr.length][arr.length];
        int i = 0;
        while (i < arr.length) {
            double sum = 0.0;
            int j = 0;
            while (j < arr.length) {
                sum += (double)arr[i][j];
                ++j;
            }
            if (sum != 0.0) {
                j = 0;
                while (j < arr.length) {
                    result[i][j] = (double)arr[i][j] / sum;
                    double[] dArray = result[i];
                    int n = j++;
                    dArray[n] = dArray[n] * 1000.0;
                }
            } else {
                j = 0;
                while (j < arr.length) {
                    result[i][j] = 1000.0;
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public static void getAtomNames() {
        ArrayList<String> pdbcodes = null;
        pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/eligible_pdbs.txt");
        String std_folder = String.valueOf(userdir) + "/protein_database/standardized";
        String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
        boolean progress = false;
        ArrayList atom_names = new ArrayList();
        for (String pdb_code : pdbcodes) {
            Residue res;
            Complex_Structure cs = new Complex_Structure(pdb_code, raw_folder, std_folder);
            for (Integer r_i : cs.m1.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                res = cs.m1.chains.get((Object)Character.valueOf((char)'A')).residues.get(r_i);
                for (Atom atom : res.atoms) {
                    atom_names.contains(atom.atom_name);
                }
            }
            for (Integer r_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(r_i);
                for (Atom atom : res.atoms) {
                    atom_names.contains(atom.atom_name);
                }
            }
        }
        for (String pdb_code : atom_names) {
        }
        for (String atom_name : atom_names) {
            System.out.println("if (name.equals(\"" + atom_name + "\"){return " + atom_name + ";}");
        }
    }
}

