/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import utils.FileSystemTools;

public class ResultWriter {
    public static void writeSimpleResults(String file, ArrayList<HashMap<Double, Integer>> results) {
        HashMap<Double, Integer> cutoffs = new HashMap<Double, Integer>();
        for (HashMap<Double, Integer> protein : results) {
            for (double cut : protein.keySet()) {
                if (!cutoffs.containsKey(cut)) {
                    cutoffs.put(cut, 0);
                }
                cutoffs.put(cut, (Integer)cutoffs.get(cut) + protein.get(cut));
            }
        }
        ArrayList<String> output = new ArrayList<String>();
        Iterator iterator = cutoffs.keySet().iterator();
        while (iterator.hasNext()) {
            double cut = (Double)iterator.next();
            output.add(String.valueOf(cut) + " " + cutoffs.get(cut));
        }
        FileSystemTools.writeFile(file, output);
    }

    public static void writeResults(String file, ArrayList<HashMap<Double, Integer>> results) {
        InputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        try {
            FileWriter fstream = new FileWriter(file);
            BufferedWriter out = new BufferedWriter(fstream);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            int i = 0;
            while (i < results.size()) {
                HashMap<Double, Integer> mapp = results.get(i);
                for (Double cutoff : mapp.keySet()) {
                    out.write(String.valueOf(i) + " " + cutoff + " " + mapp.get(cutoff) + "\n");
                }
                ++i;
            }
            bis.close();
            dis.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public static void writeResults2(String file, HashMap<Integer, Double> results) {
        InputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        try {
            FileWriter fstream = new FileWriter(file);
            BufferedWriter out = new BufferedWriter(fstream);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            for (Integer i : results.keySet()) {
                out.write(i + " " + results.get(i) + "\n");
            }
            bis.close();
            dis.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public static void writeResults3(String file, ArrayList<HashMap<Double, ArrayList<Integer>>> results) {
        InputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        try {
            FileWriter fstream = new FileWriter(file);
            BufferedWriter out = new BufferedWriter(fstream);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            int i = 0;
            while (i < results.size()) {
                HashMap<Double, ArrayList<Integer>> mapp = results.get(i);
                for (Double cutoff : mapp.keySet()) {
                    ArrayList<Integer> list = mapp.get(cutoff);
                    out.write(String.valueOf(i + 1) + " " + cutoff + " ");
                    int j = 0;
                    while (j < list.size()) {
                        int integ = list.get(j);
                        out.write(String.valueOf(integ) + " ");
                        ++j;
                    }
                    out.write("\n");
                }
                ++i;
            }
            bis.close();
            dis.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }
}

