/*
 * Decompiled with CFR 0.152.
 */
package parsing;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import utils.FileSystemTools;

public class PSA {
    public static HashMap<Integer, Boolean> runPSA(double cutoff, String atm_file) {
        HashMap<Integer, Boolean> surface_res = new HashMap<Integer, Boolean>();
        try {
            String os = System.getProperty("os.name");
            String os_specific = "";
            if (os.equals("Mac OS X")) {
                os_specific = "_mac";
            }
            System.out.println("Runing on: " + atm_file);
            String temp_folder = System.getProperty("user.dir");
            String temp_file = String.valueOf(atm_file.substring(0, atm_file.lastIndexOf(47))) + "/temp.txt";
            String run_file = String.valueOf(temp_folder) + "/psa_run.sh";
            FileSystemTools.writeFile(run_file, String.valueOf(System.getProperty("user.dir")) + "/auxiliarysoftware/psa/psa" + os_specific + " -t" + " " + atm_file + " > " + temp_file);
            Process p = Runtime.getRuntime().exec(String.valueOf(temp_folder) + "/./psa_run.sh");
            p.waitFor();
            System.out.println("Done writing...");
            ArrayList<String> lines = FileSystemTools.readFile(temp_file);
            for (String s : lines) {
                if (s.length() <= 10 || !s.substring(0, 6).equals("ACCESS")) continue;
                Integer i = Integer.parseInt(s.substring(7, 11).replace(" ", ""));
                if (s.substring(61, 66).replace(" ", "").equals("nan")) {
                    surface_res.put(i, Boolean.FALSE);
                    continue;
                }
                if (Double.parseDouble(s.substring(61, 66)) > cutoff) {
                    surface_res.put(i, Boolean.TRUE);
                    continue;
                }
                surface_res.put(i, Boolean.FALSE);
            }
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
        return surface_res;
    }

    public static HashMap<Integer, Boolean> readPSAFile(String psa_file, double cutoff) {
        HashMap<Integer, Boolean> surface_res = new HashMap<Integer, Boolean>();
        ArrayList<String> lines = FileSystemTools.readFile(psa_file);
        for (String s : lines) {
            if (s.length() <= 10 || !s.substring(0, 6).equals("ACCESS")) continue;
            Integer i = Integer.parseInt(s.substring(7, 11).replace(" ", ""));
            if (s.substring(61, 66).replace(" ", "").equals("nan")) {
                surface_res.put(i, Boolean.FALSE);
                continue;
            }
            if (Double.parseDouble(s.substring(61, 66)) > cutoff) {
                surface_res.put(i, Boolean.TRUE);
                continue;
            }
            surface_res.put(i, Boolean.FALSE);
        }
        return surface_res;
    }

    public static HashMap<Integer, Double> runPSA(String atm_file) {
        String s = null;
        HashMap<Integer, Double> surface_res = new HashMap<Integer, Double>();
        try {
            String os = System.getProperty("os.name");
            String os_specific = "";
            if (os.equals("Mac OS X")) {
                os_specific = "_mac";
            }
            String command = String.valueOf(System.getProperty("user.dir")) + "/auxiliarysoftware/psa/psa" + os_specific + " -t" + " " + atm_file;
            Process p_psa = Runtime.getRuntime().exec(command);
            BufferedReader stdInput_psa = new BufferedReader(new InputStreamReader(p_psa.getInputStream()));
            while ((s = stdInput_psa.readLine()) != null) {
                if (s.length() <= 10 || !s.substring(0, 6).equals("ACCESS")) continue;
                Integer i = Integer.parseInt(s.substring(7, 11).replace(" ", ""));
                if (s.substring(61, 66).replace(" ", "").equals("nan")) {
                    surface_res.put(i, -1.0);
                    continue;
                }
                surface_res.put(i, Double.parseDouble(s.substring(61, 66)));
            }
            stdInput_psa.close();
            p_psa.waitFor();
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
        return surface_res;
    }

    public static HashMap<Integer, Double> runPSA(String atm_file, boolean first) {
        String s = null;
        HashMap<Integer, Double> surface_res = new HashMap<Integer, Double>();
        try {
            String os = System.getProperty("os.name");
            String os_specific = "";
            if (os.equals("Mac OS X")) {
                os_specific = "_mac";
            }
            Process p_psa = Runtime.getRuntime().exec(String.valueOf(System.getProperty("user.dir")) + "/auxiliarysoftware/psa/psa" + os_specific + " -t" + " " + atm_file);
            BufferedReader stdInput_psa = new BufferedReader(new InputStreamReader(p_psa.getInputStream()));
            boolean repeating = false;
            int curr_seq = -1;
            while ((s = stdInput_psa.readLine()) != null) {
                if (s.length() <= 10 || !s.substring(0, 6).equals("ACCESS")) continue;
                int i = Integer.parseInt(s.substring(7, 11).replace(" ", ""));
                if (curr_seq == -1) {
                    curr_seq = i;
                } else {
                    if (curr_seq > i) {
                        repeating = true;
                    }
                    curr_seq = i;
                }
                if (s.substring(61, 66).replace(" ", "").equals("nan") && (first && !repeating || !first && repeating)) {
                    surface_res.put(i, -1.0);
                    continue;
                }
                if ((!first || repeating) && (first || !repeating)) continue;
                surface_res.put(i, Double.parseDouble(s.substring(61, 66)));
            }
            stdInput_psa.close();
            p_psa.waitFor();
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
        return surface_res;
    }
}

