/*
 * Decompiled with CFR 0.152.
 */
package EpitopePredictor;

import data_structures.Atom;
import data_structures.Residue;
import data_structures.SC_Structure;
import docking_global.DockingDistances;
import docking_global.PrepareData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import parsing.PDB_parser;
import parsing.PSA;
import utils.FileSystemTools;

public class EpiPredSurface {
    public static void main(String[] args) {
        String folder = args[0];
        double cutoff_graph = 0.0;
        double perc_cutoff = 0.0;
        double ext_cutoff = 0.0;
        String ab_file = String.valueOf(folder) + "/AB.pdb";
        String ag_file = String.valueOf(folder) + "/AG.pdb";
        String ab_psa = String.valueOf(folder) + "/tempAB.txt";
        String ag_psa = String.valueOf(folder) + "/tempAG.txt";
        EpiPredSurface.FullPredictEpi(Integer.parseInt(args[4]), String.valueOf(folder) + "/temp_out", ext_cutoff, args[3], ab_psa, ag_psa, ab_file, ag_file, 1, cutoff_graph, perc_cutoff);
    }

    public static ArrayList<PrepareData.Struct_maximization> FullPredictEpi(int num_predictions, String out_folder, double extension_cutoff, String paratope, String ab_psa_file, String ag_psa_file, String ab_file, String ag_file, int num_iteations, double cutoff_graph, double perc_cutoff) {
        ArrayList<PrepareData.Struct_maximization> results = new ArrayList<PrepareData.Struct_maximization>();
        int depth = 1;
        while (depth < 4) {
            double ext_cutoff = 2.0;
            while (ext_cutoff < 5.0) {
                HashMap<Integer, Residue> ab = PDB_parser.parse(ab_file, 'A');
                HashMap<Integer, Residue> ag = PDB_parser.parse(ag_file, 'A');
                HashMap<Integer, Boolean> ab_surface_exp = PSA.readPSAFile(ab_psa_file, 7.5);
                HashMap<Integer, Boolean> ag_surface_exp = PSA.readPSAFile(ag_psa_file, 7.5);
                ArrayList<Integer> ab_cons = EpiPredSurface.readParatopeExtension(paratope, ab, ab_surface_exp, 0.0);
                double[][] cons = DockingDistances.extractCons(ab, ag);
                System.out.println("Paratope size: " + ab_cons.size());
                double[][] ab_dists = new double[ab.size() + 1][ab.size() + 1];
                double[][] ag_dists = new double[ag.size() + 1][ag.size() + 1];
                for (Integer ab_i_1 : ab_cons) {
                    for (Integer ab_i_2 : ab_cons) {
                        if (ab_i_1 == ab_i_2) continue;
                        ab_dists[ab_i_1.intValue()][ab_i_2.intValue()] = ab.get(ab_i_1).distanceFrom(ab.get(ab_i_2));
                    }
                }
                for (Integer ag_i_1 : ag.keySet()) {
                    for (Integer ag_i_2 : ag.keySet()) {
                        if (ag_i_1 == ag_i_2) continue;
                        ag_dists[ag_i_1.intValue()][ag_i_2.intValue()] = ag.get(ag_i_1).distanceFrom(ag.get(ag_i_2));
                    }
                }
                int prog = 1;
                String output = "";
                double tot = 0.0;
                double ag_size = ag_surface_exp.size();
                for (Integer i_ag : ag_surface_exp.keySet()) {
                    if (!ag.get((Object)i_ag).isContact) continue;
                    tot += 1.0;
                }
                FileSystemTools.writeFile(String.valueOf(out_folder) + "/main.txt", String.valueOf(ag_size) + " " + tot);
                String main_out = out_folder;
                for (Integer i : ag_surface_exp.keySet()) {
                    double tp = 0.0;
                    double fp = 0.0;
                    double fn = 0.0;
                    System.out.println("Creating pretty picture");
                    System.out.println(String.valueOf(prog++) + "/" + ag_surface_exp.size());
                    if (!ag_surface_exp.get(i).booleanValue()) continue;
                    int d = depth;
                    PrepareData.Struct_maximization struc = PrepareData.randomEpitopeSeeded(i, null, ag_surface_exp, ag, d, ab_cons, ext_cutoff);
                    ArrayList<Integer> ag_cons = struc.epitope;
                    Object gs = null;
                    struc.score = gs.score_sum_deg;
                    ArrayList<String> pdb_file = new ArrayList<String>();
                    for (Integer ifull : ag.keySet()) {
                        if (ag_surface_exp.containsKey(ifull)) {
                            if (ag.get((Object)ifull).tempTPRO > 0.0) {
                                for (Atom a : ag.get((Object)ifull).atoms) {
                                    pdb_file.add(String.valueOf(SC_Structure.colorBFactor(a.pdb_line, String.valueOf(ag.get((Object)ifull).tempTPRO))) + "\n");
                                }
                                continue;
                            }
                            for (Atom a : ag.get((Object)ifull).atoms) {
                                pdb_file.add(String.valueOf(SC_Structure.colorBFactor(a.pdb_line, "0")) + "\n");
                            }
                            continue;
                        }
                        for (Atom a : ag.get((Object)ifull).atoms) {
                            pdb_file.add(String.valueOf(SC_Structure.colorBFactor(a.pdb_line, "0")) + "\n");
                        }
                    }
                    System.out.println(String.valueOf(main_out) + "/pretty_pictyre_" + i + "_" + ext_cutoff + "_" + depth + ".pdb");
                    FileSystemTools.writeFile(String.valueOf(main_out) + "/pretty_pictyre_" + i + "_" + ext_cutoff + "_" + depth + ".pdb", pdb_file);
                    for (Integer i_ag : ag_surface_exp.keySet()) {
                        if (struc.epitope.contains(i_ag) && ag.get((Object)i_ag).isContact) {
                            tp += 1.0;
                        }
                        if (struc.epitope.contains(i_ag) && !ag.get((Object)i_ag).isContact) {
                            fp += 1.0;
                        }
                        if (struc.epitope.contains(i_ag) || !ag.get((Object)i_ag).isContact) continue;
                        fn += 1.0;
                    }
                    double prec = tp / (tp + fp);
                    double rec = tp / (tp + fn);
                    output = String.valueOf(output) + i + " " + prec + " " + rec + struc.epitope.size() + "\n";
                }
                FileSystemTools.writeFile(String.valueOf(out_folder) + "/stats_" + ext_cutoff + "_" + depth + ".txt", output);
                ext_cutoff += 0.5;
            }
            ++depth;
        }
        return results;
    }

    public static boolean checkDuplicates(ArrayList<SuperEpi> ses, SuperEpi se, double cutoff) {
        for (SuperEpi se_temp : ses) {
            if (!(EpiPredSurface.overlapPerc(se_temp.epitope, se.epitope) > cutoff)) continue;
            return true;
        }
        return false;
    }

    public static double overlapPerc(ArrayList<Integer> a1, ArrayList<Integer> a2) {
        double tot = 0.0;
        for (Integer i : a1) {
            if (!a2.contains(i)) continue;
            tot += 1.0;
        }
        return tot / (double)a2.size();
    }

    public static SuperEpi PickBiggestRemove(ArrayList<PrepareData.Struct_maximization> epis, int N, int pdb_id) {
        int orig_n = N;
        int temp_n = N;
        TreeSet sorted = new TreeSet();
        double delta = 1.0E-4;
        double curr_max = -1.0;
        PrepareData.Struct_maximization best = null;
        for (PrepareData.Struct_maximization struc : epis) {
            if (!(struc.score > curr_max)) continue;
            curr_max = struc.score;
            best = struc;
        }
        epis.remove(best);
        if (best == null) {
            System.out.println("It appears that your percentage cutoff is too high given the number of epitopes you would like to get out of this program - please increase the percentage cutoff or decrease the number of returned epitopes");
            System.exit(0);
        }
        return new SuperEpi("", best.epitope);
    }

    public static ArrayList<Integer> readParatopeExtension(String paratope, HashMap<Integer, Residue> str, HashMap<Integer, Boolean> surf, double cutoff) {
        ArrayList<Integer> n_cons = new ArrayList<Integer>();
        ArrayList<Integer> cons = new ArrayList<Integer>();
        ArrayList<String> not_in = FileSystemTools.readFile(paratope);
        for (String line : not_in) {
            int id = Integer.parseInt(line);
            n_cons.add(id);
        }
        for (Integer i : str.keySet()) {
            if (n_cons.contains(i) || !surf.get(i).booleanValue()) continue;
            cons.add(i);
        }
        ArrayList<Integer> augmented = new ArrayList<Integer>();
        for (Integer i : str.keySet()) {
            for (Integer con : cons) {
                if (!(str.get(i).distanceFrom(str.get(con)) < cutoff) || augmented.contains(i) || cons.contains(i) || !surf.get(i).booleanValue()) continue;
                augmented.add(i);
            }
        }
        cons.addAll(augmented);
        return cons;
    }

    public static ArrayList<String> saveColored(HashMap<Integer, Residue> str, HashMap<Integer, String> colors) {
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i : str.keySet()) {
            sorted.add(i);
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (Integer i : sorted) {
            Residue r = str.get(i);
            for (Atom a : r.atoms) {
                lines.add(SC_Structure.colorBFactor(a.pdb_line, colors.get(i)));
            }
        }
        return lines;
    }

    public static class SuperEpi {
        final String data;
        public double score;
        final ArrayList<Integer> epitope;

        public SuperEpi(String stats, ArrayList<Integer> epi) {
            this.data = stats;
            this.epitope = epi;
        }
    }
}

