/*
 * Decompiled with CFR 0.152.
 */
package data_structures;

import data_structures.Atom;
import data_structures.Patch;
import data_structures.Residue_type;
import java.util.ArrayList;

public class Residue {
    private Patch patch;
    public final Residue_type type;
    public String model_seq_id;
    public final int site;
    public boolean isCDR = false;
    public double tempTPRO;
    public int ref_site;
    public boolean checked = false;
    public boolean isContact;
    public int in_array;
    public String CDR;
    private double APro;
    private double PPro;
    private double TPro;
    public double asa_NC;
    public double asa_IC;
    public double d_asa;
    public final ArrayList<Atom> atoms;

    public Residue(Residue_type typ, ArrayList<Atom> atm, int sit) {
        this.type = typ;
        this.atoms = atm;
        this.site = sit;
    }

    public Residue cloneMe() {
        Residue new_res = new Residue(this.type, this.atoms, this.site);
        new_res.setRefSite(this.ref_site);
        return new_res;
    }

    public void setRefSite(int rs) {
        this.ref_site = rs;
    }

    public int getRefSite() {
        return this.ref_site;
    }

    public void setAPro(double apro) {
        this.APro = apro;
    }

    public double getAPro() {
        return this.APro;
    }

    public void setPPro(double apro) {
        this.PPro = apro;
    }

    public double getPPro() {
        return this.PPro;
    }

    public void setTPro(double apro) {
        this.TPro = apro;
    }

    public double getTPro() {
        return this.TPro;
    }

    public double distanceFromCA(Residue res) {
        double min = Double.MAX_VALUE;
        double dist = -1.0;
        for (Atom a1 : this.atoms) {
            if (a1.atom_name == null) {
                return 1000.0;
            }
            if (!a1.atom_name.toString().contains("_CA")) continue;
            for (Atom a2 : res.atoms) {
                if (a2.atom_name == null) {
                    return 1000.0;
                }
                if (!a2.atom_name.toString().contains("_CA")) continue;
                dist = a1.distanceFrom(a2);
                return dist;
            }
        }
        return min;
    }

    public double distanceFrom(Residue res) {
        double min = Double.MAX_VALUE;
        double dist = -1.0;
        for (Atom a1 : this.atoms) {
            for (Atom a2 : res.atoms) {
                dist = a1.distanceFrom(a2);
                if (!(dist < min)) continue;
                min = dist;
            }
        }
        return min;
    }

    public void setPatch(Patch p) {
        this.patch = p;
    }

    public Patch getPatch() {
        return this.patch;
    }

    public void Output() {
        System.out.println("Residue id:" + this.site);
        System.out.println("Number of atoms:" + this.atoms.size());
        System.out.println("Residue type: " + (Object)((Object)this.type));
        for (Atom a : this.atoms) {
            a.Output();
            System.out.println("--------");
        }
    }

    public void OutputResidues() {
        System.out.println("Residue id:" + this.site);
        System.out.println("Residue type: " + (Object)((Object)this.type));
    }

    public double getBFactor() {
        double max = -1.0;
        for (Atom a : this.atoms) {
            double curr = Double.parseDouble("" + a.pdb_line.subSequence(60, 67));
            if (!(curr > max)) continue;
            max = curr;
        }
        return max;
    }

    public void OutputResidueList() {
        System.out.print(" " + (Object)((Object)this.type));
    }
}

